/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusDccProgrammer
extends AbstractProgrammer
implements CanListener {
    private CanSystemConnectionMemo _memo;
    TrafficController tc;
    int progState = 0;
    static final int NOTPROGRAMMING = 0;
    static final int MODESENT = 1;
    static final int COMMANDSENT = 2;
    static final int RETURNSENT = 4;
    boolean _progRead = false;
    int _val;
    int _cv;
    private ProgListener _usingProgrammer = null;
    private static final Logger log = LoggerFactory.getLogger(CbusDccProgrammer.class);

    public CbusDccProgrammer(TrafficController tc) {
        this.tc = tc;
        this.addTc(tc);
    }

    public CbusDccProgrammer(CanSystemConnectionMemo m) {
        this.tc = m.getTrafficController();
        this._memo = m;
        this.addTc(this.tc);
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.DIRECTBITMODE);
        ret.add(ProgrammingMode.DIRECTBYTEMODE);
        ret.add(ProgrammingMode.PAGEMODE);
        ret.add(ProgrammingMode.REGISTERMODE);
        return ret;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("writeCV {} listener {}", (Object)CV, (Object)p);
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 2;
        this._val = val;
        this._cv = CV;
        try {
            this.startLongTimer();
            this.tc.sendCanMessage(CbusMessage.getWriteCV(this._cv, this._val, this.getMode(), this.tc.getCanid()), this);
        }
        catch (Exception e) {
            log.error("Write operation failed, {} ", (Throwable)e);
            this.progState = 4;
        }
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        this.readCV(CVname, p, 0);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p, int startVal) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("readCV {} listens {}", (Object)CV, (Object)p);
        this.useProgrammer(p);
        this._progRead = true;
        this.progState = 2;
        this._cv = CV;
        try {
            this.startLongTimer();
            if (this._memo.supportsCVHints()) {
                this.tc.sendCanMessage(CbusMessage.getVerifyCV(this._cv, this.getMode(), startVal, this.tc.getCanid()), this);
            } else {
                this.tc.sendCanMessage(CbusMessage.getReadCV(this._cv, this.getMode(), this.tc.getCanid()), this);
            }
        }
        catch (Exception e) {
            log.error("Read operation failed, {} ", (Throwable)e);
            this.progState = 4;
        }
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    @Override
    public void message(CanMessage m) {
    }

    @Override
    public synchronized void reply(CanReply m) {
        if (m.extendedOrRtr()) {
            return;
        }
        if (this.progState == 2) {
            log.debug("reply in COMMANDSENT state");
            if (m.getElement(0) == 76 && m.getElement(2) == 1) {
                log.warn("handle error reply {}", (Object)m);
                this.stopTimer();
                this.notifyProgListenerEnd(-1, 2);
            } else if (m.getElement(0) == 76 && m.getElement(2) == 2) {
                log.warn("Programming overload {}", (Object)m);
                this.stopTimer();
                this.notifyProgListenerEnd(-1, 256);
            } else if (this._progRead && m.getElement(0) == 133) {
                this._val = m.getElement(4);
                this.progState = 0;
                this.stopTimer();
                this.notifyProgListenerEnd(this._val, 0);
            } else if (!this._progRead && m.getElement(0) == 76 && m.getElement(2) == 3) {
                this.progState = 0;
                this.stopTimer();
                this.notifyProgListenerEnd(this._val, 0);
            } else {
                log.debug("Reply ignored: {}", (Object)m);
            }
        }
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            log.debug("timeout!");
            this.progState = 0;
            this.notifyProgListenerEnd(this._val, 128);
        }
    }

    protected void notifyProgListenerEnd(int value, int status) {
        log.debug("notifyProgListenerEnd value {}, status {}", (Object)value, (Object)status);
        ProgListener temp = this._usingProgrammer;
        this._usingProgrammer = null;
        this.notifyProgListenerEnd(temp, value, status);
    }
}

