/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.util.ResourceBundle;
import jmri.AddressedProgrammerManager;
import jmri.CabSignalManager;
import jmri.ClockControl;
import jmri.CommandStation;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.PowerManager;
import jmri.Programmer;
import jmri.ReporterManager;
import jmri.SensorManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.ConfigurationManager;
import jmri.jmrix.can.cbus.CbusCabSignalManager;
import jmri.jmrix.can.cbus.CbusClockControl;
import jmri.jmrix.can.cbus.CbusCommandStation;
import jmri.jmrix.can.cbus.CbusDccProgrammer;
import jmri.jmrix.can.cbus.CbusDccProgrammerManager;
import jmri.jmrix.can.cbus.CbusLightManager;
import jmri.jmrix.can.cbus.CbusPowerManager;
import jmri.jmrix.can.cbus.CbusPredefinedMeters;
import jmri.jmrix.can.cbus.CbusPreferences;
import jmri.jmrix.can.cbus.CbusReporterManager;
import jmri.jmrix.can.cbus.CbusSensorManager;
import jmri.jmrix.can.cbus.CbusThrottleManager;
import jmri.jmrix.can.cbus.CbusTurnoutManager;
import jmri.jmrix.can.cbus.swing.CbusComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.managers.AbstractMeterManager;

public class CbusConfigurationManager
extends ConfigurationManager {
    private final ComponentFactory cf;
    private CbusDccProgrammerManager programmerManager;
    protected CbusPowerManager powerManager;
    protected CbusClockControl clockControl;
    protected ThrottleManager throttleManager;
    protected CbusTurnoutManager turnoutManager;
    protected CbusSensorManager sensorManager;
    protected CbusReporterManager reporterManager = null;
    protected CbusLightManager lightManager = null;
    protected CbusCommandStation commandStation;
    protected CbusPredefinedMeters predefinedMeters;
    private CbusPreferences cbusPreferences = null;
    protected CbusCabSignalManager cabSignalManager;

    public CbusConfigurationManager(CanSystemConnectionMemo memo) {
        super(memo);
        this.addToConfigMgr();
        this.cf = new CbusComponentFactory(this.adapterMemo);
        InstanceManager.store(this.cf, ComponentFactory.class);
    }

    protected final void addToConfigMgr() {
        InstanceManager.store(this, CbusConfigurationManager.class);
    }

    @Override
    public void configureManagers() {
        InstanceManager.store(this.getCbusPreferences(), CbusPreferences.class);
        InstanceManager.store(this.getPowerManager(), PowerManager.class);
        InstanceManager.setSensorManager(this.getSensorManager());
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        InstanceManager.setThrottleManager(this.getThrottleManager());
        if (this.getProgrammerManager().isAddressedModeHardwareAvailable()) {
            InstanceManager.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
        }
        if (this.getProgrammerManager().isGlobalProgrammerHardwareAvailable()) {
            InstanceManager.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
        }
        this.getPredefinedMeters();
        InstanceManager.store(this.getCommandStation(), CommandStation.class);
        InstanceManager.setReporterManager(this.getReporterManager());
        InstanceManager.setLightManager(this.getLightManager());
        InstanceManager.setDefault(CabSignalManager.class, this.getCabSignalManager());
        InstanceManager.setDefault(ClockControl.class, this.getClockControl());
    }

    @Override
    public boolean provides(Class<?> type) {
        if (this.adapterMemo.getDisabled()) {
            return false;
        }
        if (type.equals(AddressedProgrammerManager.class)) {
            return this.getProgrammerManager().isAddressedModePossible();
        }
        if (type.equals(GlobalProgrammerManager.class)) {
            return this.getProgrammerManager().isGlobalProgrammerAvailable();
        }
        if (type.equals(ThrottleManager.class)) {
            return true;
        }
        if (type.equals(PowerManager.class)) {
            return true;
        }
        if (type.equals(SensorManager.class)) {
            return true;
        }
        if (type.equals(TurnoutManager.class)) {
            return true;
        }
        if (type.equals(ReporterManager.class)) {
            return true;
        }
        if (type.equals(LightManager.class)) {
            return true;
        }
        if (type.equals(CommandStation.class)) {
            return true;
        }
        if (type.equals(CbusPreferences.class)) {
            return true;
        }
        return type.equals(CabSignalManager.class);
    }

    @Override
    public <T> T get(Class<?> T) {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (T.equals(AddressedProgrammerManager.class) && this.getProgrammerManager().isAddressedModePossible()) {
            return (T)this.getProgrammerManager();
        }
        if (T.equals(GlobalProgrammerManager.class) && this.getProgrammerManager().isGlobalProgrammerAvailable()) {
            return (T)this.getProgrammerManager();
        }
        if (T.equals(ThrottleManager.class)) {
            return (T)this.getThrottleManager();
        }
        if (T.equals(PowerManager.class)) {
            return (T)this.getPowerManager();
        }
        if (T.equals(SensorManager.class)) {
            return (T)this.getSensorManager();
        }
        if (T.equals(TurnoutManager.class)) {
            return (T)this.getTurnoutManager();
        }
        if (T.equals(ReporterManager.class)) {
            return (T)this.getReporterManager();
        }
        if (T.equals(LightManager.class)) {
            return (T)this.getLightManager();
        }
        if (T.equals(CommandStation.class)) {
            return (T)this.getCommandStation();
        }
        if (T.equals(CbusPreferences.class)) {
            return (T)this.getCbusPreferences();
        }
        if (T.equals(CabSignalManager.class)) {
            return (T)this.getCabSignalManager();
        }
        return null;
    }

    public CbusDccProgrammerManager getProgrammerManager() {
        if (this.programmerManager == null) {
            this.programmerManager = new CbusDccProgrammerManager((Programmer)new CbusDccProgrammer(this.adapterMemo), this.adapterMemo);
        }
        return this.programmerManager;
    }

    public void setProgrammerManager(CbusDccProgrammerManager p) {
        this.programmerManager = p;
    }

    public CbusPowerManager getPowerManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.powerManager == null) {
            this.powerManager = new CbusPowerManager(this.adapterMemo);
        }
        return this.powerManager;
    }

    public CbusClockControl getClockControl() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.clockControl == null) {
            this.clockControl = new CbusClockControl(this.adapterMemo);
        }
        return this.clockControl;
    }

    public ThrottleManager getThrottleManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.throttleManager == null) {
            this.throttleManager = new CbusThrottleManager(this.adapterMemo);
        }
        return this.throttleManager;
    }

    public void setThrottleManager(ThrottleManager t) {
        this.throttleManager = t;
    }

    public CbusTurnoutManager getTurnoutManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.turnoutManager == null) {
            this.turnoutManager = new CbusTurnoutManager(this.adapterMemo);
        }
        return this.turnoutManager;
    }

    public CbusSensorManager getSensorManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.sensorManager == null) {
            this.sensorManager = new CbusSensorManager(this.adapterMemo);
        }
        return this.sensorManager;
    }

    public CbusReporterManager getReporterManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.reporterManager == null) {
            this.reporterManager = new CbusReporterManager(this.adapterMemo);
        }
        return this.reporterManager;
    }

    public CbusLightManager getLightManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.lightManager == null) {
            this.lightManager = new CbusLightManager(this.adapterMemo);
        }
        return this.lightManager;
    }

    public CbusCommandStation getCommandStation() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.commandStation == null) {
            this.commandStation = new CbusCommandStation(this.adapterMemo);
        }
        return this.commandStation;
    }

    public CbusPredefinedMeters getPredefinedMeters() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.predefinedMeters == null) {
            InstanceManager.setMeterManager(new AbstractMeterManager(this.adapterMemo));
            this.predefinedMeters = new CbusPredefinedMeters(this.adapterMemo);
        }
        return this.predefinedMeters;
    }

    public CbusPreferences getCbusPreferences() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.cbusPreferences == null) {
            this.cbusPreferences = new CbusPreferences();
            InstanceManager.store(this.cbusPreferences, CbusPreferences.class);
        }
        return this.cbusPreferences;
    }

    public CbusCabSignalManager getCabSignalManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.cabSignalManager == null) {
            this.cabSignalManager = new CbusCabSignalManager(this.adapterMemo);
        }
        return this.cabSignalManager;
    }

    @Override
    public void dispose() {
        if (this.cf != null) {
            InstanceManager.deregister(this.cf, ComponentFactory.class);
        }
        if (this.powerManager != null) {
            InstanceManager.deregister(this.powerManager, CbusPowerManager.class);
        }
        if (this.clockControl != null) {
            InstanceManager.deregister(this.clockControl, ClockControl.class);
        }
        if (this.turnoutManager != null) {
            InstanceManager.deregister(this.turnoutManager, CbusTurnoutManager.class);
        }
        if (this.sensorManager != null) {
            InstanceManager.deregister(this.sensorManager, CbusSensorManager.class);
        }
        if (this.reporterManager != null) {
            InstanceManager.deregister(this.reporterManager, CbusReporterManager.class);
        }
        if (this.lightManager != null) {
            InstanceManager.deregister(this.lightManager, CbusLightManager.class);
        }
        if (this.throttleManager != null) {
            InstanceManager.deregister((CbusThrottleManager)this.throttleManager, CbusThrottleManager.class);
        }
        if (this.commandStation != null) {
            InstanceManager.deregister(this.commandStation, CommandStation.class);
        }
        if (this.predefinedMeters != null) {
            this.predefinedMeters.dispose();
        }
        if (this.cbusPreferences != null) {
            InstanceManager.deregister(this.cbusPreferences, CbusPreferences.class);
        }
        InstanceManager.deregister(this, CbusConfigurationManager.class);
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.can.CanActionListBundle");
    }
}

