/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.beans.PropertyChangeEvent;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.TimebaseRateException;
import jmri.implementation.DefaultClockControl;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusClockControl
extends DefaultClockControl
implements CanListener {
    private boolean isRunning;
    private int _cbusTemp = 0;
    private final Timebase clock;
    private CanMessage _lastSent;
    private final SimpleDateFormat minuteFormat = new SimpleDateFormat("mm");
    private final SimpleDateFormat hourFormat = new SimpleDateFormat("H");
    private final SimpleDateFormat dayofWeek = new SimpleDateFormat("u");
    private final SimpleDateFormat dayInMonth = new SimpleDateFormat("d");
    private final SimpleDateFormat monthFormat = new SimpleDateFormat("MM");
    private final SimpleDateFormat yearFormat = new SimpleDateFormat("YYYY");
    private final CanSystemConnectionMemo _memo;
    private static final Logger log = LoggerFactory.getLogger(CbusClockControl.class);

    public CbusClockControl(CanSystemConnectionMemo memo) {
        this._memo = memo;
        this.addTc(memo);
        this.clock = InstanceManager.getDefault(Timebase.class);
        this.clock.addMinuteChangeListener(this::newMinute);
    }

    private void newMinute(PropertyChangeEvent e) {
        this.sendToLayout();
    }

    public int getTemp() {
        return this._cbusTemp;
    }

    public void setTemp(int newTemp) {
        if (newTemp > -128 && newTemp < 127) {
            this._cbusTemp = newTemp;
        } else {
            log.warn("Temperature {} out of range -128 to 127", (Object)newTemp);
        }
    }

    @Override
    public String getHardwareClockName() {
        return String.valueOf(this._memo.getUserName()) + " CBUS Fast Clock";
    }

    @Override
    public void setTime(Date now) {
        this.sendToLayout();
    }

    @Override
    public void setRate(double newRate) {
        int newRatio = (int)newRate;
        if (newRate % 1.0 != 0.0) {
            log.warn("Non Integer Speed rate set, DIV values sent will not be accurate.");
        }
        if (newRatio < -255 || newRatio > 255) {
            log.error("ClockRatioRangeError");
        } else {
            this.sendToLayout();
        }
    }

    @Override
    public void initializeHardwareClock(double rate, Date now, boolean getTime) {
        this.isRunning = this.clock.getRun();
        this.setRate(rate);
        this.setTime(now);
    }

    @Override
    public void stopHardwareClock() {
        this.isRunning = false;
        this.sendToLayout();
    }

    @Override
    public void startHardwareClock(Date now) {
        this.isRunning = true;
        this.setTime(now);
    }

    private void sendToLayout() {
        int bstot;
        CanMessage send;
        if (!this.clock.getInternalMaster() || !this.clock.getSynchronize()) {
            return;
        }
        int day = Integer.parseInt(this.dayofWeek.format(this.clock.getTime())) + 1;
        if (day == 8) {
            day = 1;
        }
        if (!(send = this.getCanMessage(bstot = (Integer.parseInt(this.monthFormat.format(this.clock.getTime())) << 4) + day)).equals(this._lastSent)) {
            this._memo.getTrafficController().sendCanMessage(send, this);
            this._lastSent = send;
        }
    }

    private CanMessage getCanMessage(int bstot) {
        CanMessage send = new CanMessage(this._memo.getTrafficController().getCanid());
        send.setNumDataElements(7);
        send.setElement(0, 207);
        send.setElement(1, Integer.parseInt(this.minuteFormat.format(this.clock.getTime())));
        send.setElement(2, Integer.parseInt(this.hourFormat.format(this.clock.getTime())));
        send.setElement(3, bstot);
        send.setElement(4, this.isRunning ? (int)this.getRate() : 0);
        send.setElement(5, Integer.parseInt(this.dayInMonth.format(this.clock.getTime())));
        send.setElement(6, this._cbusTemp);
        CbusMessage.setPri(send, 11);
        return send;
    }

    @Override
    public void reply(CanReply r) {
        if (r.extendedOrRtr() || CbusMessage.getOpcode(r) != 207 || !this.clock.getSynchronize() || this.clock.getInternalMaster()) {
            return;
        }
        this.setRateFromReply(r.getElement(4) & 0xFF);
        this.setTimeFromReply(r);
        this.setTemp(CbusClockControl.tempFromTwos(r.getElement(6) & 0xFF));
    }

    private static int tempFromTwos(int twosTemp) {
        return twosTemp > 127 ? twosTemp - 256 : twosTemp;
    }

    private void setTimeFromReply(CanReply r) {
        int min = r.getElement(1) & 0xFF;
        int hour = r.getElement(2) & 0xFF;
        int day = r.getElement(5) & 0xFF;
        int month = r.getElement(3) >>> 4;
        LocalDateTime specificDate = null;
        try {
            specificDate = LocalDateTime.of(Integer.parseInt(this.yearFormat.format(this.clock.getTime())), month, day, hour, min, 0);
        }
        catch (DateTimeException e) {
            log.debug("Unable to process FastClock date. Incoming: {}", (Object)r, (Object)e);
        }
        if (specificDate == null) {
            try {
                specificDate = LocalDateTime.of(Integer.parseInt(this.yearFormat.format(this.clock.getTime())), Integer.parseInt(this.monthFormat.format(this.clock.getTime())), Integer.parseInt(this.dayInMonth.format(this.clock.getTime())), hour, min, 0);
            }
            catch (DateTimeException e) {
                log.warn("Unable to process FastClock time hrs:{} mins:{} error:{} CanFrame:{}", new Object[]{hour, min, e.getLocalizedMessage(), r});
            }
        }
        if (specificDate != null) {
            Date newnewdate = Date.from(specificDate.atZone(ZoneId.systemDefault()).toInstant());
            this.clock.setTime(newnewdate);
        }
    }

    private void setRateFromReply(int rate) {
        double oldRate;
        if (this.clock.getRun() && rate == 0) {
            this.clock.setRun(false);
        }
        if (!this.clock.getRun() && rate != 0) {
            this.clock.setRun(true);
        }
        if (Math.abs((double)rate - (oldRate = this.clock.getRate())) > 1.0E-4 && rate != 0) {
            try {
                this.clock.userSetRate(rate);
            }
            catch (TimebaseRateException timebaseRateException) {}
        }
    }

    @Override
    public void message(CanMessage m) {
    }

    public static String dateFromCanFrame(AbstractMessage r) {
        StringBuilder sb = new StringBuilder();
        int speed = r.getElement(4) & 0xFF;
        int month = r.getElement(3) >>> 4;
        int weekday = r.getElement(3) - (month << 4);
        if (weekday == 0) {
            weekday = 7;
        }
        log.debug("bs tot   {}", (Object)Integer.toBinaryString(r.getElement(3)));
        log.debug("bs day       {} {}", (Object)Integer.toBinaryString(weekday), (Object)weekday);
        log.debug("bs month {} {}", (Object)Integer.toBinaryString(month), (Object)month);
        if (speed > 0) {
            sb.append("Speed: x").append(speed).append(" ");
        } else {
            sb.append("Stopped ");
        }
        sb.append(String.format("%02d", r.getElement(2) & 0xFF)).append(":").append(String.format("%02d", r.getElement(1) & 0xFF)).append(" ");
        try {
            sb.append(DateFormatSymbols.getInstance().getWeekdays()[weekday]).append(" ");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            sb.append("Incorrect weekday (").append(weekday).append(") ");
        }
        sb.append(r.getElement(5) & 0xFF).append(" ");
        try {
            sb.append(DateFormatSymbols.getInstance().getMonths()[month - 1]).append(" ");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            sb.append("Incorrect month (").append(month).append(") ");
        }
        sb.append("Temp: ").append(CbusClockControl.tempFromTwos(r.getElement(6) & 0xFF));
        return sb.toString();
    }

    public void dispose() {
        this.clock.removeMinuteChangeListener(this::newMinute);
        this.removeTc(this._memo);
    }
}

