/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import jmri.LocoAddress;
import jmri.SignalMast;
import jmri.implementation.DefaultCabSignal;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusCabSignal
extends DefaultCabSignal {
    private TrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(CbusCabSignal.class);

    public CbusCabSignal(CanSystemConnectionMemo memo, LocoAddress address) {
        super(address);
        this.tc = memo.getTrafficController();
        log.debug("created cab signal for {}", (Object)address);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.tc = null;
    }

    @Override
    protected void forwardAspectToLayout() {
        int sendSpeed;
        int sendAspect2;
        int sendAspect1;
        int locoD2;
        int locoD1;
        block31: {
            LocoAddress locoaddr = this.getCabSignalAddress();
            SignalMast mast = this.getNextMast();
            int locoAddr = locoaddr.getNumber();
            if (locoaddr.getProtocol() == LocoAddress.Protocol.DCC_LONG) {
                locoAddr |= 0xC000;
            }
            locoD1 = locoAddr / 256;
            locoD2 = locoAddr & 0xFF;
            sendAspect1 = 255;
            sendAspect2 = 0;
            sendSpeed = 255;
            if (mast == null) break block31;
            switch (mast.getAspect()) {
                case "On": 
                case "Danger": {
                    sendAspect1 = 0;
                    break;
                }
                case "Caution": {
                    sendAspect1 = 1;
                    break;
                }
                case "Preliminary Caution": {
                    sendAspect1 = 2;
                    break;
                }
                case "Proceed": {
                    sendAspect1 = 3;
                    break;
                }
                case "Off": {
                    sendAspect1 = 4;
                    break;
                }
                case "Flash Caution": {
                    sendAspect1 = 1;
                    sendAspect2 = 1;
                    break;
                }
                case "Flash Preliminary Caution": {
                    sendAspect1 = 2;
                    sendAspect2 = 1;
                    break;
                }
                default: {
                    if (mast.getAspect().equals(mast.getAppearanceMap().getSpecificAppearance(1))) {
                        sendAspect1 = 4;
                        break;
                    }
                    if (mast.getAspect().equals(mast.getAppearanceMap().getSpecificAppearance(2))) {
                        sendAspect1 = 0;
                        break;
                    }
                    if (mast.getAspect().equals(mast.getAppearanceMap().getSpecificAppearance(0))) {
                        sendAspect1 = 0;
                        break;
                    }
                    if (!mast.getAspect().equals(mast.getAppearanceMap().getSpecificAppearance(3))) break;
                    sendAspect1 = 0;
                }
            }
        }
        CanMessage m = new CanMessage(7, this.tc.getCanid());
        CbusMessage.setPri(m, 11);
        m.setElement(0, 194);
        m.setElement(1, locoD1);
        m.setElement(2, locoD2);
        m.setElement(3, 1);
        m.setElement(4, sendAspect1);
        m.setElement(5, sendAspect2);
        m.setElement(6, sendSpeed);
        this.tc.sendCanMessage(m, null);
    }

    @Override
    protected void resetLayoutCabSignal() {
        LocoAddress locoaddr = this.getCabSignalAddress();
        int locoAddr = locoaddr.getNumber();
        if (locoaddr.getProtocol() == LocoAddress.Protocol.DCC_LONG) {
            locoAddr |= 0xC000;
        }
        int locoD1 = locoAddr / 256;
        int locoD2 = locoAddr & 0xFF;
        CanMessage m = new CanMessage(7, this.tc.getCanid());
        CbusMessage.setPri(m, 11);
        m.setElement(0, 194);
        m.setElement(1, locoD1);
        m.setElement(2, locoD2);
        m.setElement(3, 1);
        m.setElement(4, 255);
        m.setElement(5, 0);
        m.setElement(6, 255);
        this.tc.sendCanMessage(m, null);
    }
}

