/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusAddress {
    static final String SINGLE_ADDRESS_PATTERN = "((\\+|-)?\\d++)|([Xx](\\p{XDigit}\\p{XDigit}){1,8})|((\\+|-)?([Nn])?(\\d++)[Ee](\\d++))";
    private final Matcher hCode;
    private String aString;
    protected int[] aFrame;
    private boolean match;
    static final int NODEFACTOR = 100000;
    private static final String[] invalidChars = new String[]{"G", "H", "I", "J", "K", "L", "M", "S", "T", "U", "V", "W", "Y", "Z", "?", ":", "++", "--", ",", "*", "NN", "XX"};
    private static final Logger log = LoggerFactory.getLogger(CbusAddress.class);

    /*
     * Exception decompiling
     */
    public CbusAddress(String s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4] lbl41 : CaseStatement: default:\u000a, @NONE, blocks:[4] lbl41 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean equals(Object r) {
        if (r == null) {
            return false;
        }
        if (!r.getClass().equals(this.getClass())) {
            return false;
        }
        CbusAddress opp = (CbusAddress)r;
        if (opp.aFrame.length != this.aFrame.length) {
            return false;
        }
        int i = 0;
        while (i < this.aFrame.length) {
            if (this.aFrame[i] != opp.aFrame[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int ret = 0;
        int i = 0;
        while (i < this.aFrame.length) {
            ret += this.aFrame[i];
            ++i;
        }
        return ret;
    }

    public CanMessage makeMessage(int header) {
        return new CanMessage(this.aFrame, header);
    }

    public boolean check() {
        return this.hCode.reset(this.aString).matches();
    }

    public boolean match(AbstractMessage r) {
        if (r.getNumDataElements() != this.aFrame.length) {
            return false;
        }
        if (CbusMessage.isShort(r)) {
            if (this.aFrame[0] != r.getElement(0)) {
                return false;
            }
            int i = 3;
            while (i < this.aFrame.length) {
                if (this.aFrame[i] != r.getElement(i)) {
                    return false;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.aFrame.length) {
                if (this.aFrame[i] != r.getElement(i)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean matchRequest(CanReply r) {
        if (r.getNumDataElements() != this.aFrame.length) {
            return false;
        }
        if (CbusMessage.isShort(r)) {
            if (154 != r.getElement(0)) {
                return false;
            }
            int i = 3;
            while (i < this.aFrame.length) {
                if (this.aFrame[i] != r.getElement(i)) {
                    return false;
                }
                ++i;
            }
        } else {
            if (146 != r.getElement(0)) {
                return false;
            }
            int i = 1;
            while (i < this.aFrame.length) {
                if (this.aFrame[i] != r.getElement(i)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Nonnull
    public CbusAddress[] split() {
        if (this.aString.endsWith(";")) {
            return new CbusAddress[0];
        }
        String[] pStrings = this.aString.split(";");
        CbusAddress[] retval = new CbusAddress[pStrings.length];
        int i = 0;
        while (i < pStrings.length) {
            if (pStrings[i].isEmpty()) {
                return new CbusAddress[0];
            }
            if (!this.hCode.reset(pStrings[i]).matches()) {
                return new CbusAddress[0];
            }
            retval[i] = new CbusAddress(pStrings[i]);
            ++i;
        }
        return retval;
    }

    @Nonnull
    public static String getIncrement(@Nonnull String testAddr) throws JmriException {
        String newString;
        log.debug("testing address {}", (Object)testAddr);
        CbusAddress.validateSysName(testAddr);
        CbusAddress a = new CbusAddress(testAddr);
        CbusAddress[] v = a.split();
        switch (v.length) {
            case 2: {
                int lasta = StringUtil.getLastIntFromString(v[0].toString());
                int lastb = StringUtil.getLastIntFromString(v[1].toString());
                StringBuilder sb = new StringBuilder();
                sb.append(StringUtil.replaceLast(v[0].toString(), String.valueOf(lasta), String.valueOf(lasta + 1)));
                sb.append(";");
                sb.append(StringUtil.replaceLast(v[1].toString(), String.valueOf(lastb), String.valueOf(lastb + 1)));
                newString = sb.toString();
                break;
            }
            case 1: {
                int last = StringUtil.getLastIntFromString(v[0].toString());
                newString = StringUtil.replaceLast(v[0].toString(), String.valueOf(last), String.valueOf(last + 1));
                break;
            }
            default: {
                throw new JmriException("Unable to increment " + testAddr);
            }
        }
        try {
            return CbusAddress.validateSysName(newString);
        }
        catch (IllegalArgumentException e) {
            throw new JmriException("Unable to increment " + testAddr + " " + e.getMessage());
        }
    }

    public static String validateSysName(String address) throws IllegalArgumentException {
        if (address == null || address.isEmpty()) {
            throw new IllegalArgumentException("No Address passed ");
        }
        String[] stringArray = invalidChars;
        int n = invalidChars.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (address.contains(s)) {
                throw new NamedBean.BadSystemNameException(Locale.getDefault(), "InvalidSystemNameCharacter", address, s);
            }
            ++n2;
        }
        if (address.endsWith(";")) {
            throw new IllegalArgumentException("Should not end with ; " + address);
        }
        String[] addressArray = address.split(";");
        switch (addressArray.length) {
            case 1: {
                address = CbusAddress.checkPartOfName(addressArray[0], "+");
                break;
            }
            case 2: {
                address = String.valueOf(CbusAddress.checkPartOfName(addressArray[0], "+")) + ";" + CbusAddress.checkPartOfName(addressArray[1], "-");
                break;
            }
            default: {
                log.debug("validateSysName switch 1 found > 2 events");
                throw new IllegalArgumentException("Unable to convert Address: " + address);
            }
        }
        CbusAddress a = new CbusAddress(address);
        CbusAddress[] v = a.split();
        switch (v.length) {
            case 1: {
                if (address.startsWith("+") || address.startsWith("-")) break;
                try {
                    int unsigned = Integer.parseInt(address);
                    if (unsigned > 100000) {
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    log.debug("Unable to convert {} into Cbus format +nn", (Object)address);
                }
                throw new IllegalArgumentException("can't make 2nd event from address " + address);
            }
            case 2: {
                break;
            }
            default: {
                log.debug("validateSysName switch 2 found > 2 events");
                throw new IllegalArgumentException("Wrong number of events in address: " + address);
            }
        }
        return address;
    }

    private static String checkPartOfName(String testpart, String plusOrMinus) {
        int unsigned = 0;
        String part = testpart;
        try {
            unsigned = Integer.parseInt(part);
            log.debug("part {} is integer {}", (Object)part, (Object)unsigned);
            if (part.charAt(0) != '+' && part.charAt(0) != '-' && unsigned > 0 && unsigned < 65536) {
                part = String.valueOf(plusOrMinus) + part;
            }
            if (unsigned > 65535 && unsigned < 100000) {
                throw new IllegalArgumentException("On Too big for an event, too low for node + event : " + part);
            }
            if (unsigned < -65535 && unsigned > -100000) {
                throw new IllegalArgumentException("Off Too big for an event, too low for node + event : " + part);
            }
        }
        catch (NumberFormatException numberFormatException) {
            log.debug("Unable to convert {} into Cbus format +nn", (Object)part);
        }
        if (unsigned == 0) {
            try {
                if (part.toUpperCase().charAt(0) != 'X') {
                    log.debug("not an int or hex {}", (Object)part);
                    int lasta = StringUtil.getLastIntFromString(part);
                    log.debug("last string {}", (Object)lasta);
                    if (lasta > 65535) {
                        throw new IllegalArgumentException("Event Too Large in address: " + part);
                    }
                    int firsta = StringUtil.getFirstIntFromString(part);
                    log.debug("first string {}", (Object)firsta);
                    if (firsta > 65535) {
                        throw new IllegalArgumentException("Node Too Large in address: " + part);
                    }
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new IllegalArgumentException("Address Too Short? : " + part);
            }
        }
        return part;
    }

    public boolean checkSplit() {
        switch (this.split().length) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    int[] elements() {
        return Arrays.copyOf(this.aFrame, this.aFrame.length);
    }

    public String toString() {
        return this.aString;
    }

    public String toCanonicalString() {
        String retval = "x";
        int i = 0;
        while (i < this.aFrame.length) {
            retval = StringUtil.appendTwoHexFromInt(this.aFrame[i], retval);
            ++i;
        }
        return retval;
    }
}

