/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.lawicell;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.ConfigurationManager;
import jmri.jmrix.can.adapters.lawicell.Bundle;
import jmri.jmrix.can.adapters.lawicell.LawicellTrafficController;
import jmri.jmrix.can.adapters.lawicell.PortController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class SerialDriverAdapter
extends PortController {
    SerialPort activeSerialPort = null;
    protected String[] validSpeeds = new String[]{Bundle.getMessage("Baud57600"), Bundle.getMessage("Baud115200"), Bundle.getMessage("Baud230400"), Bundle.getMessage("Baud250000"), Bundle.getMessage("Baud333333"), Bundle.getMessage("Baud460800"), Bundle.getMessage("Baud500000")};
    protected int[] validSpeedValues = new int[]{57600, 115200, 230400, 250000, 333333, 460800, 500000};
    private boolean opened = false;
    InputStream serialStream = null;
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    public SerialDriverAdapter() {
        super(new CanSystemConnectionMemo());
        this.option1Name = "Protocol";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionProtocol"), ConfigurationManager.getSystemOptions()));
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = (SerialPort)portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                int baud = this.currentBaudNumber(this.mBaudRate);
                this.activeSerialPort.setSerialPortParams(baud, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            this.configureLeadsAndFlowControl(this.activeSerialPort, 0);
            this.activeSerialPort.enableReceiveTimeout(50);
            log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            this.serialStream = this.activeSerialPort.getInputStream();
            this.purgeStream(this.serialStream);
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud, sees  DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
            this.opened = true;
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException | UnsupportedCommOperationException ex) {
            log.error("Unexpected exception while opening port {}", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    @Override
    public void configure() {
        LawicellTrafficController tc = new LawicellTrafficController();
        this.getSystemConnectionMemo().setTrafficController(tc);
        log.debug("Connecting port");
        tc.connectPort(this);
        log.debug("send version request");
        CanMessage m = new CanMessage(new int[]{86, 13, 83, 52, 13, 79, 13}, tc.getCanid());
        m.setTranslated(true);
        tc.sendCanMessage(m, null);
        this.getSystemConnectionMemo().setProtocol(this.getOptionState(this.option1Name));
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.serialStream);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            return new DataOutputStream(this.activeSerialPort.getOutputStream());
        }
        catch (IOException e) {
            log.error("getOutputStream exception: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Deprecated
    public int[] validBaudValues() {
        return this.validBaudNumbers();
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

