/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.lawicell;

import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.can.CanMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message
extends AbstractMRMessage {
    static final int MAXLEN = 27;
    private static final Logger log = LoggerFactory.getLogger(Message.class);

    public Message() {
        this._nDataChars = 27;
        this._dataChars = new int[this._nDataChars];
    }

    public Message(CanMessage m) {
        this();
        this.setExtended(m.isExtended());
        int index = 1;
        index = this.setHeader(m.getHeader(), index);
        if (m.isRtr()) {
            log.error("Lawicell protocol cannot assert RTR");
        }
        this.setHexDigit(m.getNumDataElements(), index++);
        int i = 0;
        while (i < m.getNumDataElements()) {
            this.setHexDigit(m.getElement(i) >> 4 & 0xF, index++);
            this.setHexDigit(m.getElement(i) & 0xF, index++);
            ++i;
        }
        this.setElement(index++, 13);
        this.setNumDataElements(index);
    }

    @Override
    public int getNumDataElements() {
        return this._nDataChars;
    }

    public void setNumDataElements(int n) {
        this._nDataChars = n <= 27 ? n : 27;
    }

    @Override
    public int getElement(int n) {
        return this._dataChars[n];
    }

    @Override
    public void setElement(int n, int v) {
        this._dataChars[n] = v;
    }

    public void setData(int[] d) {
        int len = d.length <= 27 ? d.length : 27;
        int i = 0;
        while (i < len) {
            this._dataChars[i] = d[i];
            ++i;
        }
    }

    public void setExtended(boolean extended) {
        if (extended) {
            this.setElement(0, 84);
        } else {
            this.setElement(0, 116);
        }
    }

    public boolean isExtended() {
        return this.getElement(0) == 84;
    }

    public int setHeader(int header, int index) {
        if (this.isExtended()) {
            this.setHexDigit(header >> 28 & 0xF, index++);
            this.setHexDigit(header >> 24 & 0xF, index++);
            this.setHexDigit(header >> 20 & 0xF, index++);
            this.setHexDigit(header >> 16 & 0xF, index++);
            this.setHexDigit(header >> 12 & 0xF, index++);
        }
        this.setHexDigit(header >> 8 & 0xF, index++);
        this.setHexDigit(header >> 4 & 0xF, index++);
        this.setHexDigit(header >> 0 & 0xF, index++);
        return index;
    }

    public void setByte(int val, int n) {
        if (n >= 0 && n <= 7) {
            int index = n * 2 + 7;
            this.setHexDigit(val / 16 & 0xF, index++);
            this.setHexDigit(val & 0xF, index);
        }
    }

    void setHexDigit(int val, int n) {
        this._dataChars[n] = val >= 0 && val <= 15 ? (val < 10 ? val + 48 : val - 10 + 65) : 48;
    }
}

