/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.lawicell;

import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.adapters.lawicell.Message;
import jmri.jmrix.can.adapters.lawicell.Reply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LawicellTrafficController
extends TrafficController {
    public static final int NORMAL = 0;
    public static final int BOOTMODE = 1;
    private int gcState;
    private static final Logger log = LoggerFactory.getLogger(LawicellTrafficController.class);

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((CanListener)client).message((CanMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply r) {
        ((CanListener)client).reply((CanReply)r);
    }

    public int getgcState() {
        return this.gcState;
    }

    public void setgcState(int s) {
        this.gcState = s;
        log.debug("Setting gcState {}", (Object)s);
    }

    public boolean isBootMode() {
        return this.gcState == 1;
    }

    @Override
    public void sendCanMessage(CanMessage m, CanListener reply) {
        log.debug("TrafficController sendCanMessage() {}", (Object)m.toString());
        this.sendMessage(m, reply);
    }

    @Override
    public void sendCanReply(CanReply r, CanListener reply) {
        log.debug("TrafficController sendCanReply() {}", (Object)r.toString());
        this.notifyReply(r, reply);
    }

    @Override
    protected void addTrailerToOutput(byte[] msg, int offset, AbstractMRMessage m) {
    }

    @Override
    protected int lengthOfByteStream(AbstractMRMessage m) {
        return m.getNumDataElements();
    }

    @Override
    protected AbstractMRMessage newMessage() {
        log.debug("New Message created");
        Message msg = new Message();
        return msg;
    }

    @Override
    public CanReply decodeFromHardware(AbstractMRReply m) {
        log.debug("Decoding from hardware: {}", (Object)m);
        CanReply ret = new CanReply();
        try {
            Reply gc = (Reply)m;
            ret = gc.createReply();
            log.debug("Decoded {} as {} ", (Object)gc, (Object)ret);
        }
        catch (ClassCastException classCastException) {
            log.error("Unable to cast Reply {}", (Object)m);
        }
        return ret;
    }

    @Override
    public AbstractMRMessage encodeForHardware(CanMessage m) {
        Message ret = new Message(m);
        log.debug("Encoding for hardware as {}", (Object)ret);
        return ret;
    }

    @Override
    protected AbstractMRReply newReply() {
        log.debug("New Reply created");
        Reply reply = new Reply();
        return reply;
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply r) {
        return this.endNormalReply(r);
    }

    boolean endNormalReply(AbstractMRReply r) {
        int num = r.getNumDataElements() - 1;
        if (r.getElement(num) == 13) {
            return true;
        }
        return r.getElement(num) == 7;
    }
}

