/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.gridconnect.net;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jmri.jmrix.AbstractConnectionConfig;
import jmri.jmrix.AbstractNetworkConnectionConfig;
import jmri.jmrix.NetworkPortAdapter;
import jmri.jmrix.can.adapters.gridconnect.net.NetworkDriverAdapter;
import jmri.jmrix.openlcb.swing.protocoloptions.ConfigPaneHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfig
extends AbstractNetworkConnectionConfig {
    public static final String NAME = "CAN via GridConnect Network Interface";
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfig.class);

    public ConnectionConfig(NetworkPortAdapter p) {
        super(p);
    }

    public ConnectionConfig() {
    }

    @Override
    public void loadDetails(JPanel details) {
        this.setInstance();
        ConfigPaneHelper.maybeAddOpenLCBProtocolOptionsButton(this, this.additionalItems);
        super.loadDetails(details);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    protected void checkInitDone() {
        log.debug("init called for {}", (Object)this.name());
        if (this.init) {
            return;
        }
        super.checkInitDone();
        this.updateUserNameField();
        ((JComboBox)((AbstractConnectionConfig.Option)this.options.get("Protocol")).getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionConfig.this.updateUserNameField();
            }
        });
    }

    void updateUserNameField() {
        if (!"CAN".equals(this.adapter.getSystemConnectionMemo().getUserName())) {
            log.debug("Avoid overwriting user name {}.", (Object)this.adapter.getSystemConnectionMemo().getUserName());
            return;
        }
        log.debug("New user name based on manufacturer {}", (Object)this.getManufacturer());
        String newUserName = this.getManufacturer();
        this.connectionNameField.setText(newUserName);
        if (!this.adapter.getSystemConnectionMemo().setUserName(newUserName)) {
            int x = 2;
            while (x < 50) {
                if (this.adapter.getSystemConnectionMemo().setUserName(String.valueOf(newUserName) + x)) {
                    this.connectionNameField.setText(this.adapter.getSystemConnectionMemo().getUserName());
                    break;
                }
                ++x;
            }
        }
    }

    @Override
    public boolean isPortAdvanced() {
        return false;
    }

    public boolean isOptList1Advanced() {
        return false;
    }

    @Override
    protected void setInstance() {
        if (this.adapter == null) {
            this.adapter = new NetworkDriverAdapter();
        }
    }

    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.can.CanActionListBundle");
    }
}

