/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.gridconnect.canrs;

import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.adapters.gridconnect.GridConnectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergMessage
extends GridConnectMessage {
    private static final Logger log = LoggerFactory.getLogger(MergMessage.class);

    public MergMessage() {
    }

    public MergMessage(CanMessage m) {
        this();
        this.setExtended(m.isExtended());
        this.setHeader(m.getHeader());
        this.setRtr(m.isRtr());
        int i = 0;
        while (i < m.getNumDataElements()) {
            this.setByte(m.getElement(i), i);
            ++i;
        }
        int offset = this.isExtended() ? 11 : 7;
        this.setElement(offset + m.getNumDataElements() * 2, 59);
        this.setNumDataElements(offset + 1 + m.getNumDataElements() * 2);
        if (log.isDebugEnabled()) {
            log.debug("encoded as {}", (Object)this.toString());
        }
    }

    @Override
    public void setHeader(int header) {
        if (this.isExtended()) {
            int munged = header << 3 & 0xFFE00000 | 0x80000 | header & 0x3FFFF;
            if (log.isDebugEnabled()) {
                log.debug("Extended header is {}", (Object)header);
            }
            if (log.isDebugEnabled()) {
                log.debug("Munged header is {}", (Object)munged);
            }
            super.setHeader(munged);
        } else {
            int munged = header << 5;
            if (log.isDebugEnabled()) {
                log.debug("Standard header is {}", (Object)header);
            }
            if (log.isDebugEnabled()) {
                log.debug("Munged header is {}", (Object)munged);
            }
            this.setHexDigit(munged >> 12 & 0xF, 2);
            this.setHexDigit(munged >> 8 & 0xF, 3);
            this.setHexDigit(munged >> 4 & 0xF, 4);
            this.setHexDigit(0, 5);
        }
    }

    @Override
    public void setRtr(boolean rtr) {
        int offset = this.isExtended() ? 10 : 6;
        this.setElement(offset, rtr ? 82 : 78);
    }

    @Override
    public void setByte(int val, int n) {
        if (n >= 0 && n <= 7) {
            int index = n * 2 + (this.isExtended() ? 11 : 7);
            try {
                if (val < 0 || val > 255) {
                    val = 0;
                    throw new IllegalArgumentException();
                }
            }
            catch (IllegalArgumentException e) {
                log.error("Value out of range for MergMessage data payload {}", (Throwable)e);
            }
            this.setHexDigit(val / 16 & 0xF, index++);
            this.setHexDigit(val & 0xF, index);
        }
    }
}

