/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters;

import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jmri.jmrix.AbstractConnectionConfig;
import jmri.jmrix.AbstractSerialConnectionConfig;
import jmri.jmrix.SerialPortAdapter;
import jmri.jmrix.openlcb.swing.protocoloptions.ConfigPaneHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionConfig
extends AbstractSerialConnectionConfig {
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfig.class);

    public ConnectionConfig(SerialPortAdapter p) {
        super(p);
    }

    public ConnectionConfig() {
    }

    @Override
    protected void checkInitDone() {
        log.debug("init called for {}", (Object)this.name());
        if (this.init) {
            return;
        }
        super.checkInitDone();
        this.updateUserNameField();
        ((JComboBox)((AbstractConnectionConfig.Option)this.options.get("Protocol")).getComponent()).addActionListener(e -> this.updateUserNameField());
    }

    void updateUserNameField() {
        if (!"CAN".equals(this.adapter.getSystemConnectionMemo().getUserName())) {
            log.debug("Avoid overwriting user name {}.", (Object)this.adapter.getSystemConnectionMemo().getUserName());
            return;
        }
        log.debug("New user name based on manufacturer {}", (Object)this.getManufacturer());
        String newUserName = this.getManufacturer();
        this.connectionNameField.setText(newUserName);
        if (!this.adapter.getSystemConnectionMemo().setUserName(newUserName)) {
            int x = 2;
            while (x < 50) {
                if (this.adapter.getSystemConnectionMemo().setUserName(String.valueOf(newUserName) + x)) {
                    this.connectionNameField.setText(this.adapter.getSystemConnectionMemo().getUserName());
                    break;
                }
                ++x;
            }
        }
    }

    @Override
    public void loadDetails(JPanel details) {
        this.setInstance();
        ConfigPaneHelper.maybeAddOpenLCBProtocolOptionsButton(this, this.additionalItems);
        super.loadDetails(details);
    }

    @Override
    public abstract String name();

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.can.CanActionListBundle");
    }

    @Override
    protected abstract void setInstance();
}

