/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can;

import java.util.Arrays;
import java.util.ResourceBundle;
import jmri.jmrix.can.CanSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurationManager {
    public static final String SPROGCBUS = "SPROG CBUS";
    public static final String MERGCBUS = "MERG CBUS";
    public static final String OPENLCB = "OpenLCB";
    public static final String RAWCAN = "Raw CAN";
    public static final String TEST = "Test - do not use";
    private static String[] options = new String[]{"SPROG CBUS", "MERG CBUS", "OpenLCB", "Raw CAN", "Test - do not use"};
    protected CanSystemConnectionMemo adapterMemo;
    private static final Logger log = LoggerFactory.getLogger(ConfigurationManager.class);

    public ConfigurationManager(CanSystemConnectionMemo memo) {
        this.adapterMemo = memo;
    }

    public static String[] getSystemOptions() {
        return Arrays.copyOf(options, options.length);
    }

    public static void setOpenLCB() {
        log.debug("setOpenLCB");
        options = new String[]{OPENLCB, MERGCBUS, RAWCAN, TEST};
    }

    public static void setMERG() {
        log.debug("setMERG");
        options = new String[]{MERGCBUS, OPENLCB, RAWCAN, TEST};
    }

    public static void setSPROG() {
        log.debug("setSPROG");
        options = new String[]{SPROGCBUS};
    }

    public abstract void configureManagers();

    public abstract boolean provides(Class<?> var1);

    public abstract <T> T get(Class<?> var1);

    public abstract void dispose();

    protected abstract ResourceBundle getActionModelResourceBundle();

    public static enum ProgModeSwitch {
        NONE,
        EITHER,
        SPROG3PLUS;

    }

    public static enum SubProtocol {
        NONE,
        CBUS;

    }
}

