/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammerManager;
import jmri.ConsistManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.can.CanConfigurationManager;
import jmri.jmrix.can.ConfigurationManager;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusConfigurationManager;
import jmri.jmrix.can.nmranet.NmraConfigurationManager;
import jmri.jmrix.openlcb.OlcbConfigurationManager;
import jmri.jmrix.swing.ComponentFactory;
import jmri.util.NamedBeanComparator;
import jmri.util.startup.StartupActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanSystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    public static final String DEFAULT_USERNAME = "CAN";
    private boolean protocolOptionsChanged = false;
    protected String _protocol = "MERG CBUS";
    protected ConfigurationManager.SubProtocol _subProtocol = ConfigurationManager.SubProtocol.CBUS;
    protected ConfigurationManager.ProgModeSwitch _progModeSwitch = ConfigurationManager.ProgModeSwitch.NONE;
    protected boolean _supportsCVHints = false;
    private boolean _multipleThrottles = true;
    private boolean _powerOnArst = true;
    ComponentFactory cf = null;
    protected TrafficController tm;
    private ConfigurationManager manager;
    private final Map<String, Map<String, String>> protocolOptions = new HashMap<String, Map<String, String>>();
    private static final Logger log = LoggerFactory.getLogger(CanSystemConnectionMemo.class);

    public CanSystemConnectionMemo() {
        super("M", DEFAULT_USERNAME);
    }

    public CanSystemConnectionMemo(String prefix) {
        super(prefix, DEFAULT_USERNAME);
    }

    protected final void storeCanMemotoInstance() {
        this.register();
        InstanceManager.store(this, CanSystemConnectionMemo.class);
    }

    public void setTrafficController(TrafficController tm) {
        this.tm = tm;
    }

    public TrafficController getTrafficController() {
        return this.tm;
    }

    @Override
    public boolean provides(Class<?> type) {
        if (this.getDisabled()) {
            return false;
        }
        if (this.manager == null) {
            return false;
        }
        if (type.equals(GlobalProgrammerManager.class)) {
            GlobalProgrammerManager mgr = (GlobalProgrammerManager)this.get(GlobalProgrammerManager.class);
            if (mgr == null) {
                return false;
            }
            return mgr.isGlobalProgrammerAvailable();
        }
        if (type.equals(AddressedProgrammerManager.class)) {
            AddressedProgrammerManager mgr = (AddressedProgrammerManager)this.get(AddressedProgrammerManager.class);
            if (mgr == null) {
                return false;
            }
            return mgr.isAddressedModePossible();
        }
        if (type.equals(ConsistManager.class)) {
            return false;
        }
        boolean result = this.manager.provides(type);
        if (result) {
            return true;
        }
        return super.provides(type);
    }

    @Override
    public <T> T get(Class<?> T) {
        if (this.manager != null && !this.getDisabled()) {
            return this.manager.get(T);
        }
        return super.get(T);
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        StartupActionFactory old;
        block18: {
            old = this.getActionFactory();
            if (protocol == null) break block18;
            this._protocol = protocol;
            switch (protocol) {
                case "SPROG CBUS": 
                case "MERG CBUS": {
                    this.manager = new CbusConfigurationManager(this);
                    break;
                }
                case "OpenLCB": {
                    this.manager = new OlcbConfigurationManager(this);
                    break;
                }
                case "Raw CAN": {
                    this.manager = new CanConfigurationManager(this);
                    break;
                }
                case "Test - do not use": {
                    this.manager = new NmraConfigurationManager(this);
                    break;
                }
            }
        }
        this.firePropertyChange("actionFactory", old, this.getActionFactory());
    }

    public ConfigurationManager.SubProtocol getSubProtocol() {
        return this._subProtocol;
    }

    public void setSubProtocol(ConfigurationManager.SubProtocol sp) {
        if (sp != null) {
            this._subProtocol = sp;
        }
    }

    public ConfigurationManager.ProgModeSwitch getProgModeSwitch() {
        return this._progModeSwitch;
    }

    public void setProgModeSwitch(ConfigurationManager.ProgModeSwitch pms) {
        if (pms != null) {
            this._progModeSwitch = pms;
        }
    }

    public boolean hasMultipleThrottles() {
        return this._multipleThrottles;
    }

    public void setMultipleThrottles(boolean b) {
        this._multipleThrottles = b;
    }

    public boolean supportsCVHints() {
        return this._supportsCVHints;
    }

    public void setSupportsCVHints(boolean b) {
        this._supportsCVHints = b;
    }

    public boolean powerOnArst() {
        return this._powerOnArst;
    }

    public void setPowerOnArst(boolean b) {
        this._powerOnArst = b;
    }

    @Override
    public void configureManagers() {
        if (this.manager != null) {
            this.manager.configureManagers();
        }
        this.storeCanMemotoInstance();
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        if (this.manager == null) {
            return null;
        }
        return this.manager.getActionModelResourceBundle();
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    public Set<String> getProtocolsWithOptions() {
        return this.protocolOptions.keySet();
    }

    @Nonnull
    public Map<String, String> getProtocolAllOptions(String protocol) {
        return this.protocolOptions.getOrDefault(protocol, new HashMap());
    }

    public synchronized String getProtocolOption(String protocol, String option) {
        if (!this.protocolOptions.containsKey(protocol)) {
            return null;
        }
        Map<String, String> m = this.getProtocolAllOptions(protocol);
        return m.getOrDefault(option, null);
    }

    public synchronized void setProtocolOption(String protocol, String option, String value) {
        log.debug("Setting protocol option {} {} := {}", new Object[]{protocol, option, value});
        if (value == null) {
            return;
        }
        Map m = this.protocolOptions.computeIfAbsent(protocol, k -> new HashMap());
        String oldValue = (String)m.get(option);
        if (value.equals(oldValue)) {
            return;
        }
        m.put(option, value);
        this.protocolOptionsChanged = true;
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.protocolOptionsChanged;
    }

    @Override
    public boolean isRestartRequired() {
        return super.isRestartRequired() || this.protocolOptionsChanged;
    }

    @Override
    public int getDefaultOutputInterval() {
        return 100;
    }

    @Override
    public void dispose() {
        if (this.manager != null) {
            this.manager.dispose();
        }
        this.tm = null;
        super.dispose();
    }
}

