/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import javax.annotation.Nonnull;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.can.CanMutableFrame;
import jmri.jmrix.can.CanReply;

public class CanMessage
extends AbstractMRMessage
implements CanMutableFrame {
    private boolean _translated = false;
    int _header;
    boolean _isExtended;
    boolean _isRtr;

    public CanMessage(int header) {
        this._header = header;
        this._isExtended = false;
        this._isRtr = false;
        this._nDataChars = 8;
        super.setBinary(true);
        this._dataChars = new int[8];
    }

    public CanMessage(int i, int header) {
        this(header);
        this._nDataChars = i <= 8 ? i : 8;
    }

    public CanMessage(int[] d, int header) {
        this(header);
        this.setData(d);
        this.setNumDataElements(d.length <= 8 ? d.length : 8);
    }

    public CanMessage(byte[] d, int header) {
        this(header);
        this.setData(d);
        this.setNumDataElements(d.length <= 8 ? d.length : 8);
    }

    public CanMessage(@Nonnull CanMessage m) {
        this(m.getHeader());
        this._isExtended = m.isExtended();
        this._isRtr = m.isRtr();
        super.setBinary(true);
        this.setData(Arrays.copyOf(m.getData(), m.getNumDataElements()));
        this.setNumDataElements(m.getNumDataElements());
    }

    public CanMessage(@Nonnull CanReply m) {
        this(m.getHeader());
        this._isExtended = m.isExtended();
        this._isRtr = m.isRtr();
        super.setBinary(true);
        this.setData(m.getData());
        this.setNumDataElements(m.getNumDataElements());
    }

    public void setTranslated(boolean translated) {
        this._translated = translated;
    }

    public boolean isTranslated() {
        return this._translated;
    }

    @Override
    public int hashCode() {
        return this._header;
    }

    @Override
    @SuppressFBWarnings(value={"EQ_UNUSUAL"}, justification="Equality test done in CanFrame")
    public boolean equals(Object a) {
        return this.isEqual(this, a);
    }

    @Override
    public String toString() {
        return this.getToString();
    }

    @Override
    public String toMonitorString() {
        return this.monString();
    }

    @Override
    public boolean replyExpected() {
        return false;
    }

    @Override
    public int getNumDataElements() {
        return this._nDataChars;
    }

    @Override
    public final void setNumDataElements(int n) {
        this._nDataChars = n;
    }

    @Override
    public int getElement(int n) {
        return this._dataChars[n];
    }

    @Override
    public void setElement(int n, int v) {
        this._dataChars[n] = v;
    }

    public int[] getData() {
        return this._dataChars;
    }

    @Override
    public int getHeader() {
        return this._header;
    }

    @Override
    public void setHeader(int h) {
        this._header = h;
    }

    @Override
    public boolean isExtended() {
        return this._isExtended;
    }

    @Override
    public void setExtended(boolean b) {
        this._isExtended = b;
    }

    @Override
    public boolean isRtr() {
        return this._isRtr;
    }

    @Override
    public void setRtr(boolean b) {
        this._isRtr = b;
    }
}

