/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bachrus;

import java.io.DataInputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.SwingUtilities;
import jmri.jmrix.bachrus.SpeedoInterface;
import jmri.jmrix.bachrus.SpeedoListener;
import jmri.jmrix.bachrus.SpeedoPortController;
import jmri.jmrix.bachrus.SpeedoReply;
import jmri.jmrix.bachrus.SpeedoSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;

public class SpeedoTrafficController
implements SpeedoInterface,
SerialPortEventListener {
    private SpeedoReply reply = new SpeedoReply();
    protected Vector<SpeedoListener> cmdListeners = new Vector();
    SpeedoListener lastSender = null;
    private SpeedoPortController controller = null;
    DataInputStream istream = null;
    OutputStream ostream = null;
    private boolean unsolicited;
    private static final Logger log = LoggerFactory.getLogger(SpeedoTrafficController.class);

    public SpeedoTrafficController(SpeedoSystemConnectionMemo adaptermemo) {
    }

    @Override
    public boolean status() {
        return this.ostream != null && this.istream != null;
    }

    @Override
    public synchronized void addSpeedoListener(SpeedoListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        if (!this.cmdListeners.contains(l)) {
            this.cmdListeners.addElement(l);
        }
    }

    @Override
    public synchronized void removeSpeedoListener(SpeedoListener l) {
        if (this.cmdListeners.contains(l)) {
            this.cmdListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReply(SpeedoReply r) {
        Vector v;
        SpeedoTrafficController speedoTrafficController = this;
        synchronized (speedoTrafficController) {
            v = (Vector)this.cmdListeners.clone();
        }
        int cnt = v.size();
        int i = 0;
        while (i < cnt) {
            SpeedoListener client = (SpeedoListener)v.elementAt(i);
            try {
                if (this.lastSender != client) {
                    client.reply(r);
                }
            }
            catch (Exception e) {
                log.warn("notify: During dispatch to {}\nException {}", (Object)client, (Object)e);
            }
            ++i;
        }
        if (this.lastSender != null) {
            this.lastSender.reply(r);
        }
    }

    public void connectPort(SpeedoPortController p) {
        this.istream = p.getInputStream();
        this.ostream = p.getOutputStream();
        if (this.controller != null) {
            log.warn("connectPort: connect called while connected");
        }
        this.controller = p;
    }

    public void disconnectPort(SpeedoPortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.controller != p) {
            log.warn("disconnectPort: disconnect called from non-connected LnPortController");
        }
        this.controller = null;
    }

    @Deprecated
    public static SpeedoTrafficController instance() {
        return null;
    }

    boolean endReply(SpeedoReply msg) {
        int num = msg.getNumDataElements();
        int ptr = num - 1;
        if (msg.getElement(ptr) != 59) {
            return false;
        }
        this.unsolicited = true;
        return true;
    }

    @Override
    public void serialEvent(SerialPortEvent event) {
        block1 : switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                int replyCurrentSize;
                int i = replyCurrentSize = this.reply.getNumDataElements();
                while (i < 32 - replyCurrentSize) {
                    try {
                        if (this.istream.available() == 0) break block1;
                        byte char1 = this.istream.readByte();
                        this.reply.setElement(i, char1);
                    }
                    catch (Exception e) {
                        log.debug("{} Exception handling reply cause {}", (Object)e, (Object)e.getCause());
                    }
                    if (this.endReply(this.reply)) {
                        this.sendreply();
                        break block1;
                    }
                    ++i;
                }
                break;
            }
            default: {
                log.warn("Unhandled event type: {}", (Object)event.getEventType());
            }
        }
    }

    private void sendreply() {
        SpeedoReply thisReply = this.reply;
        if (this.unsolicited) {
            thisReply.setUnsolicited();
        }
        SpeedoTrafficController thisTc = this;
        Runnable r = new Runnable(thisReply, thisTc){
            SpeedoReply msgForLater;
            SpeedoTrafficController myTc;
            {
                this.msgForLater = speedoReply;
                this.myTc = speedoTrafficController2;
            }

            @Override
            public void run() {
                this.myTc.notifyReply(this.msgForLater);
            }
        };
        SwingUtilities.invokeLater(r);
        this.reply = new SpeedoReply();
    }
}

