/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bachrus;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrix.bachrus.Speed;

public class SpeedoDial
extends JPanel {
    float speedAngle = 0.0f;
    int speedDigits = 0;
    Image logo;
    Image scaledLogo;
    NamedIcon jmriIcon;
    NamedIcon scaledIcon;
    int[] minuteX;
    int[] minuteY;
    int[] scaledMinuteX;
    int[] scaledMinuteY;
    int[] rotatedMinuteX;
    int[] rotatedMinuteY;
    Polygon minuteHand;
    Polygon scaledMinuteHand;
    int minuteHeight;
    float scaleRatio;
    int faceSize;
    int size;
    int logoWidth;
    int logoHeight;
    int centreX;
    int centreY;
    int units;
    int baseMphLimit;
    int baseKphLimit;
    int mphLimit;
    int mphInc;
    int kphLimit;
    int kphInc;
    float priMajorTick;
    float priMinorTick;
    float secTick;
    String priString;
    String secString;

    public SpeedoDial() {
        int[] nArray = new int[11];
        nArray[0] = -12;
        nArray[1] = -11;
        nArray[2] = -24;
        nArray[3] = -11;
        nArray[4] = -11;
        nArray[6] = 11;
        nArray[7] = 11;
        nArray[8] = 24;
        nArray[9] = 11;
        nArray[10] = 12;
        this.minuteX = nArray;
        this.minuteY = new int[]{-31, -261, -266, -314, -381, -391, -381, -314, -266, -261, -31};
        this.scaledMinuteX = new int[this.minuteX.length];
        this.scaledMinuteY = new int[this.minuteY.length];
        this.rotatedMinuteX = new int[this.minuteX.length];
        this.rotatedMinuteY = new int[this.minuteY.length];
        this.units = 0;
        this.baseMphLimit = 80;
        this.baseKphLimit = 140;
        this.mphLimit = this.baseMphLimit;
        this.mphInc = 40;
        this.kphLimit = this.baseKphLimit;
        this.kphInc = 70;
        this.priString = "MPH";
        this.secString = "KPH";
        this.jmriIcon = new NamedIcon("resources/logo.gif", "resources/logo.gif");
        this.scaledIcon = new NamedIcon("resources/logo.gif", "resources/logo.gif");
        this.logo = this.jmriIcon.getImage();
        this.minuteHand = new Polygon(this.minuteX, this.minuteY, 11);
        this.minuteHeight = this.minuteHand.getBounds().getSize().height;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SpeedoDial.this.scaleFace();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        int yOffset;
        int xOffset;
        String speed;
        super.paint(g);
        if (!(g instanceof Graphics2D)) {
            throw new IllegalArgumentException("Graphics object passed is not the correct type");
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(this.centreX, this.centreY);
        g2.setColor(Color.white);
        g2.fillOval(-this.faceSize / 2, -this.faceSize / 2, this.faceSize, this.faceSize);
        g2.setColor(Color.black);
        g2.drawOval(-this.faceSize / 2, -this.faceSize / 2, this.faceSize, this.faceSize);
        int dotSize = this.faceSize / 40;
        g2.fillOval(-dotSize * 2, -dotSize * 2, 4 * dotSize, 4 * dotSize);
        g2.drawImage(this.scaledLogo, -this.logoWidth / 2, -this.faceSize / 4, this.logoWidth, this.logoHeight, this);
        int fontSize = this.faceSize / 10;
        if (fontSize < 1) {
            fontSize = 1;
        }
        Font sizedFont = new Font("Serif", 0, fontSize);
        g2.setFont(sizedFont);
        FontMetrics fontM = g2.getFontMetrics(sizedFont);
        int dashSize = this.size / 60;
        this.setTicks();
        float i = 150.0f;
        while (i < 391.0f) {
            g2.drawLine(this.dotX((float)this.faceSize / 2.0f, i), this.dotY((float)this.faceSize / 2.0f, i), this.dotX((float)this.faceSize / 2.0f - (float)dashSize, i), this.dotY((float)this.faceSize / 2.0f - (float)dashSize, i));
            i += this.priMinorTick;
        }
        int j = 0;
        float i2 = 150.0f;
        while (i2 < 391.0f) {
            g2.drawLine(this.dotX((float)this.faceSize / 2.0f, i2), this.dotY((float)this.faceSize / 2.0f, i2), this.dotX((float)this.faceSize / 2.0f - (float)(3 * dashSize), i2), this.dotY((float)this.faceSize / 2.0f - (float)(3 * dashSize), i2));
            speed = Integer.toString(10 * j);
            xOffset = fontM.stringWidth(speed);
            yOffset = fontM.getHeight();
            g2.drawString(speed, this.dotX((float)this.faceSize / 2.0f - (float)(6 * dashSize), (float)j * this.priMajorTick - 210.0f) - xOffset / 2, this.dotY((float)this.faceSize / 2.0f - (float)(6 * dashSize), (float)j * this.priMajorTick - 210.0f) + yOffset / 4);
            ++j;
            i2 += this.priMajorTick;
        }
        fontSize = this.faceSize / 15;
        if (fontSize < 1) {
            fontSize = 1;
        }
        sizedFont = new Font("Serif", 0, fontSize);
        g2.setFont(sizedFont);
        fontM = g2.getFontMetrics(sizedFont);
        g2.setColor(Color.green);
        j = 0;
        i2 = 150.0f;
        while (i2 < 391.0f) {
            g2.fillOval(this.dotX((float)this.faceSize / 2.0f - (float)(10 * dashSize), i2), this.dotY((float)this.faceSize / 2.0f - (float)(10 * dashSize), i2), 5, 5);
            if ((j & 1) == 0 || this.units == 1) {
                speed = Integer.toString(10 * j);
                xOffset = fontM.stringWidth(speed);
                yOffset = fontM.getHeight();
                g2.drawString(speed, this.dotX((float)this.faceSize / 2.0f - (float)(13 * dashSize), (float)j * this.secTick - 210.0f) - xOffset / 2, this.dotY((float)this.faceSize / 2.0f - (float)(13 * dashSize), (float)j * this.secTick - 210.0f) + yOffset / 4);
            }
            ++j;
            i2 += this.secTick;
        }
        g2.drawString(this.secString, this.dotX((float)this.faceSize / 2.0f - (float)(5 * dashSize), 45.0f) - fontM.stringWidth(this.secString) / 2, this.dotY((float)this.faceSize / 2.0f - (float)(5 * dashSize), 45.0f) + fontM.getHeight() / 4);
        g2.setColor(Color.black);
        double speedAngleRadians = Math.toRadians(this.speedAngle);
        int i3 = 0;
        while (i3 < this.scaledMinuteX.length) {
            this.rotatedMinuteX[i3] = (int)((double)this.scaledMinuteX[i3] * Math.cos(speedAngleRadians) - (double)this.scaledMinuteY[i3] * Math.sin(speedAngleRadians));
            this.rotatedMinuteY[i3] = (int)((double)this.scaledMinuteX[i3] * Math.sin(speedAngleRadians) + (double)this.scaledMinuteY[i3] * Math.cos(speedAngleRadians));
            ++i3;
        }
        this.scaledMinuteHand = new Polygon(this.rotatedMinuteX, this.rotatedMinuteY, this.rotatedMinuteX.length);
        g2.fillPolygon(this.scaledMinuteHand);
        int unitsFontSize = (int)((double)((float)this.faceSize / 10.0f) * 0.75);
        if (unitsFontSize < 1) {
            unitsFontSize = 1;
        }
        Font unitsSizedFont = new Font("Serif", 0, unitsFontSize);
        g2.setFont(unitsSizedFont);
        FontMetrics unitsFontM = g2.getFontMetrics(unitsSizedFont);
        g2.drawString(this.priString, this.dotX((float)this.faceSize / 2.0f - (float)(5 * dashSize), -225.0f) - unitsFontM.stringWidth(this.priString) / 2, this.dotY((float)this.faceSize / 2.0f - (float)(5 * dashSize), -225.0f) + unitsFontM.getHeight() / 4);
        String speedString = Integer.toString(this.speedDigits);
        int digitsFontSize = (int)((double)fontSize * 1.5);
        Font digitsSizedFont = new Font("Serif", 0, digitsFontSize);
        g2.setFont(digitsSizedFont);
        FontMetrics digitsFontM = g2.getFontMetrics(digitsSizedFont);
        int pad = (int)((double)digitsFontSize * 0.2);
        int h = (int)((double)digitsFontM.getAscent() * 0.8);
        int w = digitsFontM.stringWidth("999");
        if (pad < 2) {
            pad = 2;
        }
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillRect(-w / 2 - pad, 2 * this.faceSize / 5 - h - pad, w + pad * 2, h + pad * 2);
        g2.setColor(Color.DARK_GRAY);
        g2.drawRect(-w / 2 - pad, 2 * this.faceSize / 5 - h - pad, w + pad * 2, h + pad * 2);
        g2.setColor(Color.BLACK);
        g2.drawString(speedString, -digitsFontM.stringWidth(speedString) / 2, 2 * this.faceSize / 5);
    }

    int dotX(float radius, float angle) {
        int xDist = (int)Math.round((double)radius * Math.cos(Math.toRadians(angle)));
        return xDist;
    }

    int dotY(float radius, float angle) {
        int yDist = (int)Math.round((double)radius * Math.sin(Math.toRadians(angle)));
        return yDist;
    }

    public void scaleFace() {
        int panelHeight = this.getSize().height;
        int panelWidth = this.getSize().width;
        this.size = Math.min(panelHeight, panelWidth);
        this.faceSize = (int)((double)this.size * 0.97);
        if (this.faceSize == 0) {
            this.faceSize = 1;
        }
        int logoScaleWidth = this.faceSize / 6;
        int logoScaleHeight = (int)((float)logoScaleWidth * (float)this.jmriIcon.getIconHeight() / (float)this.jmriIcon.getIconWidth());
        this.scaledLogo = this.logo.getScaledInstance(logoScaleWidth, logoScaleHeight, 4);
        this.scaledIcon.setImage(this.scaledLogo);
        this.logoWidth = this.scaledIcon.getIconWidth();
        this.logoHeight = this.scaledIcon.getIconHeight();
        this.scaleRatio = (float)this.faceSize / 2.7f / (float)this.minuteHeight;
        int i = 0;
        while (i < this.minuteX.length) {
            this.scaledMinuteX[i] = (int)((float)this.minuteX[i] * this.scaleRatio);
            this.scaledMinuteY[i] = (int)((float)this.minuteY[i] * this.scaleRatio);
            ++i;
        }
        this.scaledMinuteHand = new Polygon(this.scaledMinuteX, this.scaledMinuteY, this.scaledMinuteX.length);
        this.centreX = panelWidth / 2;
        this.centreY = panelHeight / 2;
    }

    void update(float speed) {
        if (this.units == 0) {
            if (Speed.kphToMph(speed) > (float)this.mphLimit) {
                this.mphLimit += this.mphInc;
                this.kphLimit += this.kphInc;
            }
            this.setTicks();
            this.speedDigits = Math.round(Speed.kphToMph(speed));
            this.speedAngle = -120.0f + Speed.kphToMph(speed * this.priMajorTick / 10.0f);
        } else {
            if (speed > (float)this.kphLimit) {
                this.mphLimit += this.mphInc;
                this.kphLimit += this.kphInc;
            }
            this.setTicks();
            this.speedDigits = Math.round(speed);
            this.speedAngle = -120.0f + speed * this.priMajorTick / 10.0f;
        }
        this.repaint();
    }

    void setTicks() {
        if (this.units == 0) {
            this.priMajorTick = 240.0f / ((float)this.mphLimit / 10.0f);
            this.priMinorTick = this.priMajorTick / 5.0f;
            this.secTick = 240.0f / (Speed.mphToKph(this.mphLimit) / 10.0f);
        } else {
            this.priMajorTick = 240.0f / ((float)this.kphLimit / 10.0f);
            this.priMinorTick = this.priMajorTick / 5.0f;
            this.secTick = 240.0f / (Speed.kphToMph(this.kphLimit) / 10.0f);
        }
    }

    void setUnitsMph() {
        this.units = 0;
        this.priString = "MPH";
        this.secString = "KPH";
    }

    void setUnitsKph() {
        this.units = 1;
        this.priString = "KPH";
        this.secString = "MPH";
    }

    public void reset() {
        this.mphLimit = this.baseMphLimit;
        this.kphLimit = this.baseKphLimit;
        this.update(0.0f);
    }
}

