/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bachrus;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LocoAddress;
import jmri.PowerManager;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.ThrottleManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.DccLocoAddressSelector;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.GlobalRosterEntryComboBox;
import jmri.jmrix.bachrus.Bundle;
import jmri.jmrix.bachrus.DccSpeedProfile;
import jmri.jmrix.bachrus.GraphPane;
import jmri.jmrix.bachrus.Speed;
import jmri.jmrix.bachrus.SpeedoDial;
import jmri.jmrix.bachrus.SpeedoListener;
import jmri.jmrix.bachrus.SpeedoReply;
import jmri.jmrix.bachrus.SpeedoSystemConnectionMemo;
import jmri.jmrix.bachrus.SpeedoTrafficController;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedoConsoleFrame
extends JmriJFrame
implements SpeedoListener,
ThrottleListener,
ProgListener,
PropertyChangeListener {
    protected JLabel scaleLabel = new JLabel();
    protected JLabel customScaleLabel = new JLabel();
    protected JTextField customScaleField = new JTextField(3);
    protected int customScale = 148;
    protected JTextField speedTextField = new JTextField(12);
    protected JPanel displayCards = new JPanel();
    protected ButtonGroup modeGroup = new ButtonGroup();
    protected JRadioButton progButton = new JRadioButton(Bundle.getMessage("ProgTrack"));
    protected JRadioButton mainButton = new JRadioButton(Bundle.getMessage("OnMain"));
    protected ButtonGroup speedGroup = new ButtonGroup();
    protected JRadioButton mphButton = new JRadioButton(Bundle.getMessage("MPH"));
    protected JRadioButton kphButton = new JRadioButton(Bundle.getMessage("KPH"));
    protected ButtonGroup displayGroup = new ButtonGroup();
    protected JRadioButton numButton = new JRadioButton(Bundle.getMessage("Numeric"));
    protected JRadioButton dialButton = new JRadioButton(Bundle.getMessage("Dial"));
    protected SpeedoDial speedoDialDisplay = new SpeedoDial();
    protected JRadioButton dirFwdButton = new JRadioButton(Bundle.getMessage("Forward"));
    protected JRadioButton dirRevButton = new JRadioButton(Bundle.getMessage("Reverse"));
    protected JRadioButton toggleGridButton = new JRadioButton(Bundle.getMessage("ToggleGrid"));
    GraphPane profileGraphPane;
    protected JLabel statusLabel = new JLabel(" ");
    protected JLabel readerLabel = new JLabel();
    protected static final int defaultScale = 8;
    protected float selectedScale = 0.0f;
    protected int series = 0;
    protected float sampleSpeed = 0.0f;
    protected float targetSpeed = 0.0f;
    protected float currentSpeed = 0.0f;
    protected float incSpeed = 0.0f;
    protected float oldSpeed = 0.0f;
    protected float acc = 0.0f;
    protected float avSpeed = 0.0f;
    protected int range = 1;
    protected float circ = 0.0f;
    protected float count = 1.0f;
    protected float freq;
    protected static final int DISPLAY_UPDATE = 500;
    protected static final int FAST_DISPLAY_RATIO = 5;
    protected static final int RANGE1LO = 0;
    protected static final int RANGE1HI = 9;
    protected static final int RANGE2LO = 7;
    protected static final int RANGE2HI = 31;
    protected static final int RANGE3LO = 29;
    protected static final int RANGE3HI = 62;
    protected static final int RANGE4LO = 58;
    protected static final int RANGE4HI = 9999;
    static final int[] filterLength;
    String selectedScalePref = String.valueOf(this.getClass().getName()) + ".SelectedScale";
    String customScalePref = String.valueOf(this.getClass().getName()) + ".CustomScale";
    String speedUnitsKphPref = String.valueOf(this.getClass().getName()) + ".SpeedUnitsKph";
    String dialTypePref = String.valueOf(this.getClass().getName()) + ".DialType";
    UserPreferencesManager prefs;
    SpeedoTrafficController tc = null;
    String replyString;
    protected String[] scaleStrings = new String[]{Bundle.getMessage("ScaleZ"), Bundle.getMessage("ScaleEuroN"), Bundle.getMessage("ScaleNFine"), Bundle.getMessage("ScaleJapaneseN"), Bundle.getMessage("ScaleBritishN"), Bundle.getMessage("Scale3mm"), Bundle.getMessage("ScaleTT"), Bundle.getMessage("Scale00"), Bundle.getMessage("ScaleH0"), Bundle.getMessage("ScaleS"), Bundle.getMessage("Scale048"), Bundle.getMessage("Scale045"), Bundle.getMessage("Scale043"), Bundle.getMessage("ScaleOther")};
    protected float[] scales = new float[]{220.0f, 160.0f, 152.0f, 150.0f, 148.0f, 120.0f, 101.6f, 76.0f, 87.0f, 64.0f, 48.0f, 45.0f, 43.0f, -1.0f};
    JComboBox<String> scaleList = new JComboBox<String>(this.scaleStrings);
    private SpeedoSystemConnectionMemo _memo = null;
    protected DisplayType display = DisplayType.NUMERIC;
    protected int dccServices;
    protected static final int BASIC = 0;
    protected static final int PROG = 1;
    protected static final int COMMAND = 2;
    protected static final int THROTTLE = 4;
    protected boolean timerRunning = false;
    protected ProgState progState = ProgState.IDLE;
    protected float throttleIncrement;
    protected Programmer prog = null;
    protected AddressedProgrammer ops_mode_prog = null;
    protected CommandStation commandStation = null;
    private PowerManager pm = null;
    protected JButton readAddressButton = new JButton(Bundle.getMessage("Read"));
    private final DccLocoAddressSelector addrSelector = new DccLocoAddressSelector();
    private JButton setButton;
    private GlobalRosterEntryComboBox rosterBox;
    protected RosterEntry rosterEntry;
    private final boolean disableRosterBoxActions = false;
    private DccLocoAddress locomotiveAddress = new DccLocoAddress(0, false);
    protected int readAddress = 0;
    protected JButton trackPowerButton = new JButton(Bundle.getMessage("PowerUp"));
    protected JButton startProfileButton = new JButton(Bundle.getMessage("Start"));
    protected JButton stopProfileButton = new JButton(Bundle.getMessage("Stop"));
    protected JButton exportProfileButton = new JButton(Bundle.getMessage("Export"));
    protected JButton printProfileButton = new JButton(Bundle.getMessage("Print"));
    protected JButton resetGraphButton = new JButton(Bundle.getMessage("ResetGraph"));
    protected JButton loadProfileButton = new JButton(Bundle.getMessage("LoadRef"));
    protected JTextField printTitleText = new JTextField();
    protected DccSpeedProfile spFwd;
    protected DccSpeedProfile spRev;
    protected DccSpeedProfile spRef;
    protected ProfileDirection profileDir = ProfileDirection.FORWARD;
    protected DccThrottle throttle = null;
    protected int profileStep = 0;
    protected float profileSpeed;
    protected ProfileState profileState = ProfileState.IDLE;
    protected JLabel speedStep1TargetLabel = new JLabel(Bundle.getMessage("lblSpeedStep1"));
    protected JTextField speedStep1TargetField = new JTextField("3", 3);
    protected JLabel speedStep1TargetUnit = new JLabel(Bundle.getMessage("lblMPH"));
    protected JLabel speedStep28TargetLabel = new JLabel(Bundle.getMessage("lblSpeedStep28"));
    protected JTextField speedStep28TargetField = new JTextField("55", 3);
    protected JLabel speedStep28TargetUnit = new JLabel(Bundle.getMessage("lblMPH"));
    protected JCheckBox speedMatchWarmUpCheckBox = new JCheckBox(Bundle.getMessage("chkbxWarmUp"));
    protected JButton speedMatchButton = new JButton(Bundle.getMessage("btnStartSpeedMatch"));
    protected static float kP;
    protected static float kI;
    protected static float kD;
    protected float speedMatchIntegral = 0.0f;
    protected float speedMatchDerivative = 0.0f;
    protected float lastSpeedMatchError = 0.0f;
    protected float speedMatchError = 0.0f;
    protected float speedStep1Target = 0.0f;
    protected float speedStep28Target = 0.0f;
    protected int lastVStart = 1;
    protected int lastVHigh = 255;
    protected int lastReverseTrim = 128;
    protected int vStart = 1;
    protected int vHigh = 255;
    protected int reverseTrim = 128;
    protected int speedMatchDuration = 0;
    protected int oldMomentumAccel;
    protected int oldMomentumDecel;
    protected SpeedMatchState speedMatchState = SpeedMatchState.IDLE;
    protected SpeedMatchSetupState speedMatchSetupState = SpeedMatchSetupState.IDLE;
    protected static final int speedTestScaleFactor = 1;
    Timer speedMatchTimer = null;
    Timer profileTimer = null;
    Timer replyTimer = null;
    Timer displayTimer = null;
    Timer fastDisplayTimer = null;
    private static final Logger log;

    static {
        int[] nArray = new int[5];
        nArray[1] = 3;
        nArray[2] = 6;
        nArray[3] = 10;
        nArray[4] = 20;
        filterLength = nArray;
        kP = 0.75f;
        kI = 0.3f;
        kD = 0.4f;
        log = LoggerFactory.getLogger(SpeedoConsoleFrame.class);
    }

    public SpeedoConsoleFrame(SpeedoSystemConnectionMemo memo) {
        this._memo = memo;
    }

    protected String title() {
        return Bundle.getMessage("SpeedoConsole");
    }

    private void setTitle() {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE d MMM yyyy", Locale.getDefault());
        Date today = new Date();
        String result = formatter.format(today);
        String annotate = "Bachrus MTS-DCC " + Bundle.getMessage("ProfileFor") + " " + this.locomotiveAddress.getNumber() + " " + Bundle.getMessage("CreatedOn") + " " + result;
        this.printTitleText.setText(annotate);
    }

    @Override
    public void dispose() {
        if (this.prefs != null) {
            this.prefs.setComboBoxLastSelection(this.selectedScalePref, (String)this.scaleList.getSelectedItem());
            this.prefs.setProperty(this.customScalePref, "customScale", this.customScale);
            this.prefs.setSimplePreferenceState(this.speedUnitsKphPref, this.kphButton.isSelected());
            this.prefs.setSimplePreferenceState(this.dialTypePref, this.dialButton.isSelected());
        }
        this._memo.getTrafficController().removeSpeedoListener(this);
        super.dispose();
    }

    @Override
    public void initComponents() {
        this.prefs = InstanceManager.getDefault(UserPreferencesManager.class);
        this.setTitle(this.title());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.dccServices = 0;
        if (InstanceManager.getNullableDefault(GlobalProgrammerManager.class) != null && InstanceManager.getDefault(GlobalProgrammerManager.class).isGlobalProgrammerAvailable()) {
            this.prog = InstanceManager.getDefault(GlobalProgrammerManager.class).getGlobalProgrammer();
            this.dccServices |= 1;
        }
        if (InstanceManager.getNullableDefault(ThrottleManager.class) != null) {
            log.info("Using Throttle interface for profiling");
            this.dccServices |= 4;
        }
        if (InstanceManager.getNullableDefault(PowerManager.class) != null) {
            this.pm = InstanceManager.getDefault(PowerManager.class);
            this.pm.addPropertyChangeListener(this);
        }
        JPanel basicPane = new JPanel();
        basicPane.setLayout(new BoxLayout(basicPane, 1));
        JPanel scalePanel = new JPanel();
        scalePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("SelectScale")));
        scalePanel.setLayout(new FlowLayout());
        this.scaleList.setToolTipText(Bundle.getMessage("SelectScaleToolTip"));
        String lastSelectedScale = this.prefs.getComboBoxLastSelection(this.selectedScalePref);
        if (lastSelectedScale != null && !lastSelectedScale.equals("")) {
            try {
                this.scaleList.setSelectedItem(lastSelectedScale);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.scaleList.setSelectedIndex(8);
            }
        } else {
            this.scaleList.setSelectedIndex(8);
        }
        if (this.scaleList.getSelectedIndex() > -1) {
            this.selectedScale = this.scales[this.scaleList.getSelectedIndex()];
        }
        this.scaleList.addActionListener(e -> {
            this.selectedScale = this.scales[this.scaleList.getSelectedIndex()];
            this.checkCustomScale();
        });
        this.scaleLabel.setText(Bundle.getMessage("Scale"));
        this.scaleLabel.setVisible(true);
        this.readerLabel.setText(Bundle.getMessage("UnknownReader"));
        this.readerLabel.setVisible(true);
        scalePanel.add(this.scaleLabel);
        scalePanel.add(this.scaleList);
        scalePanel.add(this.readerLabel);
        JPanel customScalePanel = new JPanel();
        customScalePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("CustomScale")));
        customScalePanel.setLayout(new FlowLayout());
        this.customScaleLabel.setText("1: ");
        this.customScaleLabel.setVisible(true);
        this.customScaleField.setVisible(true);
        try {
            this.customScaleField.setText(this.prefs.getProperty(this.customScalePref, "customScale").toString());
        }
        catch (NullPointerException nullPointerException) {
            this.customScaleField.setText("1");
        }
        this.checkCustomScale();
        this.getCustomScale();
        this.customScaleField.addActionListener(e -> this.getCustomScale());
        customScalePanel.add(this.customScaleLabel);
        customScalePanel.add(this.customScaleField);
        basicPane.add(scalePanel);
        basicPane.add(customScalePanel);
        JPanel modePanel = new JPanel();
        modePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("SelectMode")));
        modePanel.setLayout(new FlowLayout());
        this.modeGroup.add(this.progButton);
        this.modeGroup.add(this.mainButton);
        this.progButton.setSelected(true);
        this.progButton.setToolTipText(Bundle.getMessage("TTProg"));
        this.mainButton.setToolTipText(Bundle.getMessage("TTMain"));
        modePanel.add(this.progButton);
        modePanel.add(this.mainButton);
        this.progButton.addActionListener(e -> {
            if ((this.dccServices & 1) == 1) {
                this.readAddressButton.setEnabled(true);
                this.statusLabel.setText(Bundle.getMessage("StatProg"));
            }
        });
        this.mainButton.addActionListener(e -> {
            this.readAddressButton.setEnabled(false);
            this.statusLabel.setText(Bundle.getMessage("StatMain"));
        });
        basicPane.add(modePanel);
        JPanel speedPanel = new JPanel();
        speedPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("MeasuredSpeed")));
        speedPanel.setLayout(new BoxLayout(speedPanel, 0));
        this.displayCards.setLayout(new CardLayout());
        JPanel numericSpeedPanel = new JPanel();
        numericSpeedPanel.setLayout(new BoxLayout(numericSpeedPanel, 0));
        Font f = new Font("", 0, 96);
        this.speedTextField.setFont(f);
        this.speedTextField.setHorizontalAlignment(4);
        this.speedTextField.setColumns(3);
        this.speedTextField.setText("0.0");
        this.speedTextField.setVisible(true);
        this.speedTextField.setToolTipText(Bundle.getMessage("SpeedHere"));
        numericSpeedPanel.add(this.speedTextField);
        JPanel dialSpeedPanel = new JPanel();
        dialSpeedPanel.setLayout(new BoxLayout(dialSpeedPanel, 0));
        dialSpeedPanel.add(this.speedoDialDisplay);
        this.speedoDialDisplay.update(0.0f);
        this.displayCards.add((Component)dialSpeedPanel, "DIAL");
        this.displayCards.add((Component)numericSpeedPanel, "NUMERIC");
        CardLayout cl = (CardLayout)this.displayCards.getLayout();
        cl.show(this.displayCards, "DIAL");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        this.speedGroup.add(this.mphButton);
        this.speedGroup.add(this.kphButton);
        this.mphButton.setToolTipText(Bundle.getMessage("TTDisplayMPH"));
        this.kphButton.setToolTipText(Bundle.getMessage("TTDisplayKPH"));
        this.mphButton.setSelected(!this.prefs.getSimplePreferenceState(this.speedUnitsKphPref));
        this.kphButton.setSelected(this.prefs.getSimplePreferenceState(this.speedUnitsKphPref));
        this.displayGroup.add(this.numButton);
        this.displayGroup.add(this.dialButton);
        this.numButton.setToolTipText(Bundle.getMessage("TTDisplayNumeric"));
        this.dialButton.setToolTipText(Bundle.getMessage("TTDisplayDial"));
        this.numButton.setSelected(!this.prefs.getSimplePreferenceState(this.dialTypePref));
        this.dialButton.setSelected(this.prefs.getSimplePreferenceState(this.dialTypePref));
        buttonPanel.add(this.mphButton);
        buttonPanel.add(this.kphButton);
        buttonPanel.add(this.numButton);
        buttonPanel.add(this.dialButton);
        speedPanel.add(this.displayCards);
        speedPanel.add(buttonPanel);
        this.mphButton.addActionListener(e -> this.setUnits());
        this.kphButton.addActionListener(e -> this.setUnits());
        this.numButton.addActionListener(e -> this.setDial());
        this.dialButton.addActionListener(e -> this.setDial());
        basicPane.add(speedPanel);
        JPanel profilePane = new JPanel();
        profilePane.setLayout(new BorderLayout());
        JPanel addrPane = new JPanel();
        GridBagLayout gLayout = new GridBagLayout();
        GridBagConstraints gConstraints = new GridBagConstraints();
        gConstraints.insets = new Insets(3, 3, 3, 3);
        Border addrPaneBorder = BorderFactory.createEtchedBorder();
        TitledBorder addrPaneTitle = BorderFactory.createTitledBorder(addrPaneBorder, Bundle.getMessage("LocoSelection"));
        addrPane.setLayout(gLayout);
        addrPane.setBorder(addrPaneTitle);
        this.setButton = new JButton(Bundle.getMessage("ButtonSet"));
        this.setButton.addActionListener(e -> this.changeOfAddress());
        this.addrSelector.setAddress(null);
        this.rosterBox = new GlobalRosterEntryComboBox();
        this.rosterBox.setNonSelectedItem(Bundle.getMessage("NoLocoSelected"));
        this.rosterBox.setToolTipText(Bundle.getMessage("TTSelectLocoFromRoster"));
        this.rosterBox.addPropertyChangeListener("selectedRosterEntries", pce -> this.rosterItemSelected());
        this.readAddressButton.setToolTipText(Bundle.getMessage("ReadLoco"));
        addrPane.add((Component)this.addrSelector.getCombinedJPanel(), gConstraints);
        addrPane.add((Component)new JLabel(" "), gConstraints);
        addrPane.add((Component)this.setButton, gConstraints);
        addrPane.add((Component)new JLabel(" "), gConstraints);
        addrPane.add((Component)this.rosterBox, gConstraints);
        addrPane.add((Component)new JLabel(" "), gConstraints);
        addrPane.add((Component)this.readAddressButton, gConstraints);
        if ((this.dccServices & 1) != 1 || this.mainButton.isSelected()) {
            this.addrSelector.setEnabled(false);
            this.readAddressButton.setEnabled(false);
        } else {
            this.addrSelector.setEnabled(true);
            this.readAddressButton.setEnabled(true);
        }
        this.readAddressButton.addActionListener(e -> this.readAddress());
        profilePane.add((Component)addrPane, "North");
        this.spFwd = new DccSpeedProfile(29);
        this.spRev = new DccSpeedProfile(29);
        this.spRef = new DccSpeedProfile(29);
        this.profileGraphPane = new GraphPane(this.spFwd, this.spRev, this.spRef);
        this.profileGraphPane.setPreferredSize(new Dimension(600, 300));
        this.profileGraphPane.setXLabel(Bundle.getMessage("SpeedStep"));
        this.profileGraphPane.setUnitsMph();
        profilePane.add((Component)this.profileGraphPane, "Center");
        JPanel profileButtonPane = new JPanel();
        profileButtonPane.setLayout(new FlowLayout());
        profileButtonPane.add(this.trackPowerButton);
        this.trackPowerButton.setToolTipText(Bundle.getMessage("TTPower"));
        profileButtonPane.add(this.startProfileButton);
        this.startProfileButton.setToolTipText(Bundle.getMessage("TTStartProfile"));
        profileButtonPane.add(this.stopProfileButton);
        this.stopProfileButton.setToolTipText(Bundle.getMessage("TTStopProfile"));
        profileButtonPane.add(this.exportProfileButton);
        this.exportProfileButton.setToolTipText(Bundle.getMessage("TTSaveProfile"));
        profileButtonPane.add(this.printProfileButton);
        this.printProfileButton.setToolTipText(Bundle.getMessage("TTPrintProfile"));
        profileButtonPane.add(this.resetGraphButton);
        this.resetGraphButton.setToolTipText(Bundle.getMessage("TTResetGraph"));
        profileButtonPane.add(this.loadProfileButton);
        this.loadProfileButton.setToolTipText(Bundle.getMessage("TTLoadProfile"));
        JPanel profileTitlePane = new JPanel();
        profileTitlePane.setLayout(new BoxLayout(profileTitlePane, 0));
        this.printTitleText.setToolTipText(Bundle.getMessage("TTPrintTitle"));
        this.printTitleText.setText(Bundle.getMessage("TTText1"));
        profileTitlePane.add(this.printTitleText);
        JPanel profileSouthPane = new JPanel();
        profileSouthPane.setLayout(new BoxLayout(profileSouthPane, 1));
        profileSouthPane.add(profileButtonPane);
        this.speedStep1TargetField.setHorizontalAlignment(4);
        this.speedStep1TargetUnit.setPreferredSize(new Dimension(35, 16));
        this.speedStep28TargetField.setHorizontalAlignment(4);
        this.speedStep28TargetUnit.setPreferredSize(new Dimension(35, 16));
        this.speedMatchWarmUpCheckBox.setSelected(true);
        JPanel speedMatchPane = new JPanel();
        speedMatchPane.setLayout(new FlowLayout());
        speedMatchPane.add(this.speedStep1TargetLabel);
        speedMatchPane.add(this.speedStep1TargetField);
        speedMatchPane.add(this.speedStep1TargetUnit);
        speedMatchPane.add(this.speedStep28TargetLabel);
        speedMatchPane.add(this.speedStep28TargetField);
        speedMatchPane.add(this.speedStep28TargetUnit);
        speedMatchPane.add(this.speedMatchWarmUpCheckBox);
        speedMatchPane.add(this.speedMatchButton);
        profileSouthPane.add(speedMatchPane);
        profileSouthPane.add(profileTitlePane);
        profilePane.add((Component)profileSouthPane, "South");
        JPanel profileControlPane = new JPanel();
        profileControlPane.setLayout(new BoxLayout(profileControlPane, 1));
        this.dirFwdButton.setSelected(true);
        this.dirFwdButton.setToolTipText(Bundle.getMessage("TTMeasFwd"));
        this.dirRevButton.setToolTipText(Bundle.getMessage("TTMeasRev"));
        this.dirFwdButton.setForeground(Color.RED);
        this.dirRevButton.setForeground(Color.BLUE);
        profileControlPane.add(this.dirFwdButton);
        profileControlPane.add(this.dirRevButton);
        this.toggleGridButton.setSelected(true);
        profileControlPane.add(this.toggleGridButton);
        this.profileGraphPane.showGrid(this.toggleGridButton.isSelected());
        profilePane.add((Component)profileControlPane, "East");
        this.trackPowerButton.addActionListener(e -> this.trackPower());
        this.startProfileButton.addActionListener(e -> {
            this.getCustomScale();
            this.startProfile();
        });
        this.stopProfileButton.addActionListener(e -> this.stopProfileAndSpeedMatch());
        this.speedMatchButton.addActionListener(e -> {
            if (this.speedMatchState == SpeedMatchState.IDLE && this.profileState == ProfileState.IDLE) {
                this.getCustomScale();
                this.speedStep1Target = Integer.parseInt(this.speedStep1TargetField.getText());
                this.speedStep28Target = Integer.parseInt(this.speedStep28TargetField.getText());
                if (this.mphButton.isSelected()) {
                    this.speedStep1Target = Speed.mphToKph(this.speedStep1Target);
                    this.speedStep28Target = Speed.mphToKph(this.speedStep28Target);
                }
                this.startSpeedMatch();
            } else {
                this.stopProfileAndSpeedMatch();
            }
        });
        this.toggleGridButton.addActionListener(e -> {
            this.profileGraphPane.showGrid(this.toggleGridButton.isSelected());
            this.profileGraphPane.repaint();
        });
        this.exportProfileButton.addActionListener(e -> {
            if (this.dirFwdButton.isSelected() && this.dirRevButton.isSelected()) {
                DccSpeedProfile[] sp = new DccSpeedProfile[]{this.spFwd, this.spRev};
                DccSpeedProfile.export(sp, this.locomotiveAddress.getNumber(), this.profileGraphPane.getUnits());
            } else if (this.dirFwdButton.isSelected()) {
                DccSpeedProfile.export(this.spFwd, this.locomotiveAddress.getNumber(), "fwd", this.profileGraphPane.getUnits());
            } else if (this.dirRevButton.isSelected()) {
                DccSpeedProfile.export(this.spRev, this.locomotiveAddress.getNumber(), "rev", this.profileGraphPane.getUnits());
            }
        });
        this.printProfileButton.addActionListener(e -> this.profileGraphPane.printProfile(this.printTitleText.getText()));
        this.resetGraphButton.addActionListener(e -> {
            this.spFwd.clear();
            this.spRev.clear();
            this.spRef.clear();
            this.speedoDialDisplay.reset();
            this.profileGraphPane.repaint();
        });
        this.loadProfileButton.addActionListener(e -> {
            this.spRef.clear();
            int response = this.spRef.importDccProfile(this.profileGraphPane.getUnits());
            if (response == -1) {
                this.statusLabel.setText(Bundle.getMessage("StatFileError"));
            } else {
                this.statusLabel.setText(Bundle.getMessage("StatFileSuccess"));
            }
            this.profileGraphPane.repaint();
        });
        JPanel tabbedPane = new JPanel();
        tabbedPane.setLayout(new BoxLayout(tabbedPane, 0));
        tabbedPane.add(basicPane);
        if ((this.dccServices & 4) == 4 || (this.dccServices & 2) == 2) {
            tabbedPane.add(profilePane);
        } else {
            log.info(Bundle.getMessage("StatNoDCC"));
            this.statusLabel.setText(Bundle.getMessage("StatNoDCC"));
        }
        this.addHelpMenu("package.jmri.jmrix.bachrus.SpeedoConsoleFrame", true);
        JPanel statusWrapper = new JPanel();
        statusWrapper.setLayout(new BorderLayout());
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout());
        statusPanel.add((Component)this.statusLabel, "West");
        statusPanel.setBorder(BorderFactory.createEtchedBorder(0));
        statusWrapper.add((Component)tabbedPane, "Center");
        statusWrapper.add((Component)statusPanel, "South");
        this.getContentPane().add(statusWrapper);
        this.tc = this._memo.getTrafficController();
        this.tc.addSpeedoListener(this);
        this.setUnits();
        this.setDial();
        this.pack();
        this.speedoDialDisplay.scaleFace();
    }

    @Override
    public synchronized void reply(SpeedoReply l) {
        this.count = l.getCount();
        this.series = l.getSeries();
        if (this.count > 0.0f) {
            switch (this.series) {
                case 4: {
                    this.circ = 12.5664f;
                    this.readerLabel.setText(Bundle.getMessage("Reader40"));
                    break;
                }
                case 5: {
                    this.circ = 18.8496f;
                    this.readerLabel.setText(Bundle.getMessage("Reader50"));
                    break;
                }
                case 6: {
                    this.circ = 50.2655f;
                    this.readerLabel.setText(Bundle.getMessage("Reader60"));
                    break;
                }
                default: {
                    this.speedTextField.setText(Bundle.getMessage("ReaderErr"));
                    log.error("Invalid reader type");
                }
            }
            this.calcSpeed();
        }
        if (!this.timerRunning) {
            this.startReplyTimer();
            this.startDisplayTimer();
            this.startFastDisplayTimer();
            this.timerRunning = true;
        } else {
            this.replyTimer.restart();
        }
    }

    protected void calcSpeed() {
        float thisScale;
        float f = thisScale = this.selectedScale == -1.0f ? (float)this.customScale : this.selectedScale;
        if (this.series > 0) {
            try {
                this.freq = 1500000.0f / this.count;
                this.sampleSpeed = this.freq / 24.0f * this.circ * thisScale * 3600.0f / 1000000.0f * 1.0f;
            }
            catch (ArithmeticException ae) {
                log.error("Exception calculating sampleSpeed {}", (Throwable)ae);
            }
            this.avFn(this.sampleSpeed);
            log.debug("New sample: {} Average: {}", (Object)Float.valueOf(this.sampleSpeed), (Object)Float.valueOf(this.avSpeed));
            log.debug("Acc: {} range: {}", (Object)Float.valueOf(this.acc), (Object)this.range);
            this.switchRange();
        }
    }

    protected void avFn(float speed) {
        this.acc = this.acc - this.avSpeed + speed;
        this.avSpeed = this.acc / (float)filterLength[this.range];
    }

    protected void avClr() {
        this.acc = 0.0f;
        this.avSpeed = 0.0f;
    }

    protected void switchRange() {
        switch (this.range) {
            case 1: {
                if (!(this.sampleSpeed > 9.0f)) break;
                ++this.range;
                this.acc = this.acc * (float)filterLength[2] / (float)filterLength[1];
                break;
            }
            case 2: {
                if (this.sampleSpeed < 7.0f) {
                    --this.range;
                    this.acc = this.acc * (float)filterLength[1] / (float)filterLength[2];
                    break;
                }
                if (!(this.sampleSpeed > 31.0f)) break;
                ++this.range;
                this.acc = this.acc * (float)filterLength[3] / (float)filterLength[2];
                break;
            }
            case 3: {
                if (this.sampleSpeed < 29.0f) {
                    --this.range;
                    this.acc = this.acc * (float)filterLength[2] / (float)filterLength[3];
                    break;
                }
                if (!(this.sampleSpeed > 62.0f)) break;
                ++this.range;
                this.acc = this.acc * (float)filterLength[4] / (float)filterLength[3];
                break;
            }
            case 4: {
                if (!(this.sampleSpeed < 58.0f)) break;
                --this.range;
                this.acc = this.acc * (float)filterLength[3] / (float)filterLength[4];
                break;
            }
            default: {
                log.debug("range {} unsupported, range unchanged.", (Object)this.range);
            }
        }
    }

    protected void showSpeed() {
        float speedForText = this.currentSpeed;
        if (this.mphButton.isSelected()) {
            speedForText = Speed.kphToMph(speedForText);
        }
        if (this.series > 0) {
            if (this.currentSpeed < 0.0f || this.currentSpeed > 999.0f) {
                log.error("Calculated speed out of range: {}", (Object)Float.valueOf(this.currentSpeed));
                this.speedTextField.setText("999");
            } else if ((double)this.currentSpeed > (double)this.oldSpeed * 1.02 || (double)this.currentSpeed < (double)this.oldSpeed * 0.98) {
                this.speedTextField.setText(MessageFormat.format("{0,number,##0.0}", Float.valueOf(speedForText)));
                this.speedTextField.setHorizontalAlignment(4);
                this.oldSpeed = this.currentSpeed;
                this.speedoDialDisplay.update(this.currentSpeed);
            }
        }
    }

    protected void checkCustomScale() {
        if (this.selectedScale == -1.0f) {
            this.customScaleField.setEnabled(true);
        } else {
            this.customScaleField.setEnabled(false);
        }
    }

    protected void setDial() {
        CardLayout cl = (CardLayout)this.displayCards.getLayout();
        if (this.numButton.isSelected()) {
            this.display = DisplayType.NUMERIC;
            cl.show(this.displayCards, "NUMERIC");
        } else {
            this.display = DisplayType.DIAL;
            cl.show(this.displayCards, "DIAL");
        }
    }

    protected void setUnits() {
        if (this.mphButton.isSelected()) {
            this.profileGraphPane.setUnitsMph();
            this.speedStep1TargetUnit.setText(Bundle.getMessage("lblMPH"));
            this.speedStep28TargetUnit.setText(Bundle.getMessage("lblMPH"));
        } else {
            this.profileGraphPane.setUnitsKph();
            this.speedStep1TargetUnit.setText(Bundle.getMessage("lblKPH"));
            this.speedStep28TargetUnit.setText(Bundle.getMessage("lblKPH"));
        }
        this.profileGraphPane.repaint();
        if (this.mphButton.isSelected()) {
            this.speedoDialDisplay.setUnitsMph();
        } else {
            this.speedoDialDisplay.setUnitsKph();
        }
        this.speedoDialDisplay.update(this.currentSpeed);
        this.speedoDialDisplay.repaint();
    }

    protected void getCustomScale() {
        if (this.selectedScale == -1.0f) {
            try {
                this.customScale = Integer.parseUnsignedInt(this.customScaleField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("CustomScaleDialog"), Bundle.getMessage("CustomScaleTitle"), 0);
            }
        }
    }

    private synchronized void changeOfAddress() {
        if (this.addrSelector.getAddress() != null) {
            this.locomotiveAddress = this.addrSelector.getAddress();
            this.setTitle();
        } else {
            this.locomotiveAddress = new DccLocoAddress(0, true);
        }
    }

    public void setRosterEntry(RosterEntry entry) {
        this.rosterBox.setSelectedItem(entry);
        this.addrSelector.setAddress(entry.getDccLocoAddress());
        this.rosterEntry = entry;
        this.changeOfAddress();
    }

    private void rosterItemSelected() {
        if (this.rosterBox.getSelectedRosterEntries().length != 0) {
            this.setRosterEntry(this.rosterBox.getSelectedRosterEntries()[0]);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setPowerStatus();
    }

    private void setPowerStatus() {
        if (this.pm == null) {
            return;
        }
        if (this.pm.getPower() == 2) {
            this.trackPowerButton.setText(Bundle.getMessage("PowerDown"));
        } else if (this.pm.getPower() == 4) {
            this.trackPowerButton.setText(Bundle.getMessage("PowerUp"));
        }
    }

    protected void trackPower() {
        try {
            if (this.pm.getPower() != 2) {
                this.pm.setPower(2);
            } else {
                this.stopProfileAndSpeedMatch();
                this.pm.setPower(4);
            }
        }
        catch (JmriException e) {
            log.error("Exception during power on: {}", (Object)e.toString());
        }
    }

    protected void setupSpeedMatchTimer(boolean isForward, int speedStep, int initialDelay) {
        this.throttle.setIsForward(isForward);
        this.throttle.setSpeedSetting((float)speedStep * this.throttleIncrement);
        this.speedMatchError = 0.0f;
        this.speedMatchTimer.setInitialDelay(initialDelay);
    }

    protected void setSpeedMatchError(float speedTarget) {
        this.speedMatchError = speedTarget - this.currentSpeed;
    }

    protected int getNextSpeedMatchValue(int lastValue) {
        this.speedMatchIntegral += this.speedMatchError;
        this.speedMatchDerivative = this.speedMatchError - this.lastSpeedMatchError;
        int value = lastValue + Math.round(kP * this.speedMatchError + kI * this.speedMatchIntegral + kD * this.speedMatchDerivative);
        if (value > 255) {
            value = 255;
        } else if (value < 1) {
            value = 1;
        }
        return value;
    }

    protected void startSpeedMatch() {
        DccLocoAddress dccLocoAddress = this.addrSelector.getAddress();
        if (this.speedStep1Target < 1.0f) {
            this.statusLabel.setText(Bundle.getMessage("StatInvalidSpeedStep1"));
            log.error("Attempt to speed match to invalid speed step 1 target speed");
            return;
        }
        if (this.speedStep28Target <= this.speedStep1Target) {
            this.statusLabel.setText(Bundle.getMessage("StatInvalidSpeedStep28"));
            log.error("Attempt to speed match to invalid speed step 28 target speed");
            return;
        }
        if (this.locomotiveAddress.getNumber() <= 0) {
            this.statusLabel.setText(Bundle.getMessage("StatInvalidDCCAddress"));
            log.error("Attempt to speed match loco address 0");
            return;
        }
        if (this.speedMatchState == SpeedMatchState.IDLE && this.profileState == ProfileState.IDLE) {
            this.speedMatchState = SpeedMatchState.WAIT_FOR_THROTTLE;
            this.speedMatchButton.setText(Bundle.getMessage("btnStopSpeedMatch"));
            this.vStart = 1;
            this.vHigh = 255;
            this.reverseTrim = 128;
            this.lastVStart = this.vStart;
            this.lastVHigh = this.vHigh;
            this.lastReverseTrim = this.reverseTrim;
            if (InstanceManager.getNullableDefault(AddressedProgrammerManager.class) != null && InstanceManager.getDefault(AddressedProgrammerManager.class).isAddressedModePossible(dccLocoAddress)) {
                this.ops_mode_prog = InstanceManager.getDefault(AddressedProgrammerManager.class).getAddressedProgrammer(dccLocoAddress);
            }
            this.speedMatchTimer = new Timer(4000, e -> this.speedMatchTimeout());
            this.speedMatchTimer.setRepeats(false);
            this.statusLabel.setText(Bundle.getMessage("StatReqThrottle"));
            this.speedMatchTimer.start();
            log.info("Requesting Throttle");
            boolean requestOK = InstanceManager.throttleManagerInstance().requestThrottle(this.locomotiveAddress, (ThrottleListener)this, true);
            if (!requestOK) {
                log.error("Loco Address in use, throttle request failed.");
                this.statusLabel.setText(Bundle.getMessage("StatAddressInUse"));
            }
        }
    }

    protected synchronized void speedMatchTimeout() {
        block0 : switch (this.speedMatchState) {
            case WAIT_FOR_THROTTLE: {
                this.tidyUp();
                log.error("Timeout waiting for throttle");
                this.statusLabel.setText(Bundle.getMessage("StatusTimeout"));
                break;
            }
            case SETUP: {
                switch (this.speedMatchSetupState) {
                    case MOMENTUM_ACCEL_READ: {
                        if (this.progState != ProgState.IDLE) break block0;
                        this.readMomentumAccel();
                        this.speedMatchSetupState = SpeedMatchSetupState.MOMENTUM_DECEL_READ;
                        break;
                    }
                    case MOMENTUM_DECEL_READ: {
                        if (this.progState != ProgState.IDLE) break block0;
                        this.readMomentumDecel();
                        this.speedMatchSetupState = SpeedMatchSetupState.MOMENTUM_ACCEL_WRITE;
                        break;
                    }
                    case MOMENTUM_ACCEL_WRITE: {
                        if (this.progState != ProgState.IDLE) break block0;
                        this.writeMomentumAccel(0);
                        this.speedMatchSetupState = SpeedMatchSetupState.MOMENTUM_DECEL_WRITE;
                        this.speedMatchTimer.setInitialDelay(5000);
                        break;
                    }
                    case MOMENTUM_DECEL_WRITE: {
                        if (this.progState != ProgState.IDLE) break block0;
                        this.writeMomentumDecel(0);
                        this.speedMatchSetupState = SpeedMatchSetupState.VSTART;
                        this.speedMatchTimer.setInitialDelay(1500);
                        break;
                    }
                    case VSTART: {
                        if (this.progState != ProgState.IDLE) break block0;
                        this.writeVStart();
                        this.speedMatchSetupState = SpeedMatchSetupState.VHIGH;
                        break;
                    }
                    case VHIGH: {
                        if (this.progState != ProgState.IDLE) break block0;
                        this.writeVHigh();
                        this.speedMatchSetupState = SpeedMatchSetupState.FORWARD_TRIM;
                        break;
                    }
                    case FORWARD_TRIM: {
                        if (this.progState != ProgState.IDLE) break block0;
                        this.writeForwardTrim(128);
                        this.speedMatchSetupState = SpeedMatchSetupState.REVERSE_TRIM;
                        break;
                    }
                    case REVERSE_TRIM: {
                        if (this.progState != ProgState.IDLE) break block0;
                        this.writeReverseTrim(128);
                        this.speedMatchSetupState = SpeedMatchSetupState.BEGIN_SPEED_MATCH;
                        break;
                    }
                    case BEGIN_SPEED_MATCH: {
                        if (this.progState != ProgState.IDLE) break block0;
                        this.speedMatchSetupState = SpeedMatchSetupState.IDLE;
                        this.speedMatchState = this.speedMatchWarmUpCheckBox.isSelected() ? SpeedMatchState.FORWARD_WARM_UP : SpeedMatchState.FORWARD_SPEED_MATCH_STEP_1;
                        this.setupSpeedMatchTimer(true, 0, 5000);
                        this.speedMatchDuration = 0;
                        break;
                    }
                    default: {
                        log.warn("Unhandled speed match setup state: {}", (Object)this.speedMatchSetupState);
                        break;
                    }
                }
                break;
            }
            case FORWARD_WARM_UP: {
                this.statusLabel.setText(Bundle.getMessage("StatForwardWarmUp", 240 - this.speedMatchDuration));
                if (this.speedMatchDuration >= 240) {
                    this.speedMatchState = SpeedMatchState.FORWARD_SPEED_MATCH_STEP_1;
                    this.setupSpeedMatchTimer(true, 0, 5000);
                    this.speedMatchDuration = 0;
                    this.speedMatchTimer.start();
                    break;
                }
                this.setupSpeedMatchTimer(true, 28, 5000);
                this.speedMatchDuration += 5;
                break;
            }
            case FORWARD_SPEED_MATCH_STEP_1: {
                if (this.progState != ProgState.IDLE) break;
                if (this.speedMatchDuration == 0) {
                    this.statusLabel.setText(Bundle.getMessage("StatSettingSpeedStep1"));
                    this.setupSpeedMatchTimer(true, 1, 15000);
                    this.speedMatchDuration = 1;
                    break;
                }
                this.setSpeedMatchError(this.speedStep1Target);
                if ((double)this.speedMatchError < 0.5 && (double)this.speedMatchError > -0.5) {
                    this.speedMatchState = SpeedMatchState.FORWARD_SPEED_MATCH_STEP_28;
                    this.setupSpeedMatchTimer(true, 0, 8000);
                    this.speedMatchDuration = 0;
                    break;
                }
                this.vStart = this.getNextSpeedMatchValue(this.lastVStart);
                if ((this.lastVStart == 1 || this.lastVStart == 255) && this.vStart == this.lastVStart) {
                    this.statusLabel.setText(Bundle.getMessage("StatSetSpeedStep1Fail"));
                    log.debug("Unable to achieve desired speed at Speed Step 1");
                    this.tidyUp();
                } else {
                    this.lastVStart = this.vStart;
                    this.writeVStart();
                }
                this.speedMatchTimer.setInitialDelay(8000);
                break;
            }
            case FORWARD_SPEED_MATCH_STEP_28: {
                if (this.progState != ProgState.IDLE) break;
                if (this.speedMatchDuration == 0) {
                    this.statusLabel.setText(Bundle.getMessage("StatSettingSpeedStep28"));
                    this.setupSpeedMatchTimer(true, 28, 15000);
                    this.speedMatchDuration = 1;
                    break;
                }
                this.setSpeedMatchError(this.speedStep28Target);
                if ((double)this.speedMatchError < 0.5 && (double)this.speedMatchError > -0.5) {
                    this.speedMatchState = this.speedMatchWarmUpCheckBox.isSelected() ? SpeedMatchState.REVERSE_WARM_UP : SpeedMatchState.REVERSE_SPEED_MATCH_TRIM;
                    this.setupSpeedMatchTimer(false, 0, 5000);
                    this.speedMatchDuration = 0;
                    break;
                }
                this.vHigh = this.getNextSpeedMatchValue(this.lastVHigh);
                if ((this.lastVHigh == 1 || this.lastVHigh == 255) && this.vHigh == this.lastVHigh) {
                    this.statusLabel.setText(Bundle.getMessage("StatSetSpeedStep28Fail"));
                    log.debug("Unable to achieve desired speed at Speed Step 28");
                    this.tidyUp();
                } else {
                    this.lastVHigh = this.vHigh;
                    this.writeVHigh();
                }
                this.speedMatchTimer.setInitialDelay(8000);
                break;
            }
            case REVERSE_WARM_UP: {
                this.statusLabel.setText(Bundle.getMessage("StatReverseWarmUp", 120 - this.speedMatchDuration));
                if (this.speedMatchDuration >= 120) {
                    this.speedMatchState = SpeedMatchState.REVERSE_SPEED_MATCH_TRIM;
                } else {
                    this.speedMatchDuration += 5;
                }
                this.setupSpeedMatchTimer(false, 28, 5000);
                break;
            }
            case REVERSE_SPEED_MATCH_TRIM: {
                if (this.progState != ProgState.IDLE) break;
                if (this.speedMatchDuration == 0) {
                    this.statusLabel.setText(Bundle.getMessage("StatSettingReverseTrim"));
                    this.setupSpeedMatchTimer(false, 28, 15000);
                    this.speedMatchDuration = 1;
                    break;
                }
                this.setSpeedMatchError(this.speedStep28Target);
                if ((double)this.speedMatchError < 0.5 && (double)this.speedMatchError > -0.5) {
                    this.speedMatchState = SpeedMatchState.RESTORE_MOMENTUM;
                    this.speedMatchSetupState = SpeedMatchSetupState.MOMENTUM_ACCEL_WRITE;
                    this.setupSpeedMatchTimer(false, 0, 1500);
                    this.speedMatchDuration = 0;
                    break;
                }
                this.reverseTrim = this.getNextSpeedMatchValue(this.lastReverseTrim);
                if ((this.lastReverseTrim == 1 || this.lastReverseTrim == 255) && this.reverseTrim == this.lastReverseTrim) {
                    this.statusLabel.setText(Bundle.getMessage("StatSetReverseTripFail"));
                    log.debug("Unable to trim reverse to match forward");
                    this.tidyUp();
                } else {
                    this.lastReverseTrim = this.reverseTrim;
                    this.writeReverseTrim(this.reverseTrim);
                }
                this.speedMatchTimer.setInitialDelay(8000);
                break;
            }
            case RESTORE_MOMENTUM: {
                switch (this.speedMatchSetupState) {
                    case MOMENTUM_ACCEL_WRITE: {
                        if (this.progState != ProgState.IDLE) break block0;
                        this.writeMomentumAccel(this.oldMomentumAccel);
                        this.speedMatchSetupState = SpeedMatchSetupState.MOMENTUM_DECEL_WRITE;
                        break;
                    }
                    case MOMENTUM_DECEL_WRITE: {
                        if (this.progState != ProgState.IDLE) break block0;
                        this.writeMomentumDecel(this.oldMomentumDecel);
                        this.speedMatchSetupState = SpeedMatchSetupState.IDLE;
                        break;
                    }
                    case IDLE: {
                        if (this.progState != ProgState.IDLE) break block0;
                        this.tidyUp();
                        this.statusLabel.setText(Bundle.getMessage("StatSpeedMatchComplete"));
                        break;
                    }
                    default: {
                        log.warn("Unhandled speed match cleanup state: {}", (Object)this.speedMatchSetupState);
                        break;
                    }
                }
                break;
            }
            default: {
                this.tidyUp();
                log.error("Unexpected speed match timeout");
            }
        }
        if (this.speedMatchState != SpeedMatchState.IDLE) {
            this.speedMatchTimer.start();
        }
    }

    protected synchronized void startProfile() {
        if (this.locomotiveAddress.getNumber() > 0) {
            if ((this.dirFwdButton.isSelected() || this.dirRevButton.isSelected()) && this.speedMatchState == SpeedMatchState.IDLE && this.profileState == ProfileState.IDLE) {
                this.profileTimer = new Timer(4000, e -> this.profileTimeout());
                this.profileTimer.setRepeats(false);
                this.profileState = ProfileState.WAIT_FOR_THROTTLE;
                this.statusLabel.setText(Bundle.getMessage("StatReqThrottle"));
                this.spFwd.clear();
                this.spRev.clear();
                this.profileDir = this.dirFwdButton.isSelected() ? ProfileDirection.FORWARD : ProfileDirection.REVERSE;
                this.resetGraphButton.setEnabled(false);
                this.profileGraphPane.repaint();
                this.profileTimer.start();
                log.info("Requesting throttle");
                boolean requestOK = InstanceManager.throttleManagerInstance().requestThrottle(this.locomotiveAddress, (ThrottleListener)this, true);
                if (!requestOK) {
                    log.error("Loco Address in use, throttle request failed.");
                }
            }
        } else {
            log.error("Attempt to profile loco address 0");
        }
    }

    protected synchronized void profileTimeout() {
        if (this.profileState == ProfileState.WAIT_FOR_THROTTLE) {
            this.tidyUp();
            log.error("Timeout waiting for throttle");
            this.statusLabel.setText(Bundle.getMessage("StatusTimeout"));
        } else if (this.profileState == ProfileState.RUNNING) {
            if (this.profileDir == ProfileDirection.FORWARD) {
                this.spFwd.setPoint(this.profileStep, this.avSpeed);
                this.statusLabel.setText(Bundle.getMessage("Fwd", this.profileStep));
            } else {
                this.spRev.setPoint(this.profileStep, this.avSpeed);
                this.statusLabel.setText(Bundle.getMessage("Rev", this.profileStep));
            }
            this.profileGraphPane.repaint();
            if (this.profileStep == 29) {
                if (this.profileDir == ProfileDirection.FORWARD && this.dirRevButton.isSelected()) {
                    this.profileDir = ProfileDirection.REVERSE;
                    this.throttle.setIsForward(false);
                    this.profileStep = 0;
                    this.avClr();
                    this.statusLabel.setText(Bundle.getMessage("StatCreateRev"));
                } else {
                    this.tidyUp();
                    this.statusLabel.setText(Bundle.getMessage("StatDone"));
                }
            } else {
                this.profileSpeed = this.profileStep == 28 ? 0.0f : (this.profileSpeed += this.throttleIncrement);
                this.throttle.setSpeedSetting(this.profileSpeed);
                ++this.profileStep;
                this.profileTimer.setDelay(7000 - this.range * 1000);
            }
        } else {
            log.error("Unexpected profile timeout");
            this.profileTimer.stop();
        }
    }

    protected void tidyUp() {
        this.stopTimers();
        if (this.throttle != null) {
            this.throttle.setSpeedSetting(0.0f);
            InstanceManager.throttleManagerInstance().releaseThrottle(this.throttle, this);
            this.throttle = null;
        }
        if (this.ops_mode_prog != null) {
            InstanceManager.getDefault(AddressedProgrammerManager.class).releaseAddressedProgrammer(this.ops_mode_prog);
            this.ops_mode_prog = null;
        }
        this.resetGraphButton.setEnabled(true);
        this.progState = ProgState.IDLE;
        this.profileState = ProfileState.IDLE;
        this.speedMatchState = SpeedMatchState.IDLE;
        this.speedMatchSetupState = SpeedMatchSetupState.IDLE;
        this.speedMatchButton.setText(Bundle.getMessage("btnStartSpeedMatch"));
    }

    protected synchronized void stopProfileAndSpeedMatch() {
        if (this.profileState != ProfileState.IDLE) {
            this.tidyUp();
            this.profileState = ProfileState.IDLE;
            log.info("Profiling stopped by user");
        }
        if (this.speedMatchState != SpeedMatchState.IDLE) {
            this.tidyUp();
            this.speedMatchState = SpeedMatchState.IDLE;
            this.statusLabel.setText(" ");
            log.info("Speed matching stopped by user");
        }
    }

    protected void stopTimers() {
        if (this.profileTimer != null) {
            this.profileTimer.stop();
        }
        if (this.speedMatchTimer != null) {
            this.speedMatchTimer.stop();
        }
    }

    @Override
    public synchronized void notifyThrottleFound(DccThrottle t) {
        this.stopTimers();
        this.throttle = t;
        log.info("Throttle acquired");
        this.throttle.setSpeedStepMode(SpeedStepMode.NMRA_DCC_28);
        if (this.throttle.getSpeedStepMode() != SpeedStepMode.NMRA_DCC_28) {
            log.error("Failed to set 28 step mode");
            this.statusLabel.setText(Bundle.getMessage("ThrottleError28"));
            InstanceManager.throttleManagerInstance().releaseThrottle(this.throttle, this);
            return;
        }
        try {
            this.pm.setPower(2);
        }
        catch (JmriException e) {
            log.error("Exception during power on: {}", (Object)e.toString());
        }
        this.throttleIncrement = this.throttle.getSpeedIncrement();
        if (this.profileState == ProfileState.WAIT_FOR_THROTTLE) {
            log.info("Starting profiling");
            this.profileState = ProfileState.RUNNING;
            this.profileSpeed = 0.0f;
            this.profileStep = 0;
            this.throttle.setSpeedSetting(this.profileSpeed);
            if (this.profileDir == ProfileDirection.FORWARD) {
                this.throttle.setIsForward(true);
                this.statusLabel.setText(Bundle.getMessage("StatCreateFwd"));
            } else {
                this.throttle.setIsForward(false);
                this.statusLabel.setText(Bundle.getMessage("StatCreateRev"));
            }
            this.profileTimer.setRepeats(true);
            this.profileTimer.start();
        } else if (this.speedMatchState == SpeedMatchState.WAIT_FOR_THROTTLE) {
            log.info("Starting speed matching");
            this.speedMatchState = SpeedMatchState.SETUP;
            this.speedMatchSetupState = SpeedMatchSetupState.MOMENTUM_ACCEL_READ;
            this.speedMatchTimer.setInitialDelay(1500);
            this.speedMatchTimer.start();
        } else {
            this.tidyUp();
        }
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
        InstanceManager.throttleManagerInstance().responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.STEAL);
    }

    protected void startReplyTimer() {
        this.replyTimer = new Timer(4000, e -> this.replyTimeout());
        this.replyTimer.setRepeats(true);
        this.replyTimer.start();
    }

    protected void startDisplayTimer() {
        this.displayTimer = new Timer(500, e -> this.displayTimeout());
        this.displayTimer.setRepeats(true);
        this.displayTimer.start();
    }

    protected void startFastDisplayTimer() {
        this.fastDisplayTimer = new Timer(100, e -> this.fastDisplayTimeout());
        this.fastDisplayTimer.setRepeats(true);
        this.fastDisplayTimer.start();
    }

    protected synchronized void replyTimeout() {
        this.targetSpeed = 0.0f;
        this.avClr();
        this.oldSpeed = 0.0f;
        this.showSpeed();
    }

    protected synchronized void displayTimeout() {
        this.targetSpeed = this.avSpeed;
        this.incSpeed = (this.targetSpeed - this.currentSpeed) / 5.0f;
    }

    protected synchronized void fastDisplayTimeout() {
        this.currentSpeed = Math.abs(this.targetSpeed - this.currentSpeed) < Math.abs(this.incSpeed) ? this.targetSpeed : (this.currentSpeed += this.incSpeed);
        if (this.currentSpeed < 0.01f) {
            this.currentSpeed = 0.0f;
        }
        this.showSpeed();
    }

    protected synchronized void throttleTimeout() {
        InstanceManager.throttleManagerInstance().cancelThrottleRequest(this.locomotiveAddress, (ThrottleListener)this);
        this.profileState = ProfileState.IDLE;
        this.speedMatchState = SpeedMatchState.IDLE;
        log.error("Timeout waiting for throttle");
    }

    protected synchronized void writeMomentumAccel(int value) {
        this.progState = ProgState.WRITE3;
        this.statusLabel.setText(Bundle.getMessage("ProgSetAccel", value));
        this.startOpsModeWrite("3", value);
    }

    protected synchronized void writeMomentumDecel(int value) {
        this.progState = ProgState.WRITE4;
        this.statusLabel.setText(Bundle.getMessage("ProgSetDecel", value));
        this.startOpsModeWrite("4", value);
    }

    protected synchronized void writeVStart() {
        this.progState = ProgState.WRITE2;
        this.statusLabel.setText(Bundle.getMessage("ProgSetVStart", this.vStart));
        this.startOpsModeWrite("2", this.vStart);
    }

    protected synchronized void writeVMid() {
        int vMid = (this.vStart + this.vHigh) / 2;
        this.progState = ProgState.WRITE6;
        this.startOpsModeWrite("6", vMid);
    }

    protected synchronized void writeVHigh() {
        this.progState = ProgState.WRITE5;
        this.statusLabel.setText(Bundle.getMessage("ProgSetVHigh", this.vHigh));
        this.startOpsModeWrite("5", this.vHigh);
    }

    protected synchronized void writeForwardTrim(int value) {
        this.progState = ProgState.WRITE66;
        this.statusLabel.setText(Bundle.getMessage("ProgSetForwardTrim", value));
        this.startOpsModeWrite("66", value);
    }

    protected synchronized void writeReverseTrim(int value) {
        this.progState = ProgState.WRITE95;
        this.statusLabel.setText(Bundle.getMessage("ProgSetReverseTrim", value));
        this.startOpsModeWrite("95", value);
    }

    protected void readMomentumAccel() {
        this.progState = ProgState.READ3;
        this.statusLabel.setText(Bundle.getMessage("ProgReadAccel"));
        this.startRead("3");
    }

    protected void readMomentumDecel() {
        this.progState = ProgState.READ4;
        this.statusLabel.setText(Bundle.getMessage("ProgReadDecel"));
        this.startRead("4");
    }

    protected void readAddress() {
        this.progState = ProgState.READ29;
        this.statusLabel.setText(Bundle.getMessage("ProgRd29"));
        this.startRead("29");
    }

    protected void startOpsModeWrite(String cv, int value) {
        try {
            this.ops_mode_prog.writeCV(cv, value, this);
        }
        catch (ProgrammerException e) {
            log.error("Exception writing CV {} {}", (Object)cv, (Object)e);
        }
    }

    protected void startRead(String cv) {
        try {
            this.prog.readCV(String.valueOf(cv), this);
        }
        catch (ProgrammerException e) {
            log.error("Exception reading CV {} {}", (Object)cv, (Object)e);
        }
    }

    @Override
    public void programmingOpReply(int value, int status) {
        if (status == 0) {
            switch (this.progState) {
                case IDLE: {
                    log.debug("unexpected reply in IDLE state");
                    break;
                }
                case READ29: {
                    if ((value & 0x20) == 0) {
                        this.progState = ProgState.READ1;
                        this.statusLabel.setText(Bundle.getMessage("ProgRdShort"));
                        this.startRead("1");
                        break;
                    }
                    this.progState = ProgState.READ17;
                    this.statusLabel.setText(Bundle.getMessage("ProgRdExtended"));
                    this.startRead("17");
                    break;
                }
                case READ1: {
                    this.readAddress = value;
                    this.addrSelector.setAddress(new DccLocoAddress(this.readAddress, false));
                    this.changeOfAddress();
                    this.progState = ProgState.IDLE;
                    break;
                }
                case READ17: {
                    this.readAddress = value;
                    this.progState = ProgState.READ18;
                    this.startRead("18");
                    break;
                }
                case READ18: {
                    this.readAddress = (this.readAddress & 0x3F) * 256 + value;
                    this.addrSelector.setAddress(new DccLocoAddress(this.readAddress, true));
                    this.changeOfAddress();
                    this.statusLabel.setText(Bundle.getMessage("ProgRdComplete"));
                    this.progState = ProgState.IDLE;
                    break;
                }
                case READ3: {
                    this.oldMomentumAccel = value;
                    this.progState = ProgState.IDLE;
                    break;
                }
                case READ4: {
                    this.oldMomentumDecel = value;
                    this.progState = ProgState.IDLE;
                    break;
                }
                case WRITE3: 
                case WRITE4: 
                case WRITE6: 
                case WRITE66: 
                case WRITE95: {
                    this.progState = ProgState.IDLE;
                    break;
                }
                case WRITE2: 
                case WRITE5: {
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    this.writeVMid();
                    break;
                }
                default: {
                    this.progState = ProgState.IDLE;
                    log.warn("Unhandled read state: {}", (Object)this.progState);
                    break;
                }
            }
        } else {
            log.error("Status not OK during {}: {}", (Object)this.progState.toString(), (Object)status);
            this.statusLabel.setText(Bundle.getMessage("ProgError"));
            this.progState = ProgState.IDLE;
            this.tidyUp();
        }
    }

    protected static enum DisplayType {
        NUMERIC,
        DIAL;

    }

    protected static enum ProfileDirection {
        FORWARD,
        REVERSE;

    }

    protected static enum ProfileState {
        IDLE,
        WAIT_FOR_THROTTLE,
        RUNNING;

    }

    protected static enum ProgState {
        IDLE,
        READ1,
        READ3,
        READ4,
        READ17,
        READ18,
        READ29,
        WRITE2,
        WRITE3,
        WRITE4,
        WRITE5,
        WRITE6,
        WRITE66,
        WRITE95;

    }

    protected static enum SpeedMatchSetupState {
        IDLE,
        MOMENTUM_ACCEL_READ,
        MOMENTUM_DECEL_READ,
        MOMENTUM_ACCEL_WRITE,
        MOMENTUM_DECEL_WRITE,
        VSTART,
        VHIGH,
        FORWARD_TRIM,
        REVERSE_TRIM,
        BEGIN_SPEED_MATCH;

    }

    protected static enum SpeedMatchState {
        IDLE,
        WAIT_FOR_THROTTLE,
        SETUP,
        FORWARD_WARM_UP,
        REVERSE_WARM_UP,
        FORWARD_SPEED_MATCH_STEP_1,
        FORWARD_SPEED_MATCH_STEP_28,
        REVERSE_SPEED_MATCH_TRIM,
        RESTORE_MOMENTUM;

    }
}

