/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bachrus;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JPanel;
import jmri.jmrix.bachrus.Bundle;
import jmri.jmrix.bachrus.DccSpeedProfile;
import jmri.jmrix.bachrus.Speed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphPane
extends JPanel
implements Printable {
    final int PAD = 40;
    protected String xLabel;
    protected String yLabel;
    protected DccSpeedProfile[] _sp;
    protected String annotate;
    protected Color[] colors = new Color[]{Color.RED, Color.BLUE, Color.BLACK};
    protected boolean _grid = false;
    int units = 0;
    private static final Logger log = LoggerFactory.getLogger(GraphPane.class);

    public GraphPane() {
        this._sp = new DccSpeedProfile[1];
        this._sp[0] = new DccSpeedProfile(28);
    }

    public GraphPane(DccSpeedProfile sp) {
        this._sp = new DccSpeedProfile[1];
        this._sp[0] = sp;
    }

    public GraphPane(DccSpeedProfile sp0, DccSpeedProfile sp1) {
        this._sp = new DccSpeedProfile[2];
        this._sp[0] = sp0;
        this._sp[1] = sp1;
    }

    public GraphPane(DccSpeedProfile sp0, DccSpeedProfile sp1, DccSpeedProfile ref) {
        this._sp = new DccSpeedProfile[3];
        this._sp[0] = sp0;
        this._sp[1] = sp1;
        this._sp[2] = ref;
    }

    public void setXLabel(String s) {
        this.xLabel = s;
    }

    public void setYLabel(String s) {
        this.yLabel = s;
    }

    public void showGrid(boolean b) {
        this._grid = b;
    }

    void setUnitsMph() {
        this.units = 0;
        this.setYLabel(Bundle.getMessage("SpeedMPH"));
    }

    void setUnitsKph() {
        this.units = 1;
        this.setYLabel(Bundle.getMessage("SpeedKPH"));
    }

    public int getUnits() {
        return this.units;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawGraph(g);
    }

    protected void drawGraph(Graphics g) {
        float scale;
        if (!(g instanceof Graphics2D)) {
            throw new IllegalArgumentException("Graphics object passed is not the correct type");
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.getWidth();
        int h = this.getHeight();
        g2.draw(new Line2D.Double(40.0, 40.0, 40.0, h - 40));
        g2.draw(new Line2D.Double(40.0, h - 40, w - 40, h - 40));
        Font font = g2.getFont();
        FontRenderContext frc = g2.getFontRenderContext();
        LineMetrics lm = font.getLineMetrics("0", frc);
        float[] dash1 = new float[]{1.0f};
        BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
        BasicStroke plain = new BasicStroke(1.0f);
        float sh = lm.getAscent() + lm.getDescent();
        float sy = 40.0f + ((float)(h - 80) - (float)this.yLabel.length() * sh) / 2.0f + lm.getAscent();
        g2.setPaint(Color.green.darker());
        int i = 0;
        while (i < this.yLabel.length()) {
            String letter = String.valueOf(this.yLabel.charAt(i));
            float sw = (float)font.getStringBounds(letter, frc).getWidth();
            float sx = (20.0f - sw) / 2.0f;
            g2.drawString(letter, sx, sy);
            sy += sh;
            ++i;
        }
        sy = (float)(h - 20) + (20.0f - sh) / 2.0f + lm.getAscent();
        float sw = (float)font.getStringBounds(this.xLabel, frc).getWidth();
        float sx = ((float)w - sw) / 2.0f;
        g2.drawString(this.xLabel, sx, sy);
        float maxSpeed = 0.0f;
        int i2 = 0;
        while (i2 < this._sp.length) {
            maxSpeed = Math.max(this._sp[i2].getMax(), maxSpeed);
            ++i2;
        }
        float yInc = scale = (float)(h - 80) / maxSpeed;
        int yMod = 10;
        int gridMod = 2;
        if (this.units == 0) {
            yInc = Speed.mphToKph(yInc);
        }
        if (this.units == 1 && maxSpeed > 100.0f || this.units == 0 && maxSpeed > 160.0f) {
            log.debug("Adjusting Y axis spacing for max speed");
            yMod *= 2;
            gridMod *= 2;
        }
        int i3 = 0;
        while ((float)i3 <= (float)(h - 80) / yInc) {
            g2.setPaint(Color.green.darker());
            g2.setStroke(plain);
            float y1 = (float)(h - 40) - (float)i3 * yInc;
            if (i3 % yMod == 0) {
                g2.draw(new Line2D.Double(35.0, y1, 40.0, y1));
                String ordString = Integer.toString(i3);
                sw = (float)font.getStringBounds(ordString, frc).getWidth();
                sx = 35.0f - sw;
                sy = y1 + lm.getAscent() / 2.0f;
                g2.drawString(ordString, sx, sy);
            }
            if (this._grid && i3 > 0 && i3 % gridMod == 0) {
                g2.setPaint(Color.LIGHT_GRAY);
                if (i3 % yMod != 0) {
                    g2.setStroke(dashed);
                }
                g2.draw(new Line2D.Double(40.0, y1, w - 40, y1));
            }
            ++i3;
        }
        if (this._grid) {
            g2.setPaint(Color.LIGHT_GRAY);
            g2.setStroke(dashed);
            g2.draw(new Line2D.Double(40.0, 40.0, w - 40, 40.0));
        }
        float xInc = (float)(w - 80) / (float)(this._sp[0].getLength() - 1);
        int i4 = 0;
        while (i4 < this._sp[0].getLength()) {
            g2.setPaint(Color.green.darker());
            g2.setStroke(plain);
            float x1 = 0.0f;
            int j = 0;
            while (j < this._sp.length) {
                x1 = 40.0f + (float)i4 * xInc;
                float y1 = (float)(h - 40) - scale * this._sp[j].getPoint(i4);
                float x2 = 40.0f + (float)(i4 + 1) * xInc;
                float y2 = (float)(h - 40) - scale * this._sp[j].getPoint(i4 + 1);
                if (i4 <= this._sp[j].getLast() - 1) {
                    g2.draw(new Line2D.Double(x1, y1, x2, y2));
                }
                ++j;
            }
            g2.draw(new Line2D.Double(x1, h - 35, x1, h - 40));
            if (i4 % 5 == 0 || i4 == this._sp[0].getLength() - 1) {
                String abString = Integer.toString(i4);
                sw = (float)font.getStringBounds(abString, frc).getWidth();
                sx = x1 - sw / 2.0f;
                sy = (float)(h - 40) + (20.0f - sh) / 2.0f + lm.getAscent();
                g2.drawString(abString, sx, sy);
            }
            if (this._grid && i4 > 0) {
                g2.setPaint(Color.LIGHT_GRAY);
                if (i4 % 5 != 0) {
                    g2.setStroke(dashed);
                }
                g2.draw(new Line2D.Double(x1, 40.0, x1, h - 40));
            }
            ++i4;
        }
        g2.setStroke(plain);
        i4 = 0;
        while (i4 <= this._sp[0].getLength()) {
            int j = 0;
            while (j < this._sp.length) {
                g2.setPaint(this.colors[j]);
                float x = 40.0f + (float)i4 * xInc;
                float y = (float)(h - 40) - scale * this._sp[j].getPoint(i4);
                if (i4 <= this._sp[j].getLast()) {
                    g2.fill(new Ellipse2D.Double(x - 2.0f, y - 2.0f, 4.0, 4.0));
                }
                ++j;
            }
            ++i4;
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        if (!(g instanceof Graphics2D)) {
            throw new IllegalArgumentException("Graphics object passed is not the correct type");
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(pf.getImageableX(), pf.getImageableY());
        double scale = 1.0;
        if ((double)this.getWidth() > pf.getImageableWidth()) {
            scale *= pf.getImageableWidth() / (double)this.getWidth();
        }
        if ((double)this.getHeight() > pf.getImageableHeight()) {
            scale *= pf.getImageableHeight() / (double)this.getHeight();
        }
        g2.scale(scale, scale);
        this.drawGraph(g);
        g2.setPaint(Color.BLACK);
        g2.drawString(this.annotate, 0.0f, (float)Math.round((double)this.getHeight() + 80.0 * scale));
        return 0;
    }

    public void printProfile(String s) {
        this.annotate = s;
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        boolean ok = job.printDialog();
        if (ok) {
            try {
                job.print();
            }
            catch (PrinterException ex) {
                log.error("Exception whilst printing profile {}", (Throwable)ex);
            }
        }
    }
}

