/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.anyma;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Light;
import jmri.Manager;
import jmri.jmrix.anyma.AnymaDMX_SystemConnectionMemo;
import jmri.jmrix.anyma.AnymaDMX_UsbLight;
import jmri.jmrix.anyma.Bundle;
import jmri.managers.AbstractLightManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsbLightManager
extends AbstractLightManager {
    private static final Logger log = LoggerFactory.getLogger(UsbLightManager.class);

    public UsbLightManager(AnymaDMX_SystemConnectionMemo memo) {
        super(memo);
        log.debug("*    UsbLightManager constructor called");
    }

    @Override
    @Nonnull
    public AnymaDMX_SystemConnectionMemo getMemo() {
        return (AnymaDMX_SystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    public Light createNewLight(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        log.debug("*    UsbLightManager.createNewLight() called");
        int nAddress = this.getMemo().getNodeAddressFromSystemName(systemName);
        if (nAddress != -1) {
            int channelNum = this.getMemo().getChannelFromSystemName(systemName);
            if (channelNum != 0) {
                if (this.getMemo().validSystemNameFormat(systemName, 'L') == Manager.NameValidity.VALID) {
                    if (this.getMemo().validSystemNameConfig(systemName, 'L')) {
                        return new AnymaDMX_UsbLight(systemName, userName, this.getMemo());
                    }
                    log.warn("Light System Name does not refer to configured hardware: {}", (Object)systemName);
                    throw new IllegalArgumentException("Light System Name " + systemName + " does not refer to configured hardware");
                }
                log.error("Invalid Light System Name format: {}", (Object)systemName);
                throw new IllegalArgumentException("Invalid Light System Name format: " + systemName);
            }
            log.error("Invalid channel number from System Name: {}", (Object)systemName);
            throw new IllegalArgumentException("Invalid channel number from System Name: " + systemName);
        }
        throw new IllegalArgumentException("Invalid Node Address from System Name: " + systemName);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        log.debug("*    UsbLightManager.validSystemNameFormat() called");
        return this.getMemo().validSystemNameFormat(systemName, 'L');
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return this.validateIntegerSystemNameFormat(systemName, 1, 512, locale);
    }

    @Override
    public boolean validSystemNameConfig(@Nonnull String systemName) {
        log.debug("*    UsbLightManager.validSystemNameConfig() called");
        return this.getMemo().validSystemNameConfig(systemName, 'L');
    }

    @Override
    @Nonnull
    public String convertSystemNameToAlternate(@Nonnull String systemName) {
        log.debug("*    UsbLightManager.convertSystemNameToAlternate() called");
        return this.getMemo().convertSystemNameToAlternate(systemName);
    }

    @Override
    public boolean supportsVariableLights(@Nonnull String systemName) {
        return true;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

