/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.anyma;

import jmri.implementation.AbstractVariableLight;
import jmri.jmrix.anyma.AnymaDMX_SystemConnectionMemo;
import jmri.jmrix.anyma.AnymaDMX_TrafficController;
import jmri.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnymaDMX_UsbLight
extends AbstractVariableLight {
    private AnymaDMX_SystemConnectionMemo _memo = null;
    private int mChannel = 0;
    private static final Logger log = LoggerFactory.getLogger(AnymaDMX_UsbLight.class);

    public AnymaDMX_UsbLight(String systemName, AnymaDMX_SystemConnectionMemo memo) {
        super(systemName);
        log.debug("*    UsbLight constructor called");
        this._memo = memo;
        this.initializeLight();
    }

    public AnymaDMX_UsbLight(String systemName, String userName, AnymaDMX_SystemConnectionMemo memo) {
        super(systemName, userName);
        log.debug("*    UsbLight constructor called");
        this._memo = memo;
        this.initializeLight();
    }

    private void initializeLight() {
        log.debug("*    UsbLight.initializeLight() called");
        this.mChannel = this._memo.getChannelFromSystemName(this.getSystemName());
        this.setState(4);
    }

    @Override
    protected void doNewState(int oldState, int newState) {
        log.debug("*    UsbLight.doNewState({}, {}) called", (Object)oldState, (Object)newState);
        AnymaDMX_TrafficController trafficController = this._memo.getTrafficController();
        if (trafficController != null) {
            if (newState == 2) {
                trafficController.setChannelValue(this.mChannel, (byte)-1);
            } else if (newState == 4) {
                trafficController.setChannelValue(this.mChannel, (byte)0);
            } else {
                log.warn("illegal state requested for Light: {}", (Object)this.getSystemName());
            }
        }
    }

    @Override
    protected void sendIntensity(double intensity) {
        log.debug("*    sendIntensity({})", (Object)("" + intensity));
        AnymaDMX_TrafficController trafficController = this._memo.getTrafficController();
        if (trafficController != null) {
            byte value = (byte)MathUtil.pin(intensity * 255.0, 0.0, 255.0);
            trafficController.setChannelValue(this.mChannel, value);
        }
    }

    @Override
    protected void sendOnOffCommand(int newState) {
        log.debug("*    sendOnOffCommand({})", (Object)newState);
        AnymaDMX_TrafficController trafficController = this._memo.getTrafficController();
        if (trafficController != null) {
            if (newState == 2) {
                trafficController.setChannelValue(this.mChannel, (byte)-1);
            } else if (newState == 4) {
                trafficController.setChannelValue(this.mChannel, (byte)0);
            } else {
                log.warn("illegal state requested for Light: {}", (Object)this.getSystemName());
            }
        }
    }

    @Override
    protected int getNumberOfSteps() {
        return 256;
    }
}

