/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.anyma;

import java.util.Comparator;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.anyma.AnymaDMX_TrafficController;
import jmri.jmrix.anyma.UsbLightManager;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnymaDMX_SystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    private boolean configured = false;
    private AnymaDMX_TrafficController trafficController = null;
    private static final Logger log = LoggerFactory.getLogger(AnymaDMX_SystemConnectionMemo.class);

    public AnymaDMX_SystemConnectionMemo() {
        this("D", "Anyma DMX512");
        log.debug("* Constructor()");
    }

    public AnymaDMX_SystemConnectionMemo(@Nonnull String prefix, @Nonnull String userName) {
        super(prefix, userName);
        log.debug("* Constructor ({}, {})", (Object)prefix, (Object)userName);
        this.register();
        InstanceManager.store(this, AnymaDMX_SystemConnectionMemo.class);
    }

    protected AnymaDMX_TrafficController getTrafficController() {
        return this.trafficController;
    }

    protected void setTrafficController(AnymaDMX_TrafficController trafficController) {
        this.trafficController = trafficController;
    }

    public String getUserNameFromSystemName(String systemName) {
        log.debug("* getUserNameFromSystemName('{}')", (Object)systemName);
        String result = "";
        int offset = this.checkSystemPrefix(systemName);
        if (offset > 0 && systemName.length() > offset && systemName.charAt(offset) == 'L') {
            Light lgt = null;
            lgt = InstanceManager.lightManagerInstance().getBySystemName(systemName);
            if (lgt != null) {
                result = lgt.getUserName();
            }
        }
        return result;
    }

    public int getChannelFromSystemName(String systemName) {
        int result = 0;
        log.debug("* getChannelFromSystemName('{}')", (Object)systemName);
        int offset = this.checkSystemPrefix(systemName);
        if (offset > 0) {
            if (this.validSystemNameFormat(systemName, systemName.charAt(offset)) == Manager.NameValidity.VALID) {
                int k = 0;
                int i = offset;
                while (i < systemName.length()) {
                    if (systemName.charAt(i) == 'L') {
                        k = i + 1;
                        break;
                    }
                    ++i;
                }
                if (k > offset) {
                    try {
                        result = Integer.parseInt(systemName.substring(k));
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.warn("invalid character in channel number field of anyma dmx system name: {}", (Object)systemName);
                    }
                }
            } else {
                log.error("No point in normalizing if a valid system name format is not present");
            }
        } else {
            log.error("invalid system prefix in anyma dmx system name in getChannelFromSystemName: {}", (Object)systemName);
        }
        return result;
    }

    public int checkSystemPrefix(String systemName) {
        log.debug("* checkSystemPrefix('{}')", (Object)systemName);
        int result = -1;
        if (systemName.startsWith(this.getSystemPrefix())) {
            result = this.getSystemPrefix().length();
        }
        return result;
    }

    public String convertSystemNameToAlternate(String systemName) {
        log.debug("* convertSystemNameToAlternate('{}')", (Object)systemName);
        String result = "";
        int offset = this.checkSystemPrefix(systemName);
        if (offset > 0) {
            if (this.validSystemNameFormat(systemName, systemName.charAt(offset)) == Manager.NameValidity.VALID) {
                int channelNum = Integer.parseInt(systemName.substring(offset + 1));
                result = String.valueOf(systemName.substring(0, offset + 1)) + Integer.toString(channelNum);
            } else {
                log.error("valid system name format not present in anyma dmx system name: {}", (Object)systemName);
            }
        } else {
            log.error("invalid system prefix in anyma dmx system name in convertSystemNameToAlternate: {}", (Object)systemName);
        }
        return result;
    }

    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName, char type) {
        Manager.NameValidity result;
        block7: {
            log.debug("* validSystemNameFormat('{}', '{}')", (Object)systemName, (Object)Character.valueOf(type));
            result = Manager.NameValidity.INVALID;
            int offset = this.checkSystemPrefix(systemName);
            if (offset > 0) {
                if (systemName.charAt(offset) == type) {
                    try {
                        int num = Integer.parseInt(systemName.substring(offset + 1));
                        if (num >= 1 && num <= 512) {
                            result = Manager.NameValidity.VALID;
                            break block7;
                        }
                        log.debug("number field out of range in anyma dmx system name: {}", (Object)systemName);
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.debug("invalid character in number field of anyma dmx system name: {}", (Object)systemName);
                    }
                } else {
                    log.error("invalid type character in anyma dmx system name: {}", (Object)systemName);
                }
            } else {
                log.error("invalid system prefix in anyma dmx system name in validSystemNameFormat: {}", (Object)systemName);
            }
        }
        return result;
    }

    public boolean validSystemNameConfig(String systemName, char type) {
        log.debug("* validSystemNameConfig('{}', '{}')", (Object)systemName, (Object)Character.valueOf(type));
        boolean result = false;
        if (this.validSystemNameFormat(systemName, type) == Manager.NameValidity.VALID) {
            if (type == 'L') {
                int channel = this.getChannelFromSystemName(systemName);
                if (channel >= 1 && channel <= 512) {
                    result = true;
                }
            } else {
                log.error("Invalid type specification in validSystemNameConfig call");
            }
        } else {
            log.error("valid system name format is not present");
        }
        return result;
    }

    public int getNodeAddressFromSystemName(String systemName) {
        int result = -1;
        log.debug("* getNodeAddressFromSystemName('{}')", (Object)systemName);
        int offset = this.checkSystemPrefix(systemName);
        if (offset > 0) {
            if (systemName.charAt(offset) == 'L') {
                int num = Integer.parseInt(systemName.substring(offset + 1));
                if (num > 0) {
                    result = num;
                } else {
                    log.warn("invalid anyma dmx system name: {}", (Object)systemName);
                }
            } else {
                log.error("invalid character in header field of system name: {}", (Object)systemName);
            }
        }
        return result;
    }

    @Override
    public boolean provides(Class<?> c) {
        return this.get(c) != null;
    }

    @Override
    public <T> T get(Class<?> T) {
        UsbLightManager result = null;
        log.debug("* get({})", (Object)T.toString());
        if (!this.getDisabled()) {
            if (!this.configured) {
                this.configureManagers();
            }
            if (T.equals(LightManager.class)) {
                result = this.getLightManager();
            }
        }
        return (T)result;
    }

    @Override
    public void configureManagers() {
        log.debug("* configureManagers()");
        InstanceManager.setLightManager(this.getLightManager());
        if (this.configured) {
            log.warn("calling configureManagers for a second time", (Throwable)new Exception("traceback"));
        }
        this.configured = true;
    }

    public UsbLightManager getLightManager() {
        log.debug("* getLightManager()");
        if (this.getDisabled()) {
            return null;
        }
        return (UsbLightManager)this.classObjectMap.computeIfAbsent(LightManager.class, c -> new UsbLightManager(this));
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        log.debug("* getActionModelResourceBundle()");
        return null;
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void dispose() {
        log.debug("* dispose()");
        InstanceManager.deregister(this, AnymaDMX_SystemConnectionMemo.class);
        super.dispose();
    }
}

