/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.acela.serialdriver.configurexml;

import java.util.List;
import jmri.jmrix.acela.AcelaNode;
import jmri.jmrix.acela.AcelaSystemConnectionMemo;
import jmri.jmrix.acela.AcelaTrafficController;
import jmri.jmrix.acela.serialdriver.ConnectionConfig;
import jmri.jmrix.acela.serialdriver.SerialDriverAdapter;
import jmri.jmrix.configurexml.AbstractSerialConnectionConfigXml;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfigXml
extends AbstractSerialConnectionConfigXml {
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfigXml.class);

    @Override
    protected void extendElement(Element e) {
        AcelaTrafficController tc = ((AcelaSystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController();
        AcelaNode node = (AcelaNode)tc.getNode(0);
        int index = 1;
        while (node != null) {
            int o;
            int s;
            Element n = new Element("node");
            n.setAttribute("name", "" + node.getNodeAddress());
            e.addContent((Content)n);
            n.addContent((Content)this.makeParameter("nodetype", node.getNodeTypeString()));
            if (node.getNodeType() == 1) {
                s = 0;
                while (s < 4) {
                    n.addContent((Content)this.makeParameter("sensortype" + s, node.getSensorTypeString(s)));
                    n.addContent((Content)this.makeParameter("sensorpolarity" + s, node.getSensorPolarityString(s)));
                    n.addContent((Content)this.makeParameter("sensorthreshold" + s, "" + node.getSensorThreshold(s)));
                    ++s;
                }
                o = 0;
                while (o < 4) {
                    n.addContent((Content)this.makeParameter("outputwired" + o, node.getOutputWiredString(o)));
                    n.addContent((Content)this.makeParameter("outputinit" + o, node.getOutputInitString(o)));
                    n.addContent((Content)this.makeParameter("outputtype" + o, node.getOutputTypeString(o)));
                    n.addContent((Content)this.makeParameter("outputlength" + o, "" + node.getOutputLength(o)));
                    ++o;
                }
            } else if (node.getNodeType() == 2) {
                o = 0;
                while (o < 8) {
                    n.addContent((Content)this.makeParameter("outputwired" + o, node.getOutputWiredString(o)));
                    n.addContent((Content)this.makeParameter("outputinit" + o, node.getOutputInitString(o)));
                    n.addContent((Content)this.makeParameter("outputtype" + o, node.getOutputTypeString(o)));
                    n.addContent((Content)this.makeParameter("outputlength" + o, "" + node.getOutputLength(o)));
                    ++o;
                }
            } else if (node.getNodeType() == 3) {
                s = 0;
                while (s < 8) {
                    n.addContent((Content)this.makeParameter("sensortype" + s, node.getSensorTypeString(s)));
                    n.addContent((Content)this.makeParameter("sensorpolarity" + s, node.getSensorPolarityString(s)));
                    n.addContent((Content)this.makeParameter("sensorthreshold" + s, "" + node.getSensorThreshold(s)));
                    ++s;
                }
            } else if (node.getNodeType() == 4) {
                o = 0;
                while (o < 16) {
                    n.addContent((Content)this.makeParameter("outputwired" + o, node.getOutputWiredString(o)));
                    n.addContent((Content)this.makeParameter("outputinit" + o, node.getOutputInitString(o)));
                    n.addContent((Content)this.makeParameter("outputtype" + o, node.getOutputTypeString(o)));
                    n.addContent((Content)this.makeParameter("outputlength" + o, "" + node.getOutputLength(o)));
                    ++o;
                }
            } else if (node.getNodeType() == 6) {
                o = 0;
                while (o < 16) {
                    n.addContent((Content)this.makeParameter("outputwired" + o, node.getOutputWiredString(o)));
                    n.addContent((Content)this.makeParameter("outputinit" + o, node.getOutputInitString(o)));
                    n.addContent((Content)this.makeParameter("outputtype" + o, node.getOutputTypeString(o)));
                    n.addContent((Content)this.makeParameter("outputlength" + o, "" + node.getOutputLength(o)));
                    ++o;
                }
            } else if (node.getNodeType() == 7) {
                o = 0;
                while (o < 16) {
                    n.addContent((Content)this.makeParameter("outputwired" + o, node.getOutputWiredString(o)));
                    n.addContent((Content)this.makeParameter("outputinit" + o, node.getOutputInitString(o)));
                    n.addContent((Content)this.makeParameter("outputtype" + o, node.getOutputTypeString(o)));
                    n.addContent((Content)this.makeParameter("outputlength" + o, "" + node.getOutputLength(o)));
                    ++o;
                }
            } else if (node.getNodeType() == 8) {
                s = 0;
                while (s < 16) {
                    n.addContent((Content)this.makeParameter("sensortype" + s, node.getSensorTypeString(s)));
                    n.addContent((Content)this.makeParameter("sensorpolarity" + s, node.getSensorPolarityString(s)));
                    n.addContent((Content)this.makeParameter("sensorthreshold" + s, "" + node.getSensorThreshold(s)));
                    ++s;
                }
            }
            node = (AcelaNode)tc.getNode(index);
            ++index;
        }
    }

    protected Element makeParameter(String name, String value) {
        Element p = new Element("parameter");
        p.setAttribute("name", name);
        p.addContent(value);
        return p;
    }

    @Override
    protected void unpackElement(Element shared, Element perNode) {
        List l = shared.getChildren("node");
        int i = 0;
        while (i < l.size()) {
            int outputlength;
            String outputlengths;
            String outputinit;
            String outputwired;
            String sensorpolarity;
            String sensortype;
            Element n = (Element)l.get(i);
            int addr = Integer.parseInt(n.getAttributeValue("name"));
            String nodetypestring = this.findParmValue(n, "nodetype");
            int type = "ACTBD8WMSMSCSWYMSYUN".lastIndexOf(nodetypestring) / 2;
            AcelaNode node = new AcelaNode(addr, type, ((SerialDriverAdapter)this.adapter).getSystemConnectionMemo().getTrafficController());
            log.info("Created a new Acela Node [{}] as a result of a configuration file of type: {}", (Object)addr, (Object)type);
            if (type == 1) {
                int s = 0;
                while (s < 4) {
                    sensortype = this.findParmValue(n, "sensortype" + s);
                    sensorpolarity = this.findParmValue(n, "sensorpolarity" + s);
                    int sensorthreshold = Integer.parseInt(this.findParmValue(n, "sensorthreshold" + s));
                    node.setSensorTypeString(s, sensortype);
                    node.setSensorPolarityString(s, sensorpolarity);
                    if (sensorthreshold < 0) {
                        sensorthreshold = 0;
                    }
                    if (sensorthreshold > 31) {
                        sensorthreshold = 31;
                    }
                    node.setSensorThreshold(s, sensorthreshold);
                    ++s;
                }
                int o = 0;
                while (o < 4) {
                    outputwired = this.findParmValue(n, "outputwired" + o);
                    outputinit = this.findParmValue(n, "outputinit" + o);
                    String outputtype = this.findParmValue(n, "outputtype" + o);
                    outputlengths = this.findParmValue(n, "outputlength" + o);
                    if (outputlengths == null) {
                        outputlengths = "0";
                    }
                    outputlength = Integer.parseInt(outputlengths);
                    node.setOutputWiredString(o, outputwired);
                    node.setOutputInitString(o, outputinit);
                    if (outputtype == null) {
                        outputtype = "ONOFF";
                    }
                    node.setOutputTypeString(o, outputtype);
                    if (outputlength < 0) {
                        outputlength = 0;
                    }
                    if (outputlength > 255) {
                        outputlength = 255;
                    }
                    node.setOutputLength(o, outputlength);
                    ++o;
                }
            } else if (type == 2) {
                int o = 0;
                while (o < 8) {
                    outputwired = this.findParmValue(n, "outputwired" + o);
                    outputinit = this.findParmValue(n, "outputinit" + o);
                    String outputtype = this.findParmValue(n, "outputtype" + o);
                    outputlengths = this.findParmValue(n, "outputlength" + o);
                    if (outputlengths == null) {
                        outputlengths = "0";
                    }
                    outputlength = Integer.parseInt(outputlengths);
                    node.setOutputWiredString(o, outputwired);
                    node.setOutputInitString(o, outputinit);
                    if (outputtype == null) {
                        outputtype = "ONOFF";
                    }
                    node.setOutputTypeString(o, outputtype);
                    if (outputlength < 0) {
                        outputlength = 0;
                    }
                    if (outputlength > 255) {
                        outputlength = 255;
                    }
                    node.setOutputLength(o, outputlength);
                    ++o;
                }
            } else if (type == 3) {
                int s = 0;
                while (s < 8) {
                    sensortype = this.findParmValue(n, "sensortype" + s);
                    sensorpolarity = this.findParmValue(n, "sensorpolarity" + s);
                    int sensorthreshold = Integer.parseInt(this.findParmValue(n, "sensorthreshold" + s));
                    node.setSensorTypeString(s, sensortype);
                    node.setSensorPolarityString(s, sensorpolarity);
                    if (sensorthreshold < 0) {
                        sensorthreshold = 0;
                    }
                    if (sensorthreshold > 31) {
                        sensorthreshold = 31;
                    }
                    node.setSensorThreshold(s, sensorthreshold);
                    ++s;
                }
            } else if (type == 4) {
                int o = 0;
                while (o < 16) {
                    outputwired = this.findParmValue(n, "outputwired" + o);
                    if (outputwired == null) {
                        outputwired = "N0";
                    }
                    outputinit = this.findParmValue(n, "outputinit" + o);
                    String outputtype = this.findParmValue(n, "outputtype" + o);
                    outputlengths = this.findParmValue(n, "outputlength" + o);
                    if (outputlengths == null) {
                        outputlengths = "0";
                    }
                    outputlength = Integer.parseInt(outputlengths);
                    node.setOutputInitString(o, outputinit);
                    if (outputtype == null) {
                        outputtype = "ONOFF";
                    }
                    node.setOutputTypeString(o, outputtype);
                    if (outputlength < 0) {
                        outputlength = 0;
                    }
                    if (outputlength > 255) {
                        outputlength = 255;
                    }
                    node.setOutputLength(o, outputlength);
                    ++o;
                }
            } else if (type == 6) {
                int o = 0;
                while (o < 16) {
                    outputwired = this.findParmValue(n, "outputwired" + o);
                    if (outputwired == null) {
                        outputwired = "N0";
                    }
                    outputinit = this.findParmValue(n, "outputinit" + o);
                    String outputtype = this.findParmValue(n, "outputtype" + o);
                    outputlengths = this.findParmValue(n, "outputlength" + o);
                    if (outputlengths == null) {
                        outputlengths = "0";
                    }
                    outputlength = Integer.parseInt(outputlengths);
                    node.setOutputInitString(o, outputinit);
                    if (outputtype == null) {
                        outputtype = "ONOFF";
                    }
                    node.setOutputTypeString(o, outputtype);
                    if (outputlength < 0) {
                        outputlength = 0;
                    }
                    if (outputlength > 255) {
                        outputlength = 255;
                    }
                    node.setOutputLength(o, outputlength);
                    ++o;
                }
            } else if (type == 7) {
                int o = 0;
                while (o < 16) {
                    outputwired = this.findParmValue(n, "outputwired" + o);
                    if (outputwired == null) {
                        outputwired = "N0";
                    }
                    outputinit = this.findParmValue(n, "outputinit" + o);
                    String outputtype = this.findParmValue(n, "outputtype" + o);
                    outputlengths = this.findParmValue(n, "outputlength" + o);
                    if (outputlengths == null) {
                        outputlengths = "0";
                    }
                    outputlength = Integer.parseInt(outputlengths);
                    node.setOutputInitString(o, outputinit);
                    if (outputtype == null) {
                        outputtype = "ONOFF";
                    }
                    node.setOutputTypeString(o, outputtype);
                    if (outputlength < 0) {
                        outputlength = 0;
                    }
                    if (outputlength > 255) {
                        outputlength = 255;
                    }
                    node.setOutputLength(o, outputlength);
                    ++o;
                }
            } else if (type == 8) {
                int s = 0;
                while (s < 16) {
                    sensortype = this.findParmValue(n, "sensortype" + s);
                    sensorpolarity = this.findParmValue(n, "sensorpolarity" + s);
                    int sensorthreshold = Integer.parseInt(this.findParmValue(n, "sensorthreshold" + s));
                    node.setSensorTypeString(s, sensortype);
                    node.setSensorPolarityString(s, sensorpolarity);
                    if (sensorthreshold < 0) {
                        sensorthreshold = 0;
                    }
                    if (sensorthreshold > 31) {
                        sensorthreshold = 31;
                    }
                    node.setSensorThreshold(s, sensorthreshold);
                    ++s;
                }
            }
            AcelaTrafficController tc = ((AcelaSystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController();
            tc.setNeedToPollNodes(false);
            tc.initializeAcelaNode(node);
            ++i;
        }
        ((AcelaSystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController().setReallyReadyToPoll(true);
    }

    @Override
    protected void getInstance() {
        if (this.adapter == null) {
            this.adapter = new SerialDriverAdapter();
        }
    }

    @Override
    protected void getInstance(Object object) {
        this.adapter = ((ConnectionConfig)object).getAdapter();
    }

    @Override
    protected void register() {
        this.register(new ConnectionConfig(this.adapter));
    }
}

