/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.acela;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.Turnout;
import jmri.jmrix.acela.AcelaAddress;
import jmri.jmrix.acela.AcelaSystemConnectionMemo;
import jmri.jmrix.acela.AcelaTurnout;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcelaTurnoutManager
extends AbstractTurnoutManager {
    private static final Logger log = LoggerFactory.getLogger(AcelaTurnoutManager.class);

    public AcelaTurnoutManager(AcelaSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public AcelaSystemConnectionMemo getMemo() {
        return (AcelaSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        AcelaTurnout trn = null;
        int nAddress = AcelaAddress.getNodeAddressFromSystemName(systemName, this.getMemo());
        if (nAddress == -1) {
            throw new IllegalArgumentException("Cannot get Node Address from System Name " + systemName);
        }
        int bitNum = AcelaAddress.getBitFromSystemName(systemName, this.getSystemPrefix());
        if (bitNum == -1) {
            throw new IllegalArgumentException("Cannot get Bit Number from System Name " + systemName);
        }
        if (AcelaAddress.validSystemNameFormat(systemName, 'T', this.getSystemPrefix()) == Manager.NameValidity.VALID) {
            trn = new AcelaTurnout(systemName, userName, this.getMemo());
            if (!AcelaAddress.validSystemNameConfig(systemName, 'T', this.getMemo())) {
                log.warn("Turnout System Name does not refer to configured hardware: {}", (Object)systemName);
            }
        } else {
            log.error("Invalid Turnout system Name format: {}", (Object)systemName);
            throw new IllegalArgumentException("Invalid Turnout System Name format: " + systemName);
        }
        return trn;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return super.validateIntegerSystemNameFormat(systemName, 0, 16383, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return AcelaAddress.validSystemNameFormat(systemName, 'T', this.getSystemPrefix());
    }

    public boolean validSystemNameConfig(@Nonnull String systemName) {
        return AcelaAddress.validSystemNameConfig(systemName, 'T', this.getMemo());
    }

    public String convertSystemNameToAlternate(String systemName) {
        return AcelaAddress.convertSystemNameToAlternate(systemName, this.getSystemPrefix());
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }
}

