/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.acela;

import java.io.DataInputStream;
import java.io.IOException;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRNodeTrafficController;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.acela.AcelaInterface;
import jmri.jmrix.acela.AcelaListener;
import jmri.jmrix.acela.AcelaMessage;
import jmri.jmrix.acela.AcelaNode;
import jmri.jmrix.acela.AcelaReply;
import jmri.jmrix.acela.AcelaSensorManager;
import jmri.jmrix.acela.AcelaSystemConnectionMemo;
import jmri.jmrix.acela.AcelaTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcelaTrafficController
extends AbstractMRNodeTrafficController
implements AcelaInterface {
    transient int curAcelaNodeIndex = -1;
    private transient int currentOutputAddress = -1;
    private transient int currentSensorAddress = -1;
    private boolean acelaTrafficControllerState = false;
    private boolean reallyReadyToPoll = false;
    private transient boolean needToPollNodes = true;
    private boolean needToInitAcelaNetwork = true;
    private int needToCreateNodesState = 0;
    private boolean acelaSensorsState = false;
    private int acelaSensorInitCount = 0;
    private static int SPECIALNODE = 0;
    AcelaSystemConnectionMemo mMemo = null;
    AcelaSensorManager mSensorManager = null;
    AcelaTurnoutManager mTurnoutManager = null;
    private static final Logger log = LoggerFactory.getLogger(AcelaTrafficController.class);

    public AcelaTrafficController() {
        this.mWaitBeforePoll = 25;
        this.setAllowUnexpectedReply(true);
        super.init(0, 1024);
        this.reallyReadyToPoll = false;
        this.needToPollNodes = true;
        this.needToInitAcelaNetwork = true;
        this.needToCreateNodesState = 0;
        this.acelaTrafficControllerState = false;
    }

    @Override
    public synchronized void addAcelaListener(AcelaListener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeAcelaListener(AcelaListener l) {
        this.removeListener(l);
    }

    public int getMinimumNodeAddress() {
        return this.minNode;
    }

    public int getMaximumNumberOfNodes() {
        return this.maxNode;
    }

    public boolean getAcelaTrafficControllerState() {
        return this.acelaTrafficControllerState;
    }

    public void setAcelaTrafficControllerState(boolean newstate) {
        this.acelaTrafficControllerState = newstate;
    }

    public synchronized void resetStartingAddresses() {
        this.currentOutputAddress = -1;
        this.currentSensorAddress = -1;
    }

    public boolean getAcelaSensorsState() {
        return this.acelaSensorsState;
    }

    public void setAcelaSensorsState(boolean newstate) {
        this.acelaSensorsState = newstate;
    }

    public void incrementAcelaSensorInitCount() {
        ++this.acelaSensorInitCount;
        log.debug("Number of Acela sensors initialized: {}", (Object)this.getAcelaSensorInitCount());
    }

    public int getAcelaSensorInitCount() {
        return this.acelaSensorInitCount;
    }

    public synchronized boolean getNeedToPollNodes() {
        return this.needToPollNodes;
    }

    public synchronized void setNeedToPollNodes(boolean newstate) {
        this.needToPollNodes = newstate;
    }

    public boolean getReallyReadyToPoll() {
        return this.reallyReadyToPoll;
    }

    public void setReallyReadyToPoll(boolean newstate) {
        log.debug("setting really ready to poll (nodes): {}", (Object)newstate);
        this.reallyReadyToPoll = newstate;
    }

    public AcelaSystemConnectionMemo getSystemConnectionMemo() {
        return this.mMemo;
    }

    public void setSystemConnectionMemo(AcelaSystemConnectionMemo m) {
        this.mMemo = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAcelaNode(AcelaNode node) {
        AcelaTrafficController acelaTrafficController = this;
        synchronized (acelaTrafficController) {
            super.registerNode(node);
            this.setMustInit(node, false);
            if (node.getNumOutputBitsPerCard() == 0) {
                node.setStartingOutputAddress(-1);
                node.setEndingOutputAddress(-1);
            } else {
                if (this.currentOutputAddress == -1) {
                    this.currentOutputAddress = 0;
                }
                node.setStartingOutputAddress(this.currentOutputAddress);
                this.currentOutputAddress = this.currentOutputAddress + node.getNumOutputBitsPerCard() - 1;
                node.setEndingOutputAddress(this.currentOutputAddress);
                ++this.currentOutputAddress;
            }
            if (node.getNumSensorBitsPerCard() == 0) {
                node.setStartingSensorAddress(-1);
                node.setEndingSensorAddress(-1);
            } else {
                if (this.currentSensorAddress == -1) {
                    this.currentSensorAddress = 0;
                }
                node.setStartingSensorAddress(this.currentSensorAddress);
                this.currentSensorAddress = this.currentSensorAddress + node.getNumSensorBitsPerCard() - 1;
                node.setEndingSensorAddress(this.currentSensorAddress);
                ++this.currentSensorAddress;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeAcelaNode(AcelaNode node) {
        AcelaTrafficController acelaTrafficController = this;
        synchronized (acelaTrafficController) {
            this.setMustInit(node, true);
            node.initNode();
        }
    }

    public int lookupAcelaNodeAddress(int bitAddress, boolean isSensor) {
        int i = 0;
        while (i < this.getNumNodes()) {
            AcelaNode node = (AcelaNode)this.getNode(i);
            if (isSensor ? bitAddress >= node.getStartingSensorAddress() && bitAddress <= node.getEndingSensorAddress() : bitAddress >= node.getStartingOutputAddress() && bitAddress <= node.getEndingOutputAddress()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        log.warn("enterProgMode does NOT make sense for Acela serial");
        return null;
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return null;
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((AcelaListener)client).message((AcelaMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply m) {
        ((AcelaListener)client).reply((AcelaReply)m);
    }

    public void setSensorManager(AcelaSensorManager m) {
        this.mSensorManager = m;
    }

    public void setTurnoutManager(AcelaTurnoutManager m) {
        this.mTurnoutManager = m;
    }

    @Override
    protected synchronized AbstractMRMessage pollMessage() {
        if (!this.reallyReadyToPoll) {
            return null;
        }
        if (this.needToInitAcelaNetwork) {
            if (this.needToCreateNodesState == 0) {
                if (this.needToPollNodes) {
                    new AcelaNode(0, 0, this);
                    log.info("Created a new Acela Node [0] in order to poll Acela network: 0");
                }
                this.curAcelaNodeIndex = SPECIALNODE;
                AcelaMessage m = AcelaMessage.getAcelaResetMsg();
                log.debug("send Acela reset (init step 1) message: {}", (Object)m);
                m.setTimeout(1000);
                this.mCurrentMode = 1;
                ++this.needToCreateNodesState;
                return m;
            }
            if (this.needToCreateNodesState == 1) {
                AcelaMessage m = AcelaMessage.getAcelaOnlineMsg();
                log.debug("send Acela Online (init step 2) message: {}", (Object)m);
                m.setTimeout(1000);
                this.mCurrentMode = 1;
                ++this.needToCreateNodesState;
                return m;
            }
            if (this.needToPollNodes) {
                if (this.needToCreateNodesState == 2) {
                    AcelaMessage m = AcelaMessage.getAcelaPollNodesMsg();
                    log.debug("send Acela poll nodes message: {}", (Object)m);
                    m.setTimeout(100);
                    this.mCurrentMode = 1;
                    this.needToInitAcelaNetwork = false;
                    this.needToPollNodes = false;
                    return m;
                }
            } else {
                this.needToInitAcelaNetwork = false;
                this.setAcelaTrafficControllerState(true);
            }
        }
        if (this.getNumNodes() <= 0) {
            return null;
        }
        ++this.curAcelaNodeIndex;
        if (this.curAcelaNodeIndex >= this.getNumNodes()) {
            this.curAcelaNodeIndex = 0;
        }
        AcelaNode node = (AcelaNode)this.getNode(this.curAcelaNodeIndex);
        if (node.hasActiveSensors) {
            int s = 0;
            while (s < node.sensorbitsPerCard) {
                if (node.sensorNeedInit[s] && !node.sensorHasBeenInit[s]) {
                    AcelaMessage m = AcelaMessage.getAcelaConfigSensorMsg();
                    int tempiaddr = s + node.getStartingSensorAddress();
                    byte tempbaddr = (byte)tempiaddr;
                    m.setElement(2, tempbaddr);
                    m.setElement(3, node.sensorConfigArray[s]);
                    log.debug("send Acela Config Sensor message: {}", (Object)m);
                    this.incrementAcelaSensorInitCount();
                    m.setTimeout(100);
                    this.mCurrentMode = 1;
                    node.sensorHasBeenInit[s] = true;
                    node.sensorNeedInit[s] = false;
                    return m;
                }
                ++s;
            }
        }
        if (this.getNode(this.curAcelaNodeIndex).mustSend()) {
            this.getNode(this.curAcelaNodeIndex).resetMustSend();
            AbstractMRMessage m = this.getNode(this.curAcelaNodeIndex).createOutPacket();
            m.setTimeout(100);
            log.debug("request write command to send: {}", (Object)m);
            this.mCurrentMode = 1;
            return m;
        }
        if (this.currentSensorAddress == 0 || this.currentSensorAddress != this.getAcelaSensorInitCount()) {
            return null;
        }
        if (this.acelaSensorsState) {
            AcelaMessage m = AcelaMessage.getAcelaPollSensorsMsg();
            log.debug("send Acela poll sensors message: {}", (Object)m);
            m.setTimeout(100);
            this.mCurrentMode = 1;
            return m;
        }
        return null;
    }

    @Override
    protected synchronized void handleTimeout(AbstractMRMessage m, AbstractMRListener l) {
        if (this.getNode(this.curAcelaNodeIndex).handleTimeout(m, l)) {
            this.setMustInit(this.curAcelaNodeIndex, true);
        }
    }

    @Override
    protected synchronized void resetTimeout(AbstractMRMessage m) {
        this.getNode(this.curAcelaNodeIndex).resetTimeout(m);
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return this.mSensorManager;
    }

    @Override
    public void sendAcelaMessage(AcelaMessage m, AcelaListener reply) {
        this.sendMessage(m, reply);
    }

    @Override
    protected AbstractMRReply newReply() {
        return new AcelaReply();
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        return true;
    }

    @Override
    protected void loadChars(AbstractMRReply msg, DataInputStream istream) throws IOException {
        int char1 = this.readByteProtected(istream) & 0xFF;
        if (char1 == 0) {
            msg.setElement(0, char1);
        } else if (char1 == 129 || char1 == 130) {
            msg.setElement(0, char1);
        } else {
            int i = 0;
            while (i < char1) {
                byte charn = this.readByteProtected(istream);
                msg.setElement(i, charn);
                ++i;
            }
        }
    }

    @Override
    protected void waitForStartOfReply(DataInputStream istream) throws IOException {
    }

    public void updateSensorsFromPoll(AcelaReply r) {
        int i = 0;
        while (i < this.getNumNodes()) {
            AcelaNode node = (AcelaNode)this.getNode(i);
            if (node.getSensorBitsPerCard() > 0) {
                node.markChanges(r);
            }
            ++i;
        }
    }
}

