/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.acela;

import jmri.implementation.DefaultSignalHead;
import jmri.jmrix.acela.AcelaAddress;
import jmri.jmrix.acela.AcelaNode;
import jmri.jmrix.acela.AcelaSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcelaSignalHead
extends DefaultSignalHead {
    AcelaSystemConnectionMemo _memo = null;
    String tSystemName;
    int addr;
    private static final Logger log = LoggerFactory.getLogger(AcelaSignalHead.class);

    public AcelaSignalHead(String systemName, AcelaSystemConnectionMemo memo) {
        super(systemName);
        int num;
        this._memo = memo;
        this.tSystemName = systemName;
        this.addr = num = AcelaAddress.getBitFromSystemName(systemName, this._memo.getSystemPrefix());
        AcelaNode tNode = AcelaAddress.getNodeFromSystemName(this.tSystemName, this._memo);
        if (tNode == null) {
            log.error("Can't find new Acela Signal with name '{}'", (Object)this.tSystemName);
            return;
        }
        tNode.setOutputSpecial(this.addr, 1);
        tNode.setOutputSignalHeadType(this.addr, 0);
    }

    public AcelaSignalHead(String systemName, String userName, AcelaSystemConnectionMemo memo) {
        super(systemName, userName);
        int num;
        this._memo = memo;
        this.tSystemName = systemName;
        this.addr = num = AcelaAddress.getBitFromSystemName(systemName, this._memo.getSystemPrefix());
        AcelaNode tNode = AcelaAddress.getNodeFromSystemName(this.tSystemName, this._memo);
        if (tNode == null) {
            log.error("Can't find new Acela Signal with name '{}'", (Object)this.tSystemName);
            return;
        }
        tNode.setOutputSpecial(this.addr, 1);
        tNode.setOutputSignalHeadType(this.addr, 0);
    }

    @Override
    protected void updateOutput() {
        int cmd;
        AcelaNode tNode = AcelaAddress.getNodeFromSystemName(this.tSystemName, this._memo);
        if (tNode == null) {
            log.error("Can't resolve Acela Signal with name '{}'. command ignored", (Object)this.tSystemName);
            return;
        }
        if (this.mLit) {
            switch (this.mAppearance) {
                case 1: {
                    cmd = 1;
                    break;
                }
                case 2: {
                    cmd = 2;
                    break;
                }
                case 4: {
                    cmd = 3;
                    break;
                }
                case 8: {
                    cmd = 4;
                    break;
                }
                case 16: {
                    cmd = 5;
                    break;
                }
                case 32: {
                    cmd = 6;
                    break;
                }
                case 0: {
                    cmd = 7;
                    break;
                }
                default: {
                    log.warn("Unexpected new appearance: {}", (Object)this.mAppearance);
                    cmd = 2;
                    break;
                }
            }
        } else {
            cmd = 7;
        }
        tNode.setOutputSpecial(this.addr, cmd);
        tNode.setOutputBit(this.addr, true);
    }

    @Override
    public void startFlash() {
    }

    @Override
    public void stopFlash() {
    }
}

