/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.acela;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.Sensor;
import jmri.jmrix.acela.AcelaAddress;
import jmri.jmrix.acela.AcelaListener;
import jmri.jmrix.acela.AcelaMessage;
import jmri.jmrix.acela.AcelaNode;
import jmri.jmrix.acela.AcelaReply;
import jmri.jmrix.acela.AcelaSensor;
import jmri.jmrix.acela.AcelaSystemConnectionMemo;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcelaSensorManager
extends AbstractSensorManager
implements AcelaListener {
    private static final Logger log = LoggerFactory.getLogger(AcelaSensorManager.class);

    public AcelaSensorManager(AcelaSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public AcelaSystemConnectionMemo getMemo() {
        return (AcelaSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        if (AcelaAddress.validSystemNameFormat(systemName, 'S', this.getSystemPrefix()) == Manager.NameValidity.INVALID) {
            log.error("Invalid Sensor system Name format: {}", (Object)systemName);
            throw new IllegalArgumentException("Invalid Sensor System Name format: " + systemName);
        }
        String sName = systemName;
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("Invalid Acela Sensor system name - " + systemName);
        }
        Sensor s = this.getBySystemName(sName);
        if (s != null) {
            throw new IllegalArgumentException("Acela Sensor with this name already exists - " + systemName);
        }
        String altName = AcelaAddress.convertSystemNameToAlternate(sName, this.getSystemPrefix());
        s = this.getBySystemName(altName);
        if (s != null) {
            throw new IllegalArgumentException("Acela Sensor with name  " + systemName + " already exists as " + altName);
        }
        int bit = AcelaAddress.getBitFromSystemName(sName, this.getSystemPrefix());
        if (bit < 0 || bit > 16383) {
            log.error("Sensor bit number {} is outside the supported range {}-{}", new Object[]{bit, 0, 16383});
            throw new IllegalArgumentException("Sensor bit number " + Integer.toString(bit) + " is outside the supported range " + Integer.toString(16383) + "-" + Integer.toString(16383));
        }
        s = userName == null ? new AcelaSensor(sName) : new AcelaSensor(sName, userName);
        AcelaNode node = AcelaAddress.getNodeFromSystemName(sName, this.getMemo());
        if (node == null) {
            log.warn("Sensor: {} refers to an undefined Acela Node.", (Object)sName);
            return s;
        }
        if (!node.hasActiveSensors) {
            int newNodeAddress = node.getNodeAddress();
            log.warn("We got the wrong node: {}", (Object)newNodeAddress);
            return s;
        }
        node.registerSensor(s, bit);
        return s;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return super.validateIntegerSystemNameFormat(systemName, 0, 16383, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return AcelaAddress.validSystemNameFormat(systemName, 'S', this.getSystemPrefix());
    }

    @Override
    public void message(AcelaMessage r) {
        log.warn("unexpected message");
    }

    @Override
    public void reply(AcelaReply r) {
        boolean currentstate = this.getMemo().getTrafficController().getAcelaTrafficControllerState();
        if (!currentstate) {
            int replysize = r.getNumDataElements();
            if (replysize == 0) {
                log.warn("We got an empty reply of size: {}", (Object)replysize);
            } else if (replysize == 1) {
                byte replyvalue = (byte)r.getElement(0);
                if (replyvalue != 0) {
                    log.warn("We got a bad return code: {}", (Object)replyvalue);
                }
            } else {
                int i = 0;
                while (i < replysize) {
                    int nodetype;
                    byte replynodetype = (byte)r.getElement(i);
                    switch (replynodetype) {
                        case 0: {
                            nodetype = 0;
                            break;
                        }
                        case 1: {
                            nodetype = 1;
                            break;
                        }
                        case 2: {
                            nodetype = 2;
                            break;
                        }
                        case 3: {
                            nodetype = 3;
                            break;
                        }
                        case 4: {
                            nodetype = 4;
                            break;
                        }
                        case 5: {
                            nodetype = 5;
                            break;
                        }
                        case 6: {
                            nodetype = 6;
                            break;
                        }
                        case 7: {
                            nodetype = 7;
                            break;
                        }
                        case 8: {
                            nodetype = 8;
                            break;
                        }
                        default: {
                            nodetype = 9;
                        }
                    }
                    int tempaddr = i + 1;
                    new AcelaNode(tempaddr, nodetype, this.getMemo().getTrafficController());
                    log.info("Created a new Acela Node [{}] as a result of Acela network Poll of type: {}", (Object)tempaddr, (Object)replynodetype);
                    ++i;
                }
                this.getMemo().getTrafficController().setAcelaTrafficControllerState(true);
            }
        } else {
            int replysize = r.getNumDataElements();
            if (replysize > 1) {
                this.getMemo().getTrafficController().updateSensorsFromPoll(r);
            }
        }
    }

    public void registerSensorsForNode(AcelaNode node) {
        log.info("Trying to register sensor from Manager 2: {}Sxx", (Object)this.getSystemPrefix());
        for (Sensor s : this.getNamedBeanSet()) {
            AcelaNode tNode;
            String sName = s.getSystemName();
            log.debug("system Name is {}", (Object)sName);
            if (!sName.startsWith(this.getSystemNamePrefix()) || (tNode = AcelaAddress.getNodeFromSystemName(sName, this.getMemo())) != node) continue;
            node.registerSensor(s, AcelaAddress.getBitFromSystemName(sName, this.getSystemPrefix()));
        }
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }
}

