/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.acela;

import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Sensor;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractNode;
import jmri.jmrix.acela.AcelaMessage;
import jmri.jmrix.acela.AcelaReply;
import jmri.jmrix.acela.AcelaSystemConnectionMemo;
import jmri.jmrix.acela.AcelaTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcelaNode
extends AbstractNode {
    static final int MAXSENSORBITS = 16;
    static final int MAXOUTPUTBITS = 16;
    static final int MAXNODE = 1024;
    private static int MAXDELAY = 65535;
    public static final byte AC = 0;
    public static final byte TB = 1;
    public static final byte D8 = 2;
    public static final byte WM = 3;
    public static final byte SM = 4;
    public static final byte SC = 5;
    public static final byte SW = 6;
    public static final byte YM = 7;
    public static final byte SY = 8;
    public static final byte UN = 9;
    public static final String moduleTypes = "ACTBD8WMSMSCSWYMSYUN";
    static final String[] nodeNames = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19"};
    static final String[] moduleNames = new String[]{"Acela", "TrainBrain", "Dash-8", "Watchman", "SignalMan", "SmartCab", "SwitchMan", "YardMaster", "Sentry"};
    static final String[] moduleTips = new String[]{"Acela", "TrainBrain has 4 output circuits and 4 input circuits", "Dash-8 has 8 output circuits and no input circuits", "Watchman has no output circuits and 8 input circuits", "SignalMan has 16 output circuits and no input circuits", "SmartCab has 1 output circuit and no input circuits", "SwitchMan has 16 output circuits and no input circuits", "YardMaster has 16 output circuits and no input circuits", "Sentry has no output circuits and 16 input circuits"};
    protected int nodeType = 9;
    protected int outputbitsPerCard = 16;
    protected int sensorbitsPerCard = 16;
    protected int transmissionDelay = 0;
    protected boolean needInit = false;
    protected byte[] outputArray = new byte[16];
    protected int[] outputSpecial = new int[16];
    protected int[] outputSignalHeadType = new int[16];
    protected boolean hasActiveSensors = false;
    protected int lastUsedSensor = -1;
    protected Sensor[] sensorArray = new Sensor[16];
    protected boolean[] sensorNeedInit = new boolean[16];
    protected boolean[] sensorHasBeenInit = new boolean[16];
    protected int[] sensorLastSetting = new int[16];
    protected int[] sensorType = new int[16];
    protected int[] sensorPolarity = new int[16];
    protected int[] sensorThreshold = new int[16];
    protected byte[] sensorConfigArray = new byte[16];
    protected int[] outputWired = new int[16];
    protected int[] outputInit = new int[16];
    protected int[] outputType = new int[16];
    protected int[] outputLength = new int[16];
    protected boolean[] outputNeedToSend = new boolean[16];
    public static final String sensorTypes = "NFSBCGDT";
    public static final String sensorPolarities = "ACTINV";
    public static final String outputWireds = "NONC";
    public static final String outputInits = "OFFACT";
    public static final String outputTypes = "ONOFFPULSEBLINK";
    public static final int ONOFF = 0;
    public static final int PULSE = 1;
    public static final int BLINK = 2;
    public static final String outputSignalHeadTypes = "UKNOWNDOUBLETRIPLEBPOLARWIGWAG";
    public static final int UKNOWN = 0;
    public static final int DOUBLE = 1;
    public static final int TRIPLE = 2;
    public static final int BPOLAR = 3;
    public static final int WIGWAG = 4;
    public static final String outputONOFF = "ONOFF";
    public static final String outputLEN0 = "0";
    public static final String outputNO = "N0";
    protected int startingOutputAddress = -1;
    protected int endingOutputAddress = -1;
    protected int startingSensorAddress = -1;
    protected int endingSensorAddress = -1;
    boolean warned = false;
    int timeout = 0;
    private static final Logger log = LoggerFactory.getLogger(AcelaNode.class);

    public static String[] getNodeNames() {
        return (String[])nodeNames.clone();
    }

    public static String[] getModuleNames() {
        return (String[])moduleNames.clone();
    }

    public AcelaNode() {
        this(0, 9, InstanceManager.getDefault(AcelaSystemConnectionMemo.class).getTrafficController());
    }

    public AcelaNode(int address, int type, AcelaTrafficController tc) {
        this.setNodeAddress(address);
        this.setNodeType(type);
        this.transmissionDelay = 0;
        int i = 0;
        while (i < 16) {
            this.sensorArray[i] = null;
            this.sensorNeedInit[i] = false;
            this.sensorHasBeenInit[i] = false;
            this.sensorLastSetting[i] = 1;
            this.sensorType[i] = 2;
            this.sensorPolarity[i] = 1;
            this.sensorThreshold[i] = 4;
            this.sensorConfigArray[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 16) {
            this.outputArray[i] = 0;
            this.outputSpecial[i] = 0;
            this.outputSignalHeadType[i] = 0;
            this.outputInit[i] = 0;
            this.outputWired[i] = 0;
            this.outputType[i] = 0;
            this.outputLength[i] = 10;
            this.outputNeedToSend[i] = false;
            ++i;
        }
        this.resetMustSend();
        this.needInit = false;
        this.hasActiveSensors = false;
        tc.registerAcelaNode(this);
    }

    public void initNode() {
        if (this.outputbitsPerCard > 0) {
            boolean bulk_message = true;
            int c = 0;
            while (c < this.outputbitsPerCard) {
                if (this.outputType[c] != 0 || this.outputSpecial[c] != 0) {
                    bulk_message = false;
                }
                ++c;
            }
            int i = 0;
            while (i < 16) {
                this.outputArray[i] = (byte)this.outputInit[i];
                if (!bulk_message) {
                    this.outputNeedToSend[i] = true;
                }
                ++i;
            }
            this.setMustSend();
        }
        if (this.sensorbitsPerCard > 0) {
            int i = 0;
            while (i < 16) {
                this.sensorConfigArray[i] = (byte)((byte)(this.sensorThreshold[i] << 3) + (byte)(this.sensorType[i] << 1) + (byte)this.sensorPolarity[i]);
                this.sensorNeedInit[i] = true;
                ++i;
            }
            this.hasActiveSensors = true;
        }
    }

    public void setStartingOutputAddress(int startingAddress) {
        this.startingOutputAddress = startingAddress;
    }

    public int getStartingOutputAddress() {
        return this.startingOutputAddress;
    }

    public void setEndingOutputAddress(int endingAddress) {
        this.endingOutputAddress = endingAddress;
    }

    public int getEndingOutputAddress() {
        return this.endingOutputAddress;
    }

    public void setStartingSensorAddress(int startingAddress) {
        this.startingSensorAddress = startingAddress;
    }

    public int getStartingSensorAddress() {
        return this.startingSensorAddress;
    }

    public void setEndingSensorAddress(int endingAddress) {
        this.endingSensorAddress = endingAddress;
    }

    public int getEndingSensorAddress() {
        return this.endingSensorAddress;
    }

    public void setOutputBit(int bitNumber, boolean state) {
        byte oldbyte = 0;
        int newbitNumber = 0;
        newbitNumber = bitNumber - this.startingOutputAddress;
        oldbyte = this.outputArray[newbitNumber];
        this.outputArray[newbitNumber] = state ? (byte)1 : 0;
        boolean bulk_message = true;
        int c = 0;
        while (c < this.outputbitsPerCard) {
            if (this.outputType[c] != 0 || this.outputSpecial[c] != 0) {
                bulk_message = false;
            }
            ++c;
        }
        if (bulk_message) {
            if (oldbyte != this.outputArray[newbitNumber]) {
                this.setMustSend();
            }
        } else {
            this.outputNeedToSend[newbitNumber] = true;
            this.setMustSend();
        }
    }

    public boolean getOutputBit(int bitNumber) {
        int newbitNumber = 0;
        newbitNumber = bitNumber - this.startingOutputAddress;
        byte testByte = this.outputArray[newbitNumber];
        return testByte != 0;
    }

    @Override
    public boolean getSensorsActive() {
        return this.hasActiveSensors;
    }

    public int getOutputWired(int circuitnum) {
        return this.outputWired[circuitnum];
    }

    public String getOutputWiredString(int circuitnum) {
        int sensortype = this.outputWired[circuitnum];
        return outputWireds.substring(sensortype * 2, sensortype * 2 + 2);
    }

    public void setOutputWired(int circuitnum, int type) {
        this.outputWired[circuitnum] = type;
    }

    public void setOutputWiredString(int circuitnum, String stringtype) {
        int type;
        this.outputWired[circuitnum] = type = outputWireds.lastIndexOf(stringtype) / 2;
    }

    public int getOutputInit(int circuitnum) {
        return this.outputInit[circuitnum];
    }

    public String getOutputInitString(int circuitnum) {
        int sensortype = this.outputInit[circuitnum];
        return outputInits.substring(sensortype * 3, sensortype * 3 + 3);
    }

    public void setOutputInit(int circuitnum, int type) {
        this.outputInit[circuitnum] = type;
    }

    public void setOutputInitString(int circuitnum, String stringtype) {
        int type;
        this.outputInit[circuitnum] = type = outputInits.lastIndexOf(stringtype) / 3;
    }

    public int getOutputType(int circuitnum) {
        return this.outputType[circuitnum];
    }

    public String getOutputTypeString(int circuitnum) {
        int outputtype = this.outputType[circuitnum];
        return outputTypes.substring(outputtype * 5, outputtype * 5 + 5);
    }

    public void setOutputType(int circuitnum, int type) {
        this.outputType[circuitnum] = type;
    }

    public void setOutputTypeString(int circuitnum, String stringtype) {
        int type;
        this.outputType[circuitnum] = type = outputTypes.lastIndexOf(stringtype) / 5;
    }

    public int getOutputLength(int circuitnum) {
        return this.outputLength[circuitnum];
    }

    public void setOutputLength(int circuitnum, int newlength) {
        this.outputLength[circuitnum] = newlength;
    }

    public int getOutputSpecial(int circuitnum) {
        int newbitNumber = circuitnum - this.startingOutputAddress;
        return this.outputSpecial[newbitNumber];
    }

    public void setOutputSpecial(int circuitnum, int type) {
        int newbitNumber = circuitnum - this.startingOutputAddress;
        this.outputSpecial[newbitNumber] = type;
    }

    public int getOutputSignalHeadType(int circuitnum) {
        int newbitNumber = circuitnum - this.startingOutputAddress;
        return this.outputSignalHeadType[newbitNumber];
    }

    public String getOutputSignalHeadTypeString(int circuitnum) {
        int newbitNumber = circuitnum - this.startingOutputAddress;
        int outputsignalheadtype = this.outputSignalHeadType[newbitNumber];
        return outputSignalHeadTypes.substring(outputsignalheadtype * 6, outputsignalheadtype * 6 + 6);
    }

    public void setOutputSignalHeadType(int circuitnum, int type) {
        int newbitNumber = circuitnum - this.startingOutputAddress;
        this.outputSignalHeadType[newbitNumber] = type;
    }

    public void setOutputSignalHeadTypeString(int circuitnum, String stringtype) {
        int type;
        int newbitNumber = circuitnum - this.startingOutputAddress;
        this.outputSignalHeadType[newbitNumber] = type = outputSignalHeadTypes.lastIndexOf(stringtype) / 6;
    }

    public int getSensorType(int circuitnum) {
        return this.sensorType[circuitnum];
    }

    public String getSensorTypeString(int circuitnum) {
        int sensortype = this.sensorType[circuitnum];
        return sensorTypes.substring(sensortype * 2, sensortype * 2 + 2);
    }

    public void setSensorType(int circuitnum, int type) {
        this.sensorType[circuitnum] = type;
    }

    public void setSensorTypeString(int circuitnum, String stringtype) {
        int type;
        this.sensorType[circuitnum] = type = sensorTypes.lastIndexOf(stringtype) / 2;
    }

    public int getSensorPolarity(int circuitnum) {
        return this.sensorPolarity[circuitnum];
    }

    public String getSensorPolarityString(int circuitnum) {
        int sensorpolarity = this.sensorPolarity[circuitnum];
        return sensorPolarities.substring(sensorpolarity * 3, sensorpolarity * 3 + 3);
    }

    public void setSensorPolarity(int circuitnum, int polarity) {
        this.sensorPolarity[circuitnum] = polarity;
    }

    public void setSensorPolarityString(int circuitnum, String stringpolarity) {
        int polarity;
        this.sensorPolarity[circuitnum] = polarity = sensorPolarities.lastIndexOf(stringpolarity) / 3;
    }

    public int getSensorThreshold(int circuitnum) {
        return this.sensorThreshold[circuitnum];
    }

    public void setSensorThreshold(int circuitnum, int threshold) {
        this.sensorThreshold[circuitnum] = threshold;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public String getNodeTypeString() {
        return moduleTypes.substring(this.nodeType * 2, this.nodeType * 2 + 2);
    }

    public void setNodeTypeString(String stringtype) {
        int type = moduleTypes.lastIndexOf(stringtype) / 2;
        this.setNodeType(type);
    }

    public void setNodeType(int type) {
        this.nodeType = type;
        switch (type) {
            case 0: 
            case 9: {
                this.outputbitsPerCard = 0;
                this.sensorbitsPerCard = 0;
                break;
            }
            case 1: {
                this.outputbitsPerCard = 4;
                this.sensorbitsPerCard = 4;
                break;
            }
            case 2: {
                this.outputbitsPerCard = 8;
                this.sensorbitsPerCard = 0;
                break;
            }
            case 3: {
                this.outputbitsPerCard = 0;
                this.sensorbitsPerCard = 8;
                break;
            }
            case 5: {
                this.outputbitsPerCard = 1;
                this.sensorbitsPerCard = 0;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                this.outputbitsPerCard = 16;
                this.sensorbitsPerCard = 0;
                break;
            }
            case 8: {
                this.outputbitsPerCard = 0;
                this.sensorbitsPerCard = 16;
                break;
            }
            default: {
                this.outputbitsPerCard = 0;
                this.sensorbitsPerCard = 0;
                log.error("Bad node type - {}", (Object)Integer.toString(type));
            }
        }
    }

    public int getNumOutputBitsPerCard() {
        return this.outputbitsPerCard;
    }

    public int getNumSensorBitsPerCard() {
        return this.sensorbitsPerCard;
    }

    @Override
    public boolean checkNodeAddress(int address) {
        return address >= 0 && address < 1024;
    }

    public int getSensorBitsPerCard() {
        return this.sensorbitsPerCard;
    }

    public int getTransmissionDelay() {
        return this.transmissionDelay;
    }

    public void setTransmissionDelay(int delay) {
        if (delay < 0 || delay > MAXDELAY) {
            log.warn("transmission delay {} out of 0-65535 range", (Object)Integer.toString(delay));
            if (delay < 0) {
                delay = 0;
            }
            if (delay > MAXDELAY) {
                delay = MAXDELAY;
            }
        }
        this.transmissionDelay = delay;
    }

    @Override
    public AbstractMRMessage createInitPacket() {
        return null;
    }

    @Override
    public AbstractMRMessage createOutPacket() {
        int cmdlen = 3;
        int cmdcode = 3;
        int addrhi = 0;
        byte addrlo = 0;
        int settinghi = 0;
        int settinglo = 0;
        boolean bulk_message = true;
        int c = 0;
        while (c < this.outputbitsPerCard) {
            if (this.outputType[c] != 0 || this.outputSpecial[c] != 0) {
                bulk_message = false;
            }
            ++c;
        }
        if (!bulk_message) {
            c = 0;
            boolean foundfirst = false;
            boolean foundanother = false;
            while (c < this.outputbitsPerCard) {
                if (this.outputNeedToSend[c] && foundfirst) {
                    foundanother = true;
                }
                if (this.outputNeedToSend[c] && !foundfirst) {
                    foundfirst = true;
                }
                ++c;
            }
            if (foundanother) {
                this.setMustSend();
            }
        }
        Integer tempint = this.startingOutputAddress;
        addrlo = tempint.byteValue();
        if (bulk_message) {
            int tempsettings;
            if (this.nodeType == 1) {
                cmdlen = 4;
                cmdcode = 7;
                tempsettings = (this.outputArray[3] ^ this.outputWired[3]) * 8 + (this.outputArray[2] ^ this.outputWired[2]) * 4 + (this.outputArray[1] ^ this.outputWired[1]) * 2 + (this.outputArray[0] ^ this.outputWired[0]) * 1;
                settinglo = (byte)tempsettings;
            }
            if (this.nodeType == 2) {
                cmdlen = 4;
                cmdcode = 8;
                tempsettings = (this.outputArray[3] ^ this.outputWired[3]) * 8 + (this.outputArray[2] ^ this.outputWired[2]) * 4 + (this.outputArray[1] ^ this.outputWired[1]) * 2 + (this.outputArray[0] ^ this.outputWired[0]) * 1;
                tempsettings = (this.outputArray[7] ^ this.outputWired[7]) * 128 + (this.outputArray[6] ^ this.outputWired[6]) * 64 + (this.outputArray[5] ^ this.outputWired[5]) * 32 + (this.outputArray[4] ^ this.outputWired[4]) * 16 + tempsettings;
                settinglo = (byte)tempsettings;
            }
            if (this.nodeType == 3 || this.nodeType == 8) {
                cmdcode = 1;
            }
            if (this.nodeType == 5) {
                cmdcode = 1;
            }
            if (this.nodeType == 4 || this.nodeType == 6 || this.nodeType == 7) {
                cmdlen = 5;
                cmdcode = 9;
                tempsettings = (this.outputArray[3] ^ this.outputWired[3]) * 8 + (this.outputArray[2] ^ this.outputWired[2]) * 4 + (this.outputArray[1] ^ this.outputWired[1]) * 2 + (this.outputArray[0] ^ this.outputWired[0]) * 1;
                tempsettings = (this.outputArray[7] ^ this.outputWired[7]) * 128 + (this.outputArray[6] ^ this.outputWired[6]) * 64 + (this.outputArray[5] ^ this.outputWired[5]) * 32 + (this.outputArray[4] ^ this.outputWired[4]) * 16 + tempsettings;
                settinglo = (byte)tempsettings;
                int tempsettings2 = (this.outputArray[11] ^ this.outputWired[11]) * 8 + (this.outputArray[10] ^ this.outputWired[10]) * 4 + (this.outputArray[9] ^ this.outputWired[9]) * 2 + (this.outputArray[8] ^ this.outputWired[8]) * 1;
                tempsettings2 = (this.outputArray[15] ^ this.outputWired[15]) * 128 + (this.outputArray[14] ^ this.outputWired[14]) * 64 + (this.outputArray[13] ^ this.outputWired[13]) * 32 + (this.outputArray[12] ^ this.outputWired[12]) * 16 + tempsettings2;
                settinghi = (byte)tempsettings2;
            }
        } else {
            c = 0;
            boolean foundsomething = false;
            while (c < this.outputbitsPerCard && !foundsomething) {
                if (this.outputNeedToSend[c]) {
                    Integer tempaddr = c + addrlo;
                    addrlo = tempaddr.byteValue();
                    this.outputNeedToSend[c] = false;
                    foundsomething = true;
                    if (this.outputSpecial[c] == 0) {
                        int tempcommand;
                        if (this.outputType[c] == 0) {
                            tempcommand = this.outputArray[c] ^ this.outputWired[c];
                            if (tempcommand == 0) {
                                tempcommand = 2;
                            }
                            cmdcode = (byte)tempcommand;
                            cmdlen = 3;
                        }
                        if (this.outputType[c] == 2) {
                            tempcommand = this.outputArray[c];
                            if (tempcommand == 1 && this.outputWired[c] == 1) {
                                tempcommand = 5;
                            }
                            if (tempcommand == 1 && this.outputWired[c] == 0) {
                                tempcommand = 6;
                            }
                            if (tempcommand == 0) {
                                tempcommand = 2;
                            }
                            if ((cmdcode = (int)((byte)tempcommand)) == 2) {
                                cmdlen = 3;
                            } else {
                                cmdlen = 4;
                                settinglo = (byte)this.outputLength[c];
                            }
                        }
                        if (this.outputType[c] == 1) {
                            tempcommand = this.outputArray[c];
                            if (tempcommand == 1 && this.outputWired[c] == 1) {
                                tempcommand = 4;
                            }
                            if (tempcommand == 1 && this.outputWired[c] == 0) {
                                tempcommand = 3;
                            }
                            if (tempcommand == 0) {
                                tempcommand = 2;
                            }
                            if ((cmdcode = (int)((byte)tempcommand)) == 2) {
                                cmdlen = 3;
                            } else {
                                cmdlen = 4;
                                settinglo = (byte)this.outputLength[c];
                            }
                        }
                    } else {
                        block0 : switch (this.outputSignalHeadType[c]) {
                            case 1: {
                                switch (this.outputSpecial[c]) {
                                    case 1: {
                                        cmdcode = 12;
                                        settinglo = 1;
                                        break block0;
                                    }
                                    case 2: {
                                        cmdcode = 12;
                                        settinglo = 2;
                                        break block0;
                                    }
                                    case 3: 
                                    case 4: 
                                    case 6: {
                                        cmdcode = 12;
                                        settinglo = 8;
                                        break block0;
                                    }
                                    case 5: {
                                        cmdcode = 12;
                                        settinglo = 4;
                                        break block0;
                                    }
                                    case 7: {
                                        cmdcode = 12;
                                        settinglo = 0;
                                        break block0;
                                    }
                                }
                                cmdcode = 12;
                                settinglo = 3;
                                break;
                            }
                            case 2: {
                                switch (this.outputSpecial[c]) {
                                    case 1: {
                                        cmdcode = 13;
                                        settinglo = 1;
                                        break block0;
                                    }
                                    case 2: {
                                        cmdcode = 13;
                                        settinglo = 2;
                                        break block0;
                                    }
                                    case 3: {
                                        cmdcode = 13;
                                        settinglo = 4;
                                        break block0;
                                    }
                                    case 4: {
                                        cmdcode = 13;
                                        settinglo = 8;
                                        break block0;
                                    }
                                    case 5: {
                                        cmdcode = 13;
                                        settinglo = 16;
                                        break block0;
                                    }
                                    case 6: {
                                        cmdcode = 13;
                                        settinglo = 32;
                                        break block0;
                                    }
                                    case 7: {
                                        cmdcode = 13;
                                        settinglo = 0;
                                        break block0;
                                    }
                                }
                                cmdcode = 13;
                                settinglo = 3;
                                break;
                            }
                            case 3: {
                                switch (this.outputSpecial[c]) {
                                    case 1: {
                                        cmdcode = 12;
                                        settinglo = 1;
                                        break block0;
                                    }
                                    case 2: {
                                        cmdcode = 12;
                                        settinglo = 2;
                                        break block0;
                                    }
                                    case 3: {
                                        cmdcode = 12;
                                        settinglo = 16;
                                        break block0;
                                    }
                                    case 4: {
                                        cmdcode = 12;
                                        settinglo = 32;
                                        break block0;
                                    }
                                    case 5: {
                                        cmdcode = 12;
                                        settinglo = 4;
                                        break block0;
                                    }
                                    case 6: {
                                        cmdcode = 12;
                                        settinglo = 8;
                                        break block0;
                                    }
                                    case 7: {
                                        cmdcode = 12;
                                        settinglo = 0;
                                        break block0;
                                    }
                                }
                                cmdcode = 12;
                                settinglo = 3;
                                break;
                            }
                            case 4: {
                                switch (this.outputSpecial[c]) {
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: {
                                        cmdcode = 12;
                                        settinglo = 11;
                                        break block0;
                                    }
                                    case 7: {
                                        cmdcode = 12;
                                        settinglo = 0;
                                        break block0;
                                    }
                                }
                                cmdcode = 12;
                                settinglo = 15;
                                break;
                            }
                            default: {
                                switch (this.outputSpecial[c]) {
                                    case 1: {
                                        cmdcode = 13;
                                        settinglo = 1;
                                        break block0;
                                    }
                                    case 3: {
                                        cmdcode = 13;
                                        settinglo = 4;
                                        break block0;
                                    }
                                    case 4: {
                                        cmdcode = 13;
                                        settinglo = 8;
                                        break block0;
                                    }
                                    case 5: {
                                        cmdcode = 13;
                                        settinglo = 16;
                                        break block0;
                                    }
                                    case 6: {
                                        cmdcode = 13;
                                        settinglo = 48;
                                        break block0;
                                    }
                                    case 7: {
                                        cmdcode = 13;
                                        settinglo = 0;
                                        break block0;
                                    }
                                }
                                cmdcode = 13;
                                settinglo = 3;
                            }
                        }
                        cmdlen = 4;
                    }
                }
                ++c;
            }
        }
        AcelaMessage m = new AcelaMessage(cmdlen);
        m.setElement(0, cmdcode);
        m.setElement(1, addrhi);
        m.setElement(2, addrlo);
        if (cmdlen > 3) {
            if (cmdlen > 4) {
                m.setElement(3, settinghi);
            } else {
                m.setElement(3, settinglo);
            }
        }
        if (cmdlen > 4) {
            m.setElement(4, settinglo);
        }
        m.setBinary(true);
        return m;
    }

    public void markChanges(AcelaReply l) {
        int firstByteNum = this.startingSensorAddress / 8;
        int firstBitAt = this.startingSensorAddress % 8;
        log.debug("Sensor Parsing for module type: {}", (Object)moduleNames[this.nodeType]);
        log.debug("Sensor Parsing has startingSensorAddress: {}", (Object)this.startingSensorAddress);
        log.debug("Sensor Parsing has firstByteNum: {}", (Object)firstByteNum);
        log.debug("Sensor Parsing has firstBitAt: {}", (Object)firstBitAt);
        int rawvalue = l.getElement(firstByteNum);
        log.debug("Sensor Parsing has first rawvalue: {}", (Object)Integer.toHexString(rawvalue));
        int usingByteNum = 0;
        try {
            int i = 0;
            while (i < this.sensorbitsPerCard) {
                if (this.sensorArray[i] == null) {
                    log.debug("Sensor Parsing for Sensor: {} + {} was skipped", (Object)this.startingSensorAddress, (Object)i);
                } else {
                    int j;
                    log.debug("Sensor Parsing for Sensor: {} + {}", (Object)this.startingSensorAddress, (Object)i);
                    int relvalue = rawvalue;
                    int tempi = i;
                    if (usingByteNum == 0 && firstBitAt == 4) {
                        j = 0;
                        while (j < firstBitAt) {
                            relvalue >>= 1;
                            ++j;
                        }
                        log.debug("Sensor Parsing for Sensor: {} + {} shifted by 4: {}", new Object[]{this.startingSensorAddress, i, Integer.toHexString(relvalue)});
                    }
                    if (firstBitAt == 4) {
                        if (i >= 12) {
                            usingByteNum = 2;
                            rawvalue = l.getElement(usingByteNum + firstByteNum);
                            log.debug("Sensor Parsing (1stat4) has third rawvalue: {}", (Object)Integer.toHexString(rawvalue));
                            relvalue = rawvalue;
                            tempi = i - 12;
                        } else if (i >= 4) {
                            usingByteNum = 1;
                            rawvalue = l.getElement(usingByteNum + firstByteNum);
                            log.debug("Sensor Parsing (1stat4) has second rawvalue: {}", (Object)Integer.toHexString(rawvalue));
                            relvalue = rawvalue;
                            tempi = i - 4;
                        }
                    } else if (i >= 8) {
                        usingByteNum = 1;
                        rawvalue = l.getElement(usingByteNum + firstByteNum);
                        log.debug("Sensor Parsing has second rawvalue: {}", (Object)Integer.toHexString(rawvalue));
                        relvalue = rawvalue;
                        tempi = i - 8;
                    }
                    log.debug("Sensor Parsing for Sensor: {} + {} has tempi: {}", new Object[]{this.startingSensorAddress, i, tempi});
                    j = 0;
                    while (j < tempi) {
                        relvalue >>= 1;
                        ++j;
                    }
                    log.debug("Sensor Parsing for Sensor: {} + {} has relvalue: {}", new Object[]{this.startingSensorAddress, i, Integer.toHexString(relvalue)});
                    boolean nooldstate = false;
                    byte oldstate = 0;
                    if (this.sensorLastSetting[i] == 2) {
                        oldstate = 1;
                    } else if (this.sensorLastSetting[i] == 4) {
                        oldstate = 0;
                    } else {
                        nooldstate = true;
                    }
                    int newerstate = relvalue & 1;
                    byte newstate = (byte)newerstate;
                    if (nooldstate || oldstate != newstate) {
                        if (nooldstate) {
                            log.debug("Sensor Parsing for Sensor: {} + {} had no old state.", (Object)this.startingSensorAddress, (Object)i);
                        }
                        if (newstate == 0) {
                            this.sensorLastSetting[i] = 4;
                            this.sensorArray[i].setKnownState(this.sensorLastSetting[i]);
                        } else {
                            this.sensorLastSetting[i] = 2;
                            this.sensorArray[i].setKnownState(this.sensorLastSetting[i]);
                        }
                        log.debug("Sensor Parsing for Sensor: {} + {} changed state: {} rawvalue: {}", new Object[]{this.startingSensorAddress, i, this.sensorLastSetting[i], Integer.toHexString(rawvalue)});
                    } else {
                        log.debug("Sensor Parsing for Sensor: {} + {} did NOT change state: {} rawvalue: {}", new Object[]{this.startingSensorAddress, i, this.sensorLastSetting[i], Integer.toHexString(rawvalue)});
                    }
                }
                ++i;
            }
        }
        catch (JmriException e) {
            log.error("exception in markChanges: {}", (Throwable)e);
        }
    }

    public void registerSensor(Sensor s, int rawaddr) {
        if (rawaddr < 0 || rawaddr >= 1024) {
            log.error("Unexpected sensor ordinal in registerSensor: {}", (Object)Integer.toString(rawaddr));
            return;
        }
        int addr = -1;
        addr = rawaddr - this.startingSensorAddress;
        this.hasActiveSensors = true;
        InstanceManager.getDefault(AcelaSystemConnectionMemo.class).getTrafficController().setAcelaSensorsState(true);
        if (this.startingSensorAddress < 0) {
            log.info("Trying to register sensor too early: {}S{}", (Object)InstanceManager.getDefault(AcelaSystemConnectionMemo.class).getSystemPrefix(), (Object)rawaddr);
        } else if (this.sensorArray[addr] == null) {
            this.sensorArray[addr] = s;
            if (!this.sensorHasBeenInit[addr]) {
                this.sensorNeedInit[addr] = true;
            }
        } else {
            log.warn("Multiple registration of same sensor: {}S{}", (Object)InstanceManager.getDefault(AcelaSystemConnectionMemo.class).getSystemPrefix(), (Object)rawaddr);
        }
    }

    @Override
    public boolean handleTimeout(AbstractMRMessage m, AbstractMRListener l) {
        ++this.timeout;
        if (log.isDebugEnabled()) {
            log.warn("Timeout to poll for UA={}: consecutive timeouts: {}", (Object)this.nodeAddress, (Object)this.timeout);
        }
        return false;
    }

    @Override
    public void resetTimeout(AbstractMRMessage m) {
        if (this.timeout > 0) {
            log.debug("Reset {} timeout count", (Object)this.timeout);
        }
        this.timeout = 0;
    }
}

