/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.acela;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Light;
import jmri.Manager;
import jmri.jmrix.acela.AcelaAddress;
import jmri.jmrix.acela.AcelaLight;
import jmri.jmrix.acela.AcelaSystemConnectionMemo;
import jmri.managers.AbstractLightManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcelaLightManager
extends AbstractLightManager {
    private static final Logger log = LoggerFactory.getLogger(AcelaLightManager.class);

    public AcelaLightManager(AcelaSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public AcelaSystemConnectionMemo getMemo() {
        return (AcelaSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Light createNewLight(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        AcelaLight lgt = null;
        int nAddress = AcelaAddress.getNodeAddressFromSystemName(systemName, this.getMemo());
        if (nAddress == -1) {
            throw new IllegalArgumentException("Invalid Node Address from System Name: " + systemName);
        }
        int bitNum = AcelaAddress.getBitFromSystemName(systemName, this.getSystemPrefix());
        if (bitNum == -1) {
            throw new IllegalArgumentException("Invalid Bit from System Name: " + systemName);
        }
        if (AcelaAddress.validSystemNameFormat(systemName, 'L', this.getSystemPrefix()) == Manager.NameValidity.VALID) {
            lgt = new AcelaLight(systemName, userName, this.getMemo());
            if (!AcelaAddress.validSystemNameConfig(systemName, 'L', this.getMemo())) {
                log.warn("Light System Name does not refer to configured hardware: {}", (Object)systemName);
            }
        } else {
            log.error("Invalid Light System Name format: {}", (Object)systemName);
            throw new IllegalArgumentException("Invalid Light System Name format: " + systemName);
        }
        return lgt;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return super.validateIntegerSystemNameFormat(systemName, 0, 16383, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return AcelaAddress.validSystemNameFormat(systemName, 'L', this.getSystemPrefix());
    }

    @Override
    public boolean validSystemNameConfig(@Nonnull String systemName) {
        return AcelaAddress.validSystemNameConfig(systemName, 'L', this.getMemo());
    }

    @Override
    @Nonnull
    public String convertSystemNameToAlternate(@Nonnull String systemName) {
        return AcelaAddress.convertSystemNameToAlternate(systemName, this.getSystemPrefix());
    }
}

