/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.acela;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Light;
import jmri.Manager;
import jmri.Sensor;
import jmri.Turnout;
import jmri.jmrix.acela.AcelaNode;
import jmri.jmrix.acela.AcelaSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcelaAddress {
    static final int MINSENSORADDRESS = 0;
    static final int MAXSENSORADDRESS = 16383;
    static final int MINOUTPUTADDRESS = 0;
    static final int MAXOUTPUTADDRESS = 16383;
    private static final Logger log = LoggerFactory.getLogger(AcelaAddress.class);

    public static int getNodeAddressFromSystemName(String systemName, AcelaSystemConnectionMemo memo) {
        if (AcelaAddress.validSystemNameFormat(systemName, systemName.charAt(memo.getSystemPrefix().length()), memo.getSystemPrefix()) != Manager.NameValidity.VALID) {
            return -1;
        }
        int num = AcelaAddress.getBitFromSystemName(systemName, memo.getSystemPrefix());
        if (num < 0) {
            log.error("invalid Acela system name: {}", (Object)systemName);
            return -1;
        }
        int nodeaddress = -1;
        nodeaddress = systemName.charAt(memo.getSystemPrefix().length()) == 'S' ? memo.getTrafficController().lookupAcelaNodeAddress(num, true) : memo.getTrafficController().lookupAcelaNodeAddress(num, false);
        return nodeaddress;
    }

    public static AcelaNode getNodeFromSystemName(String systemName, AcelaSystemConnectionMemo memo) {
        int ua = AcelaAddress.getNodeAddressFromSystemName(systemName, memo);
        if (ua == -1) {
            return null;
        }
        AcelaNode tempnode = (AcelaNode)memo.getTrafficController().getNodeFromAddress(ua);
        return tempnode;
    }

    public static int getBitFromSystemName(String systemName, String prefix) {
        if (!systemName.startsWith(prefix) || systemName.charAt(prefix.length()) != 'L' && systemName.charAt(prefix.length()) != 'S' && systemName.charAt(prefix.length()) != 'T' && systemName.charAt(prefix.length()) != 'H') {
            log.error("illegal character in header field of system name: {}", (Object)systemName);
            return -1;
        }
        int num = -1;
        try {
            num = Integer.parseInt(systemName.substring(prefix.length() + 1));
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("invalid character in number field of system name: {}", (Object)systemName);
            return -1;
        }
        if (num < 0) {
            log.warn("invalid Acela system name: {}", (Object)systemName);
            return -1;
        }
        return num;
    }

    public static Manager.NameValidity validSystemNameFormat(@Nonnull String systemName, char type, String prefix) {
        int num;
        if (!systemName.startsWith(String.valueOf(prefix) + type)) {
            log.error("invalid character in header field of system name: {}", (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        try {
            num = Integer.parseInt(systemName.substring(prefix.length() + 1));
        }
        catch (NumberFormatException numberFormatException) {
            log.debug("invalid character in number field of system name: {}", (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        if (num >= 0) {
            return Manager.NameValidity.VALID;
        }
        log.debug("invalid Acela system name: {}", (Object)systemName);
        return Manager.NameValidity.INVALID;
    }

    @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="additional check for valid bit value")
    public static boolean validSystemNameConfig(String systemName, char type, AcelaSystemConnectionMemo memo) {
        if (AcelaAddress.validSystemNameFormat(systemName, type, memo.getSystemPrefix()) != Manager.NameValidity.VALID) {
            return false;
        }
        AcelaNode node = AcelaAddress.getNodeFromSystemName(systemName, memo);
        if (node == null) {
            return false;
        }
        int bit = AcelaAddress.getBitFromSystemName(systemName, memo.getSystemPrefix());
        switch (type) {
            case 'L': 
            case 'T': {
                if (bit < 0 || bit > 16383) break;
                return true;
            }
            case 'S': {
                if (bit < 0 || bit > 16383) break;
                return true;
            }
            default: {
                log.error("Invalid type specification in validSystemNameConfig call");
                return false;
            }
        }
        log.warn("Acela hardware address out of range in system name: {}", (Object)systemName);
        return false;
    }

    public static boolean validSystemNameConfig(String systemName, AcelaSystemConnectionMemo memo) {
        char type = systemName.charAt(memo.getSystemPrefix().length());
        return AcelaAddress.validSystemNameConfig(systemName, type, memo);
    }

    public static String convertSystemNameToAlternate(String systemName, String prefix) {
        if (AcelaAddress.validSystemNameFormat(systemName, systemName.charAt(prefix.length()), prefix) != Manager.NameValidity.VALID) {
            return "";
        }
        String altName = "";
        altName = systemName;
        return altName;
    }

    public static String normalizeSystemName(String systemName, String prefix) {
        if (AcelaAddress.validSystemNameFormat(systemName, systemName.charAt(prefix.length()), prefix) != Manager.NameValidity.VALID) {
            return "";
        }
        int bitNum = AcelaAddress.getBitFromSystemName(systemName, prefix);
        char type = systemName.charAt(prefix.length());
        if (bitNum < 0) {
            return "";
        }
        String nName = "";
        nName = String.valueOf(prefix) + type + Integer.toString(bitNum);
        return nName;
    }

    public static String makeSystemName(String type, int nAddress, int bitNum, AcelaSystemConnectionMemo memo) {
        String nName = "";
        if (!(type.equalsIgnoreCase("S") || type.equalsIgnoreCase("L") || type.equalsIgnoreCase("T"))) {
            log.error("invalid type character proposed for system name");
            return nName;
        }
        if (nAddress < memo.getTrafficController().getMinimumNodeAddress() || nAddress > memo.getTrafficController().getMaximumNumberOfNodes()) {
            log.warn("invalid node adddress proposed for system name");
            return nName;
        }
        if (type.equalsIgnoreCase("S") && (bitNum < 0 || bitNum > 16383)) {
            log.warn("invalid bit number proposed for Acela Sensor");
            return nName;
        }
        if ((type.equalsIgnoreCase("L") || type.equalsIgnoreCase("T")) && (bitNum < 0 || bitNum > 16383)) {
            log.warn("invalid bit number proposed for Acela Turnout or Light");
            return nName;
        }
        nName = String.valueOf(memo.getSystemPrefix()) + type + Integer.toString(bitNum);
        return nName;
    }

    public static String getUserNameFromSystemName(String systemName, String prefix) {
        if (systemName.length() < prefix.length() + 2 || !systemName.startsWith(prefix)) {
            return "";
        }
        if (systemName.charAt(prefix.length() + 1) == 'S') {
            Sensor s = null;
            s = InstanceManager.sensorManagerInstance().getBySystemName(systemName);
            if (s != null) {
                return s.getUserName();
            }
            return "";
        }
        if (systemName.charAt(prefix.length() + 1) == 'T') {
            Turnout t = null;
            t = InstanceManager.turnoutManagerInstance().getBySystemName(systemName);
            if (t != null) {
                return t.getUserName();
            }
            return "";
        }
        if (systemName.charAt(prefix.length() + 1) == 'L') {
            Light lgt = null;
            lgt = InstanceManager.lightManagerInstance().getBySystemName(systemName);
            if (lgt != null) {
                return lgt.getUserName();
            }
            return "";
        }
        return "";
    }
}

