/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import jmri.SystemConnectionMemo;
import jmri.jmrix.AbstractPortController;
import jmri.util.usb.UsbUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsbPortAdapter
extends AbstractPortController {
    private Short vendorID = 0;
    private Short productID = 0;
    private String serialNumber = null;
    protected UsbDevice usbDevice = null;
    private String port = null;
    private static final Logger log = LoggerFactory.getLogger(UsbPortAdapter.class);

    public UsbPortAdapter(SystemConnectionMemo memo) {
        super(memo);
    }

    public Short getVendorID() {
        return this.vendorID;
    }

    public void setVendorID(Short value) {
        this.vendorID = value;
    }

    public Short getProductID() {
        return this.productID;
    }

    public void setProductID(Short value) {
        this.productID = value;
    }

    public String getSerialNumber() {
        if (this.serialNumber != null && this.serialNumber.trim().isEmpty()) {
            this.serialNumber = null;
        }
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber == null || serialNumber.trim().isEmpty() ? null : serialNumber;
    }

    public UsbDevice getUsbDevice() {
        if (this.usbDevice == null) {
            log.debug("Getting device at {}", (Object)this.port);
            String error = this.openPort(this.port, this.serialNumber);
            if (error != null) {
                log.error(error);
            }
        }
        return this.usbDevice;
    }

    public String openPort(String portName, String serialNumber) {
        this.usbDevice = UsbUtil.getMatchingDevice(this.vendorID, this.productID, serialNumber, portName);
        if (this.usbDevice == null) {
            List<UsbDevice> usbDevices = UsbUtil.getMatchingDevices(this.vendorID, this.productID, serialNumber);
            if (usbDevices.size() == 1) {
                this.usbDevice = usbDevices.get(0);
            } else {
                usbDevices = UsbUtil.getMatchingDevices(this.vendorID, this.productID, null);
                if (usbDevices.size() == 1) {
                    this.usbDevice = usbDevices.get(0);
                } else {
                    return String.format("Single USB device with vendor id %s and product id %s not found.", this.vendorID, this.productID);
                }
            }
        }
        return null;
    }

    @Override
    public void connect() throws IOException {
        log.debug("connect()");
    }

    @Override
    public DataInputStream getInputStream() {
        log.debug("getInputStream()");
        return null;
    }

    @Override
    public DataOutputStream getOutputStream() {
        log.debug("getOutputStream()");
        return null;
    }

    @Override
    public void recover() {
        log.debug("recover()");
    }

    @Override
    public void configure() {
        log.debug("configure()");
    }

    @Nonnull
    public List<String> getPortNames() {
        log.debug("getPortNames()");
        ArrayList<String> results = new ArrayList<String>();
        List<UsbDevice> usbDevices = UsbUtil.getMatchingDevices(this.vendorID, this.productID, null);
        usbDevices.forEach(device -> results.add(UsbUtil.getLocation(device)));
        return results;
    }

    public void setPort(String s) {
        log.debug("setPort('{}')", (Object)s);
        this.port = s;
    }

    @Override
    public String getCurrentPortName() {
        log.debug("getCurrentPortName()");
        return this.port;
    }

    public boolean sendControlTransfer(int requestType, int request, int value, int index, byte[] data) {
        boolean result = false;
        if (this.usbDevice != null) {
            try {
                UsbControlIrp usbControlIrp = this.usbDevice.createUsbControlIrp((byte)requestType, (byte)request, (short)value, (short)index);
                if (data == null) {
                    data = new byte[]{};
                }
                usbControlIrp.setData(data);
                usbControlIrp.setLength(data.length);
                this.usbDevice.syncSubmit(usbControlIrp);
                result = true;
            }
            catch (IllegalArgumentException | UsbDisconnectedException | UsbException e) {
                log.error("Exception transferring control", e);
            }
        }
        return result;
    }
}

