/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.SystemConnectionMemo;
import jmri.beans.Bean;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConnectionMemoManager
extends Bean
implements InstanceManagerAutoDefault {
    public static final String CONNECTION_ADDED = "ConnectionAdded";
    public static final String CONNECTION_REMOVED = "ConnectionRemoved";
    private static final Logger log = LoggerFactory.getLogger(SystemConnectionMemoManager.class);

    public void register(SystemConnectionMemo memo) {
        log.debug("registering connection {}", (Object)memo.getUserName());
        List<SystemConnectionMemo> list = InstanceManager.getList(SystemConnectionMemo.class);
        int size = list.size();
        if (size > 0 && list.get(size - 1) instanceof InternalSystemConnectionMemo) {
            log.debug("   putting one before end");
            SystemConnectionMemo internal = list.get(size - 1);
            InstanceManager.deregister(internal, SystemConnectionMemo.class);
            InstanceManager.store(memo, SystemConnectionMemo.class);
            InstanceManager.store(internal, SystemConnectionMemo.class);
        } else {
            InstanceManager.store(memo, SystemConnectionMemo.class);
        }
        log.trace("fire CONNECTION_ADDED for {}", (Object)memo);
        this.firePropertyChange(CONNECTION_ADDED, null, memo);
    }

    public void deregister(SystemConnectionMemo memo) {
        InstanceManager.deregister(memo, SystemConnectionMemo.class);
        log.trace("fire CONNECTION_REMOVED for {}", (Object)memo);
        this.firePropertyChange(CONNECTION_REMOVED, memo, null);
    }

    @CheckForNull
    public synchronized SystemConnectionMemo getSystemConnectionMemo(@Nonnull String systemPrefix, @Nonnull String userName) {
        for (SystemConnectionMemo memo : InstanceManager.getList(SystemConnectionMemo.class)) {
            if (!memo.getSystemPrefix().equals(systemPrefix) || !memo.getUserName().equals(userName)) continue;
            return memo;
        }
        return null;
    }

    @CheckForNull
    public synchronized SystemConnectionMemo getSystemConnectionMemoForUserName(@Nonnull String userName) {
        for (SystemConnectionMemo memo : InstanceManager.getList(SystemConnectionMemo.class)) {
            if (!memo.getUserName().equals(userName)) continue;
            return memo;
        }
        return null;
    }

    @CheckForNull
    public synchronized SystemConnectionMemo getSystemConnectionMemoForSystemPrefix(@Nonnull String systemPrefix) {
        for (SystemConnectionMemo memo : InstanceManager.getList(SystemConnectionMemo.class)) {
            if (!memo.getSystemPrefix().equals(systemPrefix)) continue;
            return memo;
        }
        return null;
    }

    public synchronized boolean isUserNameAvailable(@Nonnull String userName) {
        return InstanceManager.getList(SystemConnectionMemo.class).stream().noneMatch(memo -> userName.equals(memo.getUserName()));
    }

    public synchronized boolean isSystemPrefixAvailable(@Nonnull String systemPrefix) {
        return InstanceManager.getList(SystemConnectionMemo.class).stream().noneMatch(memo -> memo.getSystemPrefix().equals(systemPrefix));
    }

    public static SystemConnectionMemoManager getDefault() {
        return InstanceManager.getDefault(SystemConnectionMemoManager.class);
    }
}

