/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetMessage
implements Serializable {
    private int mNDataBytes = 0;
    private int[] mDataBytes = null;
    private int mOpCode = 0;
    private static final Logger log = LoggerFactory.getLogger(NetMessage.class);

    public NetMessage(int len) {
        if (len < 0) {
            log.error("invalid length in call to ctor: {}", (Object)len);
        }
        this.mNDataBytes = len;
        this.mDataBytes = new int[len];
    }

    public void setOpCode(int i) {
        this.mOpCode = i;
    }

    public int getOpCode() {
        return this.mOpCode;
    }

    public String getOpCodeHex() {
        return "0x" + Integer.toHexString(this.getOpCode());
    }

    public int getNumDataElements() {
        return this.mNDataBytes;
    }

    public int getElement(int n) {
        if (n < 0 || n >= this.mDataBytes.length) {
            log.error("illegal get element {} in message of {} elements: {}", new Object[]{n, this.mDataBytes.length, this.toString()});
        }
        return this.mDataBytes[n];
    }

    public void setElement(int n, int v) {
        if (n < 0 || n >= this.mDataBytes.length) {
            log.error("illegal set element {} in message of {} elements: {}", new Object[]{n, this.mDataBytes.length, this.toString()});
        }
        this.mDataBytes[n] = v;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < this.mNDataBytes) {
            s.append(Integer.toHexString(this.mDataBytes[i])).append(" ");
            ++i;
        }
        return s.toString();
    }

    public abstract boolean checkParity();

    public abstract void setParity();

    protected static int lowByte(int val) {
        return val & 0xFF;
    }

    protected static int highByte(int val) {
        if ((val & 0xFFFF0000) != 0) {
            log.error("highByte called with too large value: {}", (Object)Integer.toHexString(val));
        }
        return (val & 0xFF00) / 256;
    }
}

