/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.Bundle;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.jmrix.StreamConnectionConfig;
import jmri.swing.JTitledSeparator;
import jmri.swing.PreferencesPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmrixConfigPane
extends JPanel
implements PreferencesPanel {
    public static final String NONE_SELECTED = Bundle.getMessage("noneSelected");
    public static final String NO_PORTS_FOUND = Bundle.getMessage("noPortsFound");
    public static final String NONE = Bundle.getMessage("none");
    private static final Logger log = LoggerFactory.getLogger(JmrixConfigPane.class);
    private boolean isDirty = false;
    JComboBox<String> modeBox = new JComboBox();
    JComboBox<String> manuBox = new JComboBox();
    JPanel details = new JPanel();
    String[] classConnectionNameList;
    ConnectionConfig[] classConnectionList;
    String[] manufactureNameList;
    UserPreferencesManager p = InstanceManager.getDefault(UserPreferencesManager.class);
    ConnectionConfig ccCurrent = null;

    public static synchronized JmrixConfigPane createPanel(int index) {
        ConnectionConfig c = null;
        try {
            c = InstanceManager.getDefault(ConnectionConfigManager.class).getConnections(index);
            log.debug("connection {} is {}", (Object)index, (Object)c);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            log.debug("connection {} is null, creating new one", (Object)index);
        }
        return JmrixConfigPane.createPanel(c);
    }

    public static synchronized JmrixConfigPane createPanel(ConnectionConfig c) {
        JmrixConfigPane pane = new JmrixConfigPane(c);
        if (c == null) {
            pane.isDirty = true;
        }
        return pane;
    }

    public static JmrixConfigPane createNewPanel() {
        return JmrixConfigPane.createPanel(null);
    }

    public static void dispose(JmrixConfigPane confPane) {
        ConfigureManager cmOD;
        if (confPane == null) {
            log.debug("no instance found therefore can not dispose of it!");
            return;
        }
        if (confPane.ccCurrent != null) {
            try {
                confPane.ccCurrent.dispose();
            }
            catch (RuntimeException ex) {
                log.error("Error Occurred while disposing connection {}", (Object)ex.toString());
            }
        }
        if ((cmOD = InstanceManager.getNullableDefault(ConfigureManager.class)) != null) {
            cmOD.deregister(confPane);
            cmOD.deregister(confPane.ccCurrent);
        }
        InstanceManager.getDefault(ConnectionConfigManager.class).remove(confPane.ccCurrent);
    }

    protected JmrixConfigPane() {
    }

    protected JmrixConfigPane(ConnectionConfig original) {
        ConnectionConfigManager manager = InstanceManager.getDefault(ConnectionConfigManager.class);
        this.ccCurrent = original;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.manuBox.addItem(NONE_SELECTED);
        String[] stringArray = this.manufactureNameList = manager.getConnectionManufacturers();
        int n = this.manufactureNameList.length;
        int n2 = 0;
        while (n2 < n) {
            String manuName = stringArray[n2];
            if (original != null && original.getManufacturer() != null && original.getManufacturer().equals(manuName)) {
                this.manuBox.addItem(manuName);
                this.manuBox.setSelectedItem(manuName);
            } else {
                this.manuBox.addItem(manuName);
            }
            ++n2;
        }
        this.manuBox.addActionListener(evt -> this.updateComboConnection());
        String selectedItem = (String)this.manuBox.getSelectedItem();
        if (selectedItem != null) {
            this.classConnectionNameList = manager.getConnectionTypes(selectedItem);
        }
        this.classConnectionList = new ConnectionConfig[this.classConnectionNameList.length + 1];
        this.modeBox.addItem(NONE_SELECTED);
        if (this.manuBox.getSelectedIndex() != 0) {
            this.modeBox.setEnabled(true);
        } else {
            this.modeBox.setSelectedIndex(0);
            this.modeBox.setEnabled(false);
        }
        int n3 = 1;
        if (this.manuBox.getSelectedIndex() != 0) {
            String[] stringArray2 = this.classConnectionNameList;
            int n4 = this.classConnectionNameList.length;
            int n5 = 0;
            while (n5 < n4) {
                block16: {
                    String className = stringArray2[n5];
                    try {
                        ConnectionConfig config;
                        if (original != null && original.getClass().getName().equals(className)) {
                            config = original;
                            log.debug("matched existing config object");
                            this.modeBox.addItem(config.name());
                            this.modeBox.setSelectedItem(config.name());
                            if (this.classConnectionNameList.length == 1) {
                                this.modeBox.setSelectedIndex(1);
                            }
                        } else {
                            Class<?> cl = Class.forName(className);
                            config = (ConnectionConfig)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            if (config instanceof StreamConnectionConfig) break block16;
                            this.modeBox.addItem(config.name());
                        }
                        this.classConnectionList[n3++] = config;
                    }
                    catch (NullPointerException e) {
                        log.error("Attempt to load {} failed.", (Object)className, (Object)e);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        log.error("Attempt to load {} failed: {}.", (Object)className, (Object)e);
                    }
                }
                ++n5;
            }
            if (this.modeBox.getSelectedIndex() == 0 && this.p.getComboBoxLastSelection((String)this.manuBox.getSelectedItem()) != null) {
                this.modeBox.setSelectedItem(this.p.getComboBoxLastSelection((String)this.manuBox.getSelectedItem()));
            }
        }
        this.modeBox.addActionListener(a -> {
            if ((String)this.modeBox.getSelectedItem() != null && !((String)this.modeBox.getSelectedItem()).equals(NONE_SELECTED)) {
                this.p.setComboBoxLastSelection((String)this.manuBox.getSelectedItem(), (String)this.modeBox.getSelectedItem());
            }
            this.selection();
        });
        JPanel manufacturerPanel = new JPanel();
        manufacturerPanel.add(this.manuBox);
        JPanel connectionPanel = new JPanel();
        connectionPanel.add(this.modeBox);
        JPanel initialPanel = new JPanel();
        initialPanel.setLayout(new BoxLayout(initialPanel, 1));
        initialPanel.add(new JTitledSeparator(Bundle.getMessage("SystemManufacturer")));
        initialPanel.add(manufacturerPanel);
        initialPanel.add(new JTitledSeparator(Bundle.getMessage("SystemConnection")));
        initialPanel.add(connectionPanel);
        this.add((Component)initialPanel, "North");
        initialPanel.add(new JTitledSeparator(Bundle.getMessage("Settings")));
        JScrollPane scroll = new JScrollPane(this.details);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scroll, "Center");
        this.selection();
    }

    public void updateComboConnection() {
        this.modeBox.removeAllItems();
        this.modeBox.addItem(NONE_SELECTED);
        String selectedItem = (String)this.manuBox.getSelectedItem();
        if (selectedItem != null) {
            this.classConnectionNameList = InstanceManager.getDefault(ConnectionConfigManager.class).getConnectionTypes(selectedItem);
        }
        this.classConnectionList = new ConnectionConfig[this.classConnectionNameList.length + 1];
        if (this.manuBox.getSelectedIndex() != 0) {
            int n = 1;
            this.modeBox.setEnabled(true);
            String[] stringArray = this.classConnectionNameList;
            int n2 = this.classConnectionNameList.length;
            int n3 = 0;
            while (n3 < n2) {
                String classConnectionNameList1 = stringArray[n3];
                try {
                    Class<?> cl = Class.forName(classConnectionNameList1);
                    ConnectionConfig config = (ConnectionConfig)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!(config instanceof StreamConnectionConfig)) {
                        this.modeBox.addItem(config.name());
                        this.classConnectionList[n++] = config;
                        if (this.classConnectionNameList.length == 1) {
                            this.modeBox.setSelectedIndex(1);
                        }
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
                    log.warn("Attempt to load {} failed: {}", (Object)classConnectionNameList1, (Object)e);
                }
                ++n3;
            }
            if (this.p.getComboBoxLastSelection((String)this.manuBox.getSelectedItem()) != null) {
                this.modeBox.setSelectedItem(this.p.getComboBoxLastSelection((String)this.manuBox.getSelectedItem()));
            }
        } else {
            this.modeBox.setSelectedIndex(0);
            this.modeBox.setEnabled(false);
            if (this.ccCurrent != null) {
                this.ccCurrent.dispose();
            }
        }
    }

    void selection() {
        ConnectionConfig old = this.ccCurrent;
        int current = this.modeBox.getSelectedIndex();
        this.details.removeAll();
        log.debug("new selection is {} {}", (Object)current, this.modeBox.getSelectedItem());
        if (current != 0 && current != -1) {
            if (this.ccCurrent != null && this.ccCurrent != this.classConnectionList[current]) {
                this.ccCurrent.dispose();
            }
            this.ccCurrent = this.classConnectionList[current];
            this.ccCurrent.setManufacturer((String)this.manuBox.getSelectedItem());
            this.ccCurrent.loadDetails(this.details);
        } else if (this.ccCurrent != null) {
            this.ccCurrent.dispose();
        }
        if (old != this.ccCurrent) {
            assert (this.ccCurrent != null);
            this.ccCurrent.register();
        }
        this.validate();
        this.repaint();
    }

    public String getConnectionName() {
        int current = this.modeBox.getSelectedIndex();
        if (current == 0) {
            return null;
        }
        return this.classConnectionList[current].getConnectionName();
    }

    public String getCurrentManufacturerName() {
        int current = this.modeBox.getSelectedIndex();
        if (current == 0) {
            return NONE;
        }
        return this.classConnectionList[current].getManufacturer();
    }

    public String getCurrentProtocolName() {
        int current = this.modeBox.getSelectedIndex();
        if (current == 0) {
            return NONE;
        }
        return this.classConnectionList[current].name();
    }

    public String getCurrentProtocolInfo() {
        int current = this.modeBox.getSelectedIndex();
        if (current == 0) {
            return NONE;
        }
        return this.classConnectionList[current].getInfo();
    }

    public ConnectionConfig getCurrentObject() {
        int current = this.modeBox.getSelectedIndex();
        if (current != 0) {
            return this.classConnectionList[current];
        }
        return null;
    }

    public boolean getDisabled() {
        int current = this.modeBox.getSelectedIndex();
        if (current == 0) {
            return false;
        }
        return this.classConnectionList[current].getDisabled();
    }

    public void setDisabled(boolean disabled) {
        int current = this.modeBox.getSelectedIndex();
        if (current == 0) {
            return;
        }
        this.classConnectionList[current].setDisabled(disabled);
    }

    @Override
    public String getPreferencesItem() {
        return "CONNECTIONS";
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("MenuConnections");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        String title = this.getConnectionName();
        if (title == null && this.getCurrentProtocolName() != null && !this.getCurrentProtocolName().equals(NONE)) {
            title = this.getCurrentProtocolName();
        }
        if (title != null && !this.getDisabled()) {
            title = "(" + title + ")";
        }
        return title;
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return true;
    }

    @Override
    public String getPreferencesTooltip() {
        return this.getTabbedPreferencesTitle();
    }

    @Override
    public void savePreferences() {
    }

    @Override
    public boolean isDirty() {
        if (log.isDebugEnabled()) {
            log.debug("Connection \"{}\" is {}.", (Object)this.getConnectionName(), (Object)(this.isDirty || this.ccCurrent == null || this.ccCurrent.isDirty() ? "dirty" : "clean"));
        }
        return this.isDirty || this.ccCurrent == null || this.ccCurrent.isDirty();
    }

    @Override
    public boolean isRestartRequired() {
        return this.ccCurrent != null ? this.ccCurrent.isRestartRequired() : this.isDirty();
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }
}

