/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.AddressedProgrammerManager;
import jmri.CommandStation;
import jmri.ConsistManager;
import jmri.Disposable;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.SystemConnectionMemo;
import jmri.beans.Bean;
import jmri.implementation.DccConsistManager;
import jmri.implementation.NmraConsistManager;
import jmri.jmrix.ConflictingSystemConnectionMemo;
import jmri.jmrix.ResourceBundleStartupActionFactory;
import jmri.jmrix.SystemConnectionMemoManager;
import jmri.util.startup.StartupActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultSystemConnectionMemo
extends Bean
implements SystemConnectionMemo,
Disposable {
    private boolean disabled = false;
    private Boolean disabledAsLoaded = null;
    private String prefix;
    private String prefixAsLoaded;
    private String userName;
    private String userNameAsLoaded;
    protected Map<Class<?>, Object> classObjectMap;
    private int _interval = this.getDefaultOutputInterval();
    private static final Logger log = LoggerFactory.getLogger(DefaultSystemConnectionMemo.class);

    protected DefaultSystemConnectionMemo(@Nonnull String prefix, @Nonnull String userName) {
        int x;
        this.classObjectMap = new HashMap();
        if (this instanceof ConflictingSystemConnectionMemo) {
            this.prefix = prefix;
            this.userName = userName;
            return;
        }
        log.debug("SystemConnectionMemo created for prefix \"{}\" user name \"{}\"", (Object)prefix, (Object)userName);
        if (!this.setSystemPrefix(prefix)) {
            x = 2;
            while (!this.setSystemPrefix(String.valueOf(prefix) + x)) {
                ++x;
            }
            log.debug("created system prefix {}{}", (Object)prefix, (Object)x);
        }
        if (!this.setUserName(userName)) {
            x = 2;
            while (!this.setUserName(String.valueOf(userName) + x)) {
                ++x;
            }
            log.debug("created user name {}{}", (Object)prefix, (Object)x);
        }
        this.prefixAsLoaded = null;
        this.userNameAsLoaded = null;
    }

    @Override
    public void register() {
        log.debug("register as SystemConnectionMemo, really of type {}", this.getClass());
        SystemConnectionMemoManager.getDefault().register(this);
    }

    @Override
    public String getSystemPrefix() {
        return this.prefix;
    }

    @Override
    public final boolean setSystemPrefix(@Nonnull String systemPrefix) {
        Objects.requireNonNull(systemPrefix);
        if (systemPrefix.equals(this.prefix)) {
            if (this.prefixAsLoaded == null) {
                this.prefixAsLoaded = systemPrefix;
            }
            return true;
        }
        String oldPrefix = this.prefix;
        if (SystemConnectionMemoManager.getDefault().isSystemPrefixAvailable(systemPrefix)) {
            this.prefix = systemPrefix;
            if (this.prefixAsLoaded == null) {
                this.prefixAsLoaded = systemPrefix;
            }
            this.propertyChangeSupport.firePropertyChange("ConnectionPrefixChanged", oldPrefix, systemPrefix);
            return true;
        }
        log.debug("setSystemPrefix false for \"{}\"", (Object)systemPrefix);
        return false;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public final boolean setUserName(@Nonnull String userName) {
        Objects.requireNonNull(userName);
        if (userName.equals(this.userName)) {
            if (this.userNameAsLoaded == null) {
                this.userNameAsLoaded = userName;
            }
            return true;
        }
        String oldUserName = this.userName;
        if (SystemConnectionMemoManager.getDefault().isUserNameAvailable(userName)) {
            this.userName = userName;
            if (this.userNameAsLoaded == null) {
                this.userNameAsLoaded = userName;
            }
            this.propertyChangeSupport.firePropertyChange("ConnectionNameChanged", oldUserName, userName);
            return true;
        }
        return false;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean provides(Class<?> c) {
        if (this.disabled) {
            return false;
        }
        if (c.equals(ConsistManager.class)) {
            return this.classObjectMap.get(c) != null || this.provides(CommandStation.class) || this.provides(AddressedProgrammerManager.class);
        }
        return this.classObjectMap.containsKey(c);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public <T> T get(Class<?> type) {
        if (this.disabled) {
            return null;
        }
        if (type.equals(ConsistManager.class)) {
            return (T)this.getConsistManager();
        }
        return (T)this.classObjectMap.get(type);
    }

    @Override
    public void dispose() {
        HashSet keySet = new HashSet(this.classObjectMap.keySet());
        keySet.forEach(this::removeRegisteredObject);
        SystemConnectionMemoManager.getDefault().deregister(this);
    }

    private <T> void removeRegisteredObject(Class<T> c) {
        T object = this.get(c);
        if (object != null) {
            InstanceManager.deregister(object, c);
            this.deregister(object, c);
            this.disposeIfPossible(c, object);
        }
    }

    private <T> void disposeIfPossible(Class<T> c, T object) {
        if (object instanceof Disposable) {
            try {
                ((Disposable)object).dispose();
            }
            catch (Exception e) {
                log.warn("Exception while disposing object of type {} in memo of type {}.", new Object[]{c.getName(), this.getClass().getName(), e});
            }
        }
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.disabledAsLoaded == null) {
            this.disabledAsLoaded = disabled;
        }
        if (disabled != this.disabled) {
            boolean oldDisabled = this.disabled;
            this.disabled = disabled;
            this.propertyChangeSupport.firePropertyChange("ConnectionDisabled", oldDisabled, disabled);
        }
    }

    @Override
    public abstract <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> var1);

    @Override
    @Nonnull
    public StartupActionFactory getActionFactory() {
        return new ResourceBundleStartupActionFactory(this.getActionModelResourceBundle());
    }

    protected abstract ResourceBundle getActionModelResourceBundle();

    @Deprecated
    protected final void addToActionList() {
    }

    @Deprecated
    protected final void removeFromActionList() {
    }

    @Override
    public boolean isDirty() {
        return this.disabledAsLoaded == null || this.disabledAsLoaded != this.disabled || this.prefixAsLoaded == null || !this.prefixAsLoaded.equals(this.prefix) || this.userNameAsLoaded == null || !this.userNameAsLoaded.equals(this.userName);
    }

    @Override
    public boolean isRestartRequired() {
        return this.isDirty();
    }

    public ConsistManager getConsistManager() {
        return (ConsistManager)this.classObjectMap.computeIfAbsent(ConsistManager.class, c -> this.generateDefaultConsistManagerForConnection());
    }

    private ConsistManager generateDefaultConsistManagerForConnection() {
        if (this.provides(CommandStation.class)) {
            return new NmraConsistManager((CommandStation)this.get(CommandStation.class));
        }
        if (this.provides(AddressedProgrammerManager.class)) {
            return new DccConsistManager((AddressedProgrammerManager)this.get(AddressedProgrammerManager.class));
        }
        return null;
    }

    public void setConsistManager(ConsistManager c) {
        this.store(c, ConsistManager.class);
        InstanceManager.store(c, ConsistManager.class);
    }

    public <T> void store(@Nonnull T item, @Nonnull Class<T> type) {
        this.classObjectMap.put(type, item);
    }

    public <T> void deregister(@Nonnull T item, @Nonnull Class<T> type) {
        this.classObjectMap.remove(type, item);
    }

    @Override
    public int getDefaultOutputInterval() {
        return 250;
    }

    @Override
    public int getOutputInterval() {
        log.debug("Getting interval {}", (Object)this._interval);
        return this._interval;
    }

    @Override
    public void setOutputInterval(int newInterval) {
        log.debug("Setting interval from {} to {}", (Object)this._interval, (Object)newInterval);
        this.propertyChangeSupport.firePropertyChange("OutputInterval", this._interval, newInterval);
        this._interval = newInterval;
    }
}

