/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.AbstractConnectionConfig;
import jmri.jmrix.Bundle;
import jmri.jmrix.JmrixConfigPane;
import jmri.jmrix.UsbPortAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUsbConnectionConfig
extends AbstractConnectionConfig {
    protected UsbPortAdapter adapter;
    protected boolean init = false;
    protected UserPreferencesManager p = InstanceManager.getDefault(UserPreferencesManager.class);
    protected JComboBox<String> portBox = new JComboBox();
    protected JLabel portBoxLabel;
    List<String> newList = null;
    List<String> originalList = null;
    String invalidPort = null;
    private static final Logger log = LoggerFactory.getLogger(AbstractUsbConnectionConfig.class);

    public AbstractUsbConnectionConfig(UsbPortAdapter p) {
        this.adapter = p;
        log.debug("*   AbstractUSBConnectionConfig({})", (Object)p);
    }

    public AbstractUsbConnectionConfig() {
        this(null);
        log.debug("*   AbstractUSBConnectionConfig()");
    }

    @Override
    public UsbPortAdapter getAdapter() {
        log.debug("*   getAdapter()");
        return this.adapter;
    }

    @Override
    protected void checkInitDone() {
        log.debug("init called for {}", (Object)this.name());
        if (!this.init) {
            this.addNameEntryCheckers(this.adapter);
            this.portBox.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    AbstractUsbConnectionConfig.this.refreshPortBox();
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            });
            for (Map.Entry entry : this.options.entrySet()) {
                String item = (String)entry.getKey();
                if (!(((AbstractConnectionConfig.Option)entry.getValue()).getComponent() instanceof JComboBox)) continue;
                ((JComboBox)((AbstractConnectionConfig.Option)entry.getValue()).getComponent()).addActionListener(e -> this.adapter.setOptionState(item, ((AbstractConnectionConfig.Option)this.options.get(item)).getItem()));
            }
            this.init = true;
        }
    }

    @Override
    public void updateAdapter() {
        log.debug("*   updateAdapter()");
    }

    @Override
    public String getInfo() {
        log.debug("*   getInfo()");
        String t = (String)this.portBox.getSelectedItem();
        if (t != null) {
            return t;
        }
        if (this.adapter != null && this.adapter.getCurrentPortName() != null) {
            return this.adapter.getCurrentPortName();
        }
        return JmrixConfigPane.NONE;
    }

    public void refreshPortBox() {
        String portName;
        log.debug("*   refreshPortBox()");
        if (!this.init) {
            this.newList = this.getPortNames();
            this.portBox.setRenderer(new ComboBoxRenderer());
            this.portBox.setPrototypeDisplayValue("A fairly long port name of 40 characters");
        } else {
            List<String> v2 = this.getPortNames();
            if (v2.equals(this.originalList)) {
                log.debug("List of valid Ports has not changed, therefore we will not refresh the port list");
                this.adapter.setPort((String)this.portBox.getSelectedItem());
                return;
            }
            log.debug("List of valid Ports has been changed, therefore we will refresh the port list");
            this.newList = new ArrayList<String>(v2);
        }
        if (this.newList == null) {
            log.error("port name List v is null!");
            return;
        }
        this.originalList = new ArrayList<String>(this.newList);
        if (this.portBox.getActionListeners().length > 0) {
            this.portBox.removeActionListener(this.portBox.getActionListeners()[0]);
        }
        this.portBox.removeAllItems();
        log.debug("getting fresh list of available Serial Ports");
        if (this.newList.isEmpty()) {
            this.newList.add(0, Bundle.getMessage("noPortsFound"));
        }
        if ((portName = this.adapter.getCurrentPortName()) != null && !portName.equals(Bundle.getMessage("noneSelected")) && !portName.equals(Bundle.getMessage("noPortsFound"))) {
            if (!this.newList.contains(portName)) {
                this.newList.add(0, portName);
                this.invalidPort = portName;
                this.portBox.setForeground(Color.red);
            } else if (this.invalidPort != null && this.invalidPort.equals(portName)) {
                this.invalidPort = null;
            }
        } else if (!this.newList.contains(portName)) {
            this.newList.add(0, Bundle.getMessage("noneSelected"));
        } else if (this.p.getComboBoxLastSelection(String.valueOf(this.adapter.getClass().getName()) + ".port") == null) {
            this.newList.add(0, Bundle.getMessage("noneSelected"));
        }
        AbstractUsbConnectionConfig.updateUsbPortNames(portName, this.portBox, this.newList);
        boolean didSetName = false;
        if ((portName == null || portName.equals(Bundle.getMessage("noneSelected")) || portName.equals(Bundle.getMessage("noPortsFound"))) && !didSetName) {
            this.portBox.setSelectedIndex(0);
        }
        this.adapter.setPort((String)this.portBox.getSelectedItem());
        this.portBox.addActionListener(e -> {
            String port = (String)this.portBox.getSelectedItem();
            this.adapter.setPort(port);
        });
    }

    @Override
    public void loadDetails(JPanel details) {
        log.debug("*   loadDetails()");
        this._details = details;
        this.setInstance();
        if (!this.init) {
            String[] optionsAvailable = this.adapter.getOptions();
            this.options.clear();
            String[] stringArray = optionsAvailable;
            int n = optionsAvailable.length;
            int n2 = 0;
            while (n2 < n) {
                String i = stringArray[n2];
                JComboBox<String> opt = new JComboBox<String>(this.adapter.getOptionChoices(i));
                opt.setSelectedItem(this.adapter.getOptionState(i));
                if (!this.adapter.getOptionState(i).equals(opt.getSelectedItem())) {
                    opt.setSelectedIndex(0);
                    log.warn("Loading found invalid value for option {}, found \"{}\", setting to \"{}\"", new Object[]{i, this.adapter.getOptionState(i), opt.getSelectedItem()});
                    this.adapter.setOptionState(i, (String)opt.getSelectedItem());
                }
                this.options.put(i, new AbstractConnectionConfig.Option(this.adapter.getOptionDisplayName(i), opt, this.adapter.isOptionAdvanced(i)));
                ++n2;
            }
        }
        try {
            this.newList = this.getPortNames();
            if (log.isDebugEnabled()) {
                log.debug("loadDetails called in class {}", (Object)this.getClass().getName());
                log.debug("adapter class: {}", (Object)this.adapter.getClass().getName());
                log.debug("loadDetails called for {}", (Object)this.name());
                if (this.newList != null) {
                    log.debug("Found {} ports", (Object)this.newList.size());
                } else {
                    log.debug("Zero-length port List");
                }
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            log.error("UnsatisfiedLinkError - the serial library has not been installed properly");
            log.error("java.library.path={}", (Object)System.getProperty("java.library.path", "<unknown>"));
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorComLibLoad"));
            return;
        }
        if (this.adapter.getSystemConnectionMemo() != null) {
            this.systemPrefixField.setText(this.adapter.getSystemConnectionMemo().getSystemPrefix());
            this.connectionNameField.setText(this.adapter.getSystemConnectionMemo().getUserName());
            this.NUMOPTIONS += 2;
        }
        this.refreshPortBox();
        this.NUMOPTIONS += this.options.size();
        this.portBoxLabel = new JLabel(Bundle.getMessage("UsbPortLocationLabel"));
        this.showAdvanced.setFont(this.showAdvanced.getFont().deriveFont(9.0f));
        this.showAdvanced.setForeground(Color.blue);
        this.showAdvanced.addItemListener(e -> this.showAdvancedItems());
        this.showAdvancedItems();
        this.init = false;
        this.checkInitDone();
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Type is checked before casting")
    protected void showAdvancedItems() {
        log.debug("*   showAdvancedItems()");
        this._details.removeAll();
        this.cL.anchor = 17;
        this.cL.insets = new Insets(2, 5, 0, 5);
        this.cR.insets = new Insets(2, 0, 0, 5);
        this.cR.anchor = 17;
        this.cR.gridx = 1;
        this.cL.gridx = 0;
        int i = 0;
        boolean incAdvancedOptions = this.isPortAdvanced();
        if (!incAdvancedOptions) {
            for (Map.Entry entry : this.options.entrySet()) {
                if (!((AbstractConnectionConfig.Option)entry.getValue()).isAdvanced().booleanValue()) continue;
                incAdvancedOptions = true;
                break;
            }
        }
        this._details.setLayout(this.gbLayout);
        i = this.addStandardDetails(incAdvancedOptions, i);
        this.showAdvanced.setVisible(incAdvancedOptions);
        if (incAdvancedOptions && this.showAdvanced.isSelected()) {
            if (this.isPortAdvanced()) {
                this.cR.gridy = i;
                this.cL.gridy = i++;
                this.gbLayout.setConstraints(this.portBoxLabel, this.cL);
                this.gbLayout.setConstraints(this.portBox, this.cR);
                this._details.add(this.portBoxLabel);
                this._details.add(this.portBox);
            }
            for (Map.Entry entry : this.options.entrySet()) {
                if (!((AbstractConnectionConfig.Option)entry.getValue()).isAdvanced().booleanValue()) continue;
                this.cR.gridy = i;
                this.cL.gridy = i++;
                this.gbLayout.setConstraints(((AbstractConnectionConfig.Option)entry.getValue()).getLabel(), this.cL);
                this.gbLayout.setConstraints(((AbstractConnectionConfig.Option)entry.getValue()).getComponent(), this.cR);
                this._details.add(((AbstractConnectionConfig.Option)entry.getValue()).getLabel());
                this._details.add(((AbstractConnectionConfig.Option)entry.getValue()).getComponent());
            }
        }
        this.cL.gridwidth = 2;
        for (JComponent item : this.additionalItems) {
            this.cL.gridy = i++;
            this.gbLayout.setConstraints(item, this.cL);
            this._details.add(item);
        }
        this.cL.gridwidth = 1;
        if (this._details.getParent() != null && this._details.getParent() instanceof JViewport) {
            JViewport vp = (JViewport)this._details.getParent();
            vp.revalidate();
            vp.repaint();
        }
    }

    protected int addStandardDetails(boolean incAdvanced, int i) {
        log.debug("*   addStandardDetails()");
        if (!this.isPortAdvanced()) {
            this.cR.gridy = i;
            this.cL.gridy = i++;
            this.gbLayout.setConstraints(this.portBoxLabel, this.cL);
            this.gbLayout.setConstraints(this.portBox, this.cR);
            this._details.add(this.portBoxLabel);
            this._details.add(this.portBox);
        }
        return this.addStandardDetails(this.adapter, incAdvanced, i);
    }

    public boolean isPortAdvanced() {
        log.debug("*   isPortAdvanced()");
        return false;
    }

    @Override
    public String getManufacturer() {
        log.debug("*   getManufacturer()");
        return this.adapter.getManufacturer();
    }

    @Override
    public void setManufacturer(String manufacturer) {
        this.setInstance();
        log.debug("*   setManufacturer('{}')", (Object)manufacturer);
        this.adapter.setManufacturer(manufacturer);
    }

    @Override
    public boolean getDisabled() {
        log.debug("*   getDisabled()");
        if (this.adapter == null) {
            return true;
        }
        return this.adapter.getDisabled();
    }

    @Override
    public void setDisabled(boolean disabled) {
        log.debug("*   setDisabled({})", (Object)(disabled ? "True" : "False"));
        if (this.adapter != null) {
            this.adapter.setDisabled(disabled);
        }
    }

    @Override
    public String getConnectionName() {
        log.debug("*   getConnectionName()");
        if (this.adapter != null && this.adapter.getSystemConnectionMemo() != null) {
            return this.adapter.getSystemConnectionMemo().getUserName();
        }
        return this.name();
    }

    @Override
    public void dispose() {
        log.debug("*   dispose()");
        if (this.adapter != null) {
            this.adapter.dispose();
            this.adapter = null;
        }
        super.dispose();
    }

    protected static synchronized void updateUsbPortNames(String portName, JComboBox<String> portCombo, List<String> portList) {
        int i = 0;
        while (i < portList.size()) {
            String commPort = portList.get(i);
            portCombo.addItem(commPort);
            if (commPort.equals(portName)) {
                portCombo.setSelectedIndex(i);
            }
            ++i;
        }
    }

    @Nonnull
    protected List<String> getPortNames() {
        log.error("getPortNames() called in abstract class; should be overridden.");
        return new ArrayList<String>();
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        public ComboBoxRenderer() {
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String name, int index, boolean isSelected, boolean cellHasFocus) {
            this.setOpaque(index > -1);
            this.setForeground(Color.black);
            list.setSelectionForeground(Color.black);
            if (isSelected && index > -1) {
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setBackground(list.getBackground());
            }
            if (AbstractUsbConnectionConfig.this.invalidPort != null && (name == null || name.isEmpty() || name.equals(AbstractUsbConnectionConfig.this.invalidPort))) {
                list.setSelectionForeground(Color.red);
                this.setForeground(Color.red);
            }
            this.setText(name);
            return this;
        }
    }
}

