/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import jmri.BasicRosterEntry;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.SystemConnectionMemo;
import jmri.Throttle;
import jmri.ThrottleListener;
import jmri.ThrottleManager;
import jmri.jmrix.Bundle;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThrottleManager
implements ThrottleManager {
    protected SystemConnectionMemo adapterMemo;
    protected String userName = "Internal";
    @GuardedBy(value="this")
    private final HashMap<LocoAddress, ArrayList<WaitingThrottle>> throttleListeners = new HashMap(5);
    @GuardedBy(value="this")
    private final HashMap<LocoAddress, ArrayList<WaitingThrottle>> listenerOnly = new HashMap(5);
    @GuardedBy(value="this")
    private final Hashtable<LocoAddress, Addresses> addressThrottles = new Hashtable();
    private boolean _hideStealNotifications = false;
    private static final Logger log = LoggerFactory.getLogger(AbstractThrottleManager.class);

    public AbstractThrottleManager() {
    }

    public AbstractThrottleManager(SystemConnectionMemo memo) {
        this.adapterMemo = memo;
    }

    @Override
    public String getUserName() {
        if (this.adapterMemo != null) {
            return this.adapterMemo.getUserName();
        }
        return this.userName;
    }

    @Override
    public String[] getAddressTypes() {
        return new String[]{LocoAddress.Protocol.DCC.getPeopleName(), LocoAddress.Protocol.DCC_SHORT.getPeopleName(), LocoAddress.Protocol.DCC_LONG.getPeopleName()};
    }

    @Override
    public String getAddressTypeString(LocoAddress.Protocol prot) {
        return prot.getPeopleName();
    }

    @Override
    public LocoAddress.Protocol[] getAddressProtocolTypes() {
        return new LocoAddress.Protocol[]{LocoAddress.Protocol.DCC, LocoAddress.Protocol.DCC_SHORT, LocoAddress.Protocol.DCC_LONG};
    }

    @Override
    public LocoAddress getAddress(String value, LocoAddress.Protocol protocol) {
        if (value == null) {
            return null;
        }
        if (protocol == null) {
            return null;
        }
        int num = Integer.parseInt(value);
        if (!(LocoAddress.Protocol.DCC != protocol && LocoAddress.Protocol.DCC_SHORT != protocol || this.canBeShortAddress(num))) {
            protocol = LocoAddress.Protocol.DCC_LONG;
        }
        if (!(LocoAddress.Protocol.DCC != protocol && LocoAddress.Protocol.DCC_LONG != protocol || this.canBeLongAddress(num))) {
            protocol = LocoAddress.Protocol.DCC_SHORT;
        }
        if (protocol == LocoAddress.Protocol.DCC) {
            protocol = LocoAddress.Protocol.DCC_SHORT;
        }
        return new DccLocoAddress(num, protocol);
    }

    @Override
    public LocoAddress getAddress(String value, String protocol) {
        if (value == null) {
            return null;
        }
        if (protocol == null) {
            return null;
        }
        LocoAddress.Protocol p = this.getProtocolFromString(protocol);
        return this.getAddress(value, p);
    }

    @Override
    public LocoAddress.Protocol getProtocolFromString(String selection) {
        return LocoAddress.Protocol.getByPeopleName(selection);
    }

    protected boolean singleUse() {
        return true;
    }

    @Override
    public boolean requestThrottle(int address, boolean isLongAddress, ThrottleListener l, boolean canHandleDecisions) {
        DccLocoAddress la = new DccLocoAddress(address, isLongAddress);
        return this.requestThrottle(la, null, l, canHandleDecisions);
    }

    @Override
    public boolean requestThrottle(@Nonnull BasicRosterEntry re, ThrottleListener l, boolean canHandleDecisions) {
        return this.requestThrottle(re.getDccLocoAddress(), re, l, canHandleDecisions);
    }

    @Override
    public boolean requestThrottle(LocoAddress la, ThrottleListener l, boolean canHandleDecisions) {
        return this.requestThrottle(la, null, l, canHandleDecisions);
    }

    protected synchronized boolean requestThrottle(LocoAddress la, BasicRosterEntry re, ThrottleListener l, boolean canHandleDecisions) {
        boolean throttleFree = true;
        if (!this.canBeLongAddress(la.getNumber()) && !this.canBeShortAddress(la.getNumber())) {
            return false;
        }
        if (!this.throttleListeners.containsKey(la)) {
            this.throttleListeners.put(la, new ArrayList());
        }
        ArrayList<WaitingThrottle> a = this.throttleListeners.get(la);
        if (this.addressThrottles.containsKey(la)) {
            log.debug("A throttle to address {} already exists, so will return that throttle", (Object)la.getNumber());
            a.add(new WaitingThrottle(l, re, canHandleDecisions));
            this.notifyThrottleKnown(this.addressThrottles.get(la).getThrottle(), la);
            return throttleFree;
        }
        log.debug("LocoAddress {} has not been created before", (Object)la.getNumber());
        log.debug("After request in ATM: {}", (Object)a.size());
        if (this.singleUse() && a.size() > 0) {
            throttleFree = false;
            log.debug("singleUser() is true, and the list of WaitingThrottles isn't empty, returning false");
        } else if (a.size() == 0) {
            a.add(new WaitingThrottle(l, re, canHandleDecisions));
            log.debug("list of WaitingThrottles is empty: {}; {}", (Object)la, a);
            log.debug("calling requestThrottleSetup()");
            this.requestThrottleSetup(la, true);
        } else {
            a.add(new WaitingThrottle(l, re, canHandleDecisions));
            log.debug("singleUse() returns false and there are existing WaitThrottles, adding a one to the list");
        }
        return throttleFree;
    }

    @Override
    public boolean requestThrottle(int address, ThrottleListener l) {
        boolean isLong = true;
        if (this.canBeShortAddress(address)) {
            isLong = false;
        }
        return this.requestThrottle(new DccLocoAddress(address, isLong), null, l, false);
    }

    @Override
    public boolean requestThrottle(int address, ThrottleListener l, boolean canHandleDecisions) {
        boolean isLong = true;
        if (this.canBeShortAddress(address)) {
            isLong = false;
        }
        return this.requestThrottle(new DccLocoAddress(address, isLong), null, l, canHandleDecisions);
    }

    public abstract void requestThrottleSetup(LocoAddress var1, boolean var2);

    public void requestThrottleSetup(LocoAddress a) {
        this.requestThrottleSetup(a, true);
    }

    @Override
    public void cancelThrottleRequest(int address, boolean isLong, ThrottleListener l) {
        DccLocoAddress la = new DccLocoAddress(address, isLong);
        this.cancelThrottleRequest(la, l);
    }

    @Override
    public void cancelThrottleRequest(BasicRosterEntry re, ThrottleListener l) {
        this.cancelThrottleRequest(re.getDccLocoAddress(), l);
    }

    @Override
    public synchronized void cancelThrottleRequest(LocoAddress la, ThrottleListener l) {
        ArrayList<WaitingThrottle> a = this.throttleListeners.get(la);
        if (a == null || l == null) {
            return;
        }
        a.removeIf(wt -> l == wt.getListener());
    }

    @Override
    public void cancelThrottleRequest(int address, ThrottleListener l) {
        boolean isLong = true;
        if (this.canBeShortAddress(address)) {
            isLong = false;
        }
        this.cancelThrottleRequest(address, isLong, l);
    }

    @Override
    public void responseThrottleDecision(int address, ThrottleListener l, ThrottleListener.DecisionType decision) {
        boolean isLong = true;
        if (this.canBeShortAddress(address)) {
            isLong = false;
        }
        this.responseThrottleDecision(address, isLong, l, decision);
    }

    @Override
    public void responseThrottleDecision(int address, boolean isLong, ThrottleListener l, ThrottleListener.DecisionType decision) {
        DccLocoAddress la = new DccLocoAddress(address, isLong);
        this.responseThrottleDecision(la, l, decision);
    }

    @Override
    public void responseThrottleDecision(LocoAddress address, ThrottleListener l, ThrottleListener.DecisionType decision) {
        log.debug("Received response from ThrottleListener, this method should be overridden by a hardware type");
    }

    public synchronized void failedThrottleRequest(LocoAddress address, String reason) {
        ArrayList<WaitingThrottle> a = this.throttleListeners.get(address);
        if (a == null) {
            log.warn("failedThrottleRequest with zero-length listeners: {}", (Object)address);
        } else {
            for (WaitingThrottle waitingThrottle : new ArrayList<WaitingThrottle>(a)) {
                ThrottleListener l = waitingThrottle.getListener();
                l.notifyFailedThrottleRequest(address, reason);
            }
        }
        this.throttleListeners.remove(address);
        ArrayList<WaitingThrottle> p = this.listenerOnly.get(address);
        if (p == null) {
            log.debug("failedThrottleRequest with zero-length PropertyChange listeners: {}", (Object)address);
        } else {
            for (WaitingThrottle waitingThrottle : p) {
                PropertyChangeListener l = waitingThrottle.getPropertyChangeListener();
                l.propertyChange(new PropertyChangeEvent(this, "attachFailed", address, null));
            }
        }
        this.listenerOnly.remove(address);
    }

    public synchronized void notifyThrottleKnown(DccThrottle throttle, LocoAddress addr) {
        log.debug("notifyThrottleKnown for {}", (Object)addr);
        Addresses ads = null;
        if (!this.addressThrottles.containsKey(addr)) {
            log.debug("Address {} doesn't already exists so will add", (Object)addr);
            ads = new Addresses(throttle);
            this.addressThrottles.put(addr, ads);
        } else {
            this.addressThrottles.get(addr).setThrottle(throttle);
        }
        ArrayList<WaitingThrottle> a = this.throttleListeners.get(addr);
        if (a == null) {
            log.debug("notifyThrottleKnown with zero-length listeners: {}", (Object)addr);
        } else {
            int i = 0;
            while (i < a.size()) {
                ThrottleListener l = a.get(i).getListener();
                log.debug("Notify listener {} of {}", (Object)(i + 1), (Object)a.size());
                l.notifyThrottleFound(throttle);
                this.addressThrottles.get(addr).incrementUse();
                this.addressThrottles.get(addr).addListener(l);
                if (ads != null && a.get(i).getRosterEntry() != null && throttle.getRosterEntry() == null) {
                    throttle.setRosterEntry(a.get(i).getRosterEntry());
                }
                this.updateNumUsers(addr, this.addressThrottles.get(addr).getUseCount());
                ++i;
            }
            this.throttleListeners.remove(addr);
        }
        ArrayList<WaitingThrottle> p = this.listenerOnly.get(addr);
        if (p == null) {
            log.debug("notifyThrottleKnown with zero-length propertyChangeListeners: {}", (Object)addr);
        } else {
            for (WaitingThrottle waitingThrottle : p) {
                PropertyChangeListener l = waitingThrottle.getPropertyChangeListener();
                log.debug("Notify propertyChangeListener");
                l.propertyChange(new PropertyChangeEvent(this, "throttleAssigned", null, addr));
                if (ads != null && waitingThrottle.getRosterEntry() != null && throttle.getRosterEntry() == null) {
                    throttle.setRosterEntry(waitingThrottle.getRosterEntry());
                }
                throttle.addPropertyChangeListener(l);
            }
            this.listenerOnly.remove(addr);
        }
    }

    protected void makeHardwareDecision(LocoAddress address, ThrottleListener.DecisionType question) {
        this.responseThrottleDecision(address, null, ThrottleListener.DecisionType.STEAL);
    }

    protected synchronized void notifyDecisionRequest(LocoAddress address, ThrottleListener.DecisionType question) {
        ArrayList<WaitingThrottle> a = this.throttleListeners.get(address);
        if (a == null) {
            log.debug("Cannot issue question. No throttle listeners registered for address {}", (Object)address.getNumber());
            return;
        }
        log.debug("{} listener(s) registered for address {}", (Object)a.size(), (Object)address.getNumber());
        int i = 0;
        while (i < a.size()) {
            if (a.get(i).canHandleDecisions()) {
                ThrottleListener l = a.get(i).getListener();
                log.debug("Notifying a throttle listener (address {}) of the steal share situation", (Object)address.getNumber());
                l.notifyDecisionRequired(address, question);
            } else {
                log.debug("Passing {} to hardware steal / share decision making", (Object)address.getNumber());
                this.makeHardwareDecision(address, question);
            }
            ++i;
        }
    }

    @Override
    public boolean hasDispatchFunction() {
        return true;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128);
    }

    @Override
    public boolean enablePrefSilentStealOption() {
        return false;
    }

    @Override
    public boolean enablePrefSilentShareOption() {
        return false;
    }

    @Override
    public synchronized void attachListener(LocoAddress la, PropertyChangeListener p) {
        if (this.addressThrottles.containsKey(la)) {
            this.addressThrottles.get(la).getThrottle().addPropertyChangeListener(p);
            p.propertyChange(new PropertyChangeEvent(this, "throttleAssigned", null, la));
        } else {
            if (!this.listenerOnly.containsKey(la)) {
                this.listenerOnly.put(la, new ArrayList());
            }
            ArrayList<WaitingThrottle> a = this.listenerOnly.get(la);
            a.add(new WaitingThrottle(p, null, false));
            if (!this.throttleListeners.containsKey(la) && a.size() == 1) {
                this.requestThrottleSetup(la, false);
            }
        }
    }

    @Override
    public synchronized void removeListener(LocoAddress la, PropertyChangeListener p) {
        if (this.addressThrottles.containsKey(la)) {
            this.addressThrottles.get(la).getThrottle().removePropertyChangeListener(p);
            p.propertyChange(new PropertyChangeEvent(this, "throttleRemoved", la, null));
            return;
        }
        p.propertyChange(new PropertyChangeEvent(this, "throttleNotFoundInRemoval", la, null));
    }

    @Override
    public synchronized boolean addressStillRequired(LocoAddress la) {
        if (this.addressThrottles.containsKey(la)) {
            log.debug("usage count is {}", (Object)this.addressThrottles.get(la).getUseCount());
            return this.addressThrottles.get(la).getUseCount() > 0;
        }
        return false;
    }

    @Override
    public boolean addressStillRequired(int address, boolean isLongAddress) {
        DccLocoAddress la = new DccLocoAddress(address, isLongAddress);
        return this.addressStillRequired(la);
    }

    @Override
    public boolean addressStillRequired(int address) {
        boolean isLong = true;
        if (this.canBeShortAddress(address)) {
            isLong = false;
        }
        return this.addressStillRequired(address, isLong);
    }

    @Override
    public boolean addressStillRequired(BasicRosterEntry re) {
        return this.addressStillRequired(re.getDccLocoAddress());
    }

    @Override
    public void releaseThrottle(DccThrottle t, ThrottleListener l) {
        log.debug("AbstractThrottleManager.releaseThrottle: {}, {}", (Object)t, (Object)l);
        this.disposeThrottle(t, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        log.debug("AbstractThrottleManager.disposeThrottle: {}, {}", (Object)t, (Object)l);
        LocoAddress la = t.getLocoAddress();
        if (this.addressReleased(la, l)) {
            log.debug("Address {} still has active users", (Object)t.getLocoAddress());
            return false;
        }
        if (t.getPropertyChangeListeners().length > 0) {
            log.debug("Throttle {} still has {} active propertyChangeListeners registered to the throttle", (Object)t.getLocoAddress(), (Object)t.getPropertyChangeListeners().length);
            return false;
        }
        AbstractThrottleManager abstractThrottleManager = this;
        synchronized (abstractThrottleManager) {
            if (this.addressThrottles.containsKey(la)) {
                this.addressThrottles.remove(la);
                log.debug("Loco Address {} removed from the stack ", (Object)la);
            } else {
                log.debug("Loco Address {} not found in the stack ", (Object)la);
            }
        }
        return true;
    }

    protected void forceDisposeThrottle(LocoAddress la) {
        log.debug("force dispose address {}", (Object)la);
        if (this.addressThrottles.containsKey(la)) {
            this.addressThrottles.remove(la);
            log.debug("Loco Address {} removed from the stack ", (Object)la);
        } else {
            log.debug("Loco Address {} not found in the stack ", (Object)la);
        }
    }

    @Override
    public void dispatchThrottle(DccThrottle t, ThrottleListener l) {
        this.releaseThrottle(t, l);
    }

    @Override
    public void dispose() {
    }

    @Override
    public synchronized int getThrottleUsageCount(LocoAddress la) {
        if (this.addressThrottles.containsKey(la)) {
            return this.addressThrottles.get(la).getUseCount();
        }
        return 0;
    }

    @Override
    public int getThrottleUsageCount(int address, boolean isLongAddress) {
        DccLocoAddress la = new DccLocoAddress(address, isLongAddress);
        return this.getThrottleUsageCount(la);
    }

    @Override
    public int getThrottleUsageCount(int address) {
        boolean isLong = true;
        if (this.canBeShortAddress(address)) {
            isLong = false;
        }
        return this.getThrottleUsageCount(address, isLong);
    }

    @Override
    public int getThrottleUsageCount(BasicRosterEntry re) {
        return this.getThrottleUsageCount(re.getDccLocoAddress());
    }

    protected synchronized boolean addressReleased(LocoAddress la, ThrottleListener l) {
        if (this.addressThrottles.containsKey(la)) {
            if (this.addressThrottles.get(la).containsListener(l)) {
                log.debug("decrementUse called with listener {}", (Object)l);
                this.addressThrottles.get(la).decrementUse();
                this.addressThrottles.get(la).removeListener(l);
            } else if (l == null) {
                log.debug("decrementUse called withOUT listener");
                this.addressThrottles.get(la).decrementUse();
            }
        }
        if (this.addressThrottles.containsKey(la) && this.addressThrottles.get(la).getUseCount() > 0) {
            this.updateNumUsers(la, this.addressThrottles.get(la).getUseCount());
            log.debug("addressReleased still has at least one listener");
            return true;
        }
        return false;
    }

    protected void updateNumUsers(LocoAddress la, int numUsers) {
        log.debug("Throttle {} now has {} users", (Object)la, (Object)numUsers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getThrottleInfo(LocoAddress la, String item) {
        DccThrottle t;
        Object object = this;
        synchronized (object) {
            if (!this.addressThrottles.containsKey(la)) {
                return null;
            }
            t = this.addressThrottles.get(la).getThrottle();
        }
        if (item.equals("IsForward")) {
            return t.getIsForward();
        }
        if (item.startsWith("Speed")) {
            switch (item) {
                case "SpeedSetting": {
                    return Float.valueOf(t.getSpeedSetting());
                }
                case "SpeedIncrement": {
                    return Float.valueOf(t.getSpeedIncrement());
                }
                case "SpeedStepsMode": {
                    return t.getSpeedStepMode();
                }
            }
        }
        int i = 0;
        while (i < t.getFunctions().length) {
            if (item.equals(Throttle.getFunctionString(i))) {
                return t.getFunction(i);
            }
            ++i;
        }
        return null;
    }

    protected void showSessionCancelDialogue(LocoAddress address) {
        if (!GraphicsEnvironment.isHeadless() && !this._hideStealNotifications) {
            ThreadingUtil.runOnGUI(() -> {
                JCheckBox checkbox = new JCheckBox(Bundle.getMessage("HideFurtherAlerts"));
                Object[] params = new Object[]{Bundle.getMessage("LocoStolen", address), checkbox};
                JOptionPane pane = new JOptionPane(params);
                pane.setMessageType(2);
                JDialog dialog = pane.createDialog(null, Bundle.getMessage("LocoStolen", address));
                dialog.setModal(false);
                dialog.setVisible(true);
                dialog.requestFocus();
                dialog.toFront();
                ActionListener stolenpopupcheckbox = evt -> this.hideStealNotifications(checkbox.isSelected());
                checkbox.addActionListener(stolenpopupcheckbox);
            });
        }
    }

    public void hideStealNotifications(boolean hide) {
        this._hideStealNotifications = hide;
    }

    protected static class Addresses {
        int useActiveCount = 0;
        DccThrottle throttle;
        ArrayList<ThrottleListener> listeners = new ArrayList();
        BasicRosterEntry re = null;

        protected Addresses(DccThrottle throttle) {
            this.throttle = throttle;
        }

        void incrementUse() {
            ++this.useActiveCount;
            log.debug("{} increased Use Size to {}", (Object)this.throttle.getLocoAddress(), (Object)this.useActiveCount);
        }

        void decrementUse() {
            if (this.useActiveCount > 0) {
                --this.useActiveCount;
            }
            log.debug("{} decreased Use Size to {}", (Object)this.throttle.getLocoAddress(), (Object)this.useActiveCount);
        }

        int getUseCount() {
            return this.useActiveCount;
        }

        DccThrottle getThrottle() {
            return this.throttle;
        }

        void setThrottle(DccThrottle throttle) {
            DccThrottle old = this.throttle;
            this.throttle = throttle;
            if (old == null || old == throttle) {
                return;
            }
            log.debug("Throttle assigned {} has been changed, need to notify throttle users", (Object)throttle.getLocoAddress());
            this.throttle = throttle;
            for (ThrottleListener listener : this.listeners) {
                listener.notifyThrottleFound(throttle);
            }
            LocoAddress la = this.throttle.getLocoAddress();
            PropertyChangeEvent e = new PropertyChangeEvent(this, "throttleAssignmentChanged", null, la);
            PropertyChangeListener[] propertyChangeListenerArray = old.getPropertyChangeListeners();
            int n = propertyChangeListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyChangeListener prop = propertyChangeListenerArray[n2];
                this.throttle.addPropertyChangeListener(prop);
                prop.propertyChange(e);
                ++n2;
            }
        }

        void setRosterEntry(BasicRosterEntry _re) {
            this.re = _re;
        }

        BasicRosterEntry getRosterEntry() {
            return this.re;
        }

        void addListener(ThrottleListener l) {
            if (this.listeners.contains(l)) {
                log.debug("this Addresses listeners already includes listener {}", (Object)l);
            } else {
                this.listeners.add(l);
            }
        }

        void removeListener(ThrottleListener l) {
            this.listeners.remove(l);
        }

        boolean containsListener(ThrottleListener l) {
            return this.listeners.contains(l);
        }
    }

    static class WaitingThrottle {
        ThrottleListener l;
        BasicRosterEntry re;
        PropertyChangeListener pl;
        boolean canHandleDecisions;

        WaitingThrottle(ThrottleListener _l, BasicRosterEntry _re, boolean _canHandleDecisions) {
            this.l = _l;
            this.re = _re;
            this.canHandleDecisions = _canHandleDecisions;
        }

        WaitingThrottle(PropertyChangeListener _pl, BasicRosterEntry _re, boolean _canHandleDecisions) {
            this.pl = _pl;
            this.re = _re;
            this.canHandleDecisions = _canHandleDecisions;
        }

        PropertyChangeListener getPropertyChangeListener() {
            return this.pl;
        }

        ThrottleListener getListener() {
            return this.l;
        }

        BasicRosterEntry getRosterEntry() {
            return this.re;
        }

        boolean canHandleDecisions() {
            return this.canHandleDecisions;
        }
    }
}

