/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import jmri.BasicRosterEntry;
import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.NmraPacket;
import jmri.SpeedStepMode;
import jmri.SystemConnectionMemo;
import jmri.Throttle;
import jmri.ThrottleListener;
import jmri.beans.PropertyChangeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThrottle
extends PropertyChangeSupport
implements DccThrottle {
    @GuardedBy(value="this")
    protected float speedSetting;
    protected SpeedStepMode speedStepMode = SpeedStepMode.UNKNOWN;
    protected boolean isForward;
    private final boolean[] FUNCTION_BOOLEAN_ARRAY;
    private final boolean[] FUNCTION_MOMENTARY_BOOLEAN_ARRAY;
    protected boolean active = true;
    protected SystemConnectionMemo adapterMemo;
    private Boolean _dispatchEnabled = null;
    private Boolean _releaseEnabled = null;
    long durationRunning = 0L;
    protected long start;
    @GuardedBy(value="this")
    BasicRosterEntry re = null;
    private static final Logger log = LoggerFactory.getLogger(AbstractThrottle.class);

    public AbstractThrottle(SystemConnectionMemo memo) {
        this.adapterMemo = memo;
        this.FUNCTION_BOOLEAN_ARRAY = new boolean[29];
        this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY = new boolean[29];
    }

    public AbstractThrottle(SystemConnectionMemo memo, int totalFunctions) {
        this.adapterMemo = memo;
        this.FUNCTION_BOOLEAN_ARRAY = new boolean[totalFunctions];
        this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY = new boolean[totalFunctions];
    }

    @Override
    public synchronized float getSpeedSetting() {
        return this.speedSetting;
    }

    @Override
    public void setSpeedSetting(float speed) {
        this.setSpeedSetting(speed, false, false);
        this.record(speed);
    }

    @Override
    public synchronized void setSpeedSetting(float speed, boolean allowDuplicates, boolean allowDuplicatesOnStop) {
        if ((double)Math.abs(this.speedSetting - speed) > 1.0E-4) {
            this.speedSetting = speed;
            this.firePropertyChange("SpeedSetting", Float.valueOf(this.speedSetting), Float.valueOf(this.speedSetting));
        }
        this.record(speed);
    }

    @Override
    public void setSpeedSettingAgain(float speed) {
        this.setSpeedSetting(speed, true, true);
    }

    @Override
    public boolean getIsForward() {
        return this.isForward;
    }

    @Override
    public void setIsForward(boolean forward) {
        this.isForward = forward;
        this.firePropertyChange("IsForward", this.isForward, this.isForward);
    }

    @Override
    @Nonnull
    public boolean[] getFunctions() {
        return Arrays.copyOf(this.FUNCTION_BOOLEAN_ARRAY, this.FUNCTION_BOOLEAN_ARRAY.length);
    }

    @Override
    @Nonnull
    public boolean[] getFunctionsMomentary() {
        return Arrays.copyOf(this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY, this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY.length);
    }

    @Override
    public boolean getFunction(int fN) {
        if (fN < 0 || fN > this.FUNCTION_BOOLEAN_ARRAY.length - 1) {
            log.warn("Unhandled get function: {}", (Object)fN);
            return false;
        }
        return this.FUNCTION_BOOLEAN_ARRAY[fN];
    }

    @Override
    public boolean getFunctionMomentary(int fN) {
        if (fN < 0 || fN > this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY.length - 1) {
            log.warn("Unhandled get momentary function: {}", (Object)fN);
            return false;
        }
        return this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY[fN];
    }

    protected void notifyThrottleDisconnect() {
        this.firePropertyChange("ThrottleConnected", true, false);
    }

    @Override
    public void notifyThrottleDispatchEnabled(boolean newVal) {
        this._dispatchEnabled = newVal;
        this.firePropertyChange("DispatchEnabled", this._dispatchEnabled, this._dispatchEnabled);
    }

    @Override
    public void notifyThrottleReleaseEnabled(boolean newVal) {
        this._releaseEnabled = newVal;
        this.firePropertyChange("ReleaseEnabled", this._releaseEnabled, this._releaseEnabled);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (Arrays.asList(this.getPropertyChangeListeners()).contains(l)) {
            log.warn("Preventing {} adding duplicate PCL", (Object)l);
            return;
        }
        super.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        log.debug("Removing property change {}", (Object)l);
        super.removePropertyChangeListener(l);
        log.debug("remove listeners size is {}", (Object)this.getPropertyChangeListeners().length);
        if (this.getPropertyChangeListeners().length == 0) {
            log.debug("No listeners so calling ThrottleManager.dispose with an empty ThrottleListener");
            InstanceManager.throttleManagerInstance().disposeThrottle(this, new ThrottleListener(){

                @Override
                public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
                }

                @Override
                public void notifyThrottleFound(DccThrottle t) {
                }

                @Override
                public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
                }
            });
        }
    }

    @Deprecated
    protected void notifyPropertyChangeListener(String property, Object oldValue, Object newValue) {
        this.firePropertyChange(property, oldValue, newValue);
    }

    @Override
    @Deprecated
    public List<PropertyChangeListener> getListeners() {
        return Arrays.asList(this.getPropertyChangeListeners());
    }

    @Override
    public void dispose(ThrottleListener l) {
        if (!this.active) {
            log.error("Dispose called when not active");
        }
        InstanceManager.throttleManagerInstance().disposeThrottle(this, l);
    }

    @Override
    public void dispatch(ThrottleListener l) {
        if (!this.active) {
            log.warn("dispatch called when not active");
        }
        InstanceManager.throttleManagerInstance().dispatchThrottle(this, l);
    }

    @Override
    public void release(ThrottleListener l) {
        if (!this.active) {
            log.warn("release called when not active");
        }
        InstanceManager.throttleManagerInstance().releaseThrottle(this, l);
    }

    protected abstract void throttleDispose();

    @Override
    public float getSpeedIncrement() {
        return this.speedStepMode.increment;
    }

    protected void sendFunctionGroup(int functionNum, boolean momentary) {
        switch (FUNCTION_GROUPS[functionNum]) {
            case 1: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup1();
                    break;
                }
                this.sendFunctionGroup1();
                break;
            }
            case 2: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup2();
                    break;
                }
                this.sendFunctionGroup2();
                break;
            }
            case 3: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup3();
                    break;
                }
                this.sendFunctionGroup3();
                break;
            }
            case 4: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup4();
                    break;
                }
                this.sendFunctionGroup4();
                break;
            }
            case 5: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup5();
                    break;
                }
                this.sendFunctionGroup5();
                break;
            }
        }
    }

    @Override
    public void setFunction(int functionNum, boolean newState) {
        if (functionNum < 0 || functionNum > this.FUNCTION_BOOLEAN_ARRAY.length - 1) {
            log.warn("Unhandled set function number: {} {}", (Object)functionNum, (Object)this.getClass().getName());
            return;
        }
        boolean old = this.FUNCTION_BOOLEAN_ARRAY[functionNum];
        this.FUNCTION_BOOLEAN_ARRAY[functionNum] = newState;
        this.sendFunctionGroup(functionNum, false);
        this.firePropertyChange(Throttle.getFunctionString(functionNum), old, newState);
    }

    public void updateFunction(int fn, boolean state) {
        if (fn < 0 || fn > this.FUNCTION_BOOLEAN_ARRAY.length - 1) {
            log.warn("Unhandled update function number: {} {}", (Object)fn, (Object)this.getClass().getName());
            return;
        }
        boolean old = this.FUNCTION_BOOLEAN_ARRAY[fn];
        this.FUNCTION_BOOLEAN_ARRAY[fn] = state;
        this.firePropertyChange(Throttle.getFunctionString(fn), old, state);
    }

    public void updateFunctionMomentary(int fn, boolean state) {
        if (fn < 0 || fn > this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY.length - 1) {
            log.warn("Unhandled update momentary function number: {}", (Object)fn);
            return;
        }
        boolean old = this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY[fn];
        this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY[fn] = state;
        this.firePropertyChange(Throttle.getFunctionMomentaryString(fn), old, state);
    }

    protected void sendFunctionGroup1() {
        log.error("sendFunctionGroup1 needs to be implemented if invoked");
    }

    protected void sendFunctionGroup2() {
        log.error("sendFunctionGroup2 needs to be implemented if invoked");
    }

    protected void sendFunctionGroup3() {
        log.error("sendFunctionGroup3 needs to be implemented if invoked");
    }

    protected void sendFunctionGroup4() {
        DccLocoAddress a = (DccLocoAddress)this.getLocoAddress();
        byte[] result = NmraPacket.function13Through20Packet(a.getNumber(), a.isLongAddress(), this.getF13(), this.getF14(), this.getF15(), this.getF16(), this.getF17(), this.getF18(), this.getF19(), this.getF20());
        if (result == null) {
            return;
        }
        CommandStation c = this.adapterMemo != null && this.adapterMemo.get(CommandStation.class) != null ? (CommandStation)this.adapterMemo.get(CommandStation.class) : InstanceManager.getNullableDefault(CommandStation.class);
        if (c != null) {
            c.sendPacket(result, 3);
        } else {
            log.error("Can't send F13-F20 since no command station defined");
        }
    }

    protected void sendFunctionGroup5() {
        DccLocoAddress a = (DccLocoAddress)this.getLocoAddress();
        byte[] result = NmraPacket.function21Through28Packet(a.getNumber(), a.isLongAddress(), this.getF21(), this.getF22(), this.getF23(), this.getF24(), this.getF25(), this.getF26(), this.getF27(), this.getF28());
        if (result == null) {
            return;
        }
        CommandStation c = this.adapterMemo != null && this.adapterMemo.get(CommandStation.class) != null ? (CommandStation)this.adapterMemo.get(CommandStation.class) : InstanceManager.getNullableDefault(CommandStation.class);
        if (c != null) {
            c.sendPacket(result, 3);
        } else {
            log.error("Can't send F21-F28 since no command station defined");
        }
    }

    @Override
    public void setFunctionMomentary(int momFuncNum, boolean state) {
        if (momFuncNum < 0 || momFuncNum > this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY.length - 1) {
            log.warn("Unhandled set momentary function number: {}", (Object)momFuncNum);
            return;
        }
        boolean old = this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY[momFuncNum];
        this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY[momFuncNum] = state;
        this.sendFunctionGroup(momFuncNum, true);
        this.firePropertyChange(Throttle.getFunctionMomentaryString(momFuncNum), old, state);
    }

    protected void sendMomentaryFunctionGroup1() {
    }

    protected void sendMomentaryFunctionGroup2() {
    }

    protected void sendMomentaryFunctionGroup3() {
    }

    protected void sendMomentaryFunctionGroup4() {
    }

    protected void sendMomentaryFunctionGroup5() {
    }

    @Override
    public void setSpeedStepMode(SpeedStepMode mode) {
        log.debug("Speed Step Mode Change from:{} to:{}", (Object)this.speedStepMode, (Object)mode);
        this.speedStepMode = mode;
        this.firePropertyChange("SpeedSteps", (Object)this.speedStepMode, (Object)this.speedStepMode);
    }

    @Override
    public SpeedStepMode getSpeedStepMode() {
        return this.speedStepMode;
    }

    protected synchronized void record(float speed) {
        if (this.re == null) {
            return;
        }
        if (speed == 0.0f) {
            this.stopClock();
        } else {
            this.startClock();
        }
    }

    protected synchronized void startClock() {
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        }
    }

    void stopClock() {
        if (this.start == 0L) {
            return;
        }
        long stop = System.currentTimeMillis();
        this.durationRunning += (stop - this.start) / 1000L;
        this.start = 0L;
    }

    protected synchronized void finishRecord() {
        if (this.re == null) {
            return;
        }
        this.stopClock();
        String currentDurationString = this.re.getAttribute("OperatingDuration");
        long currentDuration = 0L;
        if (currentDurationString == null) {
            currentDurationString = "0";
            log.info("operating duration for {} starts as zero", (Object)this.getLocoAddress());
        }
        try {
            currentDuration = Long.parseLong(currentDurationString);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("current stored duration is not a valid number \"{} \"", (Object)currentDurationString);
        }
        this.re.putAttribute("OperatingDuration", "" + (currentDuration += this.durationRunning));
        this.re.putAttribute("LastOperated", new StdDateFormat().format(new Date()));
        if (!this.re.isOpen()) {
            this.re.store();
        } else {
            log.warn("Roster Entry {} running time not saved as entry is already open for editing", (Object)this.re.getId());
        }
        this.re = null;
    }

    @Override
    public synchronized void setRosterEntry(BasicRosterEntry re) {
        this.re = re;
    }

    @Override
    public synchronized BasicRosterEntry getRosterEntry() {
        return this.re;
    }

    protected int intSpeed(float speed) {
        return AbstractThrottle.intSpeed(speed, 127);
    }

    protected static int intSpeed(float speed, int steps) {
        if (speed < 0.0f) {
            return 1;
        }
        int value = Math.round(speed *= (float)(steps - 1));
        if (speed > 0.0f && speed <= 0.5f) {
            value = 1;
        }
        if (value < 0) {
            Exception ex = new Exception("Error calculating speed. Please send logs to the JMRI developers.");
            log.error(ex.getMessage(), (Throwable)ex);
            return 1;
        }
        if (value >= steps) {
            return steps;
        }
        if (value > 0) {
            return value + 1;
        }
        return 0;
    }
}

