/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import java.util.Vector;
import jmri.SystemConnectionMemo;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.Bundle;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.SerialPortAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;
import purejavacomm.UnsupportedCommOperationException;

public abstract class AbstractSerialPortController
extends AbstractPortController
implements SerialPortAdapter {
    protected String mPort = null;
    protected String mBaudRate = null;
    Vector<String> portNameVector = null;
    private static final Logger log = LoggerFactory.getLogger(AbstractSerialPortController.class);

    protected AbstractSerialPortController(SystemConnectionMemo connectionMemo) {
        super(connectionMemo);
    }

    @Override
    public String handlePortBusy(PortInUseException p, String portName, Logger log) {
        log.error("{} port is in use: {}", (Object)portName, (Object)p.getMessage());
        ConnectionStatus.instance().setConnectionState(this.getSystemPrefix(), portName, "Not Connected");
        return Bundle.getMessage("SerialPortInUse", portName);
    }

    public String handlePortNotFound(NoSuchPortException p, String portName, Logger log) {
        log.error("Serial port {} not found", (Object)portName);
        ConnectionStatus.instance().setConnectionState(this.getSystemPrefix(), portName, "Not Connected");
        return Bundle.getMessage("SerialPortNotFound", portName);
    }

    @Override
    public void connect() throws IOException {
        this.openPort(this.mPort, "JMRI app");
    }

    @Override
    public void setPort(String port) {
        log.debug("Setting port to {}", (Object)port);
        this.mPort = port;
    }

    @Override
    public String getCurrentPortName() {
        if (this.mPort == null) {
            if (this.getPortNames() == null) {
                log.error("Port names returned as null");
                return null;
            }
            if (this.getPortNames().size() <= 0) {
                log.error("No usable ports returned");
                return null;
            }
            return null;
        }
        return this.mPort;
    }

    protected void configureLeadsAndFlowControl(SerialPort serialPort, int flow, boolean rts, boolean dtr) {
        serialPort.setRTS(rts);
        serialPort.setDTR(dtr);
        try {
            if (flow != 0) {
                serialPort.setFlowControlMode(flow);
            }
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            log.warn("Could not set flow control, ignoring");
        }
        if (flow != 2) {
            serialPort.setRTS(rts);
        }
        serialPort.setDTR(dtr);
    }

    protected void configureLeadsAndFlowControl(SerialPort serialPort, int flow) {
        this.configureLeadsAndFlowControl(serialPort, flow, true, true);
    }

    @Override
    public void configureBaudRate(String rate) {
        this.mBaudRate = rate;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void configureBaudRateFromNumber(String indexString) {
        block14: {
            index = 0;
            rates = this.validBaudRates();
            numbers = this.validBaudNumbers();
            if (numbers == null || numbers.length == 0) {
                this.mBaudRate = null;
                AbstractSerialPortController.log.debug("no serial port speed values received (OK for simulator)");
                return;
            }
            if (numbers.length != rates.length) {
                this.mBaudRate = null;
                AbstractSerialPortController.log.error("arrays wrong length in currentBaudNumber: {}, {}", (Object)numbers.length, (Object)rates.length);
                return;
            }
            if (indexString.isEmpty()) {
                this.mBaudRate = null;
                AbstractSerialPortController.log.debug("empty baud rate received");
                return;
            }
            try {
                baudNum = Integer.parseInt(indexString);
                AbstractSerialPortController.log.debug("new profile format port speed value");
                break block14;
            }
            catch (NumberFormatException v0) {
                AbstractSerialPortController.log.warn("old profile format port speed value converted");
                baudNumber = new StringBuilder();
                digitSeen = false;
                n = 0;
                ** while (n < indexString.length())
            }
lbl-1000:
            // 1 sources

            {
                if (Character.isDigit(indexString.charAt(n))) {
                    digitSeen = true;
                    baudNumber.append(indexString.charAt(n));
                } else if (indexString.charAt(n) == ' ' && digitSeen) break;
                ++n;
                continue;
            }
lbl34:
            // 2 sources

            if (baudNumber.toString().equals("")) {
                baudNum = 0;
            } else {
                try {
                    baudNum = Integer.parseInt(baudNumber.toString());
                }
                catch (NumberFormatException v1) {
                    this.mBaudRate = null;
                    AbstractSerialPortController.log.error("error in filtering old profile format port speed value");
                    return;
                }
                AbstractSerialPortController.log.debug("old format baud number: {}", (Object)indexString);
            }
        }
        i = 0;
        while (i < numbers.length) {
            if (numbers[i] == baudNum) {
                index = i;
                AbstractSerialPortController.log.debug("found new format baud value at index {}", (Object)i);
                break;
            }
            ++i;
        }
        this.mBaudRate = this.validBaudRates()[index];
        AbstractSerialPortController.log.debug("mBaudRate set to: {}", (Object)this.mBaudRate);
    }

    @Override
    public void configureBaudRateFromIndex(int index) {
        if (this.validBaudRates().length > index) {
            this.mBaudRate = this.validBaudRates()[index];
            log.debug("mBaudRate set by index to: {}", (Object)this.mBaudRate);
        } else {
            log.debug("no baud rates in array");
        }
    }

    @Override
    public int defaultBaudIndex() {
        return -1;
    }

    @Override
    public String getCurrentBaudRate() {
        if (this.mBaudRate == null) {
            return "";
        }
        return this.mBaudRate;
    }

    @Override
    public String getCurrentBaudNumber() {
        int[] numbers = this.validBaudNumbers();
        String[] rates = this.validBaudRates();
        if (numbers == null || rates == null || numbers.length != rates.length) {
            return "";
        }
        String baudNumString = "";
        if (this.mBaudRate != null) {
            int i = 0;
            while (i < numbers.length) {
                if (rates[i].equals(this.mBaudRate)) {
                    baudNumString = Integer.toString(numbers[i]);
                    break;
                }
                ++i;
            }
        } else if (this.defaultBaudIndex() > -1) {
            baudNumString = Integer.toString(numbers[this.defaultBaudIndex()]);
            log.debug("using default port speed {}", (Object)baudNumString);
        }
        log.debug("mBaudRate = {}, matched to string {}", (Object)this.mBaudRate, (Object)baudNumString);
        return baudNumString;
    }

    @Override
    public int getCurrentBaudIndex() {
        if (this.mBaudRate != null) {
            String[] rates = this.validBaudRates();
            int i = 0;
            while (i < rates.length) {
                if (rates[i].equals(this.mBaudRate)) {
                    return i;
                }
                ++i;
            }
        }
        return this.defaultBaudIndex();
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="null signals incorrect implementation of portcontroller")
    public String[] validBaudRates() {
        log.error("default validBaudRates implementation should not be used", (Throwable)new Exception());
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="null signals incorrect implementation of portcontroller")
    public int[] validBaudNumbers() {
        log.error("default validBaudNumbers implementation should not be used", (Throwable)new Exception());
        return null;
    }

    public int currentBaudNumber(String currentBaudRate) {
        String[] rates = this.validBaudRates();
        int[] numbers = this.validBaudNumbers();
        if (numbers == null) {
            log.error("numbers array null in currentBaudNumber()");
            return -1;
        }
        if (rates == null) {
            log.error("rates array null in currentBaudNumber()");
            return -1;
        }
        if (numbers.length != rates.length) {
            log.error("arrays are of different length in currentBaudNumber: {} vs {}", (Object)numbers.length, (Object)rates.length);
            return -1;
        }
        if (numbers.length < 1) {
            log.warn("baudrate is not supported by adapter");
            return 0;
        }
        int i = 0;
        while (i < numbers.length) {
            if (rates[i].equals(currentBaudRate)) {
                return numbers[i];
            }
            ++i;
        }
        log.error("no match to ({}) in currentBaudNumber", (Object)currentBaudRate);
        return -1;
    }

    protected void setPortEventLogging(SerialPort port) {
        try {
            port.addEventListener(new SerialPortEventListener(){

                @Override
                public void serialEvent(SerialPortEvent e) {
                    int type = e.getEventType();
                    switch (type) {
                        case 1: {
                            log.info("SerialEvent: DATA_AVAILABLE is {}", (Object)e.getNewValue());
                            return;
                        }
                        case 2: {
                            log.info("SerialEvent: OUTPUT_BUFFER_EMPTY is {}", (Object)e.getNewValue());
                            return;
                        }
                        case 3: {
                            log.info("SerialEvent: CTS is {}", (Object)e.getNewValue());
                            return;
                        }
                        case 4: {
                            log.info("SerialEvent: DSR is {}", (Object)e.getNewValue());
                            return;
                        }
                        case 5: {
                            log.info("SerialEvent: RI is {}", (Object)e.getNewValue());
                            return;
                        }
                        case 6: {
                            log.info("SerialEvent: CD is {}", (Object)e.getNewValue());
                            return;
                        }
                        case 7: {
                            log.info("SerialEvent: OE (overrun error) is {}", (Object)e.getNewValue());
                            return;
                        }
                        case 8: {
                            log.info("SerialEvent: PE (parity error) is {}", (Object)e.getNewValue());
                            return;
                        }
                        case 9: {
                            log.info("SerialEvent: FE (framing error) is {}", (Object)e.getNewValue());
                            return;
                        }
                        case 10: {
                            log.info("SerialEvent: BI (break interrupt) is {}", (Object)e.getNewValue());
                            return;
                        }
                    }
                    log.info("SerialEvent of unknown type: {} value: {}", (Object)type, (Object)e.getNewValue());
                }
            });
        }
        catch (TooManyListenersException tooManyListenersException) {
            log.warn("cannot set listener for SerialPortEvents; was one already set?");
        }
        try {
            port.notifyOnFramingError(true);
        }
        catch (Exception e) {
            log.debug("Could not notifyOnFramingError: {}", (Throwable)e);
        }
        try {
            port.notifyOnBreakInterrupt(true);
        }
        catch (Exception e) {
            log.debug("Could not notifyOnBreakInterrupt: {}", (Throwable)e);
        }
        try {
            port.notifyOnParityError(true);
        }
        catch (Exception e) {
            log.debug("Could not notifyOnParityError: {}", (Throwable)e);
        }
        try {
            port.notifyOnOverrunError(true);
        }
        catch (Exception e) {
            log.debug("Could not notifyOnOverrunError: {}", (Throwable)e);
        }
        port.notifyOnCarrierDetect(true);
        port.notifyOnCTS(true);
        port.notifyOnDSR(true);
    }

    @Override
    public Vector<String> getPortNames() {
        this.portNameVector = new Vector();
        Enumeration<CommPortIdentifier> portIDs = CommPortIdentifier.getPortIdentifiers();
        while (portIDs.hasMoreElements()) {
            CommPortIdentifier id = portIDs.nextElement();
            if (id.getPortType() == 2) continue;
            this.portNameVector.addElement(id.getName());
        }
        return this.portNameVector;
    }

    @Override
    protected void closeConnection() {
    }

    @Override
    protected void resetupConnection() {
    }

    @Override
    protected void reconnectFromLoop(int retryNum) {
        try {
            log.info("Retrying Connection attempt {} for {}", (Object)retryNum, (Object)this.mPort);
            Enumeration<CommPortIdentifier> portIDs = CommPortIdentifier.getPortIdentifiers();
            while (portIDs.hasMoreElements()) {
                CommPortIdentifier id = portIDs.nextElement();
                if (id.getPortType() == 2 || !id.getName().equals(this.mPort)) continue;
                log.info(Bundle.getMessage("ReconnectPortReAppear", this.mPort));
                this.openPort(this.mPort, "jmri");
            }
            if (retryNum % 10 == 0) {
                log.info(Bundle.getMessage("ReconnectSerialTip"));
            }
        }
        catch (RuntimeException runtimeException) {
            log.warn(Bundle.getMessage("ReconnectFail", this.mPort == null ? "null" : this.mPort));
        }
    }
}

