/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.SystemConnectionMemo;
import jmri.jmrix.Bundle;
import jmri.jmrix.PortAdapter;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPortController
implements PortAdapter {
    protected String manufacturerName = null;
    private SystemConnectionMemo connectionMemo;
    protected boolean opened = false;
    protected String option1Name = "1";
    protected String option2Name = "2";
    protected String option3Name = "3";
    protected String option4Name = "4";
    protected HashMap<String, Option> options = new HashMap();
    protected boolean allowConnectionRecovery = false;
    protected int reconnectinterval = 1;
    protected int reconnectMaxAttempts = 100;
    protected int reconnectMaxInterval = 120;
    private static final Logger log = LoggerFactory.getLogger(AbstractPortController.class);

    @Override
    public abstract DataInputStream getInputStream();

    @Override
    public abstract DataOutputStream getOutputStream();

    protected AbstractPortController(SystemConnectionMemo connectionMemo) {
        this.setSystemConnectionMemo(connectionMemo);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void dispose() {
        this.allowConnectionRecovery = false;
        this.getSystemConnectionMemo().dispose();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    protected void setOpened() {
        this.opened = true;
    }

    protected void setClosed() {
        this.opened = false;
    }

    @Override
    public abstract String getCurrentPortName();

    @Override
    public void configureOption1(String value) {
        if (this.options.containsKey(this.option1Name)) {
            this.options.get(this.option1Name).configure(value);
        }
    }

    @Override
    public void configureOption2(String value) {
        if (this.options.containsKey(this.option2Name)) {
            this.options.get(this.option2Name).configure(value);
        }
    }

    @Override
    public void configureOption3(String value) {
        if (this.options.containsKey(this.option3Name)) {
            this.options.get(this.option3Name).configure(value);
        }
    }

    @Override
    public void configureOption4(String value) {
        if (this.options.containsKey(this.option4Name)) {
            this.options.get(this.option4Name).configure(value);
        }
    }

    @Override
    public String getOption1Name() {
        return this.option1Name;
    }

    @Override
    public String getOption2Name() {
        return this.option2Name;
    }

    @Override
    public String getOption3Name() {
        return this.option3Name;
    }

    @Override
    public String getOption4Name() {
        return this.option4Name;
    }

    @Override
    public String[] getOptions() {
        Set<String> keySet = this.options.keySet();
        Object[] result = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(result);
        return result;
    }

    @Override
    public void setOptionState(String option, String value) {
        log.trace("setOptionState({},{})", (Object)option, (Object)value);
        if (this.options.containsKey(option)) {
            this.options.get(option).configure(value);
        } else {
            log.warn("Couldn't find option \"{}\", can't set to \"{}\"", (Object)option, (Object)value);
        }
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="availability was checked before, should never get here")
    public String getOptionState(String option) {
        if (this.options.containsKey(option)) {
            return this.options.get(option).getCurrent();
        }
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="availability was checked before, should never get here")
    public String[] getOptionChoices(String option) {
        if (this.options.containsKey(option)) {
            return this.options.get(option).getOptions();
        }
        return null;
    }

    @Override
    public boolean isOptionTypeText(String option) {
        if (this.options.containsKey(option)) {
            return this.options.get(option).getType() == Option.Type.TEXT;
        }
        log.error("did not find option {} for type", (Object)option);
        return false;
    }

    @Override
    public boolean isOptionTypePassword(String option) {
        if (this.options.containsKey(option)) {
            return this.options.get(option).getType() == Option.Type.PASSWORD;
        }
        log.error("did not find option {} for type", (Object)option);
        return false;
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="availability was checked before, should never get here")
    public String getOptionDisplayName(String option) {
        if (this.options.containsKey(option)) {
            return this.options.get(option).getDisplayText();
        }
        return null;
    }

    @Override
    public boolean isOptionAdvanced(String option) {
        if (this.options.containsKey(option)) {
            return this.options.get(option).isAdvanced();
        }
        return false;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturerName;
    }

    @Override
    public void setManufacturer(String manufacturer) {
        log.debug("update manufacturer from {} to {}", (Object)this.manufacturerName, (Object)manufacturer);
        this.manufacturerName = manufacturer;
    }

    @Override
    public boolean getDisabled() {
        return this.getSystemConnectionMemo().getDisabled();
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.getSystemConnectionMemo().setDisabled(disabled);
    }

    @Override
    public String getSystemPrefix() {
        return this.getSystemConnectionMemo().getSystemPrefix();
    }

    @Override
    public void setSystemPrefix(String systemPrefix) {
        if (!this.getSystemConnectionMemo().setSystemPrefix(systemPrefix)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String getUserName() {
        return this.getSystemConnectionMemo().getUserName();
    }

    @Override
    public void setUserName(String userName) {
        if (!this.getSystemConnectionMemo().setUserName(userName)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void recover() {
        if (!this.allowConnectionRecovery) {
            return;
        }
        this.opened = false;
        try {
            this.closeConnection();
        }
        catch (RuntimeException runtimeException) {
            log.warn("closeConnection failed");
        }
        this.reconnect();
    }

    protected void closeConnection() {
    }

    protected void reconnect() {
        if (this.opened || !this.allowConnectionRecovery) {
            return;
        }
        Thread thread = ThreadingUtil.newThread(new ReconnectWait(), "Connection Recovery " + this.getCurrentPortName());
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            log.error("Unable to join to the reconnection thread");
        }
    }

    protected void resetupConnection() {
    }

    protected void reconnectFromLoop(int retryNum) {
    }

    @Override
    public void setReconnectMaxInterval(int maxInterval) {
        this.reconnectMaxInterval = maxInterval;
    }

    @Override
    public void setReconnectMaxAttempts(int maxAttempts) {
        this.reconnectMaxAttempts = maxAttempts;
    }

    @Override
    public int getReconnectMaxInterval() {
        return this.reconnectMaxInterval;
    }

    @Override
    public int getReconnectMaxAttempts() {
        return this.reconnectMaxAttempts;
    }

    protected static void safeSleep(long milliseconds, String s) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            log.error("Sleep Exception raised during reconnection attempt{}", (Object)s);
        }
    }

    @Override
    public boolean isDirty() {
        boolean isDirty = this.getSystemConnectionMemo().isDirty();
        if (!isDirty) {
            for (Option option : this.options.values()) {
                isDirty = option.isDirty();
                if (isDirty) break;
            }
        }
        return isDirty;
    }

    @Override
    public boolean isRestartRequired() {
        return this.isDirty();
    }

    @SuppressFBWarnings(value={"SR_NOT_CHECKED"}, justification="skipping all, don't care what skip() returns")
    protected void purgeStream(@Nonnull InputStream serialStream) throws IOException {
        int count = serialStream.available();
        log.debug("input stream shows {} bytes available", (Object)count);
        while (count > 0) {
            serialStream.skip(count);
            count = serialStream.available();
        }
    }

    @Override
    public SystemConnectionMemo getSystemConnectionMemo() {
        return this.connectionMemo;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setSystemConnectionMemo(@Nonnull SystemConnectionMemo connectionMemo) {
        if (connectionMemo == null) {
            throw new NullPointerException();
        }
        this.connectionMemo = connectionMemo;
    }

    protected static class Option {
        String currentValue = null;
        String configuredValue = null;
        String displayText;
        String[] options;
        Type type;
        Boolean advancedOption = true;

        public Option(String displayText, @Nonnull String[] options, boolean advanced, Type type) {
            this.displayText = displayText;
            this.options = Arrays.copyOf(options, options.length);
            this.advancedOption = advanced;
            this.type = type;
        }

        public Option(String displayText, String[] options, boolean advanced) {
            this(displayText, options, advanced, Type.JCOMBOBOX);
        }

        public Option(String displayText, String[] options, Type type) {
            this(displayText, options, true, type);
        }

        public Option(String displayText, String[] options) {
            this(displayText, options, true, Type.JCOMBOBOX);
        }

        void configure(String value) {
            log.trace("Option.configure({}) with \"{}\", \"{}\"", new Object[]{value, this.configuredValue, this.currentValue});
            if (this.configuredValue == null) {
                this.configuredValue = value;
            }
            this.currentValue = value;
        }

        String getCurrent() {
            if (this.currentValue == null) {
                return this.options[0];
            }
            return this.currentValue;
        }

        String[] getOptions() {
            return this.options;
        }

        Type getType() {
            return this.type;
        }

        String getDisplayText() {
            return this.displayText;
        }

        boolean isAdvanced() {
            return this.advancedOption;
        }

        boolean isDirty() {
            return this.currentValue != null && !this.currentValue.equals(this.configuredValue);
        }

        public static enum Type {
            JCOMBOBOX,
            TEXT,
            PASSWORD;

        }
    }

    private class ReconnectWait
    extends Thread {
        private ReconnectWait() {
        }

        @Override
        public void run() {
            boolean reply = true;
            int count = 0;
            int interval = AbstractPortController.this.reconnectinterval;
            int totalsleep = 0;
            while (reply && AbstractPortController.this.allowConnectionRecovery) {
                AbstractPortController.safeSleep((long)interval * 1000L, "Waiting");
                totalsleep += interval;
                AbstractPortController.this.reconnectFromLoop(++count);
                boolean bl = reply = !AbstractPortController.this.opened;
                if (AbstractPortController.this.opened) {
                    log.info(Bundle.getMessage("ReconnectedTo", AbstractPortController.this.getCurrentPortName()));
                    AbstractPortController.this.resetupConnection();
                    return;
                }
                if (count % 10 == 0) {
                    interval = Math.min(interval * 2, AbstractPortController.this.reconnectMaxInterval);
                    log.error(Bundle.getMessage("ReconnectFailRetry", totalsleep, count, interval));
                }
                if (AbstractPortController.this.reconnectMaxAttempts <= -1 || count < AbstractPortController.this.reconnectMaxAttempts) continue;
                log.error(Bundle.getMessage("ReconnectFailAbort", totalsleep, count));
                reply = false;
            }
        }
    }
}

