/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.JTextComponent;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.AbstractConnectionConfig;
import jmri.jmrix.Bundle;
import jmri.jmrix.NetworkPortAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNetworkConnectionConfig
extends AbstractConnectionConfig {
    protected boolean init = false;
    UserPreferencesManager p = InstanceManager.getDefault(UserPreferencesManager.class);
    protected JTextField hostNameField = new JTextField(15);
    protected JLabel hostNameFieldLabel;
    protected JTextField portField = new JTextField(10);
    protected JLabel portFieldLabel;
    protected JCheckBox showAutoConfig = new JCheckBox(Bundle.getMessage("AutoConfigLabel"));
    protected JTextField adNameField = new JTextField(15);
    protected JLabel adNameFieldLabel;
    protected JTextField serviceTypeField = new JTextField(15);
    protected JLabel serviceTypeFieldLabel;
    protected SpinnerNumberModel intervalSpinner = new SpinnerNumberModel(250, 0, 10000, 1);
    protected JSpinner outputIntervalSpinner = new JSpinner(this.intervalSpinner);
    protected JLabel outputIntervalLabel;
    protected JButton outputIntervalReset = new JButton(Bundle.getMessage("ButtonReset"));
    protected NetworkPortAdapter adapter = null;
    private static final Logger log = LoggerFactory.getLogger(AbstractNetworkConnectionConfig.class);

    public AbstractNetworkConnectionConfig(NetworkPortAdapter p) {
        this.adapter = p;
    }

    public AbstractNetworkConnectionConfig() {
    }

    @Override
    protected void checkInitDone() {
        log.debug("init called for {}", (Object)this.name());
        if (this.init) {
            return;
        }
        this.hostNameField.addActionListener(e -> {
            this.adapter.setHostName(this.hostNameField.getText());
            this.p.setComboBoxLastSelection(String.valueOf(this.adapter.getClass().getName()) + ".hostname", this.hostNameField.getText());
        });
        this.hostNameField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                AbstractNetworkConnectionConfig.this.adapter.setHostName(AbstractNetworkConnectionConfig.this.hostNameField.getText());
                AbstractNetworkConnectionConfig.this.p.setComboBoxLastSelection(String.valueOf(AbstractNetworkConnectionConfig.this.adapter.getClass().getName()) + ".hostname", AbstractNetworkConnectionConfig.this.hostNameField.getText());
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.portField.addActionListener(e -> {
            try {
                this.adapter.setPort(Integer.parseInt(this.portField.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                log.warn("Could not parse port attribute");
            }
        });
        this.portField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                try {
                    AbstractNetworkConnectionConfig.this.adapter.setPort(Integer.parseInt(AbstractNetworkConnectionConfig.this.portField.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    log.warn("Could not parse port attribute");
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.adNameField.addActionListener(e -> this.adapter.setAdvertisementName(this.adNameField.getText()));
        this.adNameField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                AbstractNetworkConnectionConfig.this.adapter.setAdvertisementName(AbstractNetworkConnectionConfig.this.adNameField.getText());
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.serviceTypeField.addActionListener(e -> this.adapter.setServiceType(this.serviceTypeField.getText()));
        this.serviceTypeField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                AbstractNetworkConnectionConfig.this.adapter.setServiceType(AbstractNetworkConnectionConfig.this.serviceTypeField.getText());
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        for (Map.Entry entry : this.options.entrySet()) {
            final String item = (String)entry.getKey();
            if (((AbstractConnectionConfig.Option)entry.getValue()).getComponent() instanceof JComboBox) {
                ((JComboBox)((AbstractConnectionConfig.Option)entry.getValue()).getComponent()).addActionListener(e -> {
                    log.debug("option combo box changed to {}", (Object)((AbstractConnectionConfig.Option)this.options.get(item)).getItem());
                    this.adapter.setOptionState(item, ((AbstractConnectionConfig.Option)this.options.get(item)).getItem());
                });
                continue;
            }
            if (!(((AbstractConnectionConfig.Option)entry.getValue()).getComponent() instanceof JTextField)) continue;
            ((JTextField)((AbstractConnectionConfig.Option)entry.getValue()).getComponent()).addActionListener(e -> {
                log.debug("option text field changed to {}", (Object)((AbstractConnectionConfig.Option)this.options.get(item)).getItem());
                this.adapter.setOptionState(item, ((AbstractConnectionConfig.Option)this.options.get(item)).getItem());
            });
            ((AbstractConnectionConfig.Option)entry.getValue()).getComponent().addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    AbstractNetworkConnectionConfig.this.adapter.setOptionState(item, ((AbstractConnectionConfig.Option)AbstractNetworkConnectionConfig.this.options.get(item)).getItem());
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }
            });
        }
        this.addNameEntryCheckers(this.adapter);
        this.outputIntervalSpinner.addChangeListener(e -> this.adapter.getSystemConnectionMemo().setOutputInterval((Integer)this.outputIntervalSpinner.getValue()));
        this.init = true;
    }

    @Override
    public void updateAdapter() {
        if (this.adapter.getMdnsConfigure()) {
            if (!this.hostNameField.getText().equals("")) {
                this.adapter.setHostName(this.hostNameField.getText());
            }
            if (!this.adNameField.getText().equals("")) {
                this.adapter.setAdvertisementName(this.adNameField.getText());
            }
            if (!this.serviceTypeField.getText().equals("")) {
                this.adapter.setServiceType(this.serviceTypeField.getText());
            }
            this.adapter.autoConfigure();
        } else {
            this.adapter.setHostName(this.hostNameField.getText());
            this.adapter.setPort(Integer.parseInt(this.portField.getText()));
        }
        for (Map.Entry entry : this.options.entrySet()) {
            this.adapter.setOptionState((String)entry.getKey(), ((AbstractConnectionConfig.Option)entry.getValue()).getItem());
        }
        if (this.adapter.getSystemConnectionMemo() != null && !this.adapter.getSystemConnectionMemo().setSystemPrefix(this.systemPrefixField.getText())) {
            this.systemPrefixField.setText(this.adapter.getSystemConnectionMemo().getSystemPrefix());
            this.connectionNameField.setText(this.adapter.getSystemConnectionMemo().getUserName());
        }
    }

    @Override
    public NetworkPortAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    protected abstract void setInstance();

    @Override
    public String getInfo() {
        return this.adapter.getCurrentPortName();
    }

    protected void checkOptionValueValidity(String i, JComboBox<String> opt) {
        if (!this.adapter.getOptionState(i).equals(opt.getSelectedItem())) {
            opt.setSelectedIndex(0);
            log.warn("Loading found invalid value for option {}, found \"{}\", setting to \"{}\"", new Object[]{i, this.adapter.getOptionState(i), opt.getSelectedItem()});
            this.adapter.setOptionState(i, (String)opt.getSelectedItem());
        }
    }

    @Override
    public void loadDetails(JPanel details) {
        this._details = details;
        this.setInstance();
        if (!this.init) {
            String[] optionsAvailable = this.adapter.getOptions();
            this.options.clear();
            String[] stringArray = optionsAvailable;
            int n = optionsAvailable.length;
            int n2 = 0;
            while (n2 < n) {
                JComponent opt;
                String i = stringArray[n2];
                if (this.adapter.isOptionTypeText(i)) {
                    opt = new JTextField(15);
                    ((JTextComponent)opt).setText(this.adapter.getOptionState(i));
                    this.options.put(i, new AbstractConnectionConfig.Option(this.adapter.getOptionDisplayName(i), opt, this.adapter.isOptionAdvanced(i)));
                } else if (this.adapter.isOptionTypePassword(i)) {
                    opt = new JPasswordField(15);
                    ((JTextComponent)opt).setText(this.adapter.getOptionState(i));
                    this.options.put(i, new AbstractConnectionConfig.Option(this.adapter.getOptionDisplayName(i), opt, this.adapter.isOptionAdvanced(i)));
                } else {
                    opt = new JComboBox<String>(this.adapter.getOptionChoices(i));
                    ((JComboBox)opt).setSelectedItem(this.adapter.getOptionState(i));
                    this.checkOptionValueValidity(i, (JComboBox<String>)opt);
                    this.options.put(i, new AbstractConnectionConfig.Option(this.adapter.getOptionDisplayName(i), opt, this.adapter.isOptionAdvanced(i)));
                }
                ++n2;
            }
        }
        if (this.hostNameField.getActionListeners().length > 0) {
            this.hostNameField.removeActionListener(this.hostNameField.getActionListeners()[0]);
        }
        if (this.adapter.getSystemConnectionMemo() != null) {
            this.systemPrefixField.setText(this.adapter.getSystemConnectionMemo().getSystemPrefix());
            this.connectionNameField.setText(this.adapter.getSystemConnectionMemo().getUserName());
            this.NUMOPTIONS += 2;
        }
        this.NUMOPTIONS += this.options.size();
        this.hostNameField.setText(this.adapter.getHostName());
        this.hostNameFieldLabel = new JLabel(Bundle.getMessage("HostFieldLabel"));
        this.hostNameField.setToolTipText(Bundle.getMessage("HostFieldToolTip"));
        if (this.adapter.getHostName() == null || this.adapter.getHostName().equals("")) {
            this.hostNameField.setText(this.p.getComboBoxLastSelection(String.valueOf(this.adapter.getClass().getName()) + ".hostname"));
            this.adapter.setHostName(this.hostNameField.getText());
        }
        this.portField.setToolTipText(Bundle.getMessage("PortFieldToolTip"));
        this.portField.setEnabled(true);
        this.portField.setText("" + this.adapter.getPort());
        this.portFieldLabel = new JLabel(Bundle.getMessage("PortFieldLabel"));
        this.adNameField.setToolTipText(Bundle.getMessage("AdNameFieldToolTip"));
        this.adNameField.setEnabled(false);
        this.adNameField.setText(this.adapter.getAdvertisementName());
        this.adNameFieldLabel = new JLabel(Bundle.getMessage("AdNameFieldLabel"));
        this.adNameFieldLabel.setEnabled(false);
        this.serviceTypeField.setToolTipText(Bundle.getMessage("ServiceTypeFieldToolTip"));
        this.serviceTypeField.setEnabled(false);
        this.serviceTypeField.setText(this.adapter.getServiceType());
        this.serviceTypeFieldLabel = new JLabel(Bundle.getMessage("ServiceTypeFieldLabel"));
        this.serviceTypeFieldLabel.setEnabled(false);
        this.outputIntervalLabel = new JLabel(Bundle.getMessage("OutputIntervalLabel"));
        this.outputIntervalSpinner.setToolTipText(Bundle.getMessage("OutputIntervalTooltip", this.adapter.getSystemConnectionMemo().getDefaultOutputInterval(), this.adapter.getManufacturer()));
        JFormattedTextField field = ((JSpinner.DefaultEditor)this.outputIntervalSpinner.getEditor()).getTextField();
        field.setColumns(6);
        this.outputIntervalSpinner.setMaximumSize(this.outputIntervalSpinner.getPreferredSize());
        this.outputIntervalSpinner.setValue(this.adapter.getSystemConnectionMemo().getOutputInterval());
        this.outputIntervalSpinner.setEnabled(true);
        this.outputIntervalReset.addActionListener(event -> {
            this.outputIntervalSpinner.setValue(this.adapter.getSystemConnectionMemo().getDefaultOutputInterval());
            this.adapter.getSystemConnectionMemo().setOutputInterval(this.adapter.getSystemConnectionMemo().getDefaultOutputInterval());
        });
        this.showAutoConfig.setFont(this.showAutoConfig.getFont().deriveFont(9.0f));
        this.showAutoConfig.setForeground(Color.blue);
        this.showAutoConfig.addItemListener(e -> this.setAutoNetworkConfig());
        this.showAutoConfig.setSelected(this.adapter.getMdnsConfigure());
        this.setAutoNetworkConfig();
        this.showAdvanced.setFont(this.showAdvanced.getFont().deriveFont(9.0f));
        this.showAdvanced.setForeground(Color.blue);
        this.showAdvanced.addItemListener(e -> this.showAdvancedItems());
        this.showAdvancedItems();
        this.init = false;
        this.checkInitDone();
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="type was checked before casting")
    protected void showAdvancedItems() {
        this._details.removeAll();
        this.cL.anchor = 17;
        this.cL.insets = new Insets(2, 5, 0, 5);
        this.cR.insets = new Insets(2, 0, 0, 5);
        this.cR.anchor = 17;
        this.cR.gridx = 1;
        this.cL.gridx = 0;
        int i = 0;
        int stdrows = 0;
        boolean incAdvancedOptions = true;
        if (!this.isPortAdvanced()) {
            ++stdrows;
        }
        if (!this.isHostNameAdvanced()) {
            ++stdrows;
        }
        for (Map.Entry entry : this.options.entrySet()) {
            if (((AbstractConnectionConfig.Option)entry.getValue()).isAdvanced().booleanValue()) continue;
            ++stdrows;
        }
        if (this.adapter.getSystemConnectionMemo() != null) {
            stdrows += 2;
        }
        if (stdrows == this.NUMOPTIONS) {
            incAdvancedOptions = false;
        }
        this._details.setLayout(this.gbLayout);
        i = this.addStandardDetails(incAdvancedOptions, i);
        if (this.showAdvanced.isSelected()) {
            if (this.isHostNameAdvanced()) {
                this.cR.gridy = i;
                this.cL.gridy = i++;
                this.gbLayout.setConstraints(this.hostNameFieldLabel, this.cL);
                this.gbLayout.setConstraints(this.hostNameField, this.cR);
                this._details.add(this.hostNameFieldLabel);
                this._details.add(this.hostNameField);
            }
            if (this.isPortAdvanced()) {
                this.cR.gridy = i;
                this.cL.gridy = i++;
                this.gbLayout.setConstraints(this.portFieldLabel, this.cL);
                this.gbLayout.setConstraints(this.portField, this.cR);
                this._details.add(this.portFieldLabel);
                this._details.add(this.portField);
            }
            if (this.showAutoConfig.isSelected()) {
                this.cR.gridy = i;
                this.cL.gridy = i++;
                this.gbLayout.setConstraints(this.adNameFieldLabel, this.cL);
                this.gbLayout.setConstraints(this.adNameField, this.cR);
                this._details.add(this.adNameFieldLabel);
                this._details.add(this.adNameField);
                this.cR.gridy = i;
                this.cL.gridy = i++;
                this.gbLayout.setConstraints(this.serviceTypeFieldLabel, this.cL);
                this.gbLayout.setConstraints(this.serviceTypeField, this.cR);
                this._details.add(this.serviceTypeFieldLabel);
                this._details.add(this.serviceTypeField);
            }
            for (Map.Entry entry : this.options.entrySet()) {
                if (!((AbstractConnectionConfig.Option)entry.getValue()).isAdvanced().booleanValue()) continue;
                this.cR.gridy = i;
                this.cL.gridy = i++;
                this.gbLayout.setConstraints(((AbstractConnectionConfig.Option)entry.getValue()).getLabel(), this.cL);
                this.gbLayout.setConstraints(((AbstractConnectionConfig.Option)entry.getValue()).getComponent(), this.cR);
                this._details.add(((AbstractConnectionConfig.Option)entry.getValue()).getLabel());
                this._details.add(((AbstractConnectionConfig.Option)entry.getValue()).getComponent());
            }
            this.cR.gridy = i;
            this.cL.gridy = i++;
            this.gbLayout.setConstraints(this.outputIntervalLabel, this.cL);
            this._details.add(this.outputIntervalLabel);
            JPanel intervalPanel = new JPanel();
            this.gbLayout.setConstraints(intervalPanel, this.cR);
            intervalPanel.add(this.outputIntervalSpinner);
            intervalPanel.add(this.outputIntervalReset);
            this._details.add(intervalPanel);
        }
        this.cL.gridwidth = 2;
        for (JComponent item : this.additionalItems) {
            this.cL.gridy = i++;
            this.gbLayout.setConstraints(item, this.cL);
            this._details.add(item);
        }
        this.cL.gridwidth = 1;
        if (this._details.getParent() != null && this._details.getParent() instanceof JViewport) {
            JViewport vp = (JViewport)this._details.getParent();
            vp.revalidate();
            vp.repaint();
        }
    }

    protected int addStandardDetails(boolean incAdvanced, int i) {
        if (this.isAutoConfigPossible()) {
            this.cR.gridy = i;
            this.cL.gridy = i++;
            this.gbLayout.setConstraints(this.showAutoConfig, this.cR);
            this._details.add(this.showAutoConfig);
            this._details.add(this.showAutoConfig);
        }
        if (!this.isHostNameAdvanced()) {
            this.cR.gridy = i;
            this.cL.gridy = i++;
            this.gbLayout.setConstraints(this.hostNameFieldLabel, this.cL);
            this.gbLayout.setConstraints(this.hostNameField, this.cR);
            this._details.add(this.hostNameFieldLabel);
            this._details.add(this.hostNameField);
        }
        if (!this.isPortAdvanced()) {
            this.cR.gridy = i;
            this.cL.gridy = i++;
            this.gbLayout.setConstraints(this.portFieldLabel, this.cL);
            this.gbLayout.setConstraints(this.portField, this.cR);
            this._details.add(this.portFieldLabel);
            this._details.add(this.portField);
        }
        return this.addStandardDetails(this.adapter, incAdvanced, i);
    }

    public boolean isHostNameAdvanced() {
        return false;
    }

    public boolean isPortAdvanced() {
        return true;
    }

    public boolean isAutoConfigPossible() {
        return false;
    }

    public void setAutoNetworkConfig() {
        if (this.showAutoConfig.isSelected()) {
            this.portField.setEnabled(false);
            this.portFieldLabel.setEnabled(false);
            this.adapter.setMdnsConfigure(true);
        } else {
            this.portField.setEnabled(true);
            this.portFieldLabel.setEnabled(true);
            this.adapter.setMdnsConfigure(false);
        }
    }

    @Override
    public String getManufacturer() {
        return this.adapter.getManufacturer();
    }

    @Override
    public void setManufacturer(String manufacturer) {
        this.setInstance();
        this.adapter.setManufacturer(manufacturer);
    }

    @Override
    public boolean getDisabled() {
        if (this.adapter == null) {
            return true;
        }
        return this.adapter.getDisabled();
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.adapter != null) {
            this.adapter.setDisabled(disabled);
        }
    }

    @Override
    public String getConnectionName() {
        if (this.adapter.getSystemConnectionMemo() != null) {
            return this.adapter.getSystemConnectionMemo().getUserName();
        }
        return this.name();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.adapter != null) {
            this.adapter.dispose();
            this.adapter = null;
        }
    }
}

