/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.concurrent.GuardedBy;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.Bundle;
import jmri.jmrix.Message;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.TextAreaFIFO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMonPane
extends JmriPanel {
    protected JButton clearButton = new JButton();
    protected JToggleButton freezeButton = new JToggleButton();
    protected JScrollPane jScrollPane1 = new JScrollPane();
    protected TextAreaFIFO monTextPane = new TextAreaFIFO(500);
    protected JToggleButton startLogButton = new JToggleButton();
    protected JButton stopLogButton = new JButton();
    protected JCheckBox rawCheckBox = new JCheckBox();
    protected JCheckBox timeCheckBox = new JCheckBox();
    protected JCheckBox alwaysOnTopCheckBox = new JCheckBox();
    protected JCheckBox autoScrollCheckBox = new JCheckBox();
    protected JTextField filterField = new JTextField();
    protected JLabel filterLabel = new JLabel(Bundle.getMessage("LabelFilterBytes"), 2);
    protected JButton openFileChooserButton = new JButton();
    protected JTextField entryField = new JTextField();
    protected JButton enterButton = new JButton();
    String rawDataCheck = String.valueOf(this.getClass().getName()) + ".RawData";
    String timeStampCheck = String.valueOf(this.getClass().getName()) + ".TimeStamp";
    String alwaysOnTopCheck = String.valueOf(this.getClass().getName()) + ".AlwaysOnTop";
    String autoScrollCheck = String.valueOf(this.getClass().getName()) + ".AutoScroll";
    String filterFieldCheck = String.valueOf(this.getClass().getName()) + ".FilterField";
    final JFileChooser logFileChooser = new JFileChooser(FileUtil.getUserFilesPath());
    private int timerCount = 0;
    private Timer timer;
    private static final String newline = System.getProperty("line.separator");
    @GuardedBy(value="this")
    private volatile PrintStream logStream = null;
    private final DateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
    @GuardedBy(value="this")
    protected StringBuffer linesBuffer = new StringBuffer();
    private static final int MAX_LINES = 500;
    private static final Logger log = LoggerFactory.getLogger(AbstractMonPane.class);

    @Override
    public abstract String getTitle();

    protected abstract void init();

    @Override
    public void dispose() {
        UserPreferencesManager pm = InstanceManager.getDefault(UserPreferencesManager.class);
        pm.setSimplePreferenceState(this.timeStampCheck, this.timeCheckBox.isSelected());
        pm.setSimplePreferenceState(this.rawDataCheck, this.rawCheckBox.isSelected());
        pm.setSimplePreferenceState(this.alwaysOnTopCheck, this.alwaysOnTopCheckBox.isSelected());
        pm.setSimplePreferenceState(this.autoScrollCheck, !this.autoScrollCheckBox.isSelected());
        pm.setProperty(this.filterFieldCheck, this.filterFieldCheck, this.filterField.getText());
        this.monTextPane.dispose();
        super.dispose();
    }

    protected void createDataPanes() {
        this.configureDataPane(this.monTextPane);
    }

    protected void configureDataPane(TextAreaFIFO textPane) {
        textPane.setVisible(true);
        textPane.setToolTipText(Bundle.getMessage("TooltipMonTextPane"));
        textPane.setEditable(false);
    }

    protected int getInitialPreferredLineLength() {
        return 80;
    }

    protected int getInitialPreferredLineCount() {
        return 10;
    }

    protected void addDataPanes() {
        JTextField t = new JTextField(this.getInitialPreferredLineLength());
        int x = this.jScrollPane1.getPreferredSize().width + t.getPreferredSize().width;
        int y = this.jScrollPane1.getPreferredSize().height + this.getInitialPreferredLineCount() * t.getPreferredSize().height;
        this.jScrollPane1.getViewport().add(this.monTextPane);
        this.jScrollPane1.setPreferredSize(new Dimension(x, y));
        this.jScrollPane1.setVisible(true);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.jScrollPane1);
        this.add(p);
    }

    @Override
    public void initComponents() {
        UserPreferencesManager pm = InstanceManager.getDefault(UserPreferencesManager.class);
        this.clearButton.setText(Bundle.getMessage("ButtonClearScreen"));
        this.clearButton.setVisible(true);
        this.clearButton.setToolTipText(Bundle.getMessage("TooltipClearMonHistory"));
        this.freezeButton.setText(Bundle.getMessage("ButtonFreezeScreen"));
        this.freezeButton.setVisible(true);
        this.freezeButton.setToolTipText(Bundle.getMessage("TooltipStopScroll"));
        this.enterButton.setText(Bundle.getMessage("ButtonAddMessage"));
        this.enterButton.setVisible(true);
        this.enterButton.setToolTipText(Bundle.getMessage("TooltipAddMessage"));
        this.createDataPanes();
        this.entryField.setToolTipText(Bundle.getMessage("TooltipEntryPane"));
        Dimension currentPreferredSize = this.entryField.getPreferredSize();
        Dimension currentMaximumSize = this.entryField.getMaximumSize();
        currentMaximumSize.height = currentPreferredSize.height;
        this.entryField.setMaximumSize(currentMaximumSize);
        this.filterField.setToolTipText(Bundle.getMessage("TooltipFilter"));
        this.filterField.setMaximumSize(currentMaximumSize);
        try {
            this.filterField.setText(pm.getProperty(this.filterFieldCheck, this.filterFieldCheck).toString());
        }
        catch (NullPointerException nullPointerException) {}
        ((AbstractDocument)this.filterField.getDocument()).setDocumentFilter(new DocumentFilter(){
            private static final String PATTERN = "[0-9a-fA-F ]*+";

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attrs) throws BadLocationException {
                if (text.matches(PATTERN)) {
                    fb.insertString(offset, text.toUpperCase(), attrs);
                } else {
                    fb.insertString(offset, "", attrs);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                if (text.matches(PATTERN)) {
                    fb.replace(offset, length, text.toUpperCase(), attrs);
                } else {
                    fb.replace(offset, length, "", attrs);
                }
            }
        });
        this.startLogButton.setText(Bundle.getMessage("ButtonStartLogging"));
        this.startLogButton.setVisible(true);
        this.startLogButton.setToolTipText(Bundle.getMessage("TooltipStartLogging"));
        this.stopLogButton.setText(Bundle.getMessage("ButtonStopLogging"));
        this.stopLogButton.setVisible(true);
        this.stopLogButton.setToolTipText(Bundle.getMessage("TooltipStopLogging"));
        this.rawCheckBox.setText(Bundle.getMessage("ButtonShowRaw"));
        this.rawCheckBox.setVisible(true);
        this.rawCheckBox.setToolTipText(Bundle.getMessage("TooltipShowRaw"));
        this.rawCheckBox.setSelected(pm.getSimplePreferenceState(this.rawDataCheck));
        this.timeCheckBox.setText(Bundle.getMessage("ButtonShowTimestamps"));
        this.timeCheckBox.setVisible(true);
        this.timeCheckBox.setToolTipText(Bundle.getMessage("TooltipShowTimestamps"));
        this.timeCheckBox.setSelected(pm.getSimplePreferenceState(this.timeStampCheck));
        this.alwaysOnTopCheckBox.setText(Bundle.getMessage("ButtonWindowOnTop"));
        this.alwaysOnTopCheckBox.setVisible(true);
        this.alwaysOnTopCheckBox.setToolTipText(Bundle.getMessage("TooltipWindowOnTop"));
        this.alwaysOnTopCheckBox.setSelected(pm.getSimplePreferenceState(this.alwaysOnTopCheck));
        Container ancestor = this.getTopLevelAncestor();
        if (ancestor instanceof JmriJFrame) {
            ((JmriJFrame)ancestor).setAlwaysOnTop(this.alwaysOnTopCheckBox.isSelected());
        } else if (this.alwaysOnTopCheckBox.isSelected()) {
            log.debug("Cannot set Always On Top from preferences due to no Top Level Ancestor");
            this.timerCount = 0;
            this.timer = new Timer(20, evt -> {
                if (this.getTopLevelAncestor() != null && this.timerCount > 3 && this.getTopLevelAncestor() instanceof JmriJFrame) {
                    this.timer.stop();
                    ((JmriJFrame)this.getTopLevelAncestor()).setAlwaysOnTop(this.alwaysOnTopCheckBox.isSelected());
                    log.debug("set Always On Top");
                } else {
                    log.debug("Have to repeat attempt to set Always on Top");
                    ++this.timerCount;
                    if (this.timerCount > 50) {
                        log.warn("Took too long to \"Set Always on Top\", failed");
                        this.timer.stop();
                    }
                }
            });
            this.timer.start();
        }
        this.autoScrollCheckBox.setText(Bundle.getMessage("ButtonAutoScroll"));
        this.autoScrollCheckBox.setVisible(true);
        this.autoScrollCheckBox.setToolTipText(Bundle.getMessage("TooltipAutoScroll"));
        this.autoScrollCheckBox.setSelected(!pm.getSimplePreferenceState(this.autoScrollCheck));
        this.monTextPane.setAutoScroll(!pm.getSimplePreferenceState(this.autoScrollCheck));
        this.openFileChooserButton.setText(Bundle.getMessage("ButtonChooseLogFile"));
        this.openFileChooserButton.setVisible(true);
        this.openFileChooserButton.setToolTipText(Bundle.getMessage("TooltipChooseLogFile"));
        this.setLayout(new BoxLayout(this, 1));
        this.addDataPanes();
        JPanel paneA = new JPanel();
        paneA.setLayout(new BoxLayout(paneA, 1));
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 0));
        pane1.add(this.clearButton);
        pane1.add(this.freezeButton);
        pane1.add(this.rawCheckBox);
        pane1.add(this.timeCheckBox);
        pane1.add(this.alwaysOnTopCheckBox);
        pane1.add(this.autoScrollCheckBox);
        paneA.add(pane1);
        this.addCustomControlPanes(paneA);
        JPanel pane2 = new JPanel();
        pane2.setLayout(new BoxLayout(pane2, 0));
        pane2.add(this.filterLabel);
        this.filterLabel.setLabelFor(this.filterField);
        pane2.add(this.filterField);
        pane2.add(this.openFileChooserButton);
        pane2.add(this.startLogButton);
        pane2.add(this.stopLogButton);
        paneA.add(pane2);
        JPanel pane3 = new JPanel();
        pane3.setLayout(new BoxLayout(pane3, 0));
        pane3.add(this.enterButton);
        pane3.add(this.entryField);
        paneA.add(pane3);
        this.add(paneA);
        this.clearButton.addActionListener(e -> this.clearButtonActionPerformed(e));
        this.startLogButton.addActionListener(e -> this.startLogButtonActionPerformed(e));
        this.stopLogButton.addActionListener(e -> this.stopLogButtonActionPerformed(e));
        this.openFileChooserButton.addActionListener(e -> this.openFileChooserButtonActionPerformed(e));
        this.enterButton.addActionListener(e -> this.enterButtonActionPerformed(e));
        this.alwaysOnTopCheckBox.addActionListener(e -> {
            if (this.getTopLevelAncestor() != null && this.getTopLevelAncestor() instanceof JmriJFrame) {
                ((JmriJFrame)this.getTopLevelAncestor()).setAlwaysOnTop(this.alwaysOnTopCheckBox.isSelected());
            }
        });
        this.autoScrollCheckBox.addActionListener(e -> this.monTextPane.setAutoScroll(this.autoScrollCheckBox.isSelected()));
        this.logFileChooser.setSelectedFile(new File("monitorLog.txt"));
        this.init();
    }

    protected void addCustomControlPanes(JPanel parent) {
    }

    public void setFixedWidthFont() {
        this.monTextPane.setFont(new Font("Monospaced", 0, this.monTextPane.getFont().getSize()));
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.AbstractMonFrame";
    }

    public void logMessage(Message message) {
        this.logMessage("", "", message);
    }

    public void logMessage(String messagePrefix, Message message) {
        this.logMessage(messagePrefix, "", message);
    }

    public void logMessage(String messagePrefix, String rawPrefix, Message message) {
        StringBuilder raw = new StringBuilder(rawPrefix);
        if (this.rawCheckBox.isSelected()) {
            raw.append(message.toString());
        }
        String text = message.toMonitorString();
        this.nextLine(String.valueOf(messagePrefix) + " " + text + "\n", raw.toString());
    }

    public void nextLine(String line, String raw) {
        this.nextLineWithTime(new Date(), line, raw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextLineWithTime(Date timestamp, String line, String raw) {
        StringBuilder sb = new StringBuilder(120);
        if (this.timeCheckBox.isSelected()) {
            sb.append(this.df.format(timestamp)).append(": ");
        }
        if (raw != null && this.rawCheckBox.isSelected()) {
            sb.append('[').append(raw).append("]  ");
        }
        sb.append(line);
        AbstractMonPane abstractMonPane = this;
        synchronized (abstractMonPane) {
            this.linesBuffer.append(sb.toString());
        }
        abstractMonPane = this;
        synchronized (abstractMonPane) {
            if (this.logStream != null) {
                String logLine = sb.toString();
                if (!newline.equals("\n")) {
                    int lim = sb.length();
                    StringBuilder out = new StringBuilder(sb.length() + 10);
                    int i = 0;
                    while (i < lim) {
                        if (sb.charAt(i) == '\n') {
                            out.append(newline);
                        } else {
                            out.append(sb.charAt(i));
                        }
                        ++i;
                    }
                    logLine = out.toString();
                }
                this.logStream.print(logLine);
            }
        }
        if (this.freezeButton.isSelected()) {
            return;
        }
        if (this.isFiltered(raw)) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            AbstractMonPane abstractMonPane = this;
            synchronized (abstractMonPane) {
                this.monTextPane.append(this.linesBuffer.toString());
                this.linesBuffer.setLength(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isFiltered(String raw) {
        String checkRaw = this.getOpCodeForFilter(raw);
        if (raw != null) {
            String[] filters;
            String[] stringArray = filters = this.filterField.getText().toUpperCase().split(" ");
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equals(checkRaw)) {
                    AbstractMonPane abstractMonPane = this;
                    synchronized (abstractMonPane) {
                        this.linesBuffer.setLength(0);
                    }
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected String getOpCodeForFilter(String raw) {
        if (raw != null && raw.length() >= 7) {
            return raw.substring(5, 7);
        }
        return null;
    }

    public synchronized void clearButtonActionPerformed(ActionEvent e) {
        this.linesBuffer.setLength(0);
        this.monTextPane.setText("");
    }

    public String getFilePathAndName() {
        String returnString = "";
        Path p = this.logFileChooser.getSelectedFile().toPath();
        if (p.getParent() == null) {
            Path fileName = p.getFileName();
            if (fileName != null) {
                returnString = String.valueOf(FileUtil.getUserFilesPath()) + fileName.toString();
            } else {
                log.error("User Files File Path not valid");
            }
            log.warn("File selection dialog box did not provide a path to the specified file. Log will be saved to {}", (Object)returnString);
        } else {
            returnString = p.toString();
        }
        return returnString;
    }

    public synchronized void startLogButtonActionPerformed(ActionEvent e) {
        if (this.logStream == null) {
            String filePathAndName = this.getFilePathAndName();
            log.warn("startLogButtonActionPerformed: getSelectedFile() returns {} {}", (Object)this.logFileChooser.getSelectedFile().getPath(), (Object)this.logFileChooser.getSelectedFile().getName());
            log.warn("startLogButtonActionPerformed: is attempting to use returned file path and file name {}", (Object)filePathAndName);
            File logFile = new File(filePathAndName);
            try {
                this.logStream = new PrintStream(new FileOutputStream(logFile));
            }
            catch (FileNotFoundException ex) {
                this.stopLogButtonActionPerformed(null);
                log.error("startLogButtonActionPerformed: FileOutputStream cannot open the file '{}'.  Exception: {}", (Object)this.logFileChooser.getSelectedFile().getName(), (Object)ex.getMessage());
                JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorCannotOpenFileForWriting", this.logFileChooser.getSelectedFile().getName(), Bundle.getMessage("ErrorPossibleCauseCannotOpenForWrite")), Bundle.getMessage("ErrorTitle"), 0);
            }
        } else {
            this.startLogButton.setSelected(true);
        }
    }

    public synchronized void stopLogButtonActionPerformed(ActionEvent e) {
        if (this.logStream != null) {
            this.logStream.flush();
            this.logStream.close();
            this.logStream = null;
        }
        this.startLogButton.setSelected(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFileChooserButtonActionPerformed(ActionEvent e) {
        int retVal = this.logFileChooser.showSaveDialog(this);
        if (retVal == 0) {
            AbstractMonPane abstractMonPane = this;
            synchronized (abstractMonPane) {
                boolean loggingNow = this.logStream != null;
                this.stopLogButtonActionPerformed(e);
                if (loggingNow) {
                    this.startLogButtonActionPerformed(e);
                }
            }
        }
    }

    public void enterButtonActionPerformed(ActionEvent e) {
        this.nextLine(String.valueOf(this.entryField.getText()) + "\n", null);
    }

    public synchronized String getFrameText() {
        return this.monTextPane.getText();
    }

    public final synchronized JTextArea getTextArea() {
        return this.monTextPane;
    }

    public synchronized String getFilterText() {
        return this.filterField.getText();
    }

    public synchronized void setFilterText(String text) {
        this.filterField.setText(text);
    }
}

