/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.Bundle;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.swing.TextAreaFIFO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMonFrame
extends JmriJFrame {
    protected JButton clearButton = new JButton();
    protected JToggleButton freezeButton = new JToggleButton();
    protected JScrollPane jScrollPane1 = new JScrollPane();
    protected TextAreaFIFO monTextPane = new TextAreaFIFO(MAX_LINES);
    protected JButton startLogButton = new JButton();
    protected JButton stopLogButton = new JButton();
    protected JCheckBox rawCheckBox = new JCheckBox();
    protected JCheckBox timeCheckBox = new JCheckBox();
    protected JCheckBox alwaysOnTopCheckBox = new JCheckBox();
    protected JCheckBox autoScrollCheckBox = new JCheckBox();
    protected JButton openFileChooserButton = new JButton();
    protected JTextField entryField = new JTextField();
    protected JButton enterButton = new JButton();
    String rawDataCheck = String.valueOf(this.getClass().getName()) + ".RawData";
    String timeStampCheck = String.valueOf(this.getClass().getName()) + ".TimeStamp";
    String alwaysOnTopCheck = String.valueOf(this.getClass().getName()) + ".alwaysOnTop";
    String autoScrollCheck = String.valueOf(this.getClass().getName()) + ".AutoScroll";
    UserPreferencesManager p;
    AbstractMonFrame self;
    public final JFileChooser logFileChooser = new JFileChooser(FileUtil.getUserFilesPath());
    String newline = System.getProperty("line.separator");
    volatile PrintStream logStream = null;
    DateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
    StringBuffer linesBuffer = new StringBuffer();
    private static int MAX_LINES = 500;
    private static final Logger log = LoggerFactory.getLogger(AbstractMonFrame.class);

    protected abstract String title();

    protected abstract void init();

    @Override
    @OverridingMethodsMustInvokeSuper
    public void dispose() {
        if (this.p != null) {
            this.p.setSimplePreferenceState(this.timeStampCheck, this.timeCheckBox.isSelected());
            this.p.setSimplePreferenceState(this.rawDataCheck, this.rawCheckBox.isSelected());
            this.p.setSimplePreferenceState(this.alwaysOnTopCheck, this.alwaysOnTopCheckBox.isSelected());
            this.p.setSimplePreferenceState(this.autoScrollCheck, !this.autoScrollCheckBox.isSelected());
        }
        this.monTextPane.dispose();
        super.dispose();
    }

    public AbstractMonFrame() {
        this.self = this;
    }

    @Override
    public void initComponents() {
        this.p = InstanceManager.getDefault(UserPreferencesManager.class);
        this.clearButton.setText(Bundle.getMessage("ButtonClearScreen"));
        this.clearButton.setVisible(true);
        this.clearButton.setToolTipText(Bundle.getMessage("TooltipClearMonHistory"));
        this.freezeButton.setText(Bundle.getMessage("ButtonFreezeScreen"));
        this.freezeButton.setVisible(true);
        this.freezeButton.setToolTipText(Bundle.getMessage("TooltipStopScroll"));
        this.enterButton.setText(Bundle.getMessage("ButtonAddMessage"));
        this.enterButton.setVisible(true);
        this.enterButton.setToolTipText(Bundle.getMessage("TooltipAddMessage"));
        this.monTextPane.setVisible(true);
        this.monTextPane.setToolTipText(Bundle.getMessage("TooltipMonTextPane"));
        this.monTextPane.setEditable(false);
        this.entryField.setToolTipText(Bundle.getMessage("TooltipEntryPane", Bundle.getMessage("ButtonAddMessage")));
        JTextField t = new JTextField(200);
        int x = this.jScrollPane1.getPreferredSize().width + t.getPreferredSize().width;
        int y = this.jScrollPane1.getPreferredSize().height + 10 * t.getPreferredSize().height;
        this.jScrollPane1.getViewport().add(this.monTextPane);
        this.jScrollPane1.setPreferredSize(new Dimension(x, y));
        this.jScrollPane1.setVisible(true);
        this.startLogButton.setText(Bundle.getMessage("ButtonStartLogging"));
        this.startLogButton.setVisible(true);
        this.startLogButton.setToolTipText(Bundle.getMessage("TooltipStartLogging"));
        this.stopLogButton.setText(Bundle.getMessage("ButtonStopLogging"));
        this.stopLogButton.setVisible(true);
        this.stopLogButton.setToolTipText(Bundle.getMessage("TooltipStopLogging"));
        this.rawCheckBox.setText(Bundle.getMessage("ButtonShowRaw"));
        this.rawCheckBox.setVisible(true);
        this.rawCheckBox.setToolTipText(Bundle.getMessage("TooltipShowRaw"));
        this.rawCheckBox.setSelected(this.p.getSimplePreferenceState(this.rawDataCheck));
        this.timeCheckBox.setText(Bundle.getMessage("ButtonShowTimestamps"));
        this.timeCheckBox.setVisible(true);
        this.timeCheckBox.setToolTipText(Bundle.getMessage("TooltipShowTimestamps"));
        this.timeCheckBox.setSelected(this.p.getSimplePreferenceState(this.timeStampCheck));
        this.alwaysOnTopCheckBox.setText(Bundle.getMessage("ButtonWindowOnTop"));
        this.alwaysOnTopCheckBox.setVisible(true);
        this.alwaysOnTopCheckBox.setToolTipText(Bundle.getMessage("TooltipWindowOnTop"));
        this.alwaysOnTopCheckBox.setSelected(this.p.getSimplePreferenceState(this.alwaysOnTopCheck));
        this.setAlwaysOnTop(this.alwaysOnTopCheckBox.isSelected());
        this.autoScrollCheckBox.setText(Bundle.getMessage("ButtonAutoScroll"));
        this.autoScrollCheckBox.setVisible(true);
        this.autoScrollCheckBox.setToolTipText(Bundle.getMessage("TooltipAutoScroll"));
        this.autoScrollCheckBox.setSelected(!this.p.getSimplePreferenceState(this.autoScrollCheck));
        this.openFileChooserButton.setText(Bundle.getMessage("ButtonChooseLogFile"));
        this.openFileChooserButton.setVisible(true);
        this.openFileChooserButton.setToolTipText(Bundle.getMessage("TooltipChooseLogFile"));
        this.setTitle(this.title());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.jScrollPane1);
        JPanel paneA = new JPanel();
        paneA.setLayout(new BoxLayout(paneA, 1));
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 0));
        pane1.add(this.clearButton);
        pane1.add(this.freezeButton);
        pane1.add(this.rawCheckBox);
        pane1.add(this.timeCheckBox);
        pane1.add(this.alwaysOnTopCheckBox);
        paneA.add(pane1);
        JPanel pane2 = new JPanel();
        pane2.setLayout(new BoxLayout(pane2, 0));
        pane2.add(this.openFileChooserButton);
        pane2.add(this.startLogButton);
        pane2.add(this.stopLogButton);
        paneA.add(pane2);
        JPanel pane3 = new JPanel();
        pane3.setLayout(new BoxLayout(pane3, 0));
        pane3.add(this.enterButton);
        pane3.add(this.entryField);
        paneA.add(pane3);
        this.getContentPane().add(paneA);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractMonFrame.this.clearButtonActionPerformed(e);
            }
        });
        this.startLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractMonFrame.this.startLogButtonActionPerformed(e);
            }
        });
        this.stopLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractMonFrame.this.stopLogButtonActionPerformed(e);
            }
        });
        this.openFileChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractMonFrame.this.openFileChooserButtonActionPerformed(e);
            }
        });
        this.enterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractMonFrame.this.enterButtonActionPerformed(e);
            }
        });
        this.alwaysOnTopCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractMonFrame.this.setAlwaysOnTop(AbstractMonFrame.this.alwaysOnTopCheckBox.isSelected());
            }
        });
        this.autoScrollCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractMonFrame.this.monTextPane.setAutoScroll(AbstractMonFrame.this.autoScrollCheckBox.isSelected());
            }
        });
        this.logFileChooser.setSelectedFile(new File("monitorLog.txt"));
        this.init();
        this.setHelp();
        this.pack();
        paneA.setMaximumSize(paneA.getSize());
        this.pack();
    }

    protected void setHelp() {
        this.addHelpMenu("package.jmri.jmrix.AbstractMonFrame", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextLine(String line, String raw) {
        StringBuffer sb = new StringBuffer(120);
        if (this.timeCheckBox.isSelected()) {
            sb.append(this.df.format(new Date())).append(": ");
        }
        if (this.rawCheckBox.isSelected()) {
            sb.append('[').append(raw).append("]  ");
        }
        sb.append(line);
        Object object = this.self;
        synchronized (object) {
            this.linesBuffer.append(sb.toString());
        }
        if (!this.freezeButton.isSelected()) {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AbstractMonFrame abstractMonFrame = AbstractMonFrame.this.self;
                    synchronized (abstractMonFrame) {
                        AbstractMonFrame.this.monTextPane.append(AbstractMonFrame.this.linesBuffer.toString());
                        AbstractMonFrame.this.linesBuffer.setLength(0);
                    }
                }
            };
            SwingUtilities.invokeLater(r);
        }
        if (this.logStream != null) {
            object = this.logStream;
            synchronized (object) {
                String logLine = sb.toString();
                if (!this.newline.equals("\n")) {
                    int i = 0;
                    int lim = sb.length();
                    StringBuffer out = new StringBuffer(sb.length() + 10);
                    i = 0;
                    while (i < lim) {
                        if (sb.charAt(i) == '\n') {
                            out.append(this.newline);
                        } else {
                            out.append(sb.charAt(i));
                        }
                        ++i;
                    }
                    logLine = out.toString();
                }
                this.logStream.print(logLine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearButtonActionPerformed(ActionEvent e) {
        StringBuffer stringBuffer = this.linesBuffer;
        synchronized (stringBuffer) {
            this.linesBuffer.setLength(0);
            this.monTextPane.setText("");
        }
    }

    public synchronized void startLogButtonActionPerformed(ActionEvent e) {
        if (this.logStream == null) {
            try {
                this.logStream = new PrintStream(new FileOutputStream(this.logFileChooser.getSelectedFile()));
            }
            catch (FileNotFoundException ex) {
                log.error("exception {}", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopLogButtonActionPerformed(ActionEvent e) {
        if (this.logStream != null) {
            PrintStream printStream = this.logStream;
            synchronized (printStream) {
                this.logStream.flush();
                this.logStream.close();
            }
            this.logStream = null;
        }
    }

    public void openFileChooserButtonActionPerformed(ActionEvent e) {
        int retVal = this.logFileChooser.showSaveDialog(this);
        if (retVal == 0) {
            boolean loggingNow = this.logStream != null;
            this.stopLogButtonActionPerformed(e);
            if (loggingNow) {
                this.startLogButtonActionPerformed(e);
            }
        }
    }

    public void enterButtonActionPerformed(ActionEvent e) {
        this.nextLine(String.valueOf(this.entryField.getText()) + "\n", "");
    }

    public synchronized String getFrameText() {
        return this.linesBuffer.toString();
    }

    public final synchronized JTextArea getTextArea() {
        return this.monTextPane;
    }
}

