/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.util.Objects;
import javax.annotation.Nonnull;
import jmri.jmrix.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessage
implements Message {
    protected int[] _dataChars = null;
    protected int _nDataChars = 0;
    private static final Logger log = LoggerFactory.getLogger(AbstractMessage.class);

    public AbstractMessage() {
    }

    public AbstractMessage(int n) {
        if (n < 1) {
            log.error("invalid length in call to ctor");
        }
        this._nDataChars = n;
        this._dataChars = new int[n];
    }

    public AbstractMessage(String s) {
        this(s.length());
        int i = 0;
        while (i < this._nDataChars) {
            this._dataChars[i] = s.charAt(i);
            ++i;
        }
    }

    public AbstractMessage(@Nonnull AbstractMessage m) {
        Objects.requireNonNull(m, "Unable to create message by copying null message");
        this._nDataChars = m._nDataChars;
        this._dataChars = new int[this._nDataChars];
        System.arraycopy(m._dataChars, 0, this._dataChars, 0, this._nDataChars);
    }

    @Override
    public int getElement(int n) {
        return this._dataChars[n];
    }

    @Override
    public int getNumDataElements() {
        return this._nDataChars;
    }

    @Override
    public void setElement(int n, int v) {
        this._dataChars[n] = v;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMessage m = (AbstractMessage)obj;
        if (this.getNumDataElements() != m.getNumDataElements()) {
            return false;
        }
        int i = 0;
        while (i < this.getNumDataElements()) {
            if (this.getElement(i) != m.getElement(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int retval = 0;
        int i = 0;
        while (i < this.getNumDataElements()) {
            retval += this.getElement(i);
            ++i;
        }
        return retval;
    }
}

