/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractNetworkPortController;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.ConnectionStatus;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMRTrafficController {
    private final Runnable shutDownTask = this::terminate;
    private boolean synchronizeRx = true;
    protected final Vector<AbstractMRListener> cmdListeners = new Vector();
    protected AbstractMRListener mLastSender = null;
    protected volatile int mCurrentMode;
    public static final int NORMALMODE = 1;
    public static final int PROGRAMINGMODE = 4;
    protected volatile int mCurrentState;
    public static final int IDLESTATE = 10;
    public static final int NOTIFIEDSTATE = 15;
    public static final int WAITMSGREPLYSTATE = 25;
    public static final int WAITREPLYINPROGMODESTATE = 30;
    public static final int WAITREPLYINNORMMODESTATE = 35;
    public static final int OKSENDMSGSTATE = 40;
    public static final int AUTORETRYSTATE = 45;
    public static final int POLLSTATE = 50;
    protected boolean allowUnexpectedReply;
    protected LinkedList<AbstractMRMessage> msgQueue = new LinkedList();
    protected LinkedList<AbstractMRListener> listenerQueue = new LinkedList();
    protected boolean replyInDispatch = false;
    private int maxDispatchTime = 0;
    private int warningMessageTime = 12000;
    private static final int DISPATCH_WAIT_INTERVAL = 100;
    private static final int DISPATCH_WARNING_TIME = 12000;
    private static final int WARN_NEXT_TIME = 1000;
    private boolean timeoutFlag = false;
    private int timeouts = 0;
    protected boolean flushReceiveChars = false;
    protected int mWaitBeforePoll = 100;
    protected long waitTimePoll = 0L;
    protected boolean xmtException = false;
    protected boolean connectionError = false;
    public AbstractPortController controller = null;
    protected volatile Thread xmtThread = null;
    protected volatile Thread rcvThread = null;
    protected volatile Runnable xmtRunnable = null;
    protected DataInputStream istream = null;
    protected OutputStream ostream = null;
    protected boolean rcvException = false;
    protected int maxRcvExceptionCount = 100;
    private byte[] rcvBuffer = new byte[1];
    private int retransmitCount = 0;
    protected volatile boolean threadStopRequest = false;
    private static final Logger log = LoggerFactory.getLogger(AbstractMRTrafficController.class);

    public AbstractMRTrafficController() {
        log.debug("Creating AbstractMRTrafficController instance");
        this.mCurrentMode = 1;
        this.mCurrentState = 10;
        this.allowUnexpectedReply = false;
        InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
    }

    protected void setSynchronizeRx(boolean val) {
        this.synchronizeRx = val;
    }

    protected boolean getSynchronizeRx() {
        return this.synchronizeRx;
    }

    protected synchronized void addListener(AbstractMRListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        if (!this.cmdListeners.contains(l)) {
            this.cmdListeners.addElement(l);
        }
    }

    protected synchronized void removeListener(AbstractMRListener l) {
        if (this.cmdListeners.contains(l)) {
            this.cmdListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyMessage(AbstractMRMessage m, AbstractMRListener notMe) {
        Vector v;
        AbstractMRTrafficController abstractMRTrafficController = this;
        synchronized (abstractMRTrafficController) {
            v = (Vector)this.cmdListeners.clone();
        }
        int cnt = v.size();
        int i = 0;
        while (i < cnt) {
            AbstractMRListener client = (AbstractMRListener)v.elementAt(i);
            if (notMe != client) {
                log.debug("notify message, client: {}", (Object)client);
                try {
                    this.forwardMessage(client, m);
                }
                catch (RuntimeException e) {
                    log.warn("notify: During message dispatch to {}", (Object)client, (Object)e);
                }
            }
            ++i;
        }
    }

    protected abstract void forwardMessage(AbstractMRListener var1, AbstractMRMessage var2);

    protected abstract AbstractMRMessage pollMessage();

    protected abstract AbstractMRListener pollReplyHandler();

    protected abstract AbstractMRMessage enterProgMode();

    protected abstract AbstractMRMessage enterNormalMode();

    protected boolean programmerIdle() {
        return true;
    }

    protected int enterProgModeDelayTime() {
        return 0;
    }

    protected void setAllowUnexpectedReply(boolean expected) {
        this.allowUnexpectedReply = expected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReply(AbstractMRReply r, AbstractMRListener dest) {
        Vector v;
        AbstractMRTrafficController abstractMRTrafficController = this;
        synchronized (abstractMRTrafficController) {
            v = (Vector)this.cmdListeners.clone();
        }
        int cnt = v.size();
        int i = 0;
        while (i < cnt) {
            AbstractMRListener client = (AbstractMRListener)v.elementAt(i);
            log.debug("notify reply, client: {}", (Object)client);
            try {
                if (dest != client) {
                    this.forwardReply(client, r);
                }
            }
            catch (RuntimeException e) {
                log.warn("notify: During reply dispatch to {}", (Object)client, (Object)e);
            }
            ++i;
        }
        if (dest != null) {
            log.debug("notify reply, dest: {}", (Object)dest);
            this.forwardReply(dest, r);
        }
    }

    protected abstract void forwardReply(AbstractMRListener var1, AbstractMRReply var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void sendMessage(AbstractMRMessage m, AbstractMRListener reply) {
        this.msgQueue.addLast(m);
        this.listenerQueue.addLast(reply);
        Runnable runnable = this.xmtRunnable;
        synchronized (runnable) {
            if (this.mCurrentState == 10) {
                this.mCurrentState = 15;
                this.xmtRunnable.notify();
            }
        }
        if (m != null) {
            log.debug("just notified transmit thread with message {}", (Object)m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transmitLoop() {
        log.debug("transmitLoop starts in {}", (Object)this);
        while (!this.connectionError && !this.threadStopRequest) {
            AbstractMRMessage msg;
            AbstractMRMessage m = null;
            AbstractMRListener l = null;
            AbstractMRTrafficController abstractMRTrafficController = this;
            synchronized (abstractMRTrafficController) {
                if (!this.msgQueue.isEmpty()) {
                    m = this.msgQueue.getFirst();
                    this.msgQueue.removeFirst();
                    l = this.listenerQueue.getFirst();
                    this.listenerQueue.removeFirst();
                    this.mCurrentState = 25;
                    log.debug("transmit loop has something to do: {}", (Object)m);
                }
            }
            if (m != null) {
                Object modeMsg;
                log.debug("Start msg, state = {}", (Object)this.mCurrentMode);
                if (m.getNeededMode() != this.mCurrentMode) {
                    if (m.getNeededMode() == 4) {
                        modeMsg = this.enterProgMode();
                        if (modeMsg != null) {
                            this.mCurrentState = 30;
                            log.debug("Enter Programming Mode");
                            this.forwardToPort((AbstractMRMessage)modeMsg, null);
                            this.transmitWait(m.getTimeout(), 30, "enter programming mode interrupted");
                        }
                    } else {
                        modeMsg = this.enterNormalMode();
                        if (modeMsg != null) {
                            this.mCurrentState = 35;
                            log.debug("Enter Normal Mode");
                            this.forwardToPort((AbstractMRMessage)modeMsg, null);
                            this.transmitWait(m.getTimeout(), 35, "enter normal mode interrupted");
                        }
                    }
                    if (modeMsg != null) {
                        this.checkReplyInDispatch();
                        if (this.mCurrentState != 40) {
                            this.handleTimeout((AbstractMRMessage)modeMsg, l);
                        }
                        this.mCurrentState = 25;
                    } else {
                        log.debug("Setting mode to: {}", (Object)m.getNeededMode());
                        this.mCurrentMode = m.getNeededMode();
                    }
                }
                this.forwardToPort(m, l);
                if (!m.replyExpected()) continue;
                log.debug("reply expected is true for message {}", (Object)m);
                this.transmitWait(m.getTimeout(), 25, "transmitLoop interrupted");
                this.checkReplyInDispatch();
                if (this.mCurrentState == 25) {
                    this.handleTimeout(m, l);
                    continue;
                }
                if (this.mCurrentState == 45) {
                    log.info("Message added back to queue: {}", (Object)m);
                    this.msgQueue.addFirst(m);
                    this.listenerQueue.addFirst(l);
                    modeMsg = this.xmtRunnable;
                    synchronized (modeMsg) {
                        this.mCurrentState = 10;
                        continue;
                    }
                }
                this.resetTimeout(m);
                continue;
            }
            if (this.mCurrentState != 10) {
                log.debug("Setting IDLESTATE");
                log.debug("Current Mode {}", (Object)this.mCurrentMode);
                this.mCurrentState = 10;
            }
            if ((long)this.mWaitBeforePoll > this.waitTimePoll || this.mCurrentMode == 4) {
                try {
                    long startTime = Calendar.getInstance().getTimeInMillis();
                    Runnable runnable = this.xmtRunnable;
                    synchronized (runnable) {
                        this.xmtRunnable.wait(this.mWaitBeforePoll);
                    }
                    long endTime = Calendar.getInstance().getTimeInMillis();
                    this.waitTimePoll = this.waitTimePoll + endTime - startTime;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            AbstractMRTrafficController startTime = this;
            synchronized (startTime) {
                if (this.mCurrentState != 15 && this.mCurrentState != 10) {
                    log.error("left timeout in unexpected state: {}", (Object)this.mCurrentState);
                }
                if (this.mCurrentState == 10) {
                    this.mCurrentState = 50;
                }
            }
            if (this.mCurrentMode == 4) {
                log.debug("Timeout - in service mode");
            }
            if (this.mCurrentState == 50 && this.mCurrentMode == 4 && this.programmerIdle()) {
                log.debug("timeout causes leaving programming mode");
                this.mCurrentState = 35;
                msg = this.enterNormalMode();
                if (msg != null) {
                    this.forwardToPort(msg, null);
                    this.transmitWait(msg.getTimeout(), 35, "interrupted while leaving programming mode");
                    this.checkReplyInDispatch();
                    if (this.mCurrentState == 35) {
                        this.handleTimeout(msg, l);
                        this.mCurrentMode = 1;
                    }
                }
            } else if (this.mCurrentState == 50 && this.mCurrentMode == 1) {
                msg = this.pollMessage();
                if (msg != null) {
                    log.debug("Sending poll, wait time {}", (Object)this.waitTimePoll);
                    this.mCurrentState = 25;
                    this.forwardToPort(msg, this.pollReplyHandler());
                    log.debug("Still waiting for reply");
                    this.transmitWait(msg.getTimeout(), 25, "interrupted while waiting poll reply");
                    this.checkReplyInDispatch();
                    if (this.mCurrentState == 25) {
                        this.handleTimeout(msg, l);
                    } else {
                        this.resetTimeout(msg);
                    }
                }
                this.waitTimePoll = 0L;
            }
            if (this.mCurrentState != 50) continue;
            this.mCurrentState = 10;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transmitWait(int waitTime, int state, String interruptMessage) {
        long currentTime = Calendar.getInstance().getTimeInMillis();
        long endTime = currentTime + (long)waitTime;
        while (endTime > (currentTime = Calendar.getInstance().getTimeInMillis())) {
            long wait = endTime - currentTime;
            try {
                Runnable runnable = this.xmtRunnable;
                synchronized (runnable) {
                    if (this.mCurrentState != state) {
                        return;
                    }
                    this.xmtRunnable.wait(wait);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                String[] packages = this.getClass().getName().split("\\.");
                String name = String.valueOf(packages.length >= 2 ? String.valueOf(packages[packages.length - 2]) + "." : "") + (packages.length >= 1 ? packages[packages.length - 1] : "");
                if (!this.threadStopRequest) {
                    log.error("{} in transmitWait(..) of {}", (Object)interruptMessage, (Object)name);
                    continue;
                }
                log.debug("during shutdown, {}  in transmitWait(..) of {}", (Object)interruptMessage, (Object)name);
            }
        }
        log.debug("Timeout in transmitWait, mCurrentState: {}", (Object)this.mCurrentState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReplyInDispatch() {
        int loopCount = 0;
        while (this.replyInDispatch) {
            try {
                Runnable runnable = this.xmtRunnable;
                synchronized (runnable) {
                    this.xmtRunnable.wait(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                if (this.threadStopRequest) {
                    return;
                }
                String[] packages = this.getClass().getName().split("\\.");
                String name = String.valueOf(packages.length >= 2 ? String.valueOf(packages[packages.length - 2]) + "." : "") + (packages.length >= 1 ? packages[packages.length - 1] : "");
                log.error("transmitLoop interrupted in class {}", (Object)name);
            }
            int currentDispatchTime = ++loopCount * 100;
            if (currentDispatchTime <= this.maxDispatchTime) continue;
            this.maxDispatchTime = currentDispatchTime;
            if (currentDispatchTime < this.warningMessageTime) continue;
            this.warningMessageTime += 1000;
            log.debug("Max dispatch time is now {}", (Object)currentDispatchTime);
        }
    }

    public boolean hasTimeouts() {
        return this.timeoutFlag;
    }

    protected void handleTimeout(AbstractMRMessage msg, AbstractMRListener l) {
        String[] packages = this.getClass().getName().split("\\.");
        String name = String.valueOf(packages.length >= 2 ? String.valueOf(packages[packages.length - 2]) + "." : "") + (packages.length >= 1 ? packages[packages.length - 1] : "");
        log.warn("Timeout on reply to message: {} consecutive timeouts = {} in {}", new Object[]{msg, this.timeouts, name});
        ++this.timeouts;
        this.timeoutFlag = true;
        this.flushReceiveChars = true;
    }

    protected void resetTimeout(AbstractMRMessage msg) {
        if (this.timeouts > 0) {
            log.debug("Reset timeout after {} timeouts", (Object)this.timeouts);
        }
        this.timeouts = 0;
        this.timeoutFlag = false;
    }

    protected int addHeaderToOutput(byte[] msg, AbstractMRMessage m) {
        return 0;
    }

    protected void addTrailerToOutput(byte[] msg, int offset, AbstractMRMessage m) {
        if (!m.isBinary()) {
            msg[offset] = 13;
        }
    }

    protected int lengthOfByteStream(AbstractMRMessage m) {
        int len = m.getNumDataElements();
        int cr = 0;
        if (!m.isBinary()) {
            cr = 1;
        }
        return len + cr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"TLW_TWO_LOCK_WAIT"}, justification="Two locks needed for synchronization here, this is OK")
    protected synchronized void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        block15: {
            log.debug("forwardToPort message: [{}]", (Object)m);
            this.mLastSender = reply;
            XmtNotifier r = new XmtNotifier(m, this.mLastSender, this);
            SwingUtilities.invokeLater(r);
            int byteLength = this.lengthOfByteStream(m);
            byte[] msg = new byte[byteLength];
            log.debug("copying message, length = {}", (Object)byteLength);
            int offset = this.addHeaderToOutput(msg, m);
            int len = m.getNumDataElements();
            log.debug("copying data to message, length = {}", (Object)len);
            if (len > byteLength) {
                log.warn("Invalid message array size {} for {} elements, truncated", (Object)byteLength, (Object)len);
            }
            int i = 0;
            while (i < len && i < byteLength) {
                msg[i + offset] = (byte)m.getElement(i);
                ++i;
            }
            this.addTrailerToOutput(msg, len + offset, m);
            try {
                if (this.ostream != null) {
                    if (log.isDebugEnabled()) {
                        StringBuilder f = new StringBuilder("formatted message: ");
                        int i2 = 0;
                        while (i2 < msg.length) {
                            f.append(String.format("%02X ", 0xFF & msg[i2]));
                            ++i2;
                        }
                        log.debug(f.toString());
                    }
                    while (m.getRetries() >= 0) {
                        if (this.portReadyToSend(this.controller)) {
                            this.ostream.write(msg);
                            this.ostream.flush();
                            log.debug("written, msg timeout: {} mSec", (Object)m.getTimeout());
                            break block15;
                        }
                        if (m.getRetries() >= 0) {
                            log.debug("Retry message: {} attempts remaining: {}", (Object)m, (Object)m.getRetries());
                            m.setRetries(m.getRetries() - 1);
                            try {
                                Runnable f = this.xmtRunnable;
                                synchronized (f) {
                                    this.xmtRunnable.wait(m.getTimeout());
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                                log.error("retry wait interrupted");
                            }
                            continue;
                        }
                        log.warn("sendMessage: port not ready for data sending: {}", (Object)Arrays.toString(msg));
                    }
                    break block15;
                }
                this.connectionWarn();
            }
            catch (IOException | RuntimeException e) {
                this.xmtException = true;
                this.portWarn(e);
            }
        }
    }

    protected void connectionWarn() {
        log.warn("sendMessage: no connection established for {}", (Object)this.getClass().getName(), (Object)new Exception());
    }

    protected void portWarn(Exception e) {
        log.warn("sendMessage: Exception: In {} port warn: ", (Object)this.getClass().getName(), (Object)e);
    }

    protected void portWarnTCP(Exception e) {
        log.warn("Exception java net: ", (Throwable)e);
        this.connectionError = true;
    }

    public boolean status() {
        return this.ostream != null && this.istream != null;
    }

    public void connectPort(AbstractPortController p) {
        this.rcvException = false;
        this.connectionError = false;
        this.xmtException = false;
        this.threadStopRequest = false;
        try {
            this.istream = p.getInputStream();
            this.ostream = p.getOutputStream();
            if (this.controller != null) {
                log.warn("connectPort: connect called while connected");
            } else {
                log.debug("connectPort invoked");
            }
            this.controller = p;
            this.xmtRunnable = new Runnable(){

                @Override
                public void run() {
                    block4: {
                        try {
                            AbstractMRTrafficController.this.transmitLoop();
                        }
                        catch (ThreadDeath td) {
                            if (!AbstractMRTrafficController.this.threadStopRequest) {
                                log.error("Transmit thread terminated prematurely by: {}", (Object)td, (Object)td);
                            }
                            throw td;
                        }
                        catch (Throwable e) {
                            if (AbstractMRTrafficController.this.threadStopRequest) break block4;
                            log.error("Transmit thread terminated prematurely by: {}", (Object)e, (Object)e);
                        }
                    }
                }
            };
            this.xmtThread = ThreadingUtil.newThread(this.xmtRunnable);
            String[] packages = this.getClass().getName().split("\\.");
            this.xmtThread.setName(String.valueOf(packages.length >= 2 ? String.valueOf(packages[packages.length - 2]) + "." : "") + (packages.length >= 1 ? packages[packages.length - 1] : "") + " Transmit thread");
            this.xmtThread.setDaemon(true);
            this.xmtThread.setPriority(9);
            this.xmtThread.start();
            this.rcvThread = ThreadingUtil.newThread(new Runnable(){

                @Override
                public void run() {
                    AbstractMRTrafficController.this.receiveLoop();
                }
            });
            this.rcvThread.setName(String.valueOf(packages.length >= 2 ? String.valueOf(packages[packages.length - 2]) + "." : "") + (packages.length >= 1 ? packages[packages.length - 1] : "") + " Receive thread");
            this.rcvThread.setPriority(10);
            this.rcvThread.setDaemon(true);
            this.rcvThread.start();
        }
        catch (RuntimeException e) {
            log.error("Failed to start up communications. Error was: ", (Throwable)e);
            log.debug("Full trace:", (Throwable)e);
        }
    }

    public String getPortName() {
        return this.controller.getCurrentPortName();
    }

    public void disconnectPort(AbstractPortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.controller != p) {
            log.warn("disconnectPort: disconnect called from non-connected AbstractPortController");
        }
        this.controller = null;
        this.threadStopRequest = true;
    }

    public boolean portReadyToSend(AbstractPortController p) {
        return p != null && !this.xmtException && !this.rcvException;
    }

    public void receiveLoop() {
        log.debug("receiveLoop starts in {}", (Object)this);
        int errorCount = 0;
        while (errorCount < this.maxRcvExceptionCount && !this.threadStopRequest) {
            try {
                this.handleOneIncomingReply();
                errorCount = 0;
            }
            catch (InterruptedIOException interruptedIOException) {
                break;
            }
            catch (IOException e) {
                this.rcvException = true;
                this.reportReceiveLoopException(e);
                break;
            }
            catch (RuntimeException e1) {
                log.error("Exception in receive loop: {}", (Object)e1.toString(), (Object)e1);
                if (++errorCount != this.maxRcvExceptionCount) continue;
                this.rcvException = true;
                this.reportReceiveLoopException(e1);
            }
        }
        if (!this.threadStopRequest) {
            ConnectionStatus.instance().setConnectionState(this.controller.getUserName(), this.controller.getCurrentPortName(), "Not Connected");
            log.error("Exit from rcv loop in {}", this.getClass());
            this.recovery();
        }
    }

    protected final void recovery() {
        AbstractPortController adapter = this.controller;
        this.disconnectPort(this.controller);
        adapter.recover();
    }

    protected void reportReceiveLoopException(Exception e) {
        log.error("run: Exception: {} in {}", new Object[]{e.toString(), this.getClass().toString(), e});
        ConnectionStatus.instance().setConnectionState(this.controller.getUserName(), this.controller.getCurrentPortName(), "Not Connected");
        if (this.controller instanceof AbstractNetworkPortController) {
            this.portWarnTCP(e);
        }
    }

    protected abstract AbstractMRReply newReply();

    protected abstract boolean endOfMessage(AbstractMRReply var1);

    protected void waitForStartOfReply(DataInputStream istream) throws IOException {
    }

    protected byte readByteProtected(DataInputStream istream) throws IOException {
        int nchars;
        if (istream == null) {
            throw new IOException("Input Stream NULL when reading");
        }
        do {
            if ((nchars = istream.read(this.rcvBuffer, 0, 1)) != -1) continue;
            throw new IOException("Connection not terminated normally");
        } while (nchars <= 0);
        return this.rcvBuffer[0];
    }

    protected void loadChars(AbstractMRReply msg, DataInputStream istream) throws IOException {
        int i = 0;
        while (i < msg.maxSize()) {
            byte char1 = this.readByteProtected(istream);
            log.trace("char: {} i: {}", (Object)(char1 & 0xFF), (Object)i);
            if (this.flushReceiveChars) {
                log.warn("timeout flushes receive buffer: {}", (Object)msg);
                msg.flush();
                i = 0;
                this.flushReceiveChars = false;
            }
            if (this.canReceive()) {
                msg.setElement(i, char1);
                if (this.endOfMessage(msg)) {
                    break;
                }
            } else {
                --i;
                log.error("unsolicited character received: {}", (Object)Integer.toHexString(char1));
            }
            ++i;
        }
    }

    protected boolean canReceive() {
        return true;
    }

    protected void distributeReply(Runnable r) {
        try {
            if (this.synchronizeRx) {
                SwingUtilities.invokeAndWait(r);
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
        catch (InterruptedException ie) {
            if (this.threadStopRequest) {
                return;
            }
            log.error("Unexpected exception in invokeAndWait: {}{}", (Object)ie, (Object)ie.toString());
        }
        catch (RuntimeException | InvocationTargetException e) {
            log.error("Unexpected exception in invokeAndWait: {}{}", (Object)e, (Object)e.toString());
            return;
        }
        log.debug("dispatch thread invoked");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOneIncomingReply() throws IOException {
        block33: {
            AbstractMRReply msg;
            block32: {
                msg = this.newReply();
                this.waitForStartOfReply(this.istream);
                this.loadChars(msg, this.istream);
                if (this.threadStopRequest) {
                    return;
                }
                this.replyInDispatch = true;
                log.debug("dispatch reply of length {} contains \"{}\", state {}", new Object[]{msg.getNumDataElements(), msg, this.mCurrentState});
                RcvNotifier r = new RcvNotifier(msg, this.mLastSender, this);
                this.distributeReply(r);
                if (msg.isUnsolicited()) break block32;
                switch (this.mCurrentState) {
                    case 25: {
                        if (msg.isRetransmittableErrorMsg()) {
                            log.error("Automatic Recovery from Error Message: {}.  Retransmitted {} times.", (Object)msg, (Object)this.retransmitCount);
                            Runnable runnable = this.xmtRunnable;
                            synchronized (runnable) {
                                this.mCurrentState = 45;
                                if (this.retransmitCount > 0) {
                                    try {
                                        this.xmtRunnable.wait((long)this.retransmitCount * 100L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        Thread.currentThread().interrupt();
                                    }
                                }
                                this.replyInDispatch = false;
                                this.xmtRunnable.notify();
                                ++this.retransmitCount;
                                break;
                            }
                        }
                        Runnable runnable = this.xmtRunnable;
                        synchronized (runnable) {
                            this.mCurrentState = 15;
                            this.replyInDispatch = false;
                            this.xmtRunnable.notify();
                            this.retransmitCount = 0;
                            break;
                        }
                    }
                    case 30: {
                        Runnable runnable;
                        this.mCurrentMode = 4;
                        this.replyInDispatch = false;
                        int warmUpDelay = this.enterProgModeDelayTime();
                        if (warmUpDelay != 0) {
                            try {
                                runnable = this.xmtRunnable;
                                synchronized (runnable) {
                                    this.xmtRunnable.wait(warmUpDelay);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        runnable = this.xmtRunnable;
                        synchronized (runnable) {
                            this.mCurrentState = 40;
                            this.xmtRunnable.notify();
                            break;
                        }
                    }
                    case 35: {
                        this.mCurrentMode = 1;
                        this.replyInDispatch = false;
                        Runnable runnable = this.xmtRunnable;
                        synchronized (runnable) {
                            this.mCurrentState = 40;
                            this.xmtRunnable.notify();
                            break;
                        }
                    }
                    default: {
                        this.replyInDispatch = false;
                        if (this.allowUnexpectedReply) {
                            log.debug("Allowed unexpected reply received in state: {} was {}", (Object)this.mCurrentState, (Object)msg);
                            Runnable runnable = this.xmtRunnable;
                            synchronized (runnable) {
                                this.xmtRunnable.notify();
                                break;
                            }
                        }
                        this.unexpectedReplyStateError(this.mCurrentState, msg.toString());
                        break;
                    }
                }
                break block33;
            }
            log.debug("Unsolicited Message Received {}", (Object)msg);
            this.replyInDispatch = false;
        }
    }

    protected void unexpectedReplyStateError(int State2, String msgString) {
        String[] packages = this.getClass().getName().split("\\.");
        String name = String.valueOf(packages.length >= 2 ? String.valueOf(packages[packages.length - 2]) + "." : "") + (packages.length >= 1 ? packages[packages.length - 1] : "");
        log.error("reply complete in unexpected state: {} was {} in class {}", new Object[]{State2, msgString, name});
    }

    public AbstractMRListener getLastSender() {
        return this.mLastSender;
    }

    @Deprecated
    protected final void finalize() throws Throwable {
        this.terminate();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminate() {
        block7: {
            log.debug("Cleanup Starts");
            if (this.ostream == null) {
                return;
            }
            AbstractMRMessage modeMsg = this.enterNormalMode();
            if (modeMsg != null) {
                modeMsg.setRetries(100);
                this.forwardToPort(modeMsg, null);
                try {
                    if (this.xmtRunnable == null) break block7;
                    Runnable runnable = this.xmtRunnable;
                    synchronized (runnable) {
                        this.xmtRunnable.wait(modeMsg.getTimeout());
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    log.error("transmit interrupted");
                }
            }
        }
    }

    protected RcvNotifier newRcvNotifier(AbstractMRReply pMsg, AbstractMRListener pDest, AbstractMRTrafficController pTc) {
        return new RcvNotifier(pMsg, pDest, pTc);
    }

    public void terminateThreads() {
        this.threadStopRequest = true;
        if (this.xmtThread != null) {
            this.xmtThread.interrupt();
            try {
                this.xmtThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.rcvThread != null) {
            this.rcvThread.interrupt();
            try {
                this.rcvThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        InstanceManager.getDefault(ShutDownManager.class).deregister(this.shutDownTask);
    }

    protected static class RcvNotifier
    implements Runnable {
        AbstractMRReply mMsg;
        AbstractMRListener mDest;
        AbstractMRTrafficController mTc;

        public RcvNotifier(AbstractMRReply pMsg, AbstractMRListener pDest, AbstractMRTrafficController pTc) {
            this.mMsg = pMsg;
            this.mDest = pDest;
            this.mTc = pTc;
        }

        @Override
        public void run() {
            log.debug("Delayed rcv notify starts");
            this.mTc.notifyReply(this.mMsg, this.mDest);
        }
    }

    protected static class XmtNotifier
    implements Runnable {
        AbstractMRMessage mMsg;
        AbstractMRListener mDest;
        AbstractMRTrafficController mTc;

        public XmtNotifier(AbstractMRMessage pMsg, AbstractMRListener pDest, AbstractMRTrafficController pTc) {
            this.mMsg = pMsg;
            this.mDest = pDest;
            this.mTc = pTc;
        }

        @Override
        public void run() {
            log.debug("Delayed xmt notify starts");
            this.mTc.notifyMessage(this.mMsg, this.mDest);
        }
    }
}

