/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import jmri.jmrix.AbstractMessage;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMRReply
extends AbstractMessage {
    private boolean _isBinary;
    public static final int DEFAULTMAXSIZE = 120;
    private boolean unsolicited;
    private static final Logger log = LoggerFactory.getLogger(AbstractMRReply.class);

    public AbstractMRReply() {
        this.setBinary(false);
        this.unsolicited = false;
        this._dataChars = new int[this.maxSize()];
    }

    public AbstractMRReply(AbstractMRReply m) {
        this();
        if (m == null) {
            log.error("copy ctor of null message");
        } else {
            this._nDataChars = m._nDataChars;
            if (this._nDataChars >= 0) {
                System.arraycopy(m._dataChars, 0, this._dataChars, 0, this._nDataChars);
            }
        }
    }

    public AbstractMRReply(String s) {
        this();
        this._nDataChars = s.length();
        int i = 0;
        while (i < this._nDataChars) {
            this._dataChars[i] = s.charAt(i);
            ++i;
        }
    }

    @Override
    public void setElement(int n, int v) {
        this._dataChars[n] = (char)v;
        this._nDataChars = Math.max(this._nDataChars, n + 1);
    }

    public void setOpCode(int i) {
        this._dataChars[0] = (char)i;
    }

    public int getOpCode() {
        return this._dataChars[0];
    }

    public void flush() {
        this._nDataChars = 0;
    }

    public boolean isBinary() {
        return this._isBinary;
    }

    public void setBinary(boolean b) {
        this._isBinary = b;
    }

    public final void setUnsolicited() {
        this.unsolicited = true;
    }

    public boolean isUnsolicited() {
        return this.unsolicited;
    }

    public boolean isRetransmittableErrorMsg() {
        return false;
    }

    @Override
    public String toString() {
        String s = "";
        int i = 0;
        while (i < this._nDataChars) {
            if (this._isBinary) {
                if (i != 0) {
                    s = String.valueOf(s) + " ";
                }
                s = StringUtil.appendTwoHexFromInt(this._dataChars[i] & 0xFF, s);
            } else {
                s = String.valueOf(s) + (char)this._dataChars[i];
            }
            ++i;
        }
        return s;
    }

    protected abstract int skipPrefix(int var1);

    public int value() {
        int index = 0;
        index = this.skipWhiteSpace(index);
        index = this.skipPrefix(index);
        index = this.skipWhiteSpace(index);
        String s = "" + (char)this.getElement(index) + (char)this.getElement(index + 1) + (char)this.getElement(index + 2);
        int val = -1;
        try {
            val = Integer.parseInt(s);
        }
        catch (RuntimeException runtimeException) {
            log.error("Unable to get number from reply: \"{}\" index: {} message: \"{}\"", new Object[]{s, index, this.toString()});
        }
        return val;
    }

    public int pollValue() {
        int index = 0;
        index = this.skipWhiteSpace(index);
        index = this.skipPrefix(index);
        index = this.skipWhiteSpace(index);
        String s = "" + (char)this.getElement(index) + (char)this.getElement(index + 1) + (char)this.getElement(index + 2) + (char)this.getElement(index + 3);
        int val = -1;
        try {
            val = Integer.parseInt(s, 16);
        }
        catch (RuntimeException runtimeException) {
            log.error("Unable to get number from reply: \"{}\" index: {} message: \"{}\"", new Object[]{s, index, this.toString()});
        }
        return val;
    }

    public int match(String s) {
        int i = 0;
        while (i < this._nDataChars - s.length() + 1) {
            block3: {
                int j = 0;
                while (j < s.length()) {
                    if (this._dataChars[i + j] == s.charAt(j)) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int skipWhiteSpace(int index) {
        while (index < this.getNumDataElements() - 1 && (char)this.getElement(index) <= ' ') {
            ++index;
        }
        return index;
    }

    public int maxSize() {
        return 120;
    }
}

