/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.jmrit.withrottle.Bundle;
import jmri.jmrit.withrottle.WiThrottleCreationAction;
import jmri.jmrit.withrottle.WiThrottlePreferences;
import jmri.swing.JTitledSeparator;
import jmri.swing.PreferencesPanel;
import jmri.util.FileUtil;
import jmri.util.startup.PerformActionModel;
import jmri.util.startup.StartupActionsManager;
import jmri.util.startup.StartupModel;
import jmri.util.zeroconf.ZeroConfPreferences;
import jmri.util.zeroconf.ZeroConfServiceManager;

public class WiThrottlePrefsPanel
extends JPanel
implements PreferencesPanel {
    JCheckBox eStopCB;
    JSpinner delaySpinner;
    JCheckBox momF2CB;
    JSpinner port;
    JCheckBox powerCB;
    JCheckBox turnoutCB;
    JCheckBox turnoutCreationCB;
    JCheckBox routeCB;
    JCheckBox consistCB;
    JCheckBox startupCB;
    JCheckBox useIPv4CB;
    JCheckBox useIPv6CB;
    JCheckBox fastClockDisplayCB;
    ItemListener startupItemListener;
    int startupActionPosition = -1;
    JRadioButton wifiRB;
    JRadioButton dccRB;
    WiThrottlePreferences localPrefs;

    public WiThrottlePrefsPanel() {
        if (InstanceManager.getNullableDefault(WiThrottlePreferences.class) == null) {
            InstanceManager.store(new WiThrottlePreferences(String.valueOf(FileUtil.getUserFilesPath()) + "throttle" + File.separator + "WiThrottlePreferences.xml"), WiThrottlePreferences.class);
        }
        this.localPrefs = InstanceManager.getDefault(WiThrottlePreferences.class);
        this.initGUI();
        this.setGUI();
    }

    public void initGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(new JTitledSeparator(Bundle.getMessage("TitleDelayPanel")));
        this.add(this.eStopDelayPanel());
        this.add(new JTitledSeparator(Bundle.getMessage("TitleFunctionsPanel")));
        this.add(this.functionsPanel());
        this.add(new JTitledSeparator(Bundle.getMessage("TitleNetworkPanel")));
        this.add(this.networkPanel());
        this.add(new JTitledSeparator(Bundle.getMessage("TitleControllersPanel")));
        this.add(this.allowedControllers());
    }

    private void setGUI() {
        this.eStopCB.setSelected(this.localPrefs.isUseEStop());
        this.delaySpinner.setValue(this.localPrefs.getEStopDelay());
        this.momF2CB.setSelected(this.localPrefs.isUseMomF2());
        this.port.setValue(this.localPrefs.getPort());
        this.powerCB.setSelected(this.localPrefs.isAllowTrackPower());
        this.turnoutCB.setSelected(this.localPrefs.isAllowTurnout());
        this.turnoutCreationCB.setSelected(this.localPrefs.isAllowTurnoutCreation());
        this.routeCB.setSelected(this.localPrefs.isAllowRoute());
        this.fastClockDisplayCB.setSelected(this.localPrefs.isDisplayFastClock());
        this.consistCB.setSelected(this.localPrefs.isAllowConsist());
        InstanceManager.getDefault(StartupActionsManager.class).addPropertyChangeListener(evt -> this.startupCB.setSelected(this.isStartUpAction()));
        this.useIPv4CB.setSelected(this.isUseIPv4());
        this.useIPv6CB.setSelected(this.isUseIPv6());
        this.wifiRB.setSelected(this.localPrefs.isUseWiFiConsist());
        this.dccRB.setSelected(!this.localPrefs.isUseWiFiConsist());
    }

    private boolean setValues() {
        int portNum;
        boolean didSet = true;
        this.localPrefs.setUseEStop(this.eStopCB.isSelected());
        this.localPrefs.setEStopDelay((Integer)this.delaySpinner.getValue());
        this.localPrefs.setUseMomF2(this.momF2CB.isSelected());
        try {
            portNum = (Integer)this.port.getValue();
        }
        catch (NumberFormatException numberFormatException) {
            portNum = 0;
        }
        if (portNum < 1 || portNum > 65535) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("WarningInvalidPort"), Bundle.getMessage("TitlePortWarningDialog"), 2);
            didSet = false;
        } else {
            this.localPrefs.setPort((Integer)this.port.getValue());
        }
        this.localPrefs.setAllowTrackPower(this.powerCB.isSelected());
        this.localPrefs.setAllowTurnout(this.turnoutCB.isSelected());
        this.localPrefs.setAllowTurnoutCreation(this.turnoutCreationCB.isSelected());
        this.localPrefs.setAllowRoute(this.routeCB.isSelected());
        this.localPrefs.setDisplayFastClock(this.fastClockDisplayCB.isSelected());
        this.localPrefs.setAllowConsist(this.consistCB.isSelected());
        this.localPrefs.setUseWiFiConsist(this.wifiRB.isSelected());
        ZeroConfPreferences zeroConfPrefs = InstanceManager.getDefault(ZeroConfServiceManager.class).getPreferences();
        zeroConfPrefs.setUseIPv4(this.useIPv4CB.isSelected());
        zeroConfPrefs.setUseIPv6(this.useIPv6CB.isSelected());
        return didSet;
    }

    private JPanel eStopDelayPanel() {
        JPanel panel = new JPanel();
        this.eStopCB = new JCheckBox(Bundle.getMessage("LabelUseEStop"));
        this.eStopCB.setToolTipText(Bundle.getMessage("ToolTipUseEStop"));
        SpinnerNumberModel spinMod = new SpinnerNumberModel(10, 4, 60, 2);
        this.delaySpinner = new JSpinner(spinMod);
        ((JSpinner.DefaultEditor)this.delaySpinner.getEditor()).getTextField().setEditable(false);
        panel.add(this.eStopCB);
        panel.add(this.delaySpinner);
        panel.add(new JLabel(Bundle.getMessage("LabelEStopDelay")));
        return panel;
    }

    private JPanel functionsPanel() {
        JPanel panel = new JPanel();
        this.momF2CB = new JCheckBox(Bundle.getMessage("LabelMomF2"));
        this.momF2CB.setToolTipText(Bundle.getMessage("ToolTipMomF2"));
        panel.add(this.momF2CB);
        return panel;
    }

    private JPanel networkPanel() {
        JPanel nPanelRow1 = new JPanel();
        JPanel nPanelRow2 = new JPanel();
        JPanel nPanelRow3 = new JPanel();
        JPanel nPanel = new JPanel(new GridLayout(3, 1));
        this.port = new JSpinner(new SpinnerNumberModel(this.localPrefs.getPort(), 1, 65535, 1));
        this.port.setToolTipText(Bundle.getMessage("PortToolTip"));
        this.port.setEditor(new JSpinner.NumberEditor(this.port, "#"));
        JLabel label = new JLabel(Bundle.getMessage("LabelPort"));
        label.setToolTipText(this.port.getToolTipText());
        nPanelRow1.add(this.port);
        nPanelRow1.add(label);
        nPanel.add(nPanelRow1);
        this.startupCB = new JCheckBox(Bundle.getMessage("LabelStartup"), this.isStartUpAction());
        this.startupItemListener = e -> {
            this.startupCB.removeItemListener(this.startupItemListener);
            StartupActionsManager manager = InstanceManager.getDefault(StartupActionsManager.class);
            if (this.startupCB.isSelected()) {
                PerformActionModel model2 = new PerformActionModel();
                model2.setClassName(WiThrottleCreationAction.class.getName());
                if (this.startupActionPosition == -1 || this.startupActionPosition >= manager.getActions().length) {
                    manager.addAction(model2);
                } else {
                    manager.setActions(this.startupActionPosition, model2);
                }
            } else {
                manager.getActions(PerformActionModel.class).stream().filter(model -> WiThrottleCreationAction.class.getName().equals(model.getClassName())).forEach(model -> {
                    this.startupActionPosition = Arrays.asList(manager.getActions()).indexOf(model);
                    manager.removeAction((StartupModel)model);
                });
            }
            this.startupCB.addItemListener(this.startupItemListener);
        };
        this.startupCB.addItemListener(this.startupItemListener);
        nPanelRow2.add(this.startupCB);
        nPanel.add(nPanelRow2);
        this.useIPv4CB = new JCheckBox(Bundle.getMessage("LabelUseIPv4"), this.isUseIPv4());
        this.useIPv4CB.setToolTipText(Bundle.getMessage("ToolTipUseIPv4"));
        nPanelRow3.add(this.useIPv4CB);
        this.useIPv6CB = new JCheckBox(Bundle.getMessage("LabelUseIPv6"), this.isUseIPv6());
        this.useIPv6CB.setToolTipText(Bundle.getMessage("ToolTipUseIPv6"));
        nPanelRow3.add(this.useIPv6CB);
        nPanel.add(nPanelRow3);
        return nPanel;
    }

    private JPanel allowedControllers() {
        JPanel panel = new JPanel();
        this.powerCB = new JCheckBox(Bundle.getMessage("LabelTrackPower"));
        this.powerCB.setToolTipText(Bundle.getMessage("ToolTipTrackPower"));
        this.turnoutCB = new JCheckBox(Bundle.getMessage("Turnouts"));
        this.turnoutCB.setToolTipText(Bundle.getMessage("ToolTipTurnout"));
        this.turnoutCreationCB = new JCheckBox(Bundle.getMessage("TurnoutCreation"));
        this.turnoutCreationCB.setToolTipText(Bundle.getMessage("ToolTipTurnoutCreation"));
        this.routeCB = new JCheckBox(Bundle.getMessage("LabelRoute"));
        this.routeCB.setToolTipText(Bundle.getMessage("ToolTipRoute"));
        this.fastClockDisplayCB = new JCheckBox(Bundle.getMessage("LabelFastClockDisplayed"));
        this.fastClockDisplayCB.setToolTipText(Bundle.getMessage("ToolTipFastClockDisplayed"));
        this.consistCB = new JCheckBox(Bundle.getMessage("LabelConsist"));
        this.consistCB.setToolTipText(Bundle.getMessage("ToolTipConsist"));
        this.wifiRB = new JRadioButton(Bundle.getMessage("LabelWiFiConsist"));
        this.wifiRB.setToolTipText(Bundle.getMessage("ToolTipWiFiConsist"));
        this.dccRB = new JRadioButton(Bundle.getMessage("LabelDCCConsist"));
        this.dccRB.setToolTipText(Bundle.getMessage("ToolTipDCCConsist"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.wifiRB);
        group.add(this.dccRB);
        JPanel gridPanel = new JPanel(new GridLayout(0, 2));
        JPanel conPanel = new JPanel();
        gridPanel.add(this.powerCB);
        gridPanel.add(this.fastClockDisplayCB);
        gridPanel.add(this.turnoutCB);
        gridPanel.add(this.turnoutCreationCB);
        gridPanel.add(this.routeCB);
        conPanel.setLayout(new BoxLayout(conPanel, 1));
        this.wifiRB.setMargin(new Insets(0, 20, 0, 0));
        this.dccRB.setMargin(new Insets(0, 20, 0, 0));
        conPanel.add(this.consistCB);
        conPanel.add(this.wifiRB);
        conPanel.add(this.dccRB);
        panel.setLayout(new FlowLayout(1, 40, 0));
        panel.add(gridPanel);
        panel.add(conPanel);
        return panel;
    }

    @Override
    public String getPreferencesItem() {
        return "WITHROTTLE";
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("MenuMenu");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return this.getPreferencesItemText();
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        if (this.setValues()) {
            this.localPrefs.save();
        }
    }

    @Override
    public boolean isDirty() {
        return this.localPrefs.isDirty();
    }

    @Override
    public boolean isRestartRequired() {
        return this.localPrefs.isRestartRequired();
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }

    private boolean isStartUpAction() {
        return InstanceManager.getDefault(StartupActionsManager.class).getActions(PerformActionModel.class).stream().anyMatch(model -> WiThrottleCreationAction.class.getName().equals(model.getClassName()));
    }

    private boolean isUseIPv4() {
        return InstanceManager.getDefault(ZeroConfServiceManager.class).getPreferences().isUseIPv4();
    }

    private boolean isUseIPv6() {
        return InstanceManager.getDefault(ZeroConfServiceManager.class).getPreferences().isUseIPv6();
    }
}

