/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.util.ArrayList;
import jmri.CommandStation;
import jmri.Consist;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.implementation.NmraConsistManager;
import jmri.jmrit.withrottle.ControllerInterface;
import jmri.jmrit.withrottle.WiFiConsist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WiFiConsistManager
extends NmraConsistManager {
    ArrayList<ControllerInterface> listeners = null;
    boolean isValid = false;
    private static final Logger log = LoggerFactory.getLogger(WiFiConsistManager.class);

    public WiFiConsistManager() {
        super(InstanceManager.getDefault(CommandStation.class));
        log.debug("New WiFiConsistManager");
        this.isValid = true;
    }

    public boolean checkForBroadcastAddress(DccLocoAddress addr) {
        if (addr.getNumber() < 1) {
            log.warn("Trying to use broadcast address!");
            return true;
        }
        return false;
    }

    @Override
    public Consist addConsist(LocoAddress address) {
        if (!(address instanceof DccLocoAddress)) {
            throw new IllegalArgumentException("address is not a DccLocoAddress object");
        }
        WiFiConsist consist = new WiFiConsist((DccLocoAddress)address);
        this.consistTable.put(address, consist);
        return consist;
    }

    public void addControllerListener(ControllerInterface listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeControllerListener(ControllerInterface listener) {
        if (this.listeners == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }
}

