/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import jmri.ConsistManager;
import jmri.jmrit.consisttool.ConsistFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WiFiConsistFile
extends ConsistFile {
    private static final Logger log = LoggerFactory.getLogger(WiFiConsistFile.class);

    public WiFiConsistFile(ConsistManager cm) {
        this.consistMan = cm;
        this.loadStoredConsistFile("wifiConsist.xml");
    }

    private void loadStoredConsistFile(String fileName) {
        if (this.checkFile(String.valueOf(WiFiConsistFile.getFileLocation()) + fileName)) {
            log.debug("Has {} file.", (Object)fileName);
            try {
                this.readFile(String.valueOf(WiFiConsistFile.getFileLocation()) + fileName);
            }
            catch (Exception e) {
                log.warn("error reading consist file: {}", (Throwable)e);
            }
        } else {
            log.debug("No {} file, will check for default file.", (Object)fileName);
            if (this.checkFile(WiFiConsistFile.defaultConsistFilename())) {
                log.debug("Has default consist.xml file, will read it.");
                try {
                    this.readFile();
                }
                catch (Exception e) {
                    log.warn("error reading consist file: {}", (Throwable)e);
                }
            } else {
                log.debug("No consist files found, will create if needed.");
            }
        }
    }
}

