/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.util.Arrays;
import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.NmraPacket;
import jmri.implementation.NmraConsist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WiFiConsist
extends NmraConsist {
    private static final Logger log = LoggerFactory.getLogger(WiFiConsist.class);

    public WiFiConsist(DccLocoAddress address) {
        super(address);
    }

    @Override
    public void add(DccLocoAddress loco, boolean dirNorm) {
        this.restore(loco, dirNorm);
        this.sendConsistCommand(loco, dirNorm, this);
        this.setRosterEntryCVValue(loco);
    }

    @Override
    public void remove(DccLocoAddress loco) {
        this.resetRosterEntryCVValue(loco);
        this.consistDir.remove(loco);
        this.consistList.remove(loco);
        this.consistPosition.remove(loco);
        this.consistRoster.remove(loco);
        this.sendConsistCommand(loco, true, null);
    }

    public void sendConsistCommand(DccLocoAddress loco, boolean dirNorm, WiFiConsist consist) {
        byte[] packet;
        int conAddr = 0;
        if (consist != null) {
            conAddr = this.getConsistAddress().getNumber();
        }
        if ((packet = NmraPacket.consistControl(loco.getNumber(), loco.isLongAddress(), conAddr, dirNorm)) != null) {
            if (log.isDebugEnabled()) {
                log.debug(Arrays.toString(packet));
            }
            InstanceManager.getDefault(CommandStation.class).sendPacket(packet, 1);
        }
    }
}

