/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import jmri.InstanceManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.withrottle.AbstractController;
import jmri.jmrit.withrottle.Bundle;
import jmri.jmrit.withrottle.ControllerInterface;
import jmri.jmrit.withrottle.DeviceServer;
import jmri.jmrit.withrottle.WiThrottlePreferences;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutController
extends AbstractController
implements PropertyChangeListener {
    private TurnoutManager manager = null;
    private final boolean isTurnoutCreationAllowed = InstanceManager.getDefault(WiThrottlePreferences.class).isAllowTurnoutCreation();
    private static final Logger log = LoggerFactory.getLogger(TurnoutController.class);

    public TurnoutController() {
        this.manager = InstanceManager.getNullableDefault(TurnoutManager.class);
        if (this.manager == null) {
            log.info("No turnout manager instance.");
            this.isValid = false;
        } else {
            this.isValid = true;
        }
    }

    @Override
    boolean verifyCreation() {
        return this.isValid;
    }

    @Override
    public void filterList() {
        ArrayList<String> tempList = new ArrayList<String>(0);
        for (String sysName : this.sysNameList) {
            Object o;
            Turnout t = this.manager.getBySystemName(sysName);
            if (t == null || (o = t.getProperty("WifiControllable")) != null && !Boolean.valueOf(o.toString()).booleanValue()) continue;
            tempList.add(sysName);
        }
        this.sysNameList = tempList;
    }

    @Override
    void handleMessage(String message, DeviceServer deviceServer) {
        if (message.charAt(0) == 'A') {
            String tName = message.substring(2);
            Turnout t = this.manager.getTurnout(tName);
            if (t == null && NumberUtils.isDigits((String)tName)) {
                tName = String.valueOf(this.manager.getSystemPrefix()) + this.manager.typeLetter() + tName;
                t = this.manager.getTurnout(tName);
            }
            if (t != null) {
                Object o = t.getProperty("WifiControllable");
                if (o != null && !Boolean.valueOf(o.toString()).booleanValue()) {
                    String msg = Bundle.getMessage("ErrorTurnoutNotAllowed", t.getSystemName());
                    log.warn(msg);
                    deviceServer.sendAlertMessage(msg);
                    return;
                }
            } else {
                if (!this.isTurnoutCreationAllowed) {
                    String msg = Bundle.getMessage("ErrorTurnoutNotDefined", message.substring(2));
                    log.warn(msg);
                    deviceServer.sendAlertMessage(msg);
                    return;
                }
                try {
                    t = this.manager.provideTurnout(message.substring(2));
                }
                catch (IllegalArgumentException e) {
                    String msg = Bundle.getMessage("ErrorCreatingTurnout", e.getLocalizedMessage());
                    log.warn(msg);
                    deviceServer.sendAlertMessage(msg);
                    return;
                }
                String msg = Bundle.getMessage("InfoCreatedTurnout", t.getSystemName());
                log.debug(msg);
                deviceServer.sendInfoMessage(msg);
            }
            switch (message.charAt(1)) {
                case '2': {
                    if (t.getCommandedState() == 2) {
                        t.setCommandedState(4);
                        break;
                    }
                    t.setCommandedState(2);
                    break;
                }
                case 'C': {
                    t.setCommandedState(2);
                    break;
                }
                case 'T': {
                    t.setCommandedState(4);
                    break;
                }
                default: {
                    log.warn("Message \"{}\" unknown.", (Object)message);
                }
            }
        }
    }

    public void sendTitles() {
        if (this.listeners == null) {
            return;
        }
        StringBuilder labels = new StringBuilder("PTT");
        labels.append("]\\[").append(Bundle.getMessage("MenuItemTurnoutTable")).append("}|{Turnout");
        labels.append("]\\[").append(this.manager.getClosedText()).append("}|{2");
        labels.append("]\\[").append(this.manager.getThrownText()).append("}|{4");
        labels.append("]\\[").append(Bundle.getMessage("StateUnknown")).append("}|{1");
        labels.append("]\\[").append(Bundle.getMessage("StateInconsistent")).append("}|{8");
        String message = labels.toString();
        for (ControllerInterface listener : this.listeners) {
            listener.sendPacketToDevice(message);
        }
    }

    public void sendList() {
        if (this.listeners == null) {
            return;
        }
        if (this.canBuildList) {
            this.buildList(this.manager);
        }
        if (this.sysNameList.isEmpty()) {
            return;
        }
        StringBuilder list = new StringBuilder("PTL");
        for (String sysName : this.sysNameList) {
            Turnout t = this.manager.getBySystemName(sysName);
            if (t == null) continue;
            list.append("]\\[").append(sysName);
            list.append("}|{");
            if (t.getUserName() != null) {
                list.append(t.getUserName());
            }
            list.append("}|{").append(t.getKnownState());
            if (!this.canBuildList) continue;
            t.addPropertyChangeListener(this);
        }
        String message = list.toString();
        for (ControllerInterface listener : this.listeners) {
            listener.sendPacketToDevice(message);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("KnownState")) {
            Turnout t = (Turnout)evt.getSource();
            this.sendTurnoutState(t);
        }
    }

    public void sendTurnoutState(Turnout t) {
        String message = "PTA" + t.getKnownState() + t.getSystemName();
        for (ControllerInterface listener : this.listeners) {
            listener.sendPacketToDevice(message);
        }
    }

    @Override
    public void register() {
        for (String sysName : this.sysNameList) {
            Turnout t = this.manager.getBySystemName(sysName);
            if (t == null) continue;
            t.addPropertyChangeListener(this);
            if (!log.isDebugEnabled()) continue;
            log.debug("Add listener to Turnout: {}", (Object)t.getSystemName());
        }
    }

    @Override
    public void deregister() {
        if (this.sysNameList.isEmpty()) {
            return;
        }
        for (String sysName : this.sysNameList) {
            Turnout t = this.manager.getBySystemName(sysName);
            if (t == null) continue;
            t.removePropertyChangeListener(this);
            if (!log.isDebugEnabled()) continue;
            log.debug("Remove listener from Turnout: {}", (Object)t.getSystemName());
        }
    }
}

